/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayMultibandTile;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.Crop$Options$;
import geotrellis.raster.io.geotiff.BandType$;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiff$;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.raster.io.geotiff.NewSubfileType;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.io.geotiff.PixelInterleave$;
import geotrellis.raster.io.geotiff.ReducedImage$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.Tags$;
import geotrellis.raster.io.geotiff.TiffType;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.package$;
import geotrellis.raster.render.IndexedColorMap;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.util.ByteReader;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005g\u0001\u0002%J\u0001JC\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tS\u0002\u0011\t\u0012)A\u0005;\"A!\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003m\u0011!\u0019\bA!f\u0001\n\u0003!\b\u0002C>\u0001\u0005#\u0005\u000b\u0011B;\t\u0011q\u0004!Q3A\u0005\u0002uD\u0011\"a\u0001\u0001\u0005#\u0005\u000b\u0011\u0002@\t\u0015\u0005\u0015\u0001A!f\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\u0010\u0001\u0011\t\u0012)A\u0005\u0003\u0013A!\"!\u0005\u0001\u0005+\u0007I\u0011AA\n\u0011)\ti\u0003\u0001B\tB\u0003%\u0011Q\u0003\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011%\t\t\u0005\u0001b\u0001\n\u0003\t\u0019\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA#\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBA=\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003s\u0002A\u0011AAU\u0011\u001d\tI\b\u0001C\u0001\u0003oCq!!\u001f\u0001\t\u0003\t\u0019\rC\u0004\u0002z\u0001!\t!a?\t\u000f\u0005-\b\u0001\"\u0001\u0003\u0014!9!1\u0005\u0001\u0005\u0002\t\u0015\u0002b\u0002B\u0019\u0001\u0011\u0005!1\u0007\u0005\n\u0005\u007f\u0001\u0011\u0013!C\u0001\u0005\u0003B\u0011Ba\u0016\u0001#\u0003%\tA!\u0017\t\u000f\tu\u0003\u0001\"\u0001\u0003`!I!Q\u000e\u0001\u0012\u0002\u0013\u0005!q\u000e\u0005\n\u0005g\u0002\u0011\u0013!C\u0001\u0005kB\u0011B!\u001f\u0001#\u0003%\tAa\u001f\t\u0013\t}\u0004!%A\u0005\u0002\t\u0005\u0005\"\u0003BC\u0001E\u0005I\u0011\u0001BD\u0011%\u0011Y\tAI\u0001\n\u0003\u0011i\tC\u0005\u0003\u0012\u0002\t\t\u0011\"\u0011\u0003\u0014\"I!Q\u0015\u0001\u0002\u0002\u0013\u0005!q\u0015\u0005\n\u0005S\u0003\u0011\u0011!C\u0001\u0005WC\u0011Ba.\u0001\u0003\u0003%\tE!/\t\u0013\t\u0015\u0007!!A\u0005\u0002\t\u001d\u0007\"\u0003Bi\u0001\u0005\u0005I\u0011\tBj\u0011%\u0011)\u000eAA\u0001\n\u0003\u00129\u000eC\u0005\u0003Z\u0002\t\t\u0011\"\u0011\u0003\\\u001e9!q\\%\t\u0002\t\u0005hA\u0002%J\u0011\u0003\u0011\u0019\u000fC\u0004\u00020=\"\tA!:\t\u000f\t\u001dx\u0006\"\u0001\u0003j\"9!q]\u0018\u0005\u0002\tm\bb\u0002Bt_\u0011\u000511\u0001\u0005\b\u0005O|C\u0011AB\f\u0011\u001d\u00119o\fC\u0001\u0007?AqAa:0\t\u0003\u0019Y\u0003C\u0004\u0003h>\"\ta!\r\t\u000f\t\u001dx\u0006\"\u0001\u0004D!9!q]\u0018\u0005\u0002\r%\u0003b\u0002Bt_\u0011\u00051q\n\u0005\b\u0007\u0003yC\u0011AB+\u0011\u001d\u0019\ta\fC\u0001\u00073BqAa:0\t\u0003\u0019i\u0006C\u0004\u0003h>\"\ta!\u001a\t\u000f\t\u001dx\u0006\"\u0001\u0004p!9!q]\u0018\u0005\u0002\re\u0004b\u0002Bt_\u0011\u00051Q\u0011\u0005\b\u0005O|C\u0011ABG\u0011%\u00119oLA\u0001\n\u0003\u001b)\nC\u0005\u0004$>\n\n\u0011\"\u0001\u0003\u000e\"I1QU\u0018\u0002\u0002\u0013\u00055q\u0015\u0005\n\u0007k{\u0013\u0013!C\u0001\u0005\u001bC\u0011ba.0\u0003\u0003%Ia!/\u0003!5+H\u000e^5cC:$w)Z8US\u001a4'B\u0001&L\u0003\u001d9Wm\u001c;jM\u001aT!\u0001T'\u0002\u0005%|'B\u0001(P\u0003\u0019\u0011\u0018m\u001d;fe*\t\u0001+\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0003\u0001'f\u000bG\r\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVK\u0001\u0004B]f\u0014VM\u001a\t\u00045nkV\"A%\n\u0005qK%aB$f_RKgM\u001a\t\u0003=~k\u0011!T\u0005\u0003A6\u0013Q\"T;mi&\u0014\u0017M\u001c3US2,\u0007C\u0001+c\u0013\t\u0019WKA\u0004Qe>$Wo\u0019;\u0011\u0005Q+\u0017B\u00014V\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011!\u0018\u000e\\3\u0016\u0003u\u000bQ\u0001^5mK\u0002\na!\u001a=uK:$X#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=|\u0015A\u0002<fGR|'/\u0003\u0002r]\n1Q\t\u001f;f]R\fq!\u001a=uK:$\b%A\u0002deN,\u0012!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003q>\u000bQ\u0001\u001d:pURJ!A_<\u0003\u0007\r\u00136+\u0001\u0003deN\u0004\u0013\u0001\u0002;bON,\u0012A \t\u00035~L1!!\u0001J\u0005\u0011!\u0016mZ:\u0002\u000bQ\fwm\u001d\u0011\u0002\u000f=\u0004H/[8ogV\u0011\u0011\u0011\u0002\t\u00045\u0006-\u0011bAA\u0007\u0013\nqq)Z8US\u001a4w\n\u001d;j_:\u001c\u0018\u0001C8qi&|gn\u001d\u0011\u0002\u0013=4XM\u001d<jK^\u001cXCAA\u000b!\u0015\t9\"a\nZ\u001d\u0011\tI\"a\t\u000f\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\bR\u0003\u0019a$o\\8u}%\ta+C\u0002\u0002&U\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002*\u0005-\"\u0001\u0002'jgRT1!!\nV\u0003)yg/\u001a:wS\u0016<8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u0005M\u0012QGA\u001c\u0003s\tY$!\u0010\u0002@A\u0011!\f\u0001\u0005\u0006O6\u0001\r!\u0018\u0005\u0006U6\u0001\r\u0001\u001c\u0005\u0006g6\u0001\r!\u001e\u0005\u0006y6\u0001\rA \u0005\b\u0003\u000bi\u0001\u0019AA\u0005\u0011%\t\t\"\u0004I\u0001\u0002\u0004\t)\"\u0001\u0005dK2dG+\u001f9f+\t\t)\u0005\u0005\u0003\u0002H\u0005-cb\u00010\u0002J%\u0019\u0011QE'\n\t\u00055\u0013q\n\u0002\t\u0007\u0016dG\u000eV=qK*\u0019\u0011QE'\u0002\u0013\r,G\u000e\u001c+za\u0016\u0004\u0013aB7baRKG.\u001a\u000b\u0005\u0003g\t9\u0006C\u0004\u0002ZA\u0001\r!a\u0017\u0002\u0003\u0019\u0004R\u0001VA/;vK1!a\u0018V\u0005%1UO\\2uS>t\u0017'A\txSRD7\u000b^8sC\u001e,W*\u001a;i_\u0012$B!a\r\u0002f!9\u0011qM\tA\u0002\u0005%\u0014!D:u_J\fw-Z'fi\"|G\rE\u0002[\u0003WJ1!!\u001cJ\u00055\u0019Fo\u001c:bO\u0016lU\r\u001e5pI\u0006I\u0011.\\1hK\u0012\u000bG/Y\u000b\u0003\u0003g\u00022AWA;\u0013\r\t9(\u0013\u0002\u0011\u000f\u0016|G+\u001b4g\u00136\fw-\u001a#bi\u0006\fAa\u0019:paR!\u00111GA?\u0011\u0019\tyh\u0005a\u0001Y\u0006I1/\u001e2FqR,g\u000e\u001e\u000b\u0007\u0003g\t\u0019)!\"\t\r\u0005}D\u00031\u0001m\u0011\u001d\t)\u0001\u0006a\u0001\u0003\u000f\u0003B!!#\u0002\u0014:!\u00111RAH\u001b\t\tiIC\u0002\u0002z5KA!!%\u0002\u000e\u0006!1I]8q\u0013\u0011\t)*a&\u0003\u000f=\u0003H/[8og*!\u0011\u0011SAG)\u0019\t\u0019$a'\u0002&\"9\u0011QT\u000bA\u0002\u0005}\u0015AB2pY6\u000b\u0007\u0010E\u0002U\u0003CK1!a)V\u0005\rIe\u000e\u001e\u0005\b\u0003O+\u0002\u0019AAP\u0003\u0019\u0011xn^'bqRQ\u00111GAV\u0003_\u000b\u0019,!.\t\u000f\u00055f\u00031\u0001\u0002 \u000611m\u001c7NS:Dq!!-\u0017\u0001\u0004\ty*\u0001\u0004s_^l\u0015N\u001c\u0005\b\u0003;3\u0002\u0019AAP\u0011\u001d\t9K\u0006a\u0001\u0003?#B!a\r\u0002:\"9\u00111X\fA\u0002\u0005u\u0016AC4sS\u0012\u0014u.\u001e8egB)a,a0\u0002 &\u0019\u0011\u0011Y'\u0003\u0015\u001d\u0013\u0018\u000e\u001a\"pk:$7\u000f\u0006\u0006\u0002F\u0006U\u0017q[Aq\u0003c\u0004B!a2\u0002R:!\u0011\u0011ZA%\u001d\u0011\tY-a4\u000f\t\u0005m\u0011QZ\u0005\u0002!&\u0011ajT\u0005\u0005\u0003'\fyEA\bNk2$\u0018NY1oIJ\u000b7\u000f^3s\u0011\u0019\ty\b\u0007a\u0001Y\"9\u0011\u0011\u001c\rA\u0002\u0005m\u0017\u0001C2fY2\u001c\u0016N_3\u0011\u0007y\u000bi.C\u0002\u0002`6\u0013\u0001bQ3mYNK'0\u001a\u0005\b\u0003GD\u0002\u0019AAs\u00039\u0011Xm]1na2,W*\u001a;i_\u0012\u0004B!a:\u0002n6\u0011\u0011\u0011\u001e\u0006\u0004\u0003Wl\u0015\u0001\u0003:fg\u0006l\u0007\u000f\\3\n\t\u0005=\u0018\u0011\u001e\u0002\u000f%\u0016\u001c\u0018-\u001c9mK6+G\u000f[8e\u0011\u001d\t\u0019\u0010\u0007a\u0001\u0003k\f\u0001b\u001d;sCR,w-\u001f\t\u00045\u0006]\u0018bAA}\u0013\n\u0001rJ^3sm&,wo\u0015;sCR,w-\u001f\u000b\u0005\u0003{\u0014I\u0001\u0005\u0004\u0002\u0018\u0005}(1A\u0005\u0005\u0005\u0003\tYC\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0019!&QAA_;&\u0019!qA+\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011Y!\u0007a\u0001\u0005\u001b\tqa^5oI><8\u000f\u0005\u0004\u0002\u0018\t=\u0011QX\u0005\u0005\u0005#\tYCA\u0002TKF$\u0002\"!2\u0003\u0016\t}!\u0011\u0005\u0005\b\u0005/Q\u0002\u0019\u0001B\r\u00031\u0011\u0018m\u001d;fe\u0016CH/\u001a8u!\rq&1D\u0005\u0004\u0005;i%\u0001\u0004*bgR,'/\u0012=uK:$\bbBAr5\u0001\u0007\u0011Q\u001d\u0005\b\u0003gT\u0002\u0019AA{\u00035\u0011W/\u001b7e\u001fZ,'O^5foRA\u00111\u0007B\u0014\u0005S\u0011i\u0003C\u0004\u0002dn\u0001\r!!:\t\u000f\t-2\u00041\u0001\u0002 \u0006\u0001B-Z2j[\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\n\u0005_Y\u0002\u0013!a\u0001\u0003?\u000b\u0011B\u00197pG.\u001c\u0016N_3\u0002\u001b]LG\u000f[(wKJ4\u0018.Z<t)!\t\u0019D!\u000e\u00038\tu\u0002bBAr9\u0001\u0007\u0011Q\u001d\u0005\n\u0005sa\u0002\u0013!a\u0001\u0005w\t1\u0002Z3dS6\fG/[8ogB1\u0011qCA\u0014\u0003?C\u0011Ba\f\u001d!\u0003\u0005\r!a(\u0002/]LG\u000f[(wKJ4\u0018.Z<tI\u0011,g-Y;mi\u0012\u0012TC\u0001B\"U\u0011\u0011YD!\u0012,\u0005\t\u001d\u0003\u0003\u0002B%\u0005'j!Aa\u0013\u000b\t\t5#qJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0015V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005+\u0012YEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqc^5uQ>3XM\u001d<jK^\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tm#\u0006BAP\u0005\u000b\nAaY8qsRq\u00111\u0007B1\u0005G\u0012)Ga\u001a\u0003j\t-\u0004bB4 !\u0003\u0005\r!\u0018\u0005\bU~\u0001\n\u00111\u0001m\u0011\u001d\u0019x\u0004%AA\u0002UDq\u0001`\u0010\u0011\u0002\u0003\u0007a\u0010C\u0005\u0002\u0006}\u0001\n\u00111\u0001\u0002\n!I\u0011\u0011C\u0010\u0011\u0002\u0003\u0007\u0011QC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tHK\u0002^\u0005\u000b\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003x)\u001aAN!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0010\u0016\u0004k\n\u0015\u0013AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0007S3A B#\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"A!#+\t\u0005%!QI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011yI\u000b\u0003\u0002\u0016\t\u0015\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0016B!!q\u0013BQ\u001b\t\u0011IJ\u0003\u0003\u0003\u001c\nu\u0015\u0001\u00027b]\u001eT!Aa(\u0002\t)\fg/Y\u0005\u0005\u0005G\u0013IJ\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003?\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003.\nM\u0006c\u0001+\u00030&\u0019!\u0011W+\u0003\u0007\u0005s\u0017\u0010C\u0005\u00036\"\n\t\u00111\u0001\u0002 \u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa/\u0011\r\tu&1\u0019BW\u001b\t\u0011yLC\u0002\u0003BV\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tAa0\u0002\u0011\r\fg.R9vC2$BA!3\u0003PB\u0019AKa3\n\u0007\t5WKA\u0004C_>dW-\u00198\t\u0013\tU&&!AA\u0002\t5\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005}\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tU\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0003J\nu\u0007\"\u0003B[[\u0005\u0005\t\u0019\u0001BW\u0003AiU\u000f\u001c;jE\u0006tGmR3p)&4g\r\u0005\u0002[_M\u0019qf\u00153\u0015\u0005\t\u0005\u0018!B1qa2LH\u0003BA\u001a\u0005WDqA!<2\u0001\u0004\u0011y/A\u0003csR,7\u000fE\u0003U\u0005c\u0014)0C\u0002\u0003tV\u0013Q!\u0011:sCf\u00042\u0001\u0016B|\u0013\r\u0011I0\u0016\u0002\u0005\u0005f$X\r\u0006\u0004\u00024\tu(q \u0005\b\u0005[\u0014\u0004\u0019\u0001Bx\u0011\u001d\u0019\tA\ra\u0001\u0005\u0013\f\u0011b\u001d;sK\u0006l\u0017N\\4\u0015\t\u0005M2Q\u0001\u0005\b\u0007\u000f\u0019\u0004\u0019AB\u0005\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\r-11\u0003\b\u0005\u0007\u001b\u0019y\u0001E\u0002\u0002\u001cUK1a!\u0005V\u0003\u0019\u0001&/\u001a3fM&!!1UB\u000b\u0015\r\u0019\t\"\u0016\u000b\u0007\u0003g\u0019Iba\u0007\t\u000f\r\u001dA\u00071\u0001\u0004\n!11Q\u0004\u001bA\u00021\f\u0011!\u001a\u000b\u0007\u0003g\u0019\tca\t\t\u000f\r\u001dQ\u00071\u0001\u0004\n!91QD\u001bA\u0002\r\u0015\u0002\u0003\u0002+\u0004(1L1a!\u000bV\u0005\u0019y\u0005\u000f^5p]R1\u00111GB\u0017\u0007_Aqaa\u00027\u0001\u0004\u0019I\u0001C\u0004\u0004\u0002Y\u0002\rA!3\u0015\t\u0005M21\u0007\u0005\b\u0007k9\u0004\u0019AB\u001c\u0003)\u0011\u0017\u0010^3SK\u0006$WM\u001d\t\u0005\u0007s\u0019y$\u0004\u0002\u0004<)\u00191QH(\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007\u0003\u001aYD\u0001\u0006CsR,'+Z1eKJ$b!a\r\u0004F\r\u001d\u0003bBB\u001bq\u0001\u00071q\u0007\u0005\u0007\u0007;A\u0004\u0019\u00017\u0015\r\u0005M21JB'\u0011\u001d\u0019)$\u000fa\u0001\u0007oAqa!\b:\u0001\u0004\u0019)\u0003\u0006\u0004\u00024\rE31\u000b\u0005\b\u0007kQ\u0004\u0019AB\u001c\u0011\u001d\u0019\tA\u000fa\u0001\u0005\u0013$B!a\r\u0004X!91qA\u001eA\u0002\r%A\u0003BA\u001a\u00077Bqa!\u000e=\u0001\u0004\u00199\u0004\u0006\u0005\u00024\r}3\u0011MB2\u0011\u00159W\b1\u0001^\u0011\u0015QW\b1\u0001m\u0011\u0015\u0019X\b1\u0001v))\t\u0019da\u001a\u0004j\r-4Q\u000e\u0005\u0006Oz\u0002\r!\u0018\u0005\u0006Uz\u0002\r\u0001\u001c\u0005\u0006gz\u0002\r!\u001e\u0005\u0006yz\u0002\rA \u000b\u000b\u0003g\u0019\tha\u001d\u0004v\r]\u0004\"B4@\u0001\u0004i\u0006\"\u00026@\u0001\u0004a\u0007\"B:@\u0001\u0004)\bbBA\u0003\u007f\u0001\u0007\u0011\u0011\u0002\u000b\u0007\u0003g\u0019Yha!\t\r9\u0003\u0005\u0019AB?!\u0011q6qP/\n\u0007\r\u0005UJ\u0001\u0004SCN$XM\u001d\u0005\u0006g\u0002\u0003\r!\u001e\u000b\t\u0003g\u00199i!#\u0004\f\"1a*\u0011a\u0001\u0007{BQa]!A\u0002UDQ\u0001`!A\u0002y$\u0002\"a\r\u0004\u0010\u000eE51\u0013\u0005\u0007\u001d\n\u0003\ra! \t\u000bM\u0014\u0005\u0019A;\t\u000f\u0005\u0015!\t1\u0001\u0002\nQq\u00111GBL\u00073\u001bYj!(\u0004 \u000e\u0005\u0006\"B4D\u0001\u0004i\u0006\"\u00026D\u0001\u0004a\u0007\"B:D\u0001\u0004)\b\"\u0002?D\u0001\u0004q\bbBA\u0003\u0007\u0002\u0007\u0011\u0011\u0002\u0005\n\u0003#\u0019\u0005\u0013!a\u0001\u0003+\tq\"\u00199qYf$C-\u001a4bk2$HEN\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Ik!-\u0011\u000bQ\u001b9ca+\u0011\u0017Q\u001bi+\u00187v}\u0006%\u0011QC\u0005\u0004\u0007_+&A\u0002+va2,g\u0007C\u0005\u00044\u0016\u000b\t\u00111\u0001\u00024\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\rm\u0006\u0003\u0002BL\u0007{KAaa0\u0003\u001a\n1qJ\u00196fGR\u0004")
public class MultibandGeoTiff
implements GeoTiff<MultibandTile>,
Product,
scala.Serializable {
    private final MultibandTile tile;
    private final Extent extent;
    private final CRS crs;
    private final Tags tags;
    private final GeoTiffOptions options;
    private final List<GeoTiff<MultibandTile>> overviews;
    private final DataType cellType;

    public static List<GeoTiff<MultibandTile>> $lessinit$greater$default$6() {
        return MultibandGeoTiff$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Tuple6<MultibandTile, Extent, CRS, Tags, GeoTiffOptions, List<GeoTiff<MultibandTile>>>> unapply(MultibandGeoTiff multibandGeoTiff) {
        return MultibandGeoTiff$.MODULE$.unapply(multibandGeoTiff);
    }

    public static List<GeoTiff<MultibandTile>> apply$default$6() {
        return MultibandGeoTiff$.MODULE$.apply$default$6();
    }

    public static MultibandGeoTiff apply(MultibandTile multibandTile, Extent extent, CRS cRS, Tags tags, GeoTiffOptions geoTiffOptions, List<GeoTiff<MultibandTile>> list) {
        return MultibandGeoTiff$.MODULE$.apply(multibandTile, extent, cRS, tags, geoTiffOptions, list);
    }

    public static MultibandGeoTiff apply(Raster<MultibandTile> raster, CRS cRS, GeoTiffOptions geoTiffOptions) {
        return MultibandGeoTiff$.MODULE$.apply(raster, cRS, geoTiffOptions);
    }

    public static MultibandGeoTiff apply(Raster<MultibandTile> raster, CRS cRS, Tags tags) {
        return MultibandGeoTiff$.MODULE$.apply(raster, cRS, tags);
    }

    public static MultibandGeoTiff apply(Raster<MultibandTile> raster, CRS cRS) {
        return MultibandGeoTiff$.MODULE$.apply(raster, cRS);
    }

    public static MultibandGeoTiff apply(MultibandTile multibandTile, Extent extent, CRS cRS, GeoTiffOptions geoTiffOptions) {
        return MultibandGeoTiff$.MODULE$.apply(multibandTile, extent, cRS, geoTiffOptions);
    }

    public static MultibandGeoTiff apply(MultibandTile multibandTile, Extent extent, CRS cRS, Tags tags) {
        return MultibandGeoTiff$.MODULE$.apply(multibandTile, extent, cRS, tags);
    }

    public static MultibandGeoTiff apply(MultibandTile multibandTile, Extent extent, CRS cRS) {
        return MultibandGeoTiff$.MODULE$.apply(multibandTile, extent, cRS);
    }

    public static MultibandGeoTiff streaming(ByteReader byteReader) {
        return MultibandGeoTiff$.MODULE$.streaming(byteReader);
    }

    public static MultibandGeoTiff streaming(String string) {
        return MultibandGeoTiff$.MODULE$.streaming(string);
    }

    public static MultibandGeoTiff apply(ByteReader byteReader, boolean bl) {
        return MultibandGeoTiff$.MODULE$.apply(byteReader, bl);
    }

    public static MultibandGeoTiff apply(ByteReader byteReader, Option<Extent> option) {
        return MultibandGeoTiff$.MODULE$.apply(byteReader, option);
    }

    public static MultibandGeoTiff apply(ByteReader byteReader, Extent extent) {
        return MultibandGeoTiff$.MODULE$.apply(byteReader, extent);
    }

    public static MultibandGeoTiff apply(ByteReader byteReader) {
        return MultibandGeoTiff$.MODULE$.apply(byteReader);
    }

    public static MultibandGeoTiff apply(String string, boolean bl) {
        return MultibandGeoTiff$.MODULE$.apply(string, bl);
    }

    public static MultibandGeoTiff apply(String string, Option<Extent> option) {
        return MultibandGeoTiff$.MODULE$.apply(string, option);
    }

    public static MultibandGeoTiff apply(String string, Extent extent) {
        return MultibandGeoTiff$.MODULE$.apply(string, extent);
    }

    public static MultibandGeoTiff apply(String string) {
        return MultibandGeoTiff$.MODULE$.apply(string);
    }

    public static MultibandGeoTiff apply(byte[] byArray, boolean bl) {
        return MultibandGeoTiff$.MODULE$.apply(byArray, bl);
    }

    public static MultibandGeoTiff apply(byte[] byArray) {
        return MultibandGeoTiff$.MODULE$.apply(byArray);
    }

    @Override
    public int cols() {
        return GeoTiff.cols$(this);
    }

    @Override
    public int rows() {
        return GeoTiff.rows$(this);
    }

    @Override
    public ProjectedExtent projectedExtent() {
        return GeoTiff.projectedExtent$(this);
    }

    @Override
    public ProjectedRaster<MultibandTile> projectedRaster() {
        return GeoTiff.projectedRaster$(this);
    }

    @Override
    public Raster<MultibandTile> raster() {
        return GeoTiff.raster$(this);
    }

    @Override
    public RasterExtent rasterExtent() {
        return GeoTiff.rasterExtent$(this);
    }

    @Override
    public CellSize cellSize() {
        return GeoTiff.cellSize$(this);
    }

    @Override
    public int bandCount() {
        return GeoTiff.bandCount$(this);
    }

    @Override
    public void write(String path, boolean optimizedOrder) {
        GeoTiff.write$(this, path, optimizedOrder);
    }

    @Override
    public boolean write$default$2() {
        return GeoTiff.write$default$2$(this);
    }

    @Override
    public byte[] toByteArray() {
        return GeoTiff.toByteArray$(this);
    }

    @Override
    public byte[] toCloudOptimizedByteArray() {
        return GeoTiff.toCloudOptimizedByteArray$(this);
    }

    @Override
    public int getOverviewsCount() {
        return GeoTiff.getOverviewsCount$(this);
    }

    @Override
    public GeoTiff<MultibandTile> getOverview(int idx) {
        return GeoTiff.getOverview$(this, idx);
    }

    @Override
    public int buildOverview$default$3() {
        return GeoTiff.buildOverview$default$3$(this);
    }

    @Override
    public GeoTiff<MultibandTile> withOverviews(Seq<GeoTiff<MultibandTile>> overviews) {
        return GeoTiff.withOverviews$(this, overviews);
    }

    @Override
    public Raster<MultibandTile> crop(Extent subExtent, CellSize cellSize) {
        return GeoTiff.crop$(this, subExtent, cellSize);
    }

    @Override
    public Raster<MultibandTile> crop(RasterExtent rasterExtent) {
        return GeoTiff.crop$(this, rasterExtent);
    }

    @Override
    public GeoTiff<MultibandTile> getClosestOverview(CellSize cellSize, OverviewStrategy strategy) {
        return GeoTiff.getClosestOverview$(this, cellSize, strategy);
    }

    @Override
    public OverviewStrategy getClosestOverview$default$2() {
        return GeoTiff.getClosestOverview$default$2$(this);
    }

    @Override
    public Option<PixelSampleType> pixelSampleType() {
        return GeoTiffData.pixelSampleType$(this);
    }

    @Override
    public MultibandTile tile() {
        return this.tile;
    }

    @Override
    public Extent extent() {
        return this.extent;
    }

    @Override
    public CRS crs() {
        return this.crs;
    }

    @Override
    public Tags tags() {
        return this.tags;
    }

    @Override
    public GeoTiffOptions options() {
        return this.options;
    }

    @Override
    public List<GeoTiff<MultibandTile>> overviews() {
        return this.overviews;
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    public MultibandGeoTiff mapTile(Function1<MultibandTile, MultibandTile> f) {
        return new MultibandGeoTiff((MultibandTile)f.apply((Object)this.tile()), this.extent(), this.crs(), this.tags(), this.options(), this.overviews());
    }

    public MultibandGeoTiff withStorageMethod(StorageMethod storageMethod) {
        return new MultibandGeoTiff(this.tile().toArrayTile(), this.extent(), this.crs(), this.tags(), this.options().copy(storageMethod, this.options().copy$default$2(), this.options().copy$default$3(), this.options().copy$default$4(), this.options().copy$default$5(), this.options().copy$default$6(), this.options().copy$default$7()), (List<GeoTiff<MultibandTile>>)((List)this.overviews().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withStorageMethod(storageMethod), List$.MODULE$.canBuildFrom())));
    }

    @Override
    public GeoTiffImageData imageData() {
        GeoTiffMultibandTile geoTiffMultibandTile;
        MultibandTile multibandTile = this.tile();
        GeoTiffMultibandTile geoTiffMultibandTile2 = multibandTile instanceof GeoTiffMultibandTile ? (geoTiffMultibandTile = (GeoTiffMultibandTile)multibandTile) : geotrellis.raster.io.geotiff.package$.MODULE$.GeoTiffMultibandTileMethods(this.tile()).toGeoTiffTile(this.options());
        return geoTiffMultibandTile2;
    }

    public MultibandGeoTiff crop(Extent subExtent) {
        return this.crop(subExtent, Crop$Options$.MODULE$.DEFAULT());
    }

    public MultibandGeoTiff crop(Extent subExtent, Crop.Options options) {
        Option option = this.extent().intersection(subExtent);
        if (!(option instanceof Some)) {
            throw new GeoAttrsError(new StringBuilder(60).append("Extent to crop by (").append(subExtent).append(") should intersect the imagery extent (").append(this.extent()).append(").").toString());
        }
        Some some = (Some)option;
        Extent ext = (Extent)some.value();
        Raster raster = package$.MODULE$.withMultibandTileRasterCropMethods(this.raster()).crop(ext, options);
        MultibandGeoTiff multibandGeoTiff = new MultibandGeoTiff((MultibandTile)raster.tile(), raster.extent(), this.crs(), this.tags(), this.options(), this.overviews());
        return multibandGeoTiff;
    }

    public MultibandGeoTiff crop(int colMax, int rowMax) {
        return this.crop(0, 0, colMax, rowMax);
    }

    public MultibandGeoTiff crop(int colMin, int rowMin, int colMax, int rowMax) {
        Raster raster = (Raster)package$.MODULE$.withMultibandTileRasterCropMethods(this.raster()).crop(colMin, rowMin, colMax, rowMax);
        return new MultibandGeoTiff((MultibandTile)raster.tile(), raster.extent(), this.crs(), this.tags(), this.options(), this.overviews());
    }

    public MultibandGeoTiff crop(GridBounds<Object> gridBounds) {
        return this.crop(gridBounds.colMin$mcI$sp(), gridBounds.rowMin$mcI$sp(), gridBounds.colMax$mcI$sp(), gridBounds.rowMax$mcI$sp());
    }

    @Override
    public Raster<MultibandTile> crop(Extent subExtent, CellSize cellSize, ResampleMethod resampleMethod, OverviewStrategy strategy) {
        return this.getClosestOverview(cellSize, strategy).crop(subExtent, new Crop.Options(false, Crop$Options$.MODULE$.apply$default$2())).resample(RasterExtent$.MODULE$.apply(subExtent, cellSize), resampleMethod, strategy);
    }

    @Override
    public Iterator<Tuple2<GridBounds<Object>, MultibandTile>> crop(Seq<GridBounds<Object>> windows) {
        Object object;
        MultibandTile multibandTile = this.tile();
        if (multibandTile instanceof GeoTiffMultibandTile) {
            GeoTiffMultibandTile geoTiffMultibandTile = (GeoTiffMultibandTile)multibandTile;
            object = geoTiffMultibandTile.crop(windows);
        } else if (multibandTile != null) {
            MultibandTile multibandTile2 = multibandTile;
            object = package$.MODULE$.withMultibandTileCropMethods(multibandTile2).crop(windows);
        } else {
            throw new MatchError((Object)multibandTile);
        }
        return object;
    }

    @Override
    public Raster<MultibandTile> resample(RasterExtent rasterExtent, ResampleMethod resampleMethod, OverviewStrategy strategy) {
        return package$.MODULE$.withMultibandRasterResampleMethods(this.getClosestOverview(this.cellSize(), strategy).raster()).resample(rasterExtent, resampleMethod);
    }

    public MultibandGeoTiff buildOverview(ResampleMethod resampleMethod, int decimationFactor, int blockSize) {
        MultibandTile multibandTile;
        RasterExtent overviewRasterExtent = RasterExtent$.MODULE$.apply(this.extent(), (int)scala.math.package$.MODULE$.ceil((double)BoxesRunTime.unboxToInt(this.tile().cols()) / (double)decimationFactor), (int)scala.math.package$.MODULE$.ceil((double)BoxesRunTime.unboxToInt(this.tile().rows()) / (double)decimationFactor));
        GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(overviewRasterExtent.cols(), overviewRasterExtent.rows(), new Tiled(blockSize, blockSize), PixelInterleave$.MODULE$, BandType$.MODULE$.forCellType(this.tile().cellType()));
        MultibandTile multibandTile2 = this.tile();
        if (multibandTile2 instanceof GeoTiffMultibandTile) {
            GeoTiffMultibandTile geoTiffMultibandTile = (GeoTiffMultibandTile)multibandTile2;
            multibandTile = geoTiffMultibandTile.toArrayTile();
        } else {
            multibandTile = MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)this.tile().bands().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toArrayTile(), Vector$.MODULE$.canBuildFrom())));
        }
        ArrayMultibandTile arrayTile = multibandTile;
        Seq segments = (Seq)((TraversableLike)package$.MODULE$.withMultibandTileSplitMethods(package$.MODULE$.withMultibandRasterResampleMethods(new Raster<MultibandTile>(arrayTile, this.extent())).resample(overviewRasterExtent, resampleMethod).tile()).split(segmentLayout.tileLayout()).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MultibandTile tile = (MultibandTile)tuple2._1();
            int index = tuple2._2$mcI$sp();
            int col = index % segmentLayout.tileLayout().layoutCols();
            int row = index / segmentLayout.tileLayout().layoutCols();
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(col, row), (Object)tile);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Tiled storageMethod = new Tiled(blockSize, blockSize);
        Some x$1 = new Some((Object)ReducedImage$.MODULE$);
        Tiled x$22 = storageMethod;
        Compression x$3 = this.options().copy$default$2();
        int x$4 = this.options().copy$default$3();
        Option<IndexedColorMap> x$5 = this.options().copy$default$4();
        InterleaveMethod x$6 = this.options().copy$default$5();
        TiffType x$7 = this.options().copy$default$7();
        GeoTiffOptions overviewOptions = this.options().copy(x$22, x$3, x$4, x$5, x$6, (Option<NewSubfileType>)x$1, x$7);
        MultibandTile overviewTile = GeoTiffBuilder$.MODULE$.apply(GeoTiffBuilder$.MODULE$.multibandGeoTiffBuilder()).makeTile((Iterator<Tuple2<Product2<Object, Object>, MultibandTile>>)segments.toIterator(), segmentLayout, this.cellType(), this.options().compression());
        return new MultibandGeoTiff(overviewTile, this.extent(), this.crs(), Tags$.MODULE$.empty(), overviewOptions, MultibandGeoTiff$.MODULE$.apply$default$6());
    }

    public MultibandGeoTiff withOverviews(ResampleMethod resampleMethod, List<Object> decimations, int blockSize) {
        MultibandGeoTiff multibandGeoTiff;
        List<Object> overviewDecimations;
        List<Object> list = overviewDecimations = decimations.isEmpty() ? GeoTiff$.MODULE$.defaultOverviewDecimations(BoxesRunTime.unboxToInt(this.tile().cols()), BoxesRunTime.unboxToInt(this.tile().rows()), blockSize) : decimations;
        if (overviewDecimations.isEmpty()) {
            multibandGeoTiff = this;
        } else {
            MultibandTile multibandTile;
            MultibandTile multibandTile2 = this.tile();
            if (multibandTile2 instanceof GeoTiffMultibandTile) {
                GeoTiffMultibandTile geoTiffMultibandTile = (GeoTiffMultibandTile)multibandTile2;
                multibandTile = geoTiffMultibandTile.toArrayTile();
            } else {
                multibandTile = MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)this.tile().bands().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toArrayTile(), Vector$.MODULE$.canBuildFrom())));
            }
            ArrayMultibandTile arrayTile = multibandTile;
            MultibandGeoTiff staged = new MultibandGeoTiff(arrayTile, this.extent(), this.crs(), this.tags(), this.options(), (List<GeoTiff<MultibandTile>>)Nil$.MODULE$);
            List overviews = (List)overviewDecimations.map((Function1 & Serializable & scala.Serializable)decimationFactor -> staged.buildOverview(resampleMethod, BoxesRunTime.unboxToInt((Object)decimationFactor), blockSize), List$.MODULE$.canBuildFrom());
            multibandGeoTiff = new MultibandGeoTiff(this.tile(), this.extent(), this.crs(), this.tags(), this.options(), (List<GeoTiff<MultibandTile>>)overviews);
        }
        return multibandGeoTiff;
    }

    @Override
    public List<Object> withOverviews$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public int withOverviews$default$3() {
        return GeoTiff$.MODULE$.DefaultBlockSize();
    }

    public MultibandGeoTiff copy(MultibandTile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options, List<GeoTiff<MultibandTile>> overviews) {
        return new MultibandGeoTiff(tile, extent, crs, tags, options, overviews);
    }

    @Override
    public MultibandTile copy$default$1() {
        return this.tile();
    }

    @Override
    public Extent copy$default$2() {
        return this.extent();
    }

    @Override
    public CRS copy$default$3() {
        return this.crs();
    }

    @Override
    public Tags copy$default$4() {
        return this.tags();
    }

    @Override
    public GeoTiffOptions copy$default$5() {
        return this.options();
    }

    @Override
    public List<GeoTiff<MultibandTile>> copy$default$6() {
        return this.overviews();
    }

    public String productPrefix() {
        return "MultibandGeoTiff";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tile();
                break;
            }
            case 1: {
                object = this.extent();
                break;
            }
            case 2: {
                object = this.crs();
                break;
            }
            case 3: {
                object = this.tags();
                break;
            }
            case 4: {
                object = this.options();
                break;
            }
            case 5: {
                object = this.overviews();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MultibandGeoTiff;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MultibandGeoTiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        MultibandGeoTiff multibandGeoTiff = (MultibandGeoTiff)x$1;
        MultibandTile multibandTile = this.tile();
        MultibandTile multibandTile2 = multibandGeoTiff.tile();
        if (multibandTile == null) {
            if (multibandTile2 != null) {
                return false;
            }
        } else if (!multibandTile.equals(multibandTile2)) return false;
        Extent extent = this.extent();
        Extent extent2 = multibandGeoTiff.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        CRS cRS = this.crs();
        CRS cRS2 = multibandGeoTiff.crs();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!cRS.equals(cRS2)) return false;
        Tags tags = this.tags();
        Tags tags2 = multibandGeoTiff.tags();
        if (tags == null) {
            if (tags2 != null) {
                return false;
            }
        } else if (!((Object)tags).equals(tags2)) return false;
        GeoTiffOptions geoTiffOptions = this.options();
        GeoTiffOptions geoTiffOptions2 = multibandGeoTiff.options();
        if (geoTiffOptions == null) {
            if (geoTiffOptions2 != null) {
                return false;
            }
        } else if (!((Object)geoTiffOptions).equals(geoTiffOptions2)) return false;
        List<GeoTiff<MultibandTile>> list = this.overviews();
        List<GeoTiff<MultibandTile>> list2 = multibandGeoTiff.overviews();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!multibandGeoTiff.canEqual(this)) return false;
        return true;
    }

    public MultibandGeoTiff(MultibandTile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options, List<GeoTiff<MultibandTile>> overviews) {
        this.tile = tile;
        this.extent = extent;
        this.crs = crs;
        this.tags = tags;
        this.options = options;
        this.overviews = overviews;
        GeoTiffData.$init$(this);
        GeoTiff.$init$(this);
        Product.$init$((Product)this);
        this.cellType = tile.cellType();
    }
}

