/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.compression.HorizontalPredictor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.Predictor$;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y;Q!\u0004\b\t\u0002e1Qa\u0007\b\t\u0002qAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005\u0002\u00192AaG\u0001\u0005e!A1\u0007\u0002B\u0001B\u0003%A\u0007\u0003\u00058\t\t\u0005\t\u0015!\u00039\u0011!YDA!A!\u0002\u0013!\u0004\"B\u0012\u0005\t\u0003a\u0004\"\u0002\"\u0005\t\u0003\u0019\u0005\"\u0002&\u0005\t\u0003Y\u0005\"\u0002,\u0005\t\u00039\u0006\"\u0002.\u0005\t\u0003Y\u0016a\u0005%pe&TxN\u001c;bYB\u0013X\rZ5di>\u0014(BA\b\u0011\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005E\u0011\u0012aB4f_RLgM\u001a\u0006\u0003'Q\t!![8\u000b\u0005U1\u0012A\u0002:bgR,'OC\u0001\u0018\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\tQ\u0012!D\u0001\u000f\u0005MAuN]5{_:$\u0018\r\u001c)sK\u0012L7\r^8s'\t\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\tQ!\u00199qYf$\"a\n\u0016\u0011\u0005iA\u0013BA\u0015\u000f\u0005%\u0001&/\u001a3jGR|'\u000fC\u0003,\u0007\u0001\u0007A&\u0001\u0005uS\u001a4G+Y4t!\ti\u0003'D\u0001/\u0015\ty\u0003#\u0001\u0003uC\u001e\u001c\u0018BA\u0019/\u0005!!\u0016N\u001a4UC\u001e\u001c8C\u0001\u0003\u001e\u0003\u0011\u0019w\u000e\\:\u0011\u0005y)\u0014B\u0001\u001c \u0005\rIe\u000e^\u0001\u000ee><8/\u00138TK\u001elWM\u001c;\u0011\tyID\u0007N\u0005\u0003u}\u0011\u0011BR;oGRLwN\\\u0019\u0002\u0013\t\fg\u000eZ\"pk:$H\u0003B\u001f@\u0001\u0006\u0003\"A\u0010\u0003\u000e\u0003\u0005AQa\r\u0005A\u0002QBQa\u000e\u0005A\u0002aBQa\u000f\u0005A\u0002Q\n1BZ8s\u0005\u0006tG\rV=qKR\u0011q\u0005\u0012\u0005\u0006\u000b&\u0001\rAR\u0001\tE\u0006tG\rV=qKB\u0011q\tS\u0007\u0002!%\u0011\u0011\n\u0005\u0002\t\u0005\u0006tG\rV=qK\u00061\u0011\r\u001d9msb\"2\u0001\u0014*U!\rqRjT\u0005\u0003\u001d~\u0011Q!\u0011:sCf\u0004\"A\b)\n\u0005E{\"\u0001\u0002\"zi\u0016DQa\u0015\u0006A\u00021\u000bQAY=uKNDQ!\u0016\u0006A\u0002Q\nAb]3h[\u0016tG/\u00138eKb\fq!\u00199qYf\fd\u0007F\u0002M1fCQaU\u0006A\u00021CQ!V\u0006A\u0002Q\nq!\u00199qYf\u001c$\u0007F\u0002M9vCQa\u0015\u0007A\u00021CQ!\u0016\u0007A\u0002Q\u0002")
public final class HorizontalPredictor {
    public static Predictor apply(TiffTags tiffTags) {
        return HorizontalPredictor$.MODULE$.apply(tiffTags);
    }

    public static class HorizontalPredictor {
        private final int cols;
        private final Function1<Object, Object> rowsInSegment;
        private final int bandCount;

        public Predictor forBandType(BandType bandType) {
            Function2 & java.io.Serializable & Serializable intersect;
            int n = bandType.bitsPerSample();
            switch (n) {
                case 8: {
                    intersect = (Function2 & java.io.Serializable & Serializable)(bytes, segmentIndex) -> this.apply8(bytes, BoxesRunTime.unboxToInt((Object)segmentIndex));
                    break;
                }
                case 16: {
                    intersect = (Function2 & java.io.Serializable & Serializable)(bytes, segmentIndex) -> this.apply16(bytes, BoxesRunTime.unboxToInt((Object)segmentIndex));
                    break;
                }
                case 32: {
                    intersect = (Function2 & java.io.Serializable & Serializable)(bytes, segmentIndex) -> this.apply32(bytes, BoxesRunTime.unboxToInt((Object)segmentIndex));
                    break;
                }
                default: {
                    throw new MalformedGeoTiffException(new StringBuilder(71).append("Horizontal differencing \"Predictor\" not supported with ").append(bandType.bitsPerSample()).append(" bits per sample").toString());
                }
            }
            Function2 & java.io.Serializable & Serializable applyFunc = intersect;
            return new Predictor(null, applyFunc){
                private final int code;
                private final boolean checkEndian;
                private final Function2 applyFunc$1;

                public int code() {
                    return this.code;
                }

                public boolean checkEndian() {
                    return this.checkEndian;
                }

                public byte[] apply(byte[] bytes, int segmentIndex) {
                    return (byte[])this.applyFunc$1.apply((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)segmentIndex));
                }
                {
                    this.applyFunc$1 = applyFunc$1;
                    this.code = Predictor$.MODULE$.PREDICTOR_HORIZONTAL();
                    this.checkEndian = true;
                }
            };
        }

        public byte[] apply8(byte[] bytes, int segmentIndex) {
            int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
            for (int index$macro$2 = 0; index$macro$2 < rows; ++index$macro$2) {
                int count = this.bandCount * (index$macro$2 * this.cols + 1);
                for (int index$macro$1 = this.bandCount; index$macro$1 < this.cols * this.bandCount && index$macro$1 < bytes.length; ++index$macro$1) {
                    bytes[count] = (byte)(bytes[count] + bytes[count - this.bandCount]);
                    ++count;
                }
            }
            return bytes;
        }

        public byte[] apply16(byte[] bytes, int segmentIndex) {
            ShortBuffer buffer = ByteBuffer.wrap(bytes).asShortBuffer();
            int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
            for (int index$macro$2 = 0; index$macro$2 < rows; ++index$macro$2) {
                int count = this.bandCount * (index$macro$2 * this.cols + 1);
                for (int index$macro$1 = this.bandCount; index$macro$1 < this.cols * this.bandCount; ++index$macro$1) {
                    buffer.put(count, (short)(buffer.get(count) + buffer.get(count - this.bandCount)));
                    ++count;
                }
            }
            return bytes;
        }

        public byte[] apply32(byte[] bytes, int segmentIndex) {
            IntBuffer buffer = ByteBuffer.wrap(bytes).asIntBuffer();
            int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
            for (int index$macro$2 = 0; index$macro$2 < rows; ++index$macro$2) {
                int count = this.bandCount * (index$macro$2 * this.cols + 1);
                for (int index$macro$1 = this.bandCount; index$macro$1 < this.cols * this.bandCount; ++index$macro$1) {
                    buffer.put(count, buffer.get(count) + buffer.get(count - this.bandCount));
                    ++count;
                }
            }
            return bytes;
        }

        public HorizontalPredictor(int cols, Function1<Object, Object> rowsInSegment, int bandCount) {
            this.cols = cols;
            this.rowsInSegment = rowsInSegment;
            this.bandCount = bandCount;
        }
    }
}

