/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.JpegDecompressor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.YCbCrConverter$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReaderLimitationException;
import geotrellis.raster.io.geotiff.tags.ColimetryTags;
import geotrellis.raster.io.geotiff.tags.JpegTags;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.YCbCrTags;
import geotrellis.raster.io.geotiff.tags.codes.ColorSpace$;
import geotrellis.raster.io.geotiff.tags.codes.CompressionType$;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.stream.ImageInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dt!\u0002\u000f\u001e\u0011\u0003Ac!\u0002\u0016\u001e\u0011\u0003Y\u0003\"B\u001b\u0002\t\u00031\u0004\"B\u001c\u0002\t\u0003A\u0004\"CA*\u0003\u0005\u0005I\u0011BA+\r\u0011QS\u0004\u0001\u001e\t\u0011y*!\u0011!Q\u0001\n}BQ!N\u0003\u0005\u0002\u0015CqaR\u0003C\u0002\u0013\u0005\u0001\n\u0003\u0004M\u000b\u0001\u0006I!\u0013\u0005\b\u001b\u0016\u0011\r\u0011\"\u0001O\u0011\u0019\u0011V\u0001)A\u0005\u001f\"91+\u0002b\u0001\n\u0003!\u0006B\u0002-\u0006A\u0003%Q\u000bC\u0004Z\u000b\t\u0007I\u0011\u0001.\t\ry+\u0001\u0015!\u0003\\\u0011\u001dyVA1A\u0005\u0006\u0001DaaZ\u0003!\u0002\u001b\t\u0007b\u00025\u0006\u0005\u0004%)\u0001\u0019\u0005\u0007S\u0016\u0001\u000bQB1\t\u000f),!\u0019!C\u0001W\"1\u0001/\u0002Q\u0001\n1DQ!]\u0003\u0005\nID\u0011\"!\n\u0006\u0005\u0004%\t!a\n\t\u0011\u0005eR\u0001)A\u0005\u0003SAq!a\u000f\u0006\t\u0003\ti\u0004\u0003\u0004\u0002D\u0015!\tA\u0017\u0005\b\u0003\u000b*A\u0011AA$\u0003AQ\u0005/Z4EK\u000e|W\u000e\u001d:fgN|'O\u0003\u0002\u001f?\u0005Y1m\\7qe\u0016\u001c8/[8o\u0015\t\u0001\u0013%A\u0004hK>$\u0018N\u001a4\u000b\u0005\t\u001a\u0013AA5p\u0015\t!S%\u0001\u0004sCN$XM\u001d\u0006\u0002M\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001A\u0011\u0011&A\u0007\u0002;\t\u0001\"\n]3h\t\u0016\u001cw.\u001c9sKN\u001cxN]\n\u0004\u00031\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u0002.g%\u0011AG\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\nQ!\u00199qYf$2!OA)!\tISaE\u0002\u0006Ym\u0002\"!\u000b\u001f\n\u0005uj\"\u0001\u0004#fG>l\u0007O]3tg>\u0014\u0018\u0001\u0003;jM\u001a$\u0016mZ:\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t{\u0012\u0001\u0002;bONL!\u0001R!\u0003\u0011QKgM\u001a+bON$\"!\u000f$\t\u000by:\u0001\u0019A \u0002\u0011)\u0004Xm\u001a+bON,\u0012!\u0013\t\u0003\u0001*K!aS!\u0003\u0011)\u0003Xm\u001a+bON\f\u0011B\u001b9fOR\u000bwm\u001d\u0011\u0002\u0013e\u001c%m\u0011:UC\u001e\u001cX#A(\u0011\u0005\u0001\u0003\u0016BA)B\u0005%I6IY\"s)\u0006<7/\u0001\u0006z\u0007\n\u001c%\u000fV1hg\u0002\nQbY8mS6,GO]=UC\u001e\u001cX#A+\u0011\u0005\u00013\u0016BA,B\u00055\u0019u\u000e\\5nKR\u0014\u0018\u0010V1hg\u0006q1m\u001c7j[\u0016$(/\u001f+bON\u0004\u0013!\u00059i_R|W.\u001a;sS\u000eLe\u000e^3saV\t1\f\u0005\u0002.9&\u0011QL\f\u0002\u0004\u0013:$\u0018A\u00059i_R|W.\u001a;sS\u000eLe\u000e^3sa\u0002\nqcQ\"J%~3\u0004'M02?\u000e{UI\u0012$J\u0007&+e\nV*\u0016\u0003\u0005\u00042!\f2e\u0013\t\u0019gFA\u0003BeJ\f\u0017\u0010\u0005\u0002.K&\u0011aM\f\u0002\u0007\t>,(\r\\3\u00021\r\u001b\u0015JU07aEz\u0016gX\"P\u000b\u001a3\u0015jQ%F\u001dR\u001b\u0006%A\u0011S\u000b\u001a+%+\u0012(D\u000b~\u0013E*Q\"L?^C\u0015\nV#`3\u000e\u001bu\fR#G\u0003VcE+\u0001\u0012S\u000b\u001a+%+\u0012(D\u000b~\u0013E*Q\"L?^C\u0015\nV#`3\u000e\u001bu\fR#G\u0003VcE\u000bI\u0001\u000bUB,w\rV1cY\u0016\u001cX#\u00017\u0011\u00075\u0012W\u000e\u0005\u0002.]&\u0011qN\f\u0002\u0005\u0005f$X-A\u0006ka\u0016<G+\u00192mKN\u0004\u0013AD<ji\"T\u0005/Z4SK\u0006$WM]\u000b\u0003g^$2\u0001^A\u000e)\r)\u0018\u0011\u0001\t\u0003m^d\u0001\u0001B\u0003y-\t\u0007\u0011PA\u0001U#\tQX\u0010\u0005\u0002.w&\u0011AP\f\u0002\b\u001d>$\b.\u001b8h!\tic0\u0003\u0002\u0000]\t\u0019\u0011I\\=\t\u000f\u0005\ra\u00031\u0001\u0002\u0006\u0005\u0011aM\u001c\t\u0007[\u0005\u001d\u00111B;\n\u0007\u0005%aFA\u0005Gk:\u001cG/[8ocA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011aB5nC\u001e,\u0017n\u001c\u0006\u0003\u0003+\tQA[1wCbLA!!\u0007\u0002\u0010\tY\u0011*\\1hKJ+\u0017\rZ3s\u0011\u001d\tiB\u0006a\u0001\u0003?\t!\"\u001b8qkR\u0014\u0015\u0010^3t!\u0011i\u0013\u0011\u00057\n\u0007\u0005\rbF\u0001\u0004PaRLwN\\\u0001\nUB,w\rU1sC6,\"!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005!!\u000e]3h\u0015\u0011\t\u0019$a\u0004\u0002\u000fAdWoZ5og&!\u0011qGA\u0017\u0005IQ\u0005+R$J[\u0006<WMU3bIB\u000b'/Y7\u0002\u0015)\u0004Xm\u001a)be\u0006l\u0007%\u0001\bo_Jl\u0017\r\\5{Kf\u001b%m\u0011:\u0015\u00071\fy\u0004\u0003\u0004\u0002Be\u0001\r\u0001\\\u0001\u0006CJ\u0014\u0018-_\u0001\u0005G>$W-\u0001\u0006eK\u000e|W\u000e\u001d:fgN$R\u0001\\A%\u0003\u001bBa!a\u0013\u001c\u0001\u0004a\u0017aB:fO6,g\u000e\u001e\u0005\u0007\u0003\u001fZ\u0002\u0019A.\u0002\u0019M,w-\\3oi&sG-\u001a=\t\u000by\u001a\u0001\u0019A \u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003/\u0002B!!\u0017\u0002d5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0003mC:<'BAA1\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00141\f\u0002\u0007\u001f\nTWm\u0019;")
public class JpegDecompressor
implements Decompressor {
    private final JpegTags jpegTags;
    private final YCbCrTags yCbCrTags;
    private final ColimetryTags colimetryTags;
    private final int photometricInterp;
    private final double[] CCIR_601_1_COEFFICIENTS;
    private final double[] REFERENCE_BLACK_WHITE_YCC_DEFAULT;
    private final byte[] jpegTables;
    private final JPEGImageReadParam jpegParam;

    public static JpegDecompressor apply(TiffTags tiffTags) {
        return JpegDecompressor$.MODULE$.apply(tiffTags);
    }

    @Override
    public int predictorCode() {
        return Decompressor.predictorCode$(this);
    }

    @Override
    public ByteOrder byteOrder() {
        return Decompressor.byteOrder$(this);
    }

    @Override
    public Decompressor flipEndian(int bytesPerFlip) {
        return Decompressor.flipEndian$(this, bytesPerFlip);
    }

    @Override
    public Decompressor withPredictor(Predictor predictor) {
        return Decompressor.withPredictor$(this, predictor);
    }

    public JpegTags jpegTags() {
        return this.jpegTags;
    }

    public YCbCrTags yCbCrTags() {
        return this.yCbCrTags;
    }

    public ColimetryTags colimetryTags() {
        return this.colimetryTags;
    }

    public int photometricInterp() {
        return this.photometricInterp;
    }

    public final double[] CCIR_601_1_COEFFICIENTS() {
        return this.CCIR_601_1_COEFFICIENTS;
    }

    public final double[] REFERENCE_BLACK_WHITE_YCC_DEFAULT() {
        return this.REFERENCE_BLACK_WHITE_YCC_DEFAULT;
    }

    public byte[] jpegTables() {
        return this.jpegTables;
    }

    private <T> T withJpegReader(Option<byte[]> inputBytes, Function1<ImageReader, T> fn) {
        Object object;
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
        if (!readers.hasNext()) {
            throw new IIOException("Could not instantiate JPEGImageReader");
        }
        ImageReader reader = readers.next();
        ImageInputStream tablesSource = ImageIO.createImageInputStream(new ByteArrayInputStream(this.jpegTables()));
        Option imageSource = inputBytes.map((Function1 & Serializable & scala.Serializable)ib -> ImageIO.createImageInputStream(new ByteArrayInputStream((byte[])ib)));
        try {
            reader.setInput(tablesSource);
            reader.getStreamMetadata();
            imageSource.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                reader.setInput(x$1);
                return BoxedUnit.UNIT;
            });
            object = fn.apply((Object)reader);
        }
        finally {
            tablesSource.close();
            imageSource.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.close();
                return BoxedUnit.UNIT;
            });
            reader.dispose();
        }
        return (T)object;
    }

    public JPEGImageReadParam jpegParam() {
        return this.jpegParam;
    }

    public byte[] normalizeYCbCr(byte[] array) {
        double[] coefficients = (double[])this.yCbCrTags().yCbCrCoefficients().map((Function1 & Serializable & scala.Serializable)rationals -> (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rationals)).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)JpegDecompressor.$anonfun$normalizeYCbCr$2(x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.CCIR_601_1_COEFFICIENTS());
        double[] referenceBW = (double[])this.colimetryTags().referenceBlackWhite().map((Function1 & Serializable & scala.Serializable)v -> (double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(v)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$3 -> x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.REFERENCE_BLACK_WHITE_YCC_DEFAULT());
        for (int index$macro$1 = 0; index$macro$1 < array.length; index$macro$1 += 3) {
            YCbCrConverter$.MODULE$.convertYCbCr2RGB(array, array, coefficients, referenceBW, index$macro$1);
        }
        return array;
    }

    @Override
    public int code() {
        return CompressionType$.MODULE$.JpegCoded();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decompress(byte[] segment, int segmentIndex) {
        void var3_3;
        byte[] result = (byte[])this.withJpegReader((Option<byte[]>)new Some((Object)segment), (Function1 & Serializable & scala.Serializable)jpegReader -> ((DataBufferByte)jpegReader.readRaster(0, this.jpegParam()).getDataBuffer()).getData());
        return (byte[])(this.photometricInterp() == ColorSpace$.MODULE$.YCbCr() ? this.normalizeYCbCr(result) : var3_3);
    }

    public static final /* synthetic */ double $anonfun$normalizeYCbCr$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long a = tuple2._1$mcJ$sp();
        long b = tuple2._2$mcJ$sp();
        double d = (double)a / (double)b;
        return d;
    }

    public JpegDecompressor(TiffTags tiffTags) {
        Decompressor.$init$(this);
        this.jpegTags = tiffTags.jpegTags();
        this.yCbCrTags = tiffTags.yCbCrTags();
        this.colimetryTags = tiffTags.colimetryTags();
        this.photometricInterp = tiffTags.basicTags().photometricInterp();
        this.CCIR_601_1_COEFFICIENTS = new double[]{0.299, 0.587, 0.114};
        this.REFERENCE_BLACK_WHITE_YCC_DEFAULT = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 255.0, 128.0, 255.0, 128.0, 255.0}), ClassTag$.MODULE$.Double());
        this.jpegTables = (byte[])this.jpegTags().jpegTables().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String msg = "compression type JPEG is not supported by this reader if JPEG Tables tag is not set.";
            throw new GeoTiffReaderLimitationException(msg);
        });
        this.jpegParam = (JPEGImageReadParam)this.withJpegReader((Option<byte[]>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)jpegReader -> {
            void var1_1;
            JPEGImageReadParam params = (JPEGImageReadParam)jpegReader.getDefaultReadParam();
            params.setSourceSubsampling(1, 1, 0, 0);
            return var1_1;
        });
    }
}

