/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.LZWDecompressor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.TokenTable$;
import geotrellis.raster.io.geotiff.compression.TokenTableEntry;
import geotrellis.raster.io.geotiff.tags.codes.CompressionType$;
import java.nio.ByteOrder;
import scala.Array$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001]<Q!\u0007\u000e\t\u0002\u00152Qa\n\u000e\t\u0002!BQAM\u0001\u0005\u0002MBQ\u0001N\u0001\u0005\u0002UBq!\\\u0001\u0002\u0002\u0013%aN\u0002\u0003(5\u00019\u0004\u0002C\u001e\u0006\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u000bI*A\u0011\u0001\"\t\u000b\u0011+A\u0011A#\t\u000f\u0019+!\u0019!C\u0001\u000b\"1q)\u0002Q\u0001\n}Bq\u0001S\u0003C\u0002\u0013\u0005Q\t\u0003\u0004J\u000b\u0001\u0006Ia\u0010\u0005\b\u0015\u0016\u0011\r\u0011\"\u0001F\u0011\u0019YU\u0001)A\u0005\u007f!)A*\u0002C\u0001\u001b\u001a!a+\u0002\u0003X\u0011!A\u0006C!A!\u0002\u0013q\u0005\"\u0002\u001a\u0011\t\u0003I\u0006bB/\u0011\u0005\u0004%\t!\u0012\u0005\u0007=B\u0001\u000b\u0011B \t\u000f}\u0003\u0002\u0019!C\u0005\u000b\"9\u0001\r\u0005a\u0001\n\u0013\t\u0007BB4\u0011A\u0003&q\bC\u0003i!\u0011\u0005\u0011.A\bM5^#UmY8naJ,7o]8s\u0015\tYB$A\u0006d_6\u0004(/Z:tS>t'BA\u000f\u001f\u0003\u001d9Wm\u001c;jM\u001aT!a\b\u0011\u0002\u0005%|'BA\u0011#\u0003\u0019\u0011\u0018m\u001d;fe*\t1%\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001\u0001\u0005\u0002'\u00035\t!DA\bM5^#UmY8naJ,7o]8s'\r\t\u0011f\f\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)\u0002\u0014BA\u0019,\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQ%A\u0003baBd\u0017\u0010\u0006\u00027YB\u0011a%B\n\u0004\u000b%B\u0004C\u0001\u0014:\u0013\tQ$D\u0001\u0007EK\u000e|W\u000e\u001d:fgN|'/\u0001\u0007tK\u001elWM\u001c;TSj,7\u000fE\u0002+{}J!AP\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)\u0002\u0015BA!,\u0005\rIe\u000e\u001e\u000b\u0003m\rCQaO\u0004A\u0002q\nAaY8eKV\tq(\u0001\u0006uC\ndW\rT5nSR\f1\u0002^1cY\u0016d\u0015.\\5uA\u0005I1\t\\3be\u000e{G-Z\u0001\u000b\u00072,\u0017M]\"pI\u0016\u0004\u0013aB#p\u0013\u000e{G-Z\u0001\t\u000b>L5i\u001c3fA\u0005QA-Z2p[B\u0014Xm]:\u0015\u00079\u0013F\u000bE\u0002+{=\u0003\"A\u000b)\n\u0005E[#\u0001\u0002\"zi\u0016DQaU\bA\u00029\u000bqa]3h[\u0016tG\u000fC\u0003V\u001f\u0001\u0007q(\u0001\u0007tK\u001elWM\u001c;J]\u0012,\u0007PA\tM5^\u0013\u0015\u000e^%oaV$8\u000b\u001e:fC6\u001c\"\u0001E\u0015\u0002\u0007\u0005\u0014(\u000f\u0006\u0002[9B\u00111\fE\u0007\u0002\u000b!)\u0001L\u0005a\u0001\u001d\u0006\u0019A.\u001a8\u0002\t1,g\u000eI\u0001\u0006S:$W\r_\u0001\nS:$W\r_0%KF$\"AY3\u0011\u0005)\u001a\u0017B\u00013,\u0005\u0011)f.\u001b;\t\u000f\u00194\u0012\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\u0002\r%tG-\u001a=!\u0003\r9W\r\u001e\u000b\u0003\u007f)DQa\u001b\rA\u0002}\nAA\\3yi\")1h\u0001a\u0001y\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0011a\u0017M\\4\u000b\u0003Q\fAA[1wC&\u0011a/\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class LZWDecompressor
implements Decompressor {
    private final int[] segmentSizes;
    private final int tableLimit;
    private final int ClearCode;
    private final int EoICode;

    public static LZWDecompressor apply(int[] nArray) {
        return LZWDecompressor$.MODULE$.apply(nArray);
    }

    @Override
    public int predictorCode() {
        return Decompressor.predictorCode$(this);
    }

    @Override
    public ByteOrder byteOrder() {
        return Decompressor.byteOrder$(this);
    }

    @Override
    public Decompressor flipEndian(int bytesPerFlip) {
        return Decompressor.flipEndian$(this, bytesPerFlip);
    }

    @Override
    public Decompressor withPredictor(Predictor predictor) {
        return Decompressor.withPredictor$(this, predictor);
    }

    @Override
    public int code() {
        return CompressionType$.MODULE$.LZWCoded();
    }

    public int tableLimit() {
        return this.tableLimit;
    }

    public int ClearCode() {
        return this.ClearCode;
    }

    public int EoICode() {
        return this.EoICode;
    }

    @Override
    public byte[] decompress(byte[] segment, int segmentIndex) {
        LZWBitInputStream bis = new LZWBitInputStream(this, segment);
        ObjectRef tokenTable = ObjectRef.create((Object)TokenTable$.MODULE$.initial());
        IntRef tokenTableIndex = IntRef.create((int)258);
        int outputArrayIndex = 0;
        int size = this.segmentSizes[segmentIndex];
        byte[] outputArray = (byte[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.Byte());
        IntRef threshold = IntRef.create((int)9);
        int code = 0;
        int oldCode = 0;
        boolean bl = false;
        while (!bl && (code = bis.get(threshold.elem)) != this.EoICode() && outputArrayIndex < size) {
            if (code == this.ClearCode()) {
                LZWDecompressor.initializeTokenTable$1(tokenTable, tokenTableIndex, threshold);
                code = bis.get(threshold.elem);
                if (code == this.EoICode()) {
                    bl = true;
                } else {
                    outputArrayIndex = TokenTable$.MODULE$.writeToOutput(((TokenTableEntry[])tokenTable.elem)[code], outputArray, outputArrayIndex);
                }
            } else if (code < tokenTableIndex.elem) {
                TokenTableEntry entry = ((TokenTableEntry[])tokenTable.elem)[code];
                outputArrayIndex = TokenTable$.MODULE$.writeToOutput(entry, outputArray, outputArrayIndex);
                TokenTableEntry oldEntry = ((TokenTableEntry[])tokenTable.elem)[oldCode];
                LZWDecompressor.addEntry$1(oldEntry.concat(entry.firstByte()), tokenTable, tokenTableIndex, threshold);
            } else {
                TokenTableEntry oldEntry = ((TokenTableEntry[])tokenTable.elem)[oldCode];
                TokenTableEntry newEntry = oldEntry.concat(oldEntry.firstByte());
                outputArrayIndex = TokenTable$.MODULE$.writeToOutput(newEntry, outputArray, outputArrayIndex);
                LZWDecompressor.addEntry$1(newEntry, tokenTable, tokenTableIndex, threshold);
            }
            oldCode = code;
        }
        return outputArray;
    }

    private static final void initializeTokenTable$1(ObjectRef tokenTable$1, IntRef tokenTableIndex$1, IntRef threshold$1) {
        tokenTable$1.elem = TokenTable$.MODULE$.initial();
        tokenTableIndex$1.elem = 258;
        threshold$1.elem = 9;
    }

    private static final void addEntry$1(TokenTableEntry entry, ObjectRef tokenTable$1, IntRef tokenTableIndex$1, IntRef threshold$1) {
        block2: {
            ((TokenTableEntry[])tokenTable$1.elem)[tokenTableIndex$1.elem] = entry;
            ++tokenTableIndex$1.elem;
            if (tokenTableIndex$1.elem == 511) {
                threshold$1.elem = 10;
            }
            if (tokenTableIndex$1.elem == 1023) {
                threshold$1.elem = 11;
            }
            if (tokenTableIndex$1.elem != 2047) break block2;
            threshold$1.elem = 12;
        }
    }

    public LZWDecompressor(int[] segmentSizes) {
        this.segmentSizes = segmentSizes;
        Decompressor.$init$(this);
        this.tableLimit = 4096;
        this.ClearCode = 256;
        this.EoICode = 257;
    }

    public class LZWBitInputStream {
        private final byte[] arr;
        private final int len;
        private int index;
        public final /* synthetic */ LZWDecompressor $outer;

        public int len() {
            return this.len;
        }

        private int index() {
            return this.index;
        }

        private void index_$eq(int x$1) {
            this.index = x$1;
        }

        public int get(int next) {
            int n;
            if (next + this.index() > this.len() * 8) {
                n = this.geotrellis$raster$io$geotiff$compression$LZWDecompressor$LZWBitInputStream$$$outer().EoICode();
            } else {
                int n2;
                int start = this.index() / 8;
                int end = (this.index() + next - 1) / 8;
                int ebi = (this.index() + next - 1) % 8;
                if (end - start == 2) {
                    int c = (this.arr[start] & 0xFF) << 16 | (this.arr[end - 1] & 0xFF) << 8 | this.arr[end] & 0xFF;
                    n2 = c >> 7 - ebi & 0xFFFFFF >> 24 - next;
                } else {
                    int c = (this.arr[start] & 0xFF) << 8 | this.arr[end] & 0xFF;
                    n2 = c >> 7 - ebi & 65535 >> 16 - next;
                }
                int res = n2;
                this.index_$eq(this.index() + next);
                n = res;
            }
            return n;
        }

        public /* synthetic */ LZWDecompressor geotrellis$raster$io$geotiff$compression$LZWDecompressor$LZWBitInputStream$$$outer() {
            return this.$outer;
        }

        public LZWBitInputStream(LZWDecompressor $outer, byte[] arr) {
            this.arr = arr;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.len = arr.length;
            this.index = 0;
        }
    }
}

