/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.PackBitsDecompressor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.tags.codes.CompressionType$;
import java.nio.ByteOrder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u00011;QAC\u0006\t\u0002Y1Q\u0001G\u0006\t\u0002eAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005\u0002\u0019BqAQ\u0001\u0002\u0002\u0013%1I\u0002\u0003\u0019\u0017\u0001A\u0003\u0002\u0003\u0017\u0006\u0005\u0003\u0005\u000b\u0011B\u0017\t\u000b\r*A\u0011A\u001a\t\u000bU*A\u0011\u0001\u001c\t\u000b]*A\u0011\u0001\u001d\u0002)A\u000b7m\u001b\"jiN$UmY8naJ,7o]8s\u0015\taQ\"A\u0006d_6\u0004(/Z:tS>t'B\u0001\b\u0010\u0003\u001d9Wm\u001c;jM\u001aT!\u0001E\t\u0002\u0005%|'B\u0001\n\u0014\u0003\u0019\u0011\u0018m\u001d;fe*\tA#\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001\u0001\u0005\u0002\u0018\u00035\t1B\u0001\u000bQC\u000e\\')\u001b;t\t\u0016\u001cw.\u001c9sKN\u001cxN]\n\u0004\u0003i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\tQ!\u00199qYf$\"aJ!\u0011\u0005])1cA\u0003\u001bSA\u0011qCK\u0005\u0003W-\u0011A\u0002R3d_6\u0004(/Z:t_J\fAb]3h[\u0016tGoU5{KN\u00042a\u0007\u00181\u0013\tyCDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001cc%\u0011!\u0007\b\u0002\u0004\u0013:$HCA\u00145\u0011\u0015as\u00011\u0001.\u0003\u0011\u0019w\u000eZ3\u0016\u0003A\n!\u0002Z3d_6\u0004(/Z:t)\rITh\u0010\t\u000479R\u0004CA\u000e<\u0013\taDD\u0001\u0003CsR,\u0007\"\u0002 \n\u0001\u0004I\u0014aB:fO6,g\u000e\u001e\u0005\u0006\u0001&\u0001\r\u0001M\u0001\rg\u0016<W.\u001a8u\u0013:$W\r\u001f\u0005\u0006Y\r\u0001\r!L\u0001\fe\u0016\fGMU3t_24X\rF\u0001E!\t)%*D\u0001G\u0015\t9\u0005*\u0001\u0003mC:<'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013aa\u00142kK\u000e$\b")
public class PackBitsDecompressor
implements Decompressor {
    private final int[] segmentSizes;

    public static PackBitsDecompressor apply(int[] nArray) {
        return PackBitsDecompressor$.MODULE$.apply(nArray);
    }

    @Override
    public int predictorCode() {
        return Decompressor.predictorCode$(this);
    }

    @Override
    public ByteOrder byteOrder() {
        return Decompressor.byteOrder$(this);
    }

    @Override
    public Decompressor flipEndian(int bytesPerFlip) {
        return Decompressor.flipEndian$(this, bytesPerFlip);
    }

    @Override
    public Decompressor withPredictor(Predictor predictor) {
        return Decompressor.withPredictor$(this, predictor);
    }

    @Override
    public int code() {
        return CompressionType$.MODULE$.PackBitsCoded();
    }

    @Override
    public byte[] decompress(byte[] segment, int segmentIndex) {
        int size = this.segmentSizes[segmentIndex];
        byte[] rowArray = new byte[size];
        int j = 0;
        int total = 0;
        int len = segment.length;
        while (total != size && j < len) {
            byte headerByte = segment[j];
            ++j;
            if (0 <= headerByte) {
                int limit = total + headerByte + 1;
                while (total < limit) {
                    rowArray[total] = segment[j];
                    ++total;
                    ++j;
                }
                continue;
            }
            if (-128 >= headerByte || headerByte >= 0) continue;
            byte b = segment[j];
            ++j;
            int limit = total + (1 - headerByte);
            while (total < limit) {
                rowArray[total] = b;
                ++total;
            }
        }
        return rowArray;
    }

    public PackBitsDecompressor(int[] segmentSizes) {
        this.segmentSizes = segmentSizes;
        Decompressor.$init$(this);
    }
}

