/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.tags;

import cats.Apply;
import cats.Functor;
import cats.Functor$;
import cats.data.NonEmptyList;
import cats.data.Validated;
import geotrellis.raster.io.geotiff.Tiff$;
import geotrellis.raster.io.geotiff.TiffType;
import geotrellis.raster.io.geotiff.TiffType$;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.tags.BasicTags;
import geotrellis.raster.io.geotiff.tags.BasicTags$;
import geotrellis.raster.io.geotiff.tags.CmykTags;
import geotrellis.raster.io.geotiff.tags.CmykTags$;
import geotrellis.raster.io.geotiff.tags.ColimetryTags;
import geotrellis.raster.io.geotiff.tags.ColimetryTags$;
import geotrellis.raster.io.geotiff.tags.DataSampleFormatTags;
import geotrellis.raster.io.geotiff.tags.DataSampleFormatTags$;
import geotrellis.raster.io.geotiff.tags.DocumentationTags;
import geotrellis.raster.io.geotiff.tags.DocumentationTags$;
import geotrellis.raster.io.geotiff.tags.GeoKeyDirectory;
import geotrellis.raster.io.geotiff.tags.GeoKeyDirectory$;
import geotrellis.raster.io.geotiff.tags.GeoKeyDirectoryMetadata;
import geotrellis.raster.io.geotiff.tags.GeoKeyReader$;
import geotrellis.raster.io.geotiff.tags.GeoTiffTags;
import geotrellis.raster.io.geotiff.tags.GeoTiffTags$;
import geotrellis.raster.io.geotiff.tags.JpegTags;
import geotrellis.raster.io.geotiff.tags.JpegTags$;
import geotrellis.raster.io.geotiff.tags.MetadataTags;
import geotrellis.raster.io.geotiff.tags.MetadataTags$;
import geotrellis.raster.io.geotiff.tags.NonBasicTags;
import geotrellis.raster.io.geotiff.tags.NonBasicTags$;
import geotrellis.raster.io.geotiff.tags.NonStandardizedTags;
import geotrellis.raster.io.geotiff.tags.NonStandardizedTags$;
import geotrellis.raster.io.geotiff.tags.Pixel3D;
import geotrellis.raster.io.geotiff.tags.TiffTagMetadata;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.TileTags;
import geotrellis.raster.io.geotiff.tags.TileTags$;
import geotrellis.raster.io.geotiff.tags.YCbCrTags;
import geotrellis.raster.io.geotiff.tags.YCbCrTags$;
import geotrellis.raster.io.geotiff.tags.codes.TagCodes$;
import geotrellis.raster.io.geotiff.tags.codes.TiffFieldType$;
import geotrellis.raster.io.geotiff.util.IntTiffTagOffsetSize$;
import geotrellis.raster.io.geotiff.util.LongTiffTagOffsetSize$;
import geotrellis.raster.io.geotiff.util.TiffTagOffsetSize;
import geotrellis.raster.io.geotiff.util.package$;
import geotrellis.util.ByteReader;
import geotrellis.util.ByteReader$;
import geotrellis.util.Filesystem$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.HCursor;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.generic.decoding.DerivedDecoder;
import io.circe.generic.decoding.DerivedDecoder$;
import io.circe.generic.decoding.ReprDecoder;
import io.circe.generic.decoding.ReprDecoder$;
import io.circe.generic.encoding.DerivedAsObjectEncoder;
import io.circe.generic.encoding.DerivedAsObjectEncoder$;
import io.circe.generic.encoding.ReprAsObjectEncoder;
import io.circe.generic.semiauto$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import monocle.PLens;
import monocle.syntax.ApplyLensOps$;
import monocle.syntax.apply$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple14;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import shapeless.;
import shapeless.DefaultSymbolicLabelling;
import shapeless.Generic;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.ops.hlist;

public final class TiffTags$
implements scala.Serializable {
    public static TiffTags$ MODULE$;
    private final PLens<TiffTags, TiffTags, MetadataTags, MetadataTags> _metadataTags;
    private final PLens<TiffTags, TiffTags, BasicTags, BasicTags> _basicTags;
    private final PLens<TiffTags, TiffTags, NonBasicTags, NonBasicTags> _nonBasicTags;
    private final PLens<TiffTags, TiffTags, GeoTiffTags, GeoTiffTags> _geoTiffTags;
    private final PLens<TiffTags, TiffTags, DocumentationTags, DocumentationTags> _documentationTags;
    private final PLens<TiffTags, TiffTags, TileTags, TileTags> _tileTags;
    private final PLens<TiffTags, TiffTags, CmykTags, CmykTags> _cmykTags;
    private final PLens<TiffTags, TiffTags, DataSampleFormatTags, DataSampleFormatTags> _dataSampleFormatTags;
    private final PLens<TiffTags, TiffTags, ColimetryTags, ColimetryTags> _colimetryTags;
    private final PLens<TiffTags, TiffTags, JpegTags, JpegTags> _jpegTags;
    private final PLens<TiffTags, TiffTags, YCbCrTags, YCbCrTags> _yCbCrTags;
    private final PLens<TiffTags, TiffTags, NonStandardizedTags, NonStandardizedTags> _nonStandardizedTags;
    private final PLens<TiffTags, TiffTags, TiffType, TiffType> _tiffType;
    private final PLens<TiffTags, TiffTags, List<TiffTags>, List<TiffTags>> _overviews;
    private final Encoder<TiffTags> tiffTagsEncoder;
    private final Decoder<TiffTags> tiffTagsDecoder;

    static {
        new TiffTags$();
    }

    public MetadataTags $lessinit$greater$default$1() {
        return new MetadataTags(MetadataTags$.MODULE$.apply$default$1(), MetadataTags$.MODULE$.apply$default$2(), MetadataTags$.MODULE$.apply$default$3(), MetadataTags$.MODULE$.apply$default$4(), MetadataTags$.MODULE$.apply$default$5(), MetadataTags$.MODULE$.apply$default$6(), MetadataTags$.MODULE$.apply$default$7(), MetadataTags$.MODULE$.apply$default$8());
    }

    public BasicTags $lessinit$greater$default$2() {
        return new BasicTags(BasicTags$.MODULE$.apply$default$1(), BasicTags$.MODULE$.apply$default$2(), BasicTags$.MODULE$.apply$default$3(), BasicTags$.MODULE$.apply$default$4(), BasicTags$.MODULE$.apply$default$5(), BasicTags$.MODULE$.apply$default$6(), BasicTags$.MODULE$.apply$default$7(), BasicTags$.MODULE$.apply$default$8(), BasicTags$.MODULE$.apply$default$9(), BasicTags$.MODULE$.apply$default$10(), BasicTags$.MODULE$.apply$default$11(), BasicTags$.MODULE$.apply$default$12(), BasicTags$.MODULE$.apply$default$13());
    }

    public NonBasicTags $lessinit$greater$default$3() {
        return new NonBasicTags(NonBasicTags$.MODULE$.apply$default$1(), NonBasicTags$.MODULE$.apply$default$2(), NonBasicTags$.MODULE$.apply$default$3(), NonBasicTags$.MODULE$.apply$default$4(), NonBasicTags$.MODULE$.apply$default$5(), NonBasicTags$.MODULE$.apply$default$6(), NonBasicTags$.MODULE$.apply$default$7(), NonBasicTags$.MODULE$.apply$default$8(), NonBasicTags$.MODULE$.apply$default$9(), NonBasicTags$.MODULE$.apply$default$10(), NonBasicTags$.MODULE$.apply$default$11(), NonBasicTags$.MODULE$.apply$default$12(), NonBasicTags$.MODULE$.apply$default$13(), NonBasicTags$.MODULE$.apply$default$14(), NonBasicTags$.MODULE$.apply$default$15(), NonBasicTags$.MODULE$.apply$default$16(), NonBasicTags$.MODULE$.apply$default$17());
    }

    public GeoTiffTags $lessinit$greater$default$4() {
        return new GeoTiffTags(GeoTiffTags$.MODULE$.apply$default$1(), GeoTiffTags$.MODULE$.apply$default$2(), GeoTiffTags$.MODULE$.apply$default$3(), GeoTiffTags$.MODULE$.apply$default$4(), GeoTiffTags$.MODULE$.apply$default$5(), GeoTiffTags$.MODULE$.apply$default$6(), GeoTiffTags$.MODULE$.apply$default$7(), GeoTiffTags$.MODULE$.apply$default$8());
    }

    public DocumentationTags $lessinit$greater$default$5() {
        return new DocumentationTags(DocumentationTags$.MODULE$.apply$default$1(), DocumentationTags$.MODULE$.apply$default$2(), DocumentationTags$.MODULE$.apply$default$3(), DocumentationTags$.MODULE$.apply$default$4(), DocumentationTags$.MODULE$.apply$default$5());
    }

    public TileTags $lessinit$greater$default$6() {
        return new TileTags(TileTags$.MODULE$.apply$default$1(), TileTags$.MODULE$.apply$default$2(), TileTags$.MODULE$.apply$default$3(), TileTags$.MODULE$.apply$default$4());
    }

    public CmykTags $lessinit$greater$default$7() {
        return new CmykTags(CmykTags$.MODULE$.apply$default$1(), CmykTags$.MODULE$.apply$default$2(), CmykTags$.MODULE$.apply$default$3(), CmykTags$.MODULE$.apply$default$4(), CmykTags$.MODULE$.apply$default$5());
    }

    public DataSampleFormatTags $lessinit$greater$default$8() {
        return new DataSampleFormatTags(DataSampleFormatTags$.MODULE$.apply$default$1(), DataSampleFormatTags$.MODULE$.apply$default$2(), DataSampleFormatTags$.MODULE$.apply$default$3());
    }

    public ColimetryTags $lessinit$greater$default$9() {
        return new ColimetryTags(ColimetryTags$.MODULE$.apply$default$1(), ColimetryTags$.MODULE$.apply$default$2(), ColimetryTags$.MODULE$.apply$default$3(), ColimetryTags$.MODULE$.apply$default$4(), ColimetryTags$.MODULE$.apply$default$5());
    }

    public JpegTags $lessinit$greater$default$10() {
        return new JpegTags(JpegTags$.MODULE$.apply$default$1(), JpegTags$.MODULE$.apply$default$2(), JpegTags$.MODULE$.apply$default$3(), JpegTags$.MODULE$.apply$default$4(), JpegTags$.MODULE$.apply$default$5(), JpegTags$.MODULE$.apply$default$6(), JpegTags$.MODULE$.apply$default$7(), JpegTags$.MODULE$.apply$default$8(), JpegTags$.MODULE$.apply$default$9(), JpegTags$.MODULE$.apply$default$10());
    }

    public YCbCrTags $lessinit$greater$default$11() {
        return new YCbCrTags(YCbCrTags$.MODULE$.apply$default$1(), YCbCrTags$.MODULE$.apply$default$2(), YCbCrTags$.MODULE$.apply$default$3());
    }

    public NonStandardizedTags $lessinit$greater$default$12() {
        return new NonStandardizedTags(NonStandardizedTags$.MODULE$.apply$default$1(), NonStandardizedTags$.MODULE$.apply$default$2(), NonStandardizedTags$.MODULE$.apply$default$3(), NonStandardizedTags$.MODULE$.apply$default$4(), NonStandardizedTags$.MODULE$.apply$default$5());
    }

    public TiffType $lessinit$greater$default$13() {
        return Tiff$.MODULE$;
    }

    public List<TiffTags> $lessinit$greater$default$14() {
        return Nil$.MODULE$;
    }

    public PLens<TiffTags, TiffTags, MetadataTags, MetadataTags> _metadataTags() {
        return this._metadataTags;
    }

    public PLens<TiffTags, TiffTags, BasicTags, BasicTags> _basicTags() {
        return this._basicTags;
    }

    public PLens<TiffTags, TiffTags, NonBasicTags, NonBasicTags> _nonBasicTags() {
        return this._nonBasicTags;
    }

    public PLens<TiffTags, TiffTags, GeoTiffTags, GeoTiffTags> _geoTiffTags() {
        return this._geoTiffTags;
    }

    public PLens<TiffTags, TiffTags, DocumentationTags, DocumentationTags> _documentationTags() {
        return this._documentationTags;
    }

    public PLens<TiffTags, TiffTags, TileTags, TileTags> _tileTags() {
        return this._tileTags;
    }

    public PLens<TiffTags, TiffTags, CmykTags, CmykTags> _cmykTags() {
        return this._cmykTags;
    }

    public PLens<TiffTags, TiffTags, DataSampleFormatTags, DataSampleFormatTags> _dataSampleFormatTags() {
        return this._dataSampleFormatTags;
    }

    public PLens<TiffTags, TiffTags, ColimetryTags, ColimetryTags> _colimetryTags() {
        return this._colimetryTags;
    }

    public PLens<TiffTags, TiffTags, JpegTags, JpegTags> _jpegTags() {
        return this._jpegTags;
    }

    public PLens<TiffTags, TiffTags, YCbCrTags, YCbCrTags> _yCbCrTags() {
        return this._yCbCrTags;
    }

    public PLens<TiffTags, TiffTags, NonStandardizedTags, NonStandardizedTags> _nonStandardizedTags() {
        return this._nonStandardizedTags;
    }

    public PLens<TiffTags, TiffTags, TiffType, TiffType> _tiffType() {
        return this._tiffType;
    }

    public PLens<TiffTags, TiffTags, List<TiffTags>, List<TiffTags>> _overviews() {
        return this._overviews;
    }

    public TiffTags read(String path) {
        return this.read(ByteReader$.MODULE$.byteBuffer2ByteReader(Filesystem$.MODULE$.toMappedByteBuffer(path)));
    }

    public TiffTags read(byte[] bytes) {
        return this.read(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)));
    }

    /*
     * Unable to fully structure code
     */
    public TiffTags read(ByteReader byteReader) {
        block7: {
            block6: {
                var3_2 = new Tuple2.mcCC.sp((char)byteReader.get(), (char)byteReader.get());
                if (var3_2 == null) break block6;
                var4_3 = var3_2._1$mcC$sp();
                var5_4 = var3_2._2$mcC$sp();
                if ('I' != var4_3 || 'I' != var5_4) break block6;
                byteReader.order(ByteOrder.LITTLE_ENDIAN);
                var2_5 = BoxedUnit.UNIT;
                break block7;
            }
            if (var3_2 == null) ** GOTO lbl-1000
            var6_7 = var3_2._1$mcC$sp();
            var7_8 = var3_2._2$mcC$sp();
            if ('M' == var6_7 && 'M' == var7_8) {
                byteReader.order(ByteOrder.BIG_ENDIAN);
                var2_6 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                throw new MalformedGeoTiffException("incorrect byte order");
            }
        }
        var8_9 = byteReader.getChar();
        switch (var8_9) {
            case '*': {
                v0 = this.read(byteReader, byteReader.getInt(), IntTiffTagOffsetSize$.MODULE$);
                break;
            }
            case '+': {
                byteReader.position(8L);
                v0 = this.read(byteReader, byteReader.getLong(), LongTiffTagOffsetSize$.MODULE$);
                break;
            }
            default: {
                throw new MalformedGeoTiffException(new StringBuilder(50).append("bad identification number (must be 42 or 43, was ").append(var8_9).append(")").toString());
            }
        }
        return v0;
    }

    public TiffTags read(ByteReader byteReader, long tagsStartPosition, TiffTagOffsetSize ttos) {
        int rowsPerStrip;
        long l;
        TiffTagOffsetSize tiffTagOffsetSize = ttos;
        if (IntTiffTagOffsetSize$.MODULE$.equals(tiffTagOffsetSize)) {
            byteReader.position((long)((int)tagsStartPosition));
            l = byteReader.getShort();
        } else if (LongTiffTagOffsetSize$.MODULE$.equals(tiffTagOffsetSize)) {
            byteReader.position(tagsStartPosition);
            l = byteReader.getLong();
        } else {
            throw new MatchError((Object)tiffTagOffsetSize);
        }
        long tagCount = l;
        TiffTags tiffTags = new TiffTags(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9(), this.apply$default$10(), this.apply$default$11(), this.apply$default$12(), this.apply$default$13(), this.apply$default$14());
        None$ geoTags = None$.MODULE$;
        int index$macro$1 = 0;
        while ((long)index$macro$1 < tagCount) {
            TiffTagMetadata tiffTagMetadata;
            TiffTagOffsetSize tiffTagOffsetSize2 = ttos;
            if (IntTiffTagOffsetSize$.MODULE$.equals(tiffTagOffsetSize2)) {
                tiffTagMetadata = new TiffTagMetadata(package$.MODULE$.ByteReaderUtilities(byteReader).getUnsignedShort(), package$.MODULE$.ByteReaderUtilities(byteReader).getUnsignedShort(), byteReader.getInt(), byteReader.getInt());
            } else if (LongTiffTagOffsetSize$.MODULE$.equals(tiffTagOffsetSize2)) {
                tiffTagMetadata = new TiffTagMetadata(package$.MODULE$.ByteReaderUtilities(byteReader).getUnsignedShort(), package$.MODULE$.ByteReaderUtilities(byteReader).getUnsignedShort(), byteReader.getLong(), byteReader.getLong());
            } else {
                throw new MatchError((Object)tiffTagOffsetSize2);
            }
            TiffTagMetadata tagMetadata = tiffTagMetadata;
            if (tagMetadata.tag() == TagCodes$.MODULE$.GeoKeyDirectoryTag()) {
                geoTags = new Some((Object)tagMetadata);
            } else {
                tiffTags = this.readTag(byteReader, tiffTags, tagMetadata, ttos);
            }
            ++index$macro$1;
        }
        None$ none$ = geoTags;
        if (none$ instanceof Some) {
            Some some = (Some)none$;
            TiffTagMetadata t = (TiffTagMetadata)some.value();
            tiffTags = this.readTag(byteReader, tiffTags, t, ttos);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(none$)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)none$);
        }
        return tiffTags.hasStripStorage() ? ((rowsPerStrip = (int)BoxesRunTime.unboxToLong((Object)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._rowsPerStrip()).get())) < 0 ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._rowsPerStrip()).set((Object)BoxesRunTime.boxToLong((long)tiffTags.rows())) : tiffTags) : tiffTags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TiffTags readTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tagMetadata.tag(), tagMetadata.fieldType());
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            if (TagCodes$.MODULE$.ModelPixelScaleTag() == n) {
                return this.readModelPixelScaleTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            if (TagCodes$.MODULE$.ModelTiePointsTag() == n) {
                return this.readModelTiePointsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            if (TagCodes$.MODULE$.GeoKeyDirectoryTag() == n) {
                return this.readGeoKeyDirectoryTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.BytesFieldType() == n) {
                return this.readBytesTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.AsciisFieldType() == n) {
                return this.readAsciisTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.ShortsFieldType() == n) {
                return this.readShortsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.IntsFieldType() == n) {
                return this.readIntsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.FractionalsFieldType() == n) {
                return this.readFractionalsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedBytesFieldType() == n) {
                return this.readSignedBytesTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.UndefinedFieldType() == n) {
                return this.readUndefinedTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedShortsFieldType() == n) {
                return this.readSignedShortsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedIntsFieldType() == n) {
                return this.readSignedIntsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedFractionalsFieldType() == n) {
                return this.readSignedFractionalsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.FloatsFieldType() == n) {
                return this.readFloatsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.DoublesFieldType() == n) {
                return this.readDoublesTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.LongsFieldType() == n) {
                return this.readLongsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedLongsFieldType() == n) {
                return this.readLongsTag(byteReader, tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 == null) return new TiffTags(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9(), this.apply$default$10(), this.apply$default$11(), this.apply$default$12(), this.apply$default$13(), this.apply$default$14());
        int n = sp2._2$mcI$sp();
        if (TiffFieldType$.MODULE$.IFDOffset() != n) return new TiffTags(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9(), this.apply$default$10(), this.apply$default$11(), this.apply$default$12(), this.apply$default$13(), this.apply$default$14());
        return this.readLongsTag(byteReader, tiffTags, tagMetadata, ttos);
    }

    private TiffTags readModelPixelScaleTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        long oldPos = byteReader.position();
        byteReader.position(tagMetadata.offset());
        double scaleX = byteReader.getDouble();
        double scaleY = byteReader.getDouble();
        double scaleZ = byteReader.getDouble();
        byteReader.position(oldPos);
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._geoTiffTags()).$up$bar$minus$greater(GeoTiffTags$.MODULE$._modelPixelScale()).set((Object)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)scaleX), (Object)BoxesRunTime.boxToDouble((double)scaleY), (Object)BoxesRunTime.boxToDouble((double)scaleZ))));
    }

    private TiffTags readModelTiePointsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        long oldPos = byteReader.position();
        long numberOfPoints = tagMetadata.length() / 6L;
        byteReader.position(tagMetadata.offset());
        Tuple2[] points = (Tuple2[])Array$.MODULE$.ofDim((int)numberOfPoints, ClassTag$.MODULE$.apply(Tuple2.class));
        int index$macro$1 = 0;
        while ((long)index$macro$1 < numberOfPoints) {
            points[index$macro$1] = new Tuple2((Object)new Pixel3D(byteReader.getDouble(), byteReader.getDouble(), byteReader.getDouble()), (Object)new Pixel3D(byteReader.getDouble(), byteReader.getDouble(), byteReader.getDouble()));
            ++index$macro$1;
        }
        byteReader.position(oldPos);
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._geoTiffTags()).$up$bar$minus$greater(GeoTiffTags$.MODULE$._modelTiePoints()).set((Object)new Some((Object)points));
    }

    private TiffTags readGeoKeyDirectoryTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        long oldPos = byteReader.position();
        byteReader.position(tagMetadata.offset());
        short version = byteReader.getShort();
        short keyRevision = byteReader.getShort();
        short minorRevision = byteReader.getShort();
        short numberOfKeys = byteReader.getShort();
        GeoKeyDirectoryMetadata keyDirectoryMetadata = new GeoKeyDirectoryMetadata(version, keyRevision, minorRevision, numberOfKeys);
        GeoKeyDirectory geoKeyDirectory = GeoKeyReader$.MODULE$.read(byteReader, tiffTags, new GeoKeyDirectory(numberOfKeys, GeoKeyDirectory$.MODULE$.apply$default$2(), GeoKeyDirectory$.MODULE$.apply$default$3(), GeoKeyDirectory$.MODULE$.apply$default$4(), GeoKeyDirectory$.MODULE$.apply$default$5(), GeoKeyDirectory$.MODULE$.apply$default$6()), GeoKeyReader$.MODULE$.read$default$4());
        byteReader.position(oldPos);
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._geoTiffTags()).$up$bar$minus$greater(GeoTiffTags$.MODULE$._geoKeyDirectory()).set((Object)new Some((Object)geoKeyDirectory));
    }

    private TiffTags readBytesTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        short[] bytes = package$.MODULE$.ByteReaderUtilities(byteReader).getByteArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        int n = tagMetadata.tag();
        TiffTags tiffTags2 = TagCodes$.MODULE$.DotRangeTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._cmykTags()).$up$bar$minus$greater(CmykTags$.MODULE$._dotRange()).set((Object)new Some(new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToShort((Object)x$20)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))) : (TagCodes$.MODULE$.ExtraSamplesTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._extraSamples()).set((Object)new Some(new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToShort((Object)x$21)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))) : (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._longsMap()).modify((Function1 & Serializable & scala.Serializable)x$22 -> x$22.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToShort((Object)x$23)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))))));
        return tiffTags2;
    }

    private TiffTags readAsciisTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        String string = package$.MODULE$.ByteReaderUtilities(byteReader).getString(tagMetadata.offset(), tagMetadata.length(), ttos).substring(0, (int)(tagMetadata.length() - 1L));
        int n = tagMetadata.tag();
        TiffTags tiffTags2 = TagCodes$.MODULE$.DateTimeTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._metadataTags()).$up$bar$minus$greater(MetadataTags$.MODULE$._dateTime()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.ImageDescTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._metadataTags()).$up$bar$minus$greater(MetadataTags$.MODULE$._imageDesc()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.MakerTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._metadataTags()).$up$bar$minus$greater(MetadataTags$.MODULE$._maker()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.ModelTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._metadataTags()).$up$bar$minus$greater(MetadataTags$.MODULE$._model()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.SoftwareTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._metadataTags()).$up$bar$minus$greater(MetadataTags$.MODULE$._software()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.ArtistTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._metadataTags()).$up$bar$minus$greater(MetadataTags$.MODULE$._artist()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.HostComputerTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._metadataTags()).$up$bar$minus$greater(MetadataTags$.MODULE$._hostComputer()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.CopyrightTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._metadataTags()).$up$bar$minus$greater(MetadataTags$.MODULE$._copyright()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.AsciisTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._geoTiffTags()).$up$bar$minus$greater(GeoTiffTags$.MODULE$._asciis()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.MetadataTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._geoTiffTags()).$up$bar$minus$greater(GeoTiffTags$.MODULE$._metadata()).set((Object)new Some((Object)string)) : (TagCodes$.MODULE$.GDALInternalNoDataTag() == n ? tiffTags.setGDALNoData(string) : (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._asciisMap()).modify((Function1 & Serializable & scala.Serializable)x$24 -> x$24.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)string)))))))))))));
        return tiffTags2;
    }

    private TiffTags readShortsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        int[] shorts = package$.MODULE$.ByteReaderUtilities(byteReader).getShortArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        int n = tagMetadata.tag();
        TiffTags tiffTags2 = TagCodes$.MODULE$.SubfileTypeTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._subfileType()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.ImageWidthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._imageWidth()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.ImageLengthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._imageLength()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.CompressionTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._compression()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.PhotometricInterpTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._photometricInterp()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.ThresholdingTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._thresholding()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.CellWidthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._cellWidth()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.CellLengthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._cellLength()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.FillOrderTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._fillOrder()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.OrientationTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._orientation()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.SamplesPerPixelTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._samplesPerPixel()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.RowsPerStripTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._rowsPerStrip()).set((Object)BoxesRunTime.boxToLong((long)shorts[0])) : (TagCodes$.MODULE$.PlanarConfigurationTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._planarConfiguration()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.GrayResponseUnitTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._grayResponseUnit()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.ResolutionUnitTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._resolutionUnit()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.PredictorTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._predictor()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.TileWidthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileWidth()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)shorts[0]))) : (TagCodes$.MODULE$.TileLengthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileLength()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)shorts[0]))) : (TagCodes$.MODULE$.InkSetTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._cmykTags()).$up$bar$minus$greater(CmykTags$.MODULE$._inkSet()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.NumberOfInksTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._cmykTags()).$up$bar$minus$greater(CmykTags$.MODULE$._numberOfInks()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.JpegProcTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegProc()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.JpegInterchangeFormatTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegInterchangeFormat()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)shorts[0]))) : (TagCodes$.MODULE$.JpegInterchangeFormatLengthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegInterchangeFormatLength()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)shorts[0]))) : (TagCodes$.MODULE$.JpegRestartIntervalTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegRestartInterval()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.YCbCrPositioningTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._yCbCrTags()).$up$bar$minus$greater(YCbCrTags$.MODULE$._yCbCrPositioning()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)shorts[0]))) : (TagCodes$.MODULE$.BitsPerSampleTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._bitsPerSample()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.StripOffsetsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._stripOffsets()).set((Object)new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shorts)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$25 -> x$25, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))) : (TagCodes$.MODULE$.StripByteCountsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._stripByteCounts()).set((Object)new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shorts)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$26 -> x$26, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))) : (TagCodes$.MODULE$.MinSampleValueTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._dataSampleFormatTags()).$up$bar$minus$greater(DataSampleFormatTags$.MODULE$._minSampleValue()).set((Object)new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shorts)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$27 -> x$27, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))) : (TagCodes$.MODULE$.MaxSampleValueTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._dataSampleFormatTags()).$up$bar$minus$greater(DataSampleFormatTags$.MODULE$._maxSampleValue()).set((Object)new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shorts)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$28 -> x$28, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))) : (TagCodes$.MODULE$.GrayResponseCurveTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._grayResponseCurve()).set((Object)new Some((Object)shorts)) : (TagCodes$.MODULE$.PageNumberTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._documentationTags()).$up$bar$minus$greater(DocumentationTags$.MODULE$._pageNumber()).set((Object)new Some((Object)shorts)) : (TagCodes$.MODULE$.TransferFunctionTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._colimetryTags()).$up$bar$minus$greater(ColimetryTags$.MODULE$._transferFunction()).set((Object)new Some((Object)shorts)) : (TagCodes$.MODULE$.ColorMapTag() == n ? this.setColorMap(byteReader, tiffTags, shorts, ttos) : (TagCodes$.MODULE$.HalftoneHintsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._halftoneHints()).set((Object)new Some((Object)shorts)) : (TagCodes$.MODULE$.TileByteCountsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileByteCounts()).set((Object)new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shorts)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$29 -> x$29, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))) : (TagCodes$.MODULE$.DotRangeTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._cmykTags()).$up$bar$minus$greater(CmykTags$.MODULE$._dotRange()).set((Object)new Some((Object)shorts)) : (TagCodes$.MODULE$.SampleFormatTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._dataSampleFormatTags()).$up$bar$minus$greater(DataSampleFormatTags$.MODULE$._sampleFormat()).set((Object)BoxesRunTime.boxToInteger((int)shorts[0])) : (TagCodes$.MODULE$.TransferRangeTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._colimetryTags()).$up$bar$minus$greater(ColimetryTags$.MODULE$._transferRange()).set((Object)new Some((Object)shorts)) : (TagCodes$.MODULE$.JpegLosslessPredictorsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegLosslessPredictors()).set((Object)new Some((Object)shorts)) : (TagCodes$.MODULE$.JpegPointTransformsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegPointTransforms()).set((Object)new Some((Object)shorts)) : (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._longsMap()).modify((Function1 & Serializable & scala.Serializable)x$30 -> x$30.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(shorts)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$31 -> x$31, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))))))))))))))))))))))))))))))))))))))))))));
        return tiffTags2;
    }

    private TiffTags setColorMap(ByteReader byteReader, TiffTags tiffTags, int[] shorts, TiffTagOffsetSize ttos) {
        Tuple3[] arr;
        if (BoxesRunTime.unboxToInt((Object)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._photometricInterp()).get()) == 3) {
            int divider = shorts.length / 3;
            arr = (Tuple3[])Array$.MODULE$.ofDim(divider, ClassTag$.MODULE$.apply(Tuple3.class));
            for (int index$macro$1 = 0; index$macro$1 < divider; ++index$macro$1) {
                arr[index$macro$1] = new Tuple3((Object)BoxesRunTime.boxToShort((short)((short)shorts[index$macro$1])), (Object)BoxesRunTime.boxToShort((short)((short)shorts[index$macro$1 + divider])), (Object)BoxesRunTime.boxToShort((short)((short)shorts[index$macro$1 + 2 * divider])));
            }
        } else {
            throw new MalformedGeoTiffException("Colormap without Photometric Interpetation = 3.");
        }
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._colorMap()).set((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).toSeq());
    }

    private TiffTags readIntsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        long[] ints = package$.MODULE$.ByteReaderUtilities(byteReader).getIntArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        int n = tagMetadata.tag();
        TiffTags tiffTags2 = TagCodes$.MODULE$.NewSubfileTypeTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._newSubfileType()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)ints[0]))) : (TagCodes$.MODULE$.ImageWidthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._imageWidth()).set((Object)BoxesRunTime.boxToInteger((int)((int)ints[0]))) : (TagCodes$.MODULE$.ImageLengthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._imageLength()).set((Object)BoxesRunTime.boxToInteger((int)((int)ints[0]))) : (TagCodes$.MODULE$.T4OptionsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._t4Options()).set((Object)BoxesRunTime.boxToInteger((int)((int)ints[0]))) : (TagCodes$.MODULE$.T6OptionsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._t6Options()).set((Object)new Some((Object)BoxesRunTime.boxToInteger((int)((int)ints[0])))) : (TagCodes$.MODULE$.TileWidthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileWidth()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)ints[0]))) : (TagCodes$.MODULE$.TileLengthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileLength()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)ints[0]))) : (TagCodes$.MODULE$.JpegInterchangeFormatTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegInterchangeFormat()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)ints[0]))) : (TagCodes$.MODULE$.JpegInterchangeFormatLengthTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegInterchangeFormatLength()).set((Object)new Some((Object)BoxesRunTime.boxToLong((long)ints[0]))) : (TagCodes$.MODULE$.RowsPerStripTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._rowsPerStrip()).set((Object)BoxesRunTime.boxToLong((long)ints[0])) : (TagCodes$.MODULE$.StripOffsetsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._stripOffsets()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.StripByteCountsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._stripByteCounts()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.FreeOffsetsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._freeOffsets()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.FreeByteCountsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._freeByteCounts()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.TileOffsetsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileOffsets()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.TileByteCountsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileByteCounts()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.JpegQTablesTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegQTables()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.JpegDCTablesTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegDCTables()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.JpegACTablesTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegACTables()).set((Object)new Some((Object)ints)) : (TagCodes$.MODULE$.ReferenceBlackWhiteTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._colimetryTags()).$up$bar$minus$greater(ColimetryTags$.MODULE$._referenceBlackWhite()).set((Object)new Some((Object)ints)) : (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._longsMap()).modify((Function1 & Serializable & scala.Serializable)x$34 -> x$34.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ints)).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$35 -> x$35, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))))))))))))))))))))))));
        return tiffTags2;
    }

    private TiffTags readLongsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        TiffTags tiffTags2;
        long[] longs = package$.MODULE$.ByteReaderUtilities(byteReader).getLongArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        int n = tagMetadata.tag();
        if (TagCodes$.MODULE$.StripOffsetsTag() == n) {
            tiffTags2 = (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._stripOffsets()).set((Object)new Some((Object)longs));
        } else if (TagCodes$.MODULE$.StripByteCountsTag() == n) {
            tiffTags2 = (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._stripByteCounts()).set((Object)new Some((Object)longs));
        } else if (TagCodes$.MODULE$.TileOffsetsTag() == n) {
            tiffTags2 = (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileOffsets()).set((Object)new Some((Object)longs));
        } else if (TagCodes$.MODULE$.TileByteCountsTag() == n) {
            tiffTags2 = (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileByteCounts()).set((Object)new Some((Object)longs));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return tiffTags2;
    }

    private TiffTags readFractionalsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        Tuple2<Object, Object>[] fractionals = package$.MODULE$.ByteReaderUtilities(byteReader).getFractionalArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        int n = tagMetadata.tag();
        TiffTags tiffTags2 = TagCodes$.MODULE$.XResolutionTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._xResolution()).set((Object)new Some(fractionals[0])) : (TagCodes$.MODULE$.YResolutionTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._yResolution()).set((Object)new Some(fractionals[0])) : (TagCodes$.MODULE$.XPositionTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._documentationTags()).$up$bar$minus$greater(DocumentationTags$.MODULE$._xPositions()).set((Object)new Some(fractionals)) : (TagCodes$.MODULE$.YPositionTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._documentationTags()).$up$bar$minus$greater(DocumentationTags$.MODULE$._yPositions()).set((Object)new Some(fractionals)) : (TagCodes$.MODULE$.WhitePointTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._colimetryTags()).$up$bar$minus$greater(ColimetryTags$.MODULE$._whitePoints()).set((Object)new Some(fractionals)) : (TagCodes$.MODULE$.PrimaryChromaticitiesTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._colimetryTags()).$up$bar$minus$greater(ColimetryTags$.MODULE$._primaryChromaticities()).set((Object)new Some(fractionals)) : (TagCodes$.MODULE$.YCbCrCoefficientsTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._yCbCrTags()).$up$bar$minus$greater(YCbCrTags$.MODULE$._yCbCrCoefficients()).set((Object)new Some(fractionals)) : (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._fractionalsMap()).modify((Function1 & Serializable & scala.Serializable)x$36 -> x$36.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)fractionals)))))))));
        return tiffTags2;
    }

    private TiffTags readSignedBytesTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        byte[] bytes = package$.MODULE$.ByteReaderUtilities(byteReader).getSignedByteArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._longsMap()).modify((Function1 & Serializable & scala.Serializable)x$37 -> x$37.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tagMetadata.tag())), new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToByte((Object)x$38)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))));
    }

    private TiffTags readUndefinedTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        byte[] bytes = package$.MODULE$.ByteReaderUtilities(byteReader).getSignedByteArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        int n = tagMetadata.tag();
        TiffTags tiffTags2 = TagCodes$.MODULE$.JpegTablesTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._jpegTags()).$up$bar$minus$greater(JpegTags$.MODULE$._jpegTables()).set((Object)new Some((Object)bytes)) : (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._undefinedMap()).modify((Function1 & Serializable & scala.Serializable)x$39 -> x$39.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)bytes)));
        return tiffTags2;
    }

    private TiffTags readSignedShortsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        short[] shorts = package$.MODULE$.ByteReaderUtilities(byteReader).getSignedShortArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._longsMap()).modify((Function1 & Serializable & scala.Serializable)x$40 -> x$40.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tagMetadata.tag())), new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(shorts)).map((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToShort((Object)x$41)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))));
    }

    private TiffTags readSignedIntsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        int[] ints = package$.MODULE$.ByteReaderUtilities(byteReader).getSignedIntArray(tagMetadata.offset(), tagMetadata.offset(), ttos);
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._longsMap()).modify((Function1 & Serializable & scala.Serializable)x$42 -> x$42.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tagMetadata.tag())), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ints)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$43 -> x$43, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))));
    }

    private TiffTags readSignedFractionalsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        Tuple2<Object, Object>[] fractionals = package$.MODULE$.ByteReaderUtilities(byteReader).getSignedFractionalArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._fractionalsMap()).modify((Function1 & Serializable & scala.Serializable)x$44 -> x$44.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tagMetadata.tag())), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fractionals)).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcJJ.sp((long)x._1$mcI$sp(), (long)x._2$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))));
    }

    private TiffTags readFloatsTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        float[] floats = package$.MODULE$.ByteReaderUtilities(byteReader).getFloatArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        return (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._doublesMap()).modify((Function1 & Serializable & scala.Serializable)x$45 -> x$45.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tagMetadata.tag())), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(floats)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$46 -> x$46, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))));
    }

    private TiffTags readDoublesTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        TiffTags tiffTags2;
        double[] doubles = package$.MODULE$.ByteReaderUtilities(byteReader).getDoubleArray(tagMetadata.offset(), tagMetadata.length(), ttos);
        int n = tagMetadata.tag();
        if (TagCodes$.MODULE$.ModelTransformationTag() == n) {
            if (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubles)).size() != 16) {
                throw new MalformedGeoTiffException("bad model tranformations");
            }
            double[][] matrix = (double[][])((Object[])new double[][]{{doubles[0], doubles[1], doubles[2], doubles[3]}, {doubles[4], doubles[5], doubles[6], doubles[7]}, {doubles[8], doubles[9], doubles[10], doubles[11]}, {doubles[12], doubles[13], doubles[14], doubles[15]}});
            tiffTags2 = (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._geoTiffTags()).$up$bar$minus$greater(GeoTiffTags$.MODULE$._modelTransformation()).set((Object)new Some((Object)matrix));
        } else {
            tiffTags2 = TagCodes$.MODULE$.DoublesTag() == n ? (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._geoTiffTags()).$up$bar$minus$greater(GeoTiffTags$.MODULE$._doubles()).set((Object)new Some((Object)doubles)) : (TiffTags)ApplyLensOps$.MODULE$.$amp$bar$minus$greater$extension(apply$.MODULE$.toApplyLensOps((Object)tiffTags), this._nonStandardizedTags()).$up$bar$minus$greater(NonStandardizedTags$.MODULE$._doublesMap()).modify((Function1 & Serializable & scala.Serializable)x$47 -> x$47.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)doubles)));
        }
        return tiffTags2;
    }

    public Encoder<TiffTags> tiffTagsEncoder() {
        return this.tiffTagsEncoder;
    }

    public Decoder<TiffTags> tiffTagsDecoder() {
        return this.tiffTagsDecoder;
    }

    public TiffTags apply(MetadataTags metadataTags, BasicTags basicTags, NonBasicTags nonBasicTags, GeoTiffTags geoTiffTags, DocumentationTags documentationTags, TileTags tileTags, CmykTags cmykTags, DataSampleFormatTags dataSampleFormatTags, ColimetryTags colimetryTags, JpegTags jpegTags, YCbCrTags yCbCrTags, NonStandardizedTags nonStandardizedTags, TiffType tiffType, List<TiffTags> overviews) {
        return new TiffTags(metadataTags, basicTags, nonBasicTags, geoTiffTags, documentationTags, tileTags, cmykTags, dataSampleFormatTags, colimetryTags, jpegTags, yCbCrTags, nonStandardizedTags, tiffType, overviews);
    }

    public MetadataTags apply$default$1() {
        return new MetadataTags(MetadataTags$.MODULE$.apply$default$1(), MetadataTags$.MODULE$.apply$default$2(), MetadataTags$.MODULE$.apply$default$3(), MetadataTags$.MODULE$.apply$default$4(), MetadataTags$.MODULE$.apply$default$5(), MetadataTags$.MODULE$.apply$default$6(), MetadataTags$.MODULE$.apply$default$7(), MetadataTags$.MODULE$.apply$default$8());
    }

    public JpegTags apply$default$10() {
        return new JpegTags(JpegTags$.MODULE$.apply$default$1(), JpegTags$.MODULE$.apply$default$2(), JpegTags$.MODULE$.apply$default$3(), JpegTags$.MODULE$.apply$default$4(), JpegTags$.MODULE$.apply$default$5(), JpegTags$.MODULE$.apply$default$6(), JpegTags$.MODULE$.apply$default$7(), JpegTags$.MODULE$.apply$default$8(), JpegTags$.MODULE$.apply$default$9(), JpegTags$.MODULE$.apply$default$10());
    }

    public YCbCrTags apply$default$11() {
        return new YCbCrTags(YCbCrTags$.MODULE$.apply$default$1(), YCbCrTags$.MODULE$.apply$default$2(), YCbCrTags$.MODULE$.apply$default$3());
    }

    public NonStandardizedTags apply$default$12() {
        return new NonStandardizedTags(NonStandardizedTags$.MODULE$.apply$default$1(), NonStandardizedTags$.MODULE$.apply$default$2(), NonStandardizedTags$.MODULE$.apply$default$3(), NonStandardizedTags$.MODULE$.apply$default$4(), NonStandardizedTags$.MODULE$.apply$default$5());
    }

    public TiffType apply$default$13() {
        return Tiff$.MODULE$;
    }

    public List<TiffTags> apply$default$14() {
        return Nil$.MODULE$;
    }

    public BasicTags apply$default$2() {
        return new BasicTags(BasicTags$.MODULE$.apply$default$1(), BasicTags$.MODULE$.apply$default$2(), BasicTags$.MODULE$.apply$default$3(), BasicTags$.MODULE$.apply$default$4(), BasicTags$.MODULE$.apply$default$5(), BasicTags$.MODULE$.apply$default$6(), BasicTags$.MODULE$.apply$default$7(), BasicTags$.MODULE$.apply$default$8(), BasicTags$.MODULE$.apply$default$9(), BasicTags$.MODULE$.apply$default$10(), BasicTags$.MODULE$.apply$default$11(), BasicTags$.MODULE$.apply$default$12(), BasicTags$.MODULE$.apply$default$13());
    }

    public NonBasicTags apply$default$3() {
        return new NonBasicTags(NonBasicTags$.MODULE$.apply$default$1(), NonBasicTags$.MODULE$.apply$default$2(), NonBasicTags$.MODULE$.apply$default$3(), NonBasicTags$.MODULE$.apply$default$4(), NonBasicTags$.MODULE$.apply$default$5(), NonBasicTags$.MODULE$.apply$default$6(), NonBasicTags$.MODULE$.apply$default$7(), NonBasicTags$.MODULE$.apply$default$8(), NonBasicTags$.MODULE$.apply$default$9(), NonBasicTags$.MODULE$.apply$default$10(), NonBasicTags$.MODULE$.apply$default$11(), NonBasicTags$.MODULE$.apply$default$12(), NonBasicTags$.MODULE$.apply$default$13(), NonBasicTags$.MODULE$.apply$default$14(), NonBasicTags$.MODULE$.apply$default$15(), NonBasicTags$.MODULE$.apply$default$16(), NonBasicTags$.MODULE$.apply$default$17());
    }

    public GeoTiffTags apply$default$4() {
        return new GeoTiffTags(GeoTiffTags$.MODULE$.apply$default$1(), GeoTiffTags$.MODULE$.apply$default$2(), GeoTiffTags$.MODULE$.apply$default$3(), GeoTiffTags$.MODULE$.apply$default$4(), GeoTiffTags$.MODULE$.apply$default$5(), GeoTiffTags$.MODULE$.apply$default$6(), GeoTiffTags$.MODULE$.apply$default$7(), GeoTiffTags$.MODULE$.apply$default$8());
    }

    public DocumentationTags apply$default$5() {
        return new DocumentationTags(DocumentationTags$.MODULE$.apply$default$1(), DocumentationTags$.MODULE$.apply$default$2(), DocumentationTags$.MODULE$.apply$default$3(), DocumentationTags$.MODULE$.apply$default$4(), DocumentationTags$.MODULE$.apply$default$5());
    }

    public TileTags apply$default$6() {
        return new TileTags(TileTags$.MODULE$.apply$default$1(), TileTags$.MODULE$.apply$default$2(), TileTags$.MODULE$.apply$default$3(), TileTags$.MODULE$.apply$default$4());
    }

    public CmykTags apply$default$7() {
        return new CmykTags(CmykTags$.MODULE$.apply$default$1(), CmykTags$.MODULE$.apply$default$2(), CmykTags$.MODULE$.apply$default$3(), CmykTags$.MODULE$.apply$default$4(), CmykTags$.MODULE$.apply$default$5());
    }

    public DataSampleFormatTags apply$default$8() {
        return new DataSampleFormatTags(DataSampleFormatTags$.MODULE$.apply$default$1(), DataSampleFormatTags$.MODULE$.apply$default$2(), DataSampleFormatTags$.MODULE$.apply$default$3());
    }

    public ColimetryTags apply$default$9() {
        return new ColimetryTags(ColimetryTags$.MODULE$.apply$default$1(), ColimetryTags$.MODULE$.apply$default$2(), ColimetryTags$.MODULE$.apply$default$3(), ColimetryTags$.MODULE$.apply$default$4(), ColimetryTags$.MODULE$.apply$default$5());
    }

    public Option<Tuple14<MetadataTags, BasicTags, NonBasicTags, GeoTiffTags, DocumentationTags, TileTags, CmykTags, DataSampleFormatTags, ColimetryTags, JpegTags, YCbCrTags, NonStandardizedTags, TiffType, List<TiffTags>>> unapply(TiffTags x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.metadataTags(), (Object)x$0.basicTags(), (Object)x$0.nonBasicTags(), (Object)x$0.geoTiffTags(), (Object)x$0.documentationTags(), (Object)x$0.tileTags(), (Object)x$0.cmykTags(), (Object)x$0.dataSampleFormatTags(), (Object)x$0.colimetryTags(), (Object)x$0.jpegTags(), (Object)x$0.yCbCrTags(), (Object)x$0.nonStandardizedTags(), (Object)x$0.tiffType(), x$0.overviews()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TiffTags$() {
        MODULE$ = this;
        this._metadataTags = new PLens<TiffTags, TiffTags, MetadataTags, MetadataTags>(){

            public MetadataTags get(TiffTags s) {
                return s.metadataTags();
            }

            public Function1<TiffTags, TiffTags> set(MetadataTags a) {
                return (Function1 & Serializable & scala.Serializable)x$216 -> x$216.copy(a, x$216.copy$default$2(), x$216.copy$default$3(), x$216.copy$default$4(), x$216.copy$default$5(), x$216.copy$default$6(), x$216.copy$default$7(), x$216.copy$default$8(), x$216.copy$default$9(), x$216.copy$default$10(), x$216.copy$default$11(), x$216.copy$default$12(), x$216.copy$default$13(), x$216.copy$default$14());
            }

            public <F$macro$6> F$macro$6 modifyF(Function1<MetadataTags, F$macro$6> f, TiffTags s, Functor<F$macro$6> evidence$6) {
                return (F$macro$6)Functor$.MODULE$.apply(evidence$6).map(f.apply((Object)s.metadataTags()), (Function1 & Serializable & scala.Serializable)a -> s.copy((MetadataTags)a, s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9(), s.copy$default$10(), s.copy$default$11(), s.copy$default$12(), s.copy$default$13(), s.copy$default$14()));
            }

            public Function1<TiffTags, TiffTags> modify(Function1<MetadataTags, MetadataTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> s.copy((MetadataTags)f.apply((Object)s.metadataTags()), s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9(), s.copy$default$10(), s.copy$default$11(), s.copy$default$12(), s.copy$default$13(), s.copy$default$14());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$1(geotrellis.raster.io.geotiff.tags.MetadataTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$1(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.MetadataTags ), $anonfun$modify$1(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._basicTags = new PLens<TiffTags, TiffTags, BasicTags, BasicTags>(){

            public BasicTags get(TiffTags s) {
                return s.basicTags();
            }

            public Function1<TiffTags, TiffTags> set(BasicTags a) {
                return (Function1 & Serializable & scala.Serializable)x$1 -> {
                    BasicTags x$2 = a;
                    MetadataTags x$3 = x$1.copy$default$1();
                    NonBasicTags x$4 = x$1.copy$default$3();
                    GeoTiffTags x$5 = x$1.copy$default$4();
                    DocumentationTags x$6 = x$1.copy$default$5();
                    TileTags x$7 = x$1.copy$default$6();
                    CmykTags x$8 = x$1.copy$default$7();
                    DataSampleFormatTags x$9 = x$1.copy$default$8();
                    ColimetryTags x$10 = x$1.copy$default$9();
                    JpegTags x$11 = x$1.copy$default$10();
                    YCbCrTags x$12 = x$1.copy$default$11();
                    NonStandardizedTags x$13 = x$1.copy$default$12();
                    TiffType x$14 = x$1.copy$default$13();
                    List<TiffTags> x$15 = x$1.copy$default$14();
                    return x$1.copy(x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
                };
            }

            public <F$macro$1> F$macro$1 modifyF(Function1<BasicTags, F$macro$1> f, TiffTags s, Functor<F$macro$1> evidence$1) {
                return (F$macro$1)Functor$.MODULE$.apply(evidence$1).map(f.apply((Object)s.basicTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    BasicTags x$16 = a;
                    MetadataTags x$17 = s.copy$default$1();
                    NonBasicTags x$18 = s.copy$default$3();
                    GeoTiffTags x$19 = s.copy$default$4();
                    DocumentationTags x$20 = s.copy$default$5();
                    TileTags x$21 = s.copy$default$6();
                    CmykTags x$22 = s.copy$default$7();
                    DataSampleFormatTags x$23 = s.copy$default$8();
                    ColimetryTags x$24 = s.copy$default$9();
                    JpegTags x$25 = s.copy$default$10();
                    YCbCrTags x$26 = s.copy$default$11();
                    NonStandardizedTags x$27 = s.copy$default$12();
                    TiffType x$28 = s.copy$default$13();
                    List<TiffTags> x$29 = s.copy$default$14();
                    return s.copy(x$17, x$16, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<BasicTags, BasicTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    BasicTags x$30 = (BasicTags)f.apply((Object)s.basicTags());
                    MetadataTags x$31 = s.copy$default$1();
                    NonBasicTags x$32 = s.copy$default$3();
                    GeoTiffTags x$33 = s.copy$default$4();
                    DocumentationTags x$34 = s.copy$default$5();
                    TileTags x$35 = s.copy$default$6();
                    CmykTags x$36 = s.copy$default$7();
                    DataSampleFormatTags x$37 = s.copy$default$8();
                    ColimetryTags x$38 = s.copy$default$9();
                    JpegTags x$39 = s.copy$default$10();
                    YCbCrTags x$40 = s.copy$default$11();
                    NonStandardizedTags x$41 = s.copy$default$12();
                    TiffType x$42 = s.copy$default$13();
                    List<TiffTags> x$43 = s.copy$default$14();
                    return s.copy(x$31, x$30, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$2(geotrellis.raster.io.geotiff.tags.BasicTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$2(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.BasicTags ), $anonfun$modify$2(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._nonBasicTags = new PLens<TiffTags, TiffTags, NonBasicTags, NonBasicTags>(){

            public NonBasicTags get(TiffTags s) {
                return s.nonBasicTags();
            }

            public Function1<TiffTags, TiffTags> set(NonBasicTags a) {
                return (Function1 & Serializable & scala.Serializable)x$87 -> {
                    NonBasicTags x$88 = a;
                    MetadataTags x$89 = x$87.copy$default$1();
                    BasicTags x$90 = x$87.copy$default$2();
                    GeoTiffTags x$91 = x$87.copy$default$4();
                    DocumentationTags x$92 = x$87.copy$default$5();
                    TileTags x$93 = x$87.copy$default$6();
                    CmykTags x$94 = x$87.copy$default$7();
                    DataSampleFormatTags x$95 = x$87.copy$default$8();
                    ColimetryTags x$96 = x$87.copy$default$9();
                    JpegTags x$97 = x$87.copy$default$10();
                    YCbCrTags x$98 = x$87.copy$default$11();
                    NonStandardizedTags x$99 = x$87.copy$default$12();
                    TiffType x$100 = x$87.copy$default$13();
                    List<TiffTags> x$101 = x$87.copy$default$14();
                    return x$87.copy(x$89, x$90, x$88, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101);
                };
            }

            public <F$macro$3> F$macro$3 modifyF(Function1<NonBasicTags, F$macro$3> f, TiffTags s, Functor<F$macro$3> evidence$3) {
                return (F$macro$3)Functor$.MODULE$.apply(evidence$3).map(f.apply((Object)s.nonBasicTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    NonBasicTags x$102 = a;
                    MetadataTags x$103 = s.copy$default$1();
                    BasicTags x$104 = s.copy$default$2();
                    GeoTiffTags x$105 = s.copy$default$4();
                    DocumentationTags x$106 = s.copy$default$5();
                    TileTags x$107 = s.copy$default$6();
                    CmykTags x$108 = s.copy$default$7();
                    DataSampleFormatTags x$109 = s.copy$default$8();
                    ColimetryTags x$110 = s.copy$default$9();
                    JpegTags x$111 = s.copy$default$10();
                    YCbCrTags x$112 = s.copy$default$11();
                    NonStandardizedTags x$113 = s.copy$default$12();
                    TiffType x$114 = s.copy$default$13();
                    List<TiffTags> x$115 = s.copy$default$14();
                    return s.copy(x$103, x$104, x$102, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<NonBasicTags, NonBasicTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    NonBasicTags x$116 = (NonBasicTags)f.apply((Object)s.nonBasicTags());
                    MetadataTags x$117 = s.copy$default$1();
                    BasicTags x$118 = s.copy$default$2();
                    GeoTiffTags x$119 = s.copy$default$4();
                    DocumentationTags x$120 = s.copy$default$5();
                    TileTags x$121 = s.copy$default$6();
                    CmykTags x$122 = s.copy$default$7();
                    DataSampleFormatTags x$123 = s.copy$default$8();
                    ColimetryTags x$124 = s.copy$default$9();
                    JpegTags x$125 = s.copy$default$10();
                    YCbCrTags x$126 = s.copy$default$11();
                    NonStandardizedTags x$127 = s.copy$default$12();
                    TiffType x$128 = s.copy$default$13();
                    List<TiffTags> x$129 = s.copy$default$14();
                    return s.copy(x$117, x$118, x$116, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$3(geotrellis.raster.io.geotiff.tags.NonBasicTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$3(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.NonBasicTags ), $anonfun$modify$3(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._geoTiffTags = new PLens<TiffTags, TiffTags, GeoTiffTags, GeoTiffTags>(){

            public GeoTiffTags get(TiffTags s) {
                return s.geoTiffTags();
            }

            public Function1<TiffTags, TiffTags> set(GeoTiffTags a) {
                return (Function1 & Serializable & scala.Serializable)x$130 -> {
                    GeoTiffTags x$131 = a;
                    MetadataTags x$132 = x$130.copy$default$1();
                    BasicTags x$133 = x$130.copy$default$2();
                    NonBasicTags x$134 = x$130.copy$default$3();
                    DocumentationTags x$135 = x$130.copy$default$5();
                    TileTags x$136 = x$130.copy$default$6();
                    CmykTags x$137 = x$130.copy$default$7();
                    DataSampleFormatTags x$138 = x$130.copy$default$8();
                    ColimetryTags x$139 = x$130.copy$default$9();
                    JpegTags x$140 = x$130.copy$default$10();
                    YCbCrTags x$141 = x$130.copy$default$11();
                    NonStandardizedTags x$142 = x$130.copy$default$12();
                    TiffType x$143 = x$130.copy$default$13();
                    List<TiffTags> x$144 = x$130.copy$default$14();
                    return x$130.copy(x$132, x$133, x$134, x$131, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144);
                };
            }

            public <F$macro$4> F$macro$4 modifyF(Function1<GeoTiffTags, F$macro$4> f, TiffTags s, Functor<F$macro$4> evidence$4) {
                return (F$macro$4)Functor$.MODULE$.apply(evidence$4).map(f.apply((Object)s.geoTiffTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    GeoTiffTags x$145 = a;
                    MetadataTags x$146 = s.copy$default$1();
                    BasicTags x$147 = s.copy$default$2();
                    NonBasicTags x$148 = s.copy$default$3();
                    DocumentationTags x$149 = s.copy$default$5();
                    TileTags x$150 = s.copy$default$6();
                    CmykTags x$151 = s.copy$default$7();
                    DataSampleFormatTags x$152 = s.copy$default$8();
                    ColimetryTags x$153 = s.copy$default$9();
                    JpegTags x$154 = s.copy$default$10();
                    YCbCrTags x$155 = s.copy$default$11();
                    NonStandardizedTags x$156 = s.copy$default$12();
                    TiffType x$157 = s.copy$default$13();
                    List<TiffTags> x$158 = s.copy$default$14();
                    return s.copy(x$146, x$147, x$148, x$145, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<GeoTiffTags, GeoTiffTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    GeoTiffTags x$159 = (GeoTiffTags)f.apply((Object)s.geoTiffTags());
                    MetadataTags x$160 = s.copy$default$1();
                    BasicTags x$161 = s.copy$default$2();
                    NonBasicTags x$162 = s.copy$default$3();
                    DocumentationTags x$163 = s.copy$default$5();
                    TileTags x$164 = s.copy$default$6();
                    CmykTags x$165 = s.copy$default$7();
                    DataSampleFormatTags x$166 = s.copy$default$8();
                    ColimetryTags x$167 = s.copy$default$9();
                    JpegTags x$168 = s.copy$default$10();
                    YCbCrTags x$169 = s.copy$default$11();
                    NonStandardizedTags x$170 = s.copy$default$12();
                    TiffType x$171 = s.copy$default$13();
                    List<TiffTags> x$172 = s.copy$default$14();
                    return s.copy(x$160, x$161, x$162, x$159, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$171, x$172);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$4(geotrellis.raster.io.geotiff.tags.GeoTiffTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$4(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.GeoTiffTags ), $anonfun$modify$4(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._documentationTags = new PLens<TiffTags, TiffTags, DocumentationTags, DocumentationTags>(){

            public DocumentationTags get(TiffTags s) {
                return s.documentationTags();
            }

            public Function1<TiffTags, TiffTags> set(DocumentationTags a) {
                return (Function1 & Serializable & scala.Serializable)x$217 -> {
                    DocumentationTags x$218 = a;
                    MetadataTags x$219 = x$217.copy$default$1();
                    BasicTags x$220 = x$217.copy$default$2();
                    NonBasicTags x$221 = x$217.copy$default$3();
                    GeoTiffTags x$222 = x$217.copy$default$4();
                    TileTags x$223 = x$217.copy$default$6();
                    CmykTags x$224 = x$217.copy$default$7();
                    DataSampleFormatTags x$225 = x$217.copy$default$8();
                    ColimetryTags x$226 = x$217.copy$default$9();
                    JpegTags x$227 = x$217.copy$default$10();
                    YCbCrTags x$228 = x$217.copy$default$11();
                    NonStandardizedTags x$229 = x$217.copy$default$12();
                    TiffType x$230 = x$217.copy$default$13();
                    List<TiffTags> x$231 = x$217.copy$default$14();
                    return x$217.copy(x$219, x$220, x$221, x$222, x$218, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$231);
                };
            }

            public <F$macro$7> F$macro$7 modifyF(Function1<DocumentationTags, F$macro$7> f, TiffTags s, Functor<F$macro$7> evidence$7) {
                return (F$macro$7)Functor$.MODULE$.apply(evidence$7).map(f.apply((Object)s.documentationTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    DocumentationTags x$232 = a;
                    MetadataTags x$233 = s.copy$default$1();
                    BasicTags x$234 = s.copy$default$2();
                    NonBasicTags x$235 = s.copy$default$3();
                    GeoTiffTags x$236 = s.copy$default$4();
                    TileTags x$237 = s.copy$default$6();
                    CmykTags x$238 = s.copy$default$7();
                    DataSampleFormatTags x$239 = s.copy$default$8();
                    ColimetryTags x$240 = s.copy$default$9();
                    JpegTags x$241 = s.copy$default$10();
                    YCbCrTags x$242 = s.copy$default$11();
                    NonStandardizedTags x$243 = s.copy$default$12();
                    TiffType x$244 = s.copy$default$13();
                    List<TiffTags> x$245 = s.copy$default$14();
                    return s.copy(x$233, x$234, x$235, x$236, x$232, x$237, x$238, x$239, x$240, x$241, x$242, x$243, x$244, x$245);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<DocumentationTags, DocumentationTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    DocumentationTags x$246 = (DocumentationTags)f.apply((Object)s.documentationTags());
                    MetadataTags x$247 = s.copy$default$1();
                    BasicTags x$248 = s.copy$default$2();
                    NonBasicTags x$249 = s.copy$default$3();
                    GeoTiffTags x$250 = s.copy$default$4();
                    TileTags x$251 = s.copy$default$6();
                    CmykTags x$252 = s.copy$default$7();
                    DataSampleFormatTags x$253 = s.copy$default$8();
                    ColimetryTags x$254 = s.copy$default$9();
                    JpegTags x$255 = s.copy$default$10();
                    YCbCrTags x$256 = s.copy$default$11();
                    NonStandardizedTags x$257 = s.copy$default$12();
                    TiffType x$258 = s.copy$default$13();
                    List<TiffTags> x$259 = s.copy$default$14();
                    return s.copy(x$247, x$248, x$249, x$250, x$246, x$251, x$252, x$253, x$254, x$255, x$256, x$257, x$258, x$259);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$5(geotrellis.raster.io.geotiff.tags.DocumentationTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$5(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.DocumentationTags ), $anonfun$modify$5(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._tileTags = new PLens<TiffTags, TiffTags, TileTags, TileTags>(){

            public TileTags get(TiffTags s) {
                return s.tileTags();
            }

            public Function1<TiffTags, TiffTags> set(TileTags a) {
                return (Function1 & Serializable & scala.Serializable)x$44 -> {
                    TileTags x$45 = a;
                    MetadataTags x$46 = x$44.copy$default$1();
                    BasicTags x$47 = x$44.copy$default$2();
                    NonBasicTags x$48 = x$44.copy$default$3();
                    GeoTiffTags x$49 = x$44.copy$default$4();
                    DocumentationTags x$50 = x$44.copy$default$5();
                    CmykTags x$51 = x$44.copy$default$7();
                    DataSampleFormatTags x$52 = x$44.copy$default$8();
                    ColimetryTags x$53 = x$44.copy$default$9();
                    JpegTags x$54 = x$44.copy$default$10();
                    YCbCrTags x$55 = x$44.copy$default$11();
                    NonStandardizedTags x$56 = x$44.copy$default$12();
                    TiffType x$57 = x$44.copy$default$13();
                    List<TiffTags> x$58 = x$44.copy$default$14();
                    return x$44.copy(x$46, x$47, x$48, x$49, x$50, x$45, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58);
                };
            }

            public <F$macro$2> F$macro$2 modifyF(Function1<TileTags, F$macro$2> f, TiffTags s, Functor<F$macro$2> evidence$2) {
                return (F$macro$2)Functor$.MODULE$.apply(evidence$2).map(f.apply((Object)s.tileTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    TileTags x$59 = a;
                    MetadataTags x$60 = s.copy$default$1();
                    BasicTags x$61 = s.copy$default$2();
                    NonBasicTags x$62 = s.copy$default$3();
                    GeoTiffTags x$63 = s.copy$default$4();
                    DocumentationTags x$64 = s.copy$default$5();
                    CmykTags x$65 = s.copy$default$7();
                    DataSampleFormatTags x$66 = s.copy$default$8();
                    ColimetryTags x$67 = s.copy$default$9();
                    JpegTags x$68 = s.copy$default$10();
                    YCbCrTags x$69 = s.copy$default$11();
                    NonStandardizedTags x$70 = s.copy$default$12();
                    TiffType x$71 = s.copy$default$13();
                    List<TiffTags> x$72 = s.copy$default$14();
                    return s.copy(x$60, x$61, x$62, x$63, x$64, x$59, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<TileTags, TileTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    TileTags x$73 = (TileTags)f.apply((Object)s.tileTags());
                    MetadataTags x$74 = s.copy$default$1();
                    BasicTags x$75 = s.copy$default$2();
                    NonBasicTags x$76 = s.copy$default$3();
                    GeoTiffTags x$77 = s.copy$default$4();
                    DocumentationTags x$78 = s.copy$default$5();
                    CmykTags x$79 = s.copy$default$7();
                    DataSampleFormatTags x$80 = s.copy$default$8();
                    ColimetryTags x$81 = s.copy$default$9();
                    JpegTags x$82 = s.copy$default$10();
                    YCbCrTags x$83 = s.copy$default$11();
                    NonStandardizedTags x$84 = s.copy$default$12();
                    TiffType x$85 = s.copy$default$13();
                    List<TiffTags> x$86 = s.copy$default$14();
                    return s.copy(x$74, x$75, x$76, x$77, x$78, x$73, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$6(geotrellis.raster.io.geotiff.tags.TileTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$6(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.TileTags ), $anonfun$modify$6(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._cmykTags = new PLens<TiffTags, TiffTags, CmykTags, CmykTags>(){

            public CmykTags get(TiffTags s) {
                return s.cmykTags();
            }

            public Function1<TiffTags, TiffTags> set(CmykTags a) {
                return (Function1 & Serializable & scala.Serializable)x$260 -> {
                    CmykTags x$261 = a;
                    MetadataTags x$262 = x$260.copy$default$1();
                    BasicTags x$263 = x$260.copy$default$2();
                    NonBasicTags x$264 = x$260.copy$default$3();
                    GeoTiffTags x$265 = x$260.copy$default$4();
                    DocumentationTags x$266 = x$260.copy$default$5();
                    TileTags x$267 = x$260.copy$default$6();
                    DataSampleFormatTags x$268 = x$260.copy$default$8();
                    ColimetryTags x$269 = x$260.copy$default$9();
                    JpegTags x$270 = x$260.copy$default$10();
                    YCbCrTags x$271 = x$260.copy$default$11();
                    NonStandardizedTags x$272 = x$260.copy$default$12();
                    TiffType x$273 = x$260.copy$default$13();
                    List<TiffTags> x$274 = x$260.copy$default$14();
                    return x$260.copy(x$262, x$263, x$264, x$265, x$266, x$267, x$261, x$268, x$269, x$270, x$271, x$272, x$273, x$274);
                };
            }

            public <F$macro$8> F$macro$8 modifyF(Function1<CmykTags, F$macro$8> f, TiffTags s, Functor<F$macro$8> evidence$8) {
                return (F$macro$8)Functor$.MODULE$.apply(evidence$8).map(f.apply((Object)s.cmykTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    CmykTags x$275 = a;
                    MetadataTags x$276 = s.copy$default$1();
                    BasicTags x$277 = s.copy$default$2();
                    NonBasicTags x$278 = s.copy$default$3();
                    GeoTiffTags x$279 = s.copy$default$4();
                    DocumentationTags x$280 = s.copy$default$5();
                    TileTags x$281 = s.copy$default$6();
                    DataSampleFormatTags x$282 = s.copy$default$8();
                    ColimetryTags x$283 = s.copy$default$9();
                    JpegTags x$284 = s.copy$default$10();
                    YCbCrTags x$285 = s.copy$default$11();
                    NonStandardizedTags x$286 = s.copy$default$12();
                    TiffType x$287 = s.copy$default$13();
                    List<TiffTags> x$288 = s.copy$default$14();
                    return s.copy(x$276, x$277, x$278, x$279, x$280, x$281, x$275, x$282, x$283, x$284, x$285, x$286, x$287, x$288);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<CmykTags, CmykTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    CmykTags x$289 = (CmykTags)f.apply((Object)s.cmykTags());
                    MetadataTags x$290 = s.copy$default$1();
                    BasicTags x$291 = s.copy$default$2();
                    NonBasicTags x$292 = s.copy$default$3();
                    GeoTiffTags x$293 = s.copy$default$4();
                    DocumentationTags x$294 = s.copy$default$5();
                    TileTags x$295 = s.copy$default$6();
                    DataSampleFormatTags x$296 = s.copy$default$8();
                    ColimetryTags x$297 = s.copy$default$9();
                    JpegTags x$298 = s.copy$default$10();
                    YCbCrTags x$299 = s.copy$default$11();
                    NonStandardizedTags x$300 = s.copy$default$12();
                    TiffType x$301 = s.copy$default$13();
                    List<TiffTags> x$302 = s.copy$default$14();
                    return s.copy(x$290, x$291, x$292, x$293, x$294, x$295, x$289, x$296, x$297, x$298, x$299, x$300, x$301, x$302);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$7(geotrellis.raster.io.geotiff.tags.CmykTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$7(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.CmykTags ), $anonfun$modify$7(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._dataSampleFormatTags = new PLens<TiffTags, TiffTags, DataSampleFormatTags, DataSampleFormatTags>(){

            public DataSampleFormatTags get(TiffTags s) {
                return s.dataSampleFormatTags();
            }

            public Function1<TiffTags, TiffTags> set(DataSampleFormatTags a) {
                return (Function1 & Serializable & scala.Serializable)x$173 -> {
                    DataSampleFormatTags x$174 = a;
                    MetadataTags x$175 = x$173.copy$default$1();
                    BasicTags x$176 = x$173.copy$default$2();
                    NonBasicTags x$177 = x$173.copy$default$3();
                    GeoTiffTags x$178 = x$173.copy$default$4();
                    DocumentationTags x$179 = x$173.copy$default$5();
                    TileTags x$180 = x$173.copy$default$6();
                    CmykTags x$181 = x$173.copy$default$7();
                    ColimetryTags x$182 = x$173.copy$default$9();
                    JpegTags x$183 = x$173.copy$default$10();
                    YCbCrTags x$184 = x$173.copy$default$11();
                    NonStandardizedTags x$185 = x$173.copy$default$12();
                    TiffType x$186 = x$173.copy$default$13();
                    List<TiffTags> x$187 = x$173.copy$default$14();
                    return x$173.copy(x$175, x$176, x$177, x$178, x$179, x$180, x$181, x$174, x$182, x$183, x$184, x$185, x$186, x$187);
                };
            }

            public <F$macro$5> F$macro$5 modifyF(Function1<DataSampleFormatTags, F$macro$5> f, TiffTags s, Functor<F$macro$5> evidence$5) {
                return (F$macro$5)Functor$.MODULE$.apply(evidence$5).map(f.apply((Object)s.dataSampleFormatTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    DataSampleFormatTags x$188 = a;
                    MetadataTags x$189 = s.copy$default$1();
                    BasicTags x$190 = s.copy$default$2();
                    NonBasicTags x$191 = s.copy$default$3();
                    GeoTiffTags x$192 = s.copy$default$4();
                    DocumentationTags x$193 = s.copy$default$5();
                    TileTags x$194 = s.copy$default$6();
                    CmykTags x$195 = s.copy$default$7();
                    ColimetryTags x$196 = s.copy$default$9();
                    JpegTags x$197 = s.copy$default$10();
                    YCbCrTags x$198 = s.copy$default$11();
                    NonStandardizedTags x$199 = s.copy$default$12();
                    TiffType x$200 = s.copy$default$13();
                    List<TiffTags> x$201 = s.copy$default$14();
                    return s.copy(x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$188, x$196, x$197, x$198, x$199, x$200, x$201);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<DataSampleFormatTags, DataSampleFormatTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    DataSampleFormatTags x$202 = (DataSampleFormatTags)f.apply((Object)s.dataSampleFormatTags());
                    MetadataTags x$203 = s.copy$default$1();
                    BasicTags x$204 = s.copy$default$2();
                    NonBasicTags x$205 = s.copy$default$3();
                    GeoTiffTags x$206 = s.copy$default$4();
                    DocumentationTags x$207 = s.copy$default$5();
                    TileTags x$208 = s.copy$default$6();
                    CmykTags x$209 = s.copy$default$7();
                    ColimetryTags x$210 = s.copy$default$9();
                    JpegTags x$211 = s.copy$default$10();
                    YCbCrTags x$212 = s.copy$default$11();
                    NonStandardizedTags x$213 = s.copy$default$12();
                    TiffType x$214 = s.copy$default$13();
                    List<TiffTags> x$215 = s.copy$default$14();
                    return s.copy(x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$202, x$210, x$211, x$212, x$213, x$214, x$215);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$8(geotrellis.raster.io.geotiff.tags.DataSampleFormatTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$8(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.DataSampleFormatTags ), $anonfun$modify$8(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._colimetryTags = new PLens<TiffTags, TiffTags, ColimetryTags, ColimetryTags>(){

            public ColimetryTags get(TiffTags s) {
                return s.colimetryTags();
            }

            public Function1<TiffTags, TiffTags> set(ColimetryTags a) {
                return (Function1 & Serializable & scala.Serializable)x$303 -> {
                    ColimetryTags x$304 = a;
                    MetadataTags x$305 = x$303.copy$default$1();
                    BasicTags x$306 = x$303.copy$default$2();
                    NonBasicTags x$307 = x$303.copy$default$3();
                    GeoTiffTags x$308 = x$303.copy$default$4();
                    DocumentationTags x$309 = x$303.copy$default$5();
                    TileTags x$310 = x$303.copy$default$6();
                    CmykTags x$311 = x$303.copy$default$7();
                    DataSampleFormatTags x$312 = x$303.copy$default$8();
                    JpegTags x$313 = x$303.copy$default$10();
                    YCbCrTags x$314 = x$303.copy$default$11();
                    NonStandardizedTags x$315 = x$303.copy$default$12();
                    TiffType x$316 = x$303.copy$default$13();
                    List<TiffTags> x$317 = x$303.copy$default$14();
                    return x$303.copy(x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$312, x$304, x$313, x$314, x$315, x$316, x$317);
                };
            }

            public <F$macro$9> F$macro$9 modifyF(Function1<ColimetryTags, F$macro$9> f, TiffTags s, Functor<F$macro$9> evidence$9) {
                return (F$macro$9)Functor$.MODULE$.apply(evidence$9).map(f.apply((Object)s.colimetryTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    ColimetryTags x$318 = a;
                    MetadataTags x$319 = s.copy$default$1();
                    BasicTags x$320 = s.copy$default$2();
                    NonBasicTags x$321 = s.copy$default$3();
                    GeoTiffTags x$322 = s.copy$default$4();
                    DocumentationTags x$323 = s.copy$default$5();
                    TileTags x$324 = s.copy$default$6();
                    CmykTags x$325 = s.copy$default$7();
                    DataSampleFormatTags x$326 = s.copy$default$8();
                    JpegTags x$327 = s.copy$default$10();
                    YCbCrTags x$328 = s.copy$default$11();
                    NonStandardizedTags x$329 = s.copy$default$12();
                    TiffType x$330 = s.copy$default$13();
                    List<TiffTags> x$331 = s.copy$default$14();
                    return s.copy(x$319, x$320, x$321, x$322, x$323, x$324, x$325, x$326, x$318, x$327, x$328, x$329, x$330, x$331);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<ColimetryTags, ColimetryTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    ColimetryTags x$332 = (ColimetryTags)f.apply((Object)s.colimetryTags());
                    MetadataTags x$333 = s.copy$default$1();
                    BasicTags x$334 = s.copy$default$2();
                    NonBasicTags x$335 = s.copy$default$3();
                    GeoTiffTags x$336 = s.copy$default$4();
                    DocumentationTags x$337 = s.copy$default$5();
                    TileTags x$338 = s.copy$default$6();
                    CmykTags x$339 = s.copy$default$7();
                    DataSampleFormatTags x$340 = s.copy$default$8();
                    JpegTags x$341 = s.copy$default$10();
                    YCbCrTags x$342 = s.copy$default$11();
                    NonStandardizedTags x$343 = s.copy$default$12();
                    TiffType x$344 = s.copy$default$13();
                    List<TiffTags> x$345 = s.copy$default$14();
                    return s.copy(x$333, x$334, x$335, x$336, x$337, x$338, x$339, x$340, x$332, x$341, x$342, x$343, x$344, x$345);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$9(geotrellis.raster.io.geotiff.tags.ColimetryTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$9(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.ColimetryTags ), $anonfun$modify$9(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._jpegTags = new PLens<TiffTags, TiffTags, JpegTags, JpegTags>(){

            public JpegTags get(TiffTags s) {
                return s.jpegTags();
            }

            public Function1<TiffTags, TiffTags> set(JpegTags a) {
                return (Function1 & Serializable & scala.Serializable)x$346 -> {
                    JpegTags x$347 = a;
                    MetadataTags x$348 = x$346.copy$default$1();
                    BasicTags x$349 = x$346.copy$default$2();
                    NonBasicTags x$350 = x$346.copy$default$3();
                    GeoTiffTags x$351 = x$346.copy$default$4();
                    DocumentationTags x$352 = x$346.copy$default$5();
                    TileTags x$353 = x$346.copy$default$6();
                    CmykTags x$354 = x$346.copy$default$7();
                    DataSampleFormatTags x$355 = x$346.copy$default$8();
                    ColimetryTags x$356 = x$346.copy$default$9();
                    YCbCrTags x$357 = x$346.copy$default$11();
                    NonStandardizedTags x$358 = x$346.copy$default$12();
                    TiffType x$359 = x$346.copy$default$13();
                    List<TiffTags> x$360 = x$346.copy$default$14();
                    return x$346.copy(x$348, x$349, x$350, x$351, x$352, x$353, x$354, x$355, x$356, x$347, x$357, x$358, x$359, x$360);
                };
            }

            public <F$macro$10> F$macro$10 modifyF(Function1<JpegTags, F$macro$10> f, TiffTags s, Functor<F$macro$10> evidence$10) {
                return (F$macro$10)Functor$.MODULE$.apply(evidence$10).map(f.apply((Object)s.jpegTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    JpegTags x$361 = a;
                    MetadataTags x$362 = s.copy$default$1();
                    BasicTags x$363 = s.copy$default$2();
                    NonBasicTags x$364 = s.copy$default$3();
                    GeoTiffTags x$365 = s.copy$default$4();
                    DocumentationTags x$366 = s.copy$default$5();
                    TileTags x$367 = s.copy$default$6();
                    CmykTags x$368 = s.copy$default$7();
                    DataSampleFormatTags x$369 = s.copy$default$8();
                    ColimetryTags x$370 = s.copy$default$9();
                    YCbCrTags x$371 = s.copy$default$11();
                    NonStandardizedTags x$372 = s.copy$default$12();
                    TiffType x$373 = s.copy$default$13();
                    List<TiffTags> x$374 = s.copy$default$14();
                    return s.copy(x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$361, x$371, x$372, x$373, x$374);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<JpegTags, JpegTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    JpegTags x$375 = (JpegTags)f.apply((Object)s.jpegTags());
                    MetadataTags x$376 = s.copy$default$1();
                    BasicTags x$377 = s.copy$default$2();
                    NonBasicTags x$378 = s.copy$default$3();
                    GeoTiffTags x$379 = s.copy$default$4();
                    DocumentationTags x$380 = s.copy$default$5();
                    TileTags x$381 = s.copy$default$6();
                    CmykTags x$382 = s.copy$default$7();
                    DataSampleFormatTags x$383 = s.copy$default$8();
                    ColimetryTags x$384 = s.copy$default$9();
                    YCbCrTags x$385 = s.copy$default$11();
                    NonStandardizedTags x$386 = s.copy$default$12();
                    TiffType x$387 = s.copy$default$13();
                    List<TiffTags> x$388 = s.copy$default$14();
                    return s.copy(x$376, x$377, x$378, x$379, x$380, x$381, x$382, x$383, x$384, x$375, x$385, x$386, x$387, x$388);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$10(geotrellis.raster.io.geotiff.tags.JpegTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$10(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.JpegTags ), $anonfun$modify$10(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._yCbCrTags = new PLens<TiffTags, TiffTags, YCbCrTags, YCbCrTags>(){

            public YCbCrTags get(TiffTags s) {
                return s.yCbCrTags();
            }

            public Function1<TiffTags, TiffTags> set(YCbCrTags a) {
                return (Function1 & Serializable & scala.Serializable)x$389 -> {
                    YCbCrTags x$390 = a;
                    MetadataTags x$391 = x$389.copy$default$1();
                    BasicTags x$392 = x$389.copy$default$2();
                    NonBasicTags x$393 = x$389.copy$default$3();
                    GeoTiffTags x$394 = x$389.copy$default$4();
                    DocumentationTags x$395 = x$389.copy$default$5();
                    TileTags x$396 = x$389.copy$default$6();
                    CmykTags x$397 = x$389.copy$default$7();
                    DataSampleFormatTags x$398 = x$389.copy$default$8();
                    ColimetryTags x$399 = x$389.copy$default$9();
                    JpegTags x$400 = x$389.copy$default$10();
                    NonStandardizedTags x$401 = x$389.copy$default$12();
                    TiffType x$402 = x$389.copy$default$13();
                    List<TiffTags> x$403 = x$389.copy$default$14();
                    return x$389.copy(x$391, x$392, x$393, x$394, x$395, x$396, x$397, x$398, x$399, x$400, x$390, x$401, x$402, x$403);
                };
            }

            public <F$macro$11> F$macro$11 modifyF(Function1<YCbCrTags, F$macro$11> f, TiffTags s, Functor<F$macro$11> evidence$11) {
                return (F$macro$11)Functor$.MODULE$.apply(evidence$11).map(f.apply((Object)s.yCbCrTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    YCbCrTags x$404 = a;
                    MetadataTags x$405 = s.copy$default$1();
                    BasicTags x$406 = s.copy$default$2();
                    NonBasicTags x$407 = s.copy$default$3();
                    GeoTiffTags x$408 = s.copy$default$4();
                    DocumentationTags x$409 = s.copy$default$5();
                    TileTags x$410 = s.copy$default$6();
                    CmykTags x$411 = s.copy$default$7();
                    DataSampleFormatTags x$412 = s.copy$default$8();
                    ColimetryTags x$413 = s.copy$default$9();
                    JpegTags x$414 = s.copy$default$10();
                    NonStandardizedTags x$415 = s.copy$default$12();
                    TiffType x$416 = s.copy$default$13();
                    List<TiffTags> x$417 = s.copy$default$14();
                    return s.copy(x$405, x$406, x$407, x$408, x$409, x$410, x$411, x$412, x$413, x$414, x$404, x$415, x$416, x$417);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<YCbCrTags, YCbCrTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    YCbCrTags x$418 = (YCbCrTags)f.apply((Object)s.yCbCrTags());
                    MetadataTags x$419 = s.copy$default$1();
                    BasicTags x$420 = s.copy$default$2();
                    NonBasicTags x$421 = s.copy$default$3();
                    GeoTiffTags x$422 = s.copy$default$4();
                    DocumentationTags x$423 = s.copy$default$5();
                    TileTags x$424 = s.copy$default$6();
                    CmykTags x$425 = s.copy$default$7();
                    DataSampleFormatTags x$426 = s.copy$default$8();
                    ColimetryTags x$427 = s.copy$default$9();
                    JpegTags x$428 = s.copy$default$10();
                    NonStandardizedTags x$429 = s.copy$default$12();
                    TiffType x$430 = s.copy$default$13();
                    List<TiffTags> x$431 = s.copy$default$14();
                    return s.copy(x$419, x$420, x$421, x$422, x$423, x$424, x$425, x$426, x$427, x$428, x$418, x$429, x$430, x$431);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$11(geotrellis.raster.io.geotiff.tags.YCbCrTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$11(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.YCbCrTags ), $anonfun$modify$11(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._nonStandardizedTags = new PLens<TiffTags, TiffTags, NonStandardizedTags, NonStandardizedTags>(){

            public NonStandardizedTags get(TiffTags s) {
                return s.nonStandardizedTags();
            }

            public Function1<TiffTags, TiffTags> set(NonStandardizedTags a) {
                return (Function1 & Serializable & scala.Serializable)x$432 -> {
                    NonStandardizedTags x$433 = a;
                    MetadataTags x$434 = x$432.copy$default$1();
                    BasicTags x$435 = x$432.copy$default$2();
                    NonBasicTags x$436 = x$432.copy$default$3();
                    GeoTiffTags x$437 = x$432.copy$default$4();
                    DocumentationTags x$438 = x$432.copy$default$5();
                    TileTags x$439 = x$432.copy$default$6();
                    CmykTags x$440 = x$432.copy$default$7();
                    DataSampleFormatTags x$441 = x$432.copy$default$8();
                    ColimetryTags x$442 = x$432.copy$default$9();
                    JpegTags x$443 = x$432.copy$default$10();
                    YCbCrTags x$444 = x$432.copy$default$11();
                    TiffType x$445 = x$432.copy$default$13();
                    List<TiffTags> x$446 = x$432.copy$default$14();
                    return x$432.copy(x$434, x$435, x$436, x$437, x$438, x$439, x$440, x$441, x$442, x$443, x$444, x$433, x$445, x$446);
                };
            }

            public <F$macro$12> F$macro$12 modifyF(Function1<NonStandardizedTags, F$macro$12> f, TiffTags s, Functor<F$macro$12> evidence$12) {
                return (F$macro$12)Functor$.MODULE$.apply(evidence$12).map(f.apply((Object)s.nonStandardizedTags()), (Function1 & Serializable & scala.Serializable)a -> {
                    NonStandardizedTags x$447 = a;
                    MetadataTags x$448 = s.copy$default$1();
                    BasicTags x$449 = s.copy$default$2();
                    NonBasicTags x$450 = s.copy$default$3();
                    GeoTiffTags x$451 = s.copy$default$4();
                    DocumentationTags x$452 = s.copy$default$5();
                    TileTags x$453 = s.copy$default$6();
                    CmykTags x$454 = s.copy$default$7();
                    DataSampleFormatTags x$455 = s.copy$default$8();
                    ColimetryTags x$456 = s.copy$default$9();
                    JpegTags x$457 = s.copy$default$10();
                    YCbCrTags x$458 = s.copy$default$11();
                    TiffType x$459 = s.copy$default$13();
                    List<TiffTags> x$460 = s.copy$default$14();
                    return s.copy(x$448, x$449, x$450, x$451, x$452, x$453, x$454, x$455, x$456, x$457, x$458, x$447, x$459, x$460);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<NonStandardizedTags, NonStandardizedTags> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    NonStandardizedTags x$461 = (NonStandardizedTags)f.apply((Object)s.nonStandardizedTags());
                    MetadataTags x$462 = s.copy$default$1();
                    BasicTags x$463 = s.copy$default$2();
                    NonBasicTags x$464 = s.copy$default$3();
                    GeoTiffTags x$465 = s.copy$default$4();
                    DocumentationTags x$466 = s.copy$default$5();
                    TileTags x$467 = s.copy$default$6();
                    CmykTags x$468 = s.copy$default$7();
                    DataSampleFormatTags x$469 = s.copy$default$8();
                    ColimetryTags x$470 = s.copy$default$9();
                    JpegTags x$471 = s.copy$default$10();
                    YCbCrTags x$472 = s.copy$default$11();
                    TiffType x$473 = s.copy$default$13();
                    List<TiffTags> x$474 = s.copy$default$14();
                    return s.copy(x$462, x$463, x$464, x$465, x$466, x$467, x$468, x$469, x$470, x$471, x$472, x$461, x$473, x$474);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$12(geotrellis.raster.io.geotiff.tags.NonStandardizedTags geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$12(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.NonStandardizedTags ), $anonfun$modify$12(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._tiffType = new PLens<TiffTags, TiffTags, TiffType, TiffType>(){

            public TiffType get(TiffTags s) {
                return s.tiffType();
            }

            public Function1<TiffTags, TiffTags> set(TiffType a) {
                return (Function1 & Serializable & scala.Serializable)x$475 -> {
                    TiffType x$476 = a;
                    MetadataTags x$477 = x$475.copy$default$1();
                    BasicTags x$478 = x$475.copy$default$2();
                    NonBasicTags x$479 = x$475.copy$default$3();
                    GeoTiffTags x$480 = x$475.copy$default$4();
                    DocumentationTags x$481 = x$475.copy$default$5();
                    TileTags x$482 = x$475.copy$default$6();
                    CmykTags x$483 = x$475.copy$default$7();
                    DataSampleFormatTags x$484 = x$475.copy$default$8();
                    ColimetryTags x$485 = x$475.copy$default$9();
                    JpegTags x$486 = x$475.copy$default$10();
                    YCbCrTags x$487 = x$475.copy$default$11();
                    NonStandardizedTags x$488 = x$475.copy$default$12();
                    List<TiffTags> x$489 = x$475.copy$default$14();
                    return x$475.copy(x$477, x$478, x$479, x$480, x$481, x$482, x$483, x$484, x$485, x$486, x$487, x$488, x$476, x$489);
                };
            }

            public <F$macro$13> F$macro$13 modifyF(Function1<TiffType, F$macro$13> f, TiffTags s, Functor<F$macro$13> evidence$13) {
                return (F$macro$13)Functor$.MODULE$.apply(evidence$13).map(f.apply((Object)s.tiffType()), (Function1 & Serializable & scala.Serializable)a -> {
                    TiffType x$490 = a;
                    MetadataTags x$491 = s.copy$default$1();
                    BasicTags x$492 = s.copy$default$2();
                    NonBasicTags x$493 = s.copy$default$3();
                    GeoTiffTags x$494 = s.copy$default$4();
                    DocumentationTags x$495 = s.copy$default$5();
                    TileTags x$496 = s.copy$default$6();
                    CmykTags x$497 = s.copy$default$7();
                    DataSampleFormatTags x$498 = s.copy$default$8();
                    ColimetryTags x$499 = s.copy$default$9();
                    JpegTags x$500 = s.copy$default$10();
                    YCbCrTags x$501 = s.copy$default$11();
                    NonStandardizedTags x$502 = s.copy$default$12();
                    List<TiffTags> x$503 = s.copy$default$14();
                    return s.copy(x$491, x$492, x$493, x$494, x$495, x$496, x$497, x$498, x$499, x$500, x$501, x$502, x$490, x$503);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<TiffType, TiffType> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    TiffType x$504 = (TiffType)f.apply((Object)s.tiffType());
                    MetadataTags x$505 = s.copy$default$1();
                    BasicTags x$506 = s.copy$default$2();
                    NonBasicTags x$507 = s.copy$default$3();
                    GeoTiffTags x$508 = s.copy$default$4();
                    DocumentationTags x$509 = s.copy$default$5();
                    TileTags x$510 = s.copy$default$6();
                    CmykTags x$511 = s.copy$default$7();
                    DataSampleFormatTags x$512 = s.copy$default$8();
                    ColimetryTags x$513 = s.copy$default$9();
                    JpegTags x$514 = s.copy$default$10();
                    YCbCrTags x$515 = s.copy$default$11();
                    NonStandardizedTags x$516 = s.copy$default$12();
                    List<TiffTags> x$517 = s.copy$default$14();
                    return s.copy(x$505, x$506, x$507, x$508, x$509, x$510, x$511, x$512, x$513, x$514, x$515, x$516, x$504, x$517);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$13(geotrellis.raster.io.geotiff.TiffType geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$13(geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.TiffType ), $anonfun$modify$13(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        this._overviews = new PLens<TiffTags, TiffTags, List<TiffTags>, List<TiffTags>>(){

            public List<TiffTags> get(TiffTags s) {
                return s.overviews();
            }

            public Function1<TiffTags, TiffTags> set(List<TiffTags> a) {
                return (Function1 & Serializable & scala.Serializable)x$518 -> {
                    List x$519 = a;
                    MetadataTags x$520 = x$518.copy$default$1();
                    BasicTags x$521 = x$518.copy$default$2();
                    NonBasicTags x$522 = x$518.copy$default$3();
                    GeoTiffTags x$523 = x$518.copy$default$4();
                    DocumentationTags x$524 = x$518.copy$default$5();
                    TileTags x$525 = x$518.copy$default$6();
                    CmykTags x$526 = x$518.copy$default$7();
                    DataSampleFormatTags x$527 = x$518.copy$default$8();
                    ColimetryTags x$528 = x$518.copy$default$9();
                    JpegTags x$529 = x$518.copy$default$10();
                    YCbCrTags x$530 = x$518.copy$default$11();
                    NonStandardizedTags x$531 = x$518.copy$default$12();
                    TiffType x$532 = x$518.copy$default$13();
                    return x$518.copy(x$520, x$521, x$522, x$523, x$524, x$525, x$526, x$527, x$528, x$529, x$530, x$531, x$532, (List<TiffTags>)x$519);
                };
            }

            public <F$macro$14> F$macro$14 modifyF(Function1<List<TiffTags>, F$macro$14> f, TiffTags s, Functor<F$macro$14> evidence$14) {
                return (F$macro$14)Functor$.MODULE$.apply(evidence$14).map(f.apply(s.overviews()), (Function1 & Serializable & scala.Serializable)a -> {
                    List x$533 = a;
                    MetadataTags x$534 = s.copy$default$1();
                    BasicTags x$535 = s.copy$default$2();
                    NonBasicTags x$536 = s.copy$default$3();
                    GeoTiffTags x$537 = s.copy$default$4();
                    DocumentationTags x$538 = s.copy$default$5();
                    TileTags x$539 = s.copy$default$6();
                    CmykTags x$540 = s.copy$default$7();
                    DataSampleFormatTags x$541 = s.copy$default$8();
                    ColimetryTags x$542 = s.copy$default$9();
                    JpegTags x$543 = s.copy$default$10();
                    YCbCrTags x$544 = s.copy$default$11();
                    NonStandardizedTags x$545 = s.copy$default$12();
                    TiffType x$546 = s.copy$default$13();
                    return s.copy(x$534, x$535, x$536, x$537, x$538, x$539, x$540, x$541, x$542, x$543, x$544, x$545, x$546, (List<TiffTags>)x$533);
                });
            }

            public Function1<TiffTags, TiffTags> modify(Function1<List<TiffTags>, List<TiffTags>> f) {
                return (Function1 & Serializable & scala.Serializable)s -> {
                    List x$547 = (List)f.apply(s.overviews());
                    MetadataTags x$548 = s.copy$default$1();
                    BasicTags x$549 = s.copy$default$2();
                    NonBasicTags x$550 = s.copy$default$3();
                    GeoTiffTags x$551 = s.copy$default$4();
                    DocumentationTags x$552 = s.copy$default$5();
                    TileTags x$553 = s.copy$default$6();
                    CmykTags x$554 = s.copy$default$7();
                    DataSampleFormatTags x$555 = s.copy$default$8();
                    ColimetryTags x$556 = s.copy$default$9();
                    JpegTags x$557 = s.copy$default$10();
                    YCbCrTags x$558 = s.copy$default$11();
                    NonStandardizedTags x$559 = s.copy$default$12();
                    TiffType x$560 = s.copy$default$13();
                    return s.copy(x$548, x$549, x$550, x$551, x$552, x$553, x$554, x$555, x$556, x$557, x$558, x$559, x$560, (List<TiffTags>)x$547);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$set$14(scala.collection.immutable.List geotrellis.raster.io.geotiff.tags.TiffTags ), $anonfun$modifyF$14(geotrellis.raster.io.geotiff.tags.TiffTags scala.collection.immutable.List ), $anonfun$modify$14(scala.Function1 geotrellis.raster.io.geotiff.tags.TiffTags )}, serializedLambda);
            }
        };
        public final class Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1
        implements scala.Serializable {
            private ReprAsObjectEncoder<.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>> inst$macro$46;
            private DerivedAsObjectEncoder<TiffTags> inst$macro$15;
            private volatile byte bitmap$0;

            private ReprAsObjectEncoder<.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>> inst$macro$46$lzycompute() {
                Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.inst$macro$46 = new ReprAsObjectEncoder<.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>>(null){
                            private final Encoder<MetadataTags> circeGenericEncoderFormetadataTags;
                            private final Encoder<BasicTags> circeGenericEncoderForbasicTags;
                            private final Encoder<NonBasicTags> circeGenericEncoderFornonBasicTags;
                            private final Encoder<GeoTiffTags> circeGenericEncoderForgeoTiffTags;
                            private final Encoder<DocumentationTags> circeGenericEncoderFordocumentationTags;
                            private final Encoder<TileTags> circeGenericEncoderFortileTags;
                            private final Encoder<CmykTags> circeGenericEncoderForcmykTags;
                            private final Encoder<DataSampleFormatTags> circeGenericEncoderFordataSampleFormatTags;
                            private final Encoder<ColimetryTags> circeGenericEncoderForcolimetryTags;
                            private final Encoder<JpegTags> circeGenericEncoderForjpegTags;
                            private final Encoder<YCbCrTags> circeGenericEncoderForyCbCrTags;
                            private final Encoder<NonStandardizedTags> circeGenericEncoderFornonStandardizedTags;
                            private final Encoder<TiffType> circeGenericEncoderFortiffType;
                            private final Encoder.AsArray<List<TiffTags>> circeGenericEncoderForoverviews;

                            public final JsonObject encodeObject(.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>> a) {
                                List circeGenericHListBindingForoverviews;
                                TiffType circeGenericHListBindingFortiffType;
                                NonStandardizedTags circeGenericHListBindingFornonStandardizedTags;
                                YCbCrTags circeGenericHListBindingForyCbCrTags;
                                JpegTags circeGenericHListBindingForjpegTags;
                                ColimetryTags circeGenericHListBindingForcolimetryTags;
                                DataSampleFormatTags circeGenericHListBindingFordataSampleFormatTags;
                                CmykTags circeGenericHListBindingForcmykTags;
                                TileTags circeGenericHListBindingFortileTags;
                                DocumentationTags circeGenericHListBindingFordocumentationTags;
                                GeoTiffTags circeGenericHListBindingForgeoTiffTags;
                                NonBasicTags circeGenericHListBindingFornonBasicTags;
                                BasicTags circeGenericHListBindingForbasicTags;
                                MetadataTags circeGenericHListBindingFormetadataTags;
                                block3: {
                                    .colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>> colon2;
                                    block2: {
                                        colon2 = a;
                                        if (colon2 == null) break block2;
                                        circeGenericHListBindingFormetadataTags = (MetadataTags)colon2.head();
                                        .colon.colon colon3 = (.colon.colon)colon2.tail();
                                        if (colon3 == null) break block2;
                                        circeGenericHListBindingForbasicTags = (BasicTags)colon3.head();
                                        .colon.colon colon4 = (.colon.colon)colon3.tail();
                                        if (colon4 == null) break block2;
                                        circeGenericHListBindingFornonBasicTags = (NonBasicTags)colon4.head();
                                        .colon.colon colon5 = (.colon.colon)colon4.tail();
                                        if (colon5 == null) break block2;
                                        circeGenericHListBindingForgeoTiffTags = (GeoTiffTags)colon5.head();
                                        .colon.colon colon6 = (.colon.colon)colon5.tail();
                                        if (colon6 == null) break block2;
                                        circeGenericHListBindingFordocumentationTags = (DocumentationTags)colon6.head();
                                        .colon.colon colon7 = (.colon.colon)colon6.tail();
                                        if (colon7 == null) break block2;
                                        circeGenericHListBindingFortileTags = (TileTags)colon7.head();
                                        .colon.colon colon8 = (.colon.colon)colon7.tail();
                                        if (colon8 == null) break block2;
                                        circeGenericHListBindingForcmykTags = (CmykTags)colon8.head();
                                        .colon.colon colon9 = (.colon.colon)colon8.tail();
                                        if (colon9 == null) break block2;
                                        circeGenericHListBindingFordataSampleFormatTags = (DataSampleFormatTags)colon9.head();
                                        .colon.colon colon10 = (.colon.colon)colon9.tail();
                                        if (colon10 == null) break block2;
                                        circeGenericHListBindingForcolimetryTags = (ColimetryTags)colon10.head();
                                        .colon.colon colon11 = (.colon.colon)colon10.tail();
                                        if (colon11 == null) break block2;
                                        circeGenericHListBindingForjpegTags = (JpegTags)colon11.head();
                                        .colon.colon colon12 = (.colon.colon)colon11.tail();
                                        if (colon12 == null) break block2;
                                        circeGenericHListBindingForyCbCrTags = (YCbCrTags)colon12.head();
                                        .colon.colon colon13 = (.colon.colon)colon12.tail();
                                        if (colon13 == null) break block2;
                                        circeGenericHListBindingFornonStandardizedTags = (NonStandardizedTags)colon13.head();
                                        .colon.colon colon14 = (.colon.colon)colon13.tail();
                                        if (colon14 == null) break block2;
                                        circeGenericHListBindingFortiffType = (TiffType)colon14.head();
                                        .colon.colon colon15 = (.colon.colon)colon14.tail();
                                        if (colon15 == null) break block2;
                                        circeGenericHListBindingForoverviews = (List)colon15.head();
                                        HNil hNil = (HNil)colon15.tail();
                                        if (HNil$.MODULE$.equals(hNil)) break block3;
                                    }
                                    throw new MatchError(colon2);
                                }
                                JsonObject jsonObject = JsonObject$.MODULE$.fromIterable((Iterable)Vector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"metadataTags", (Object)this.circeGenericEncoderFormetadataTags.apply((Object)circeGenericHListBindingFormetadataTags)), new Tuple2((Object)"basicTags", (Object)this.circeGenericEncoderForbasicTags.apply((Object)circeGenericHListBindingForbasicTags)), new Tuple2((Object)"nonBasicTags", (Object)this.circeGenericEncoderFornonBasicTags.apply((Object)circeGenericHListBindingFornonBasicTags)), new Tuple2((Object)"geoTiffTags", (Object)this.circeGenericEncoderForgeoTiffTags.apply((Object)circeGenericHListBindingForgeoTiffTags)), new Tuple2((Object)"documentationTags", (Object)this.circeGenericEncoderFordocumentationTags.apply((Object)circeGenericHListBindingFordocumentationTags)), new Tuple2((Object)"tileTags", (Object)this.circeGenericEncoderFortileTags.apply((Object)circeGenericHListBindingFortileTags)), new Tuple2((Object)"cmykTags", (Object)this.circeGenericEncoderForcmykTags.apply((Object)circeGenericHListBindingForcmykTags)), new Tuple2((Object)"dataSampleFormatTags", (Object)this.circeGenericEncoderFordataSampleFormatTags.apply((Object)circeGenericHListBindingFordataSampleFormatTags)), new Tuple2((Object)"colimetryTags", (Object)this.circeGenericEncoderForcolimetryTags.apply((Object)circeGenericHListBindingForcolimetryTags)), new Tuple2((Object)"jpegTags", (Object)this.circeGenericEncoderForjpegTags.apply((Object)circeGenericHListBindingForjpegTags)), new Tuple2((Object)"yCbCrTags", (Object)this.circeGenericEncoderForyCbCrTags.apply((Object)circeGenericHListBindingForyCbCrTags)), new Tuple2((Object)"nonStandardizedTags", (Object)this.circeGenericEncoderFornonStandardizedTags.apply((Object)circeGenericHListBindingFornonStandardizedTags)), new Tuple2((Object)"tiffType", (Object)this.circeGenericEncoderFortiffType.apply((Object)circeGenericHListBindingFortiffType)), new Tuple2((Object)"overviews", (Object)this.circeGenericEncoderForoverviews.apply((Object)circeGenericHListBindingForoverviews))})));
                                return jsonObject;
                            }
                            {
                                this.circeGenericEncoderFormetadataTags = MetadataTags$.MODULE$.metadataTagsEncoder();
                                this.circeGenericEncoderForbasicTags = BasicTags$.MODULE$.basicTagsEncoder();
                                this.circeGenericEncoderFornonBasicTags = NonBasicTags$.MODULE$.nonBasicTagsEncoder();
                                this.circeGenericEncoderForgeoTiffTags = GeoTiffTags$.MODULE$.geotiffTagsEncoder();
                                this.circeGenericEncoderFordocumentationTags = DocumentationTags$.MODULE$.documentationTagsEncoder();
                                this.circeGenericEncoderFortileTags = TileTags$.MODULE$.tileTagsEncoder();
                                this.circeGenericEncoderForcmykTags = CmykTags$.MODULE$.cmykTagsEncoder();
                                this.circeGenericEncoderFordataSampleFormatTags = DataSampleFormatTags$.MODULE$.dataSampleFormatTagsEncoder();
                                this.circeGenericEncoderForcolimetryTags = ColimetryTags$.MODULE$.colimetryTagsEncoder();
                                this.circeGenericEncoderForjpegTags = JpegTags$.MODULE$.jpegTagsEncoder();
                                this.circeGenericEncoderForyCbCrTags = YCbCrTags$.MODULE$.ycbcrTagsEncoder();
                                this.circeGenericEncoderFornonStandardizedTags = NonStandardizedTags$.MODULE$.nonStandardizedTagsEncoder();
                                this.circeGenericEncoderFortiffType = TiffType$.MODULE$.tiffTypeEncoder();
                                this.circeGenericEncoderForoverviews = Encoder$.MODULE$.encodeList(TiffTags$.MODULE$.tiffTagsEncoder());
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$46;
            }

            public ReprAsObjectEncoder<.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>> inst$macro$46() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$46$lzycompute() : this.inst$macro$46;
            }

            private DerivedAsObjectEncoder<TiffTags> inst$macro$15$lzycompute() {
                Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        public final class Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1$anon$macro$45$1
                        implements Generic<TiffTags> {
                            public .colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>> to(TiffTags p) {
                                TiffTags tiffTags = p;
                                if (tiffTags == null) {
                                    throw new MatchError((Object)tiffTags);
                                }
                                MetadataTags pat$macro$31 = tiffTags.metadataTags();
                                BasicTags pat$macro$32 = tiffTags.basicTags();
                                NonBasicTags pat$macro$33 = tiffTags.nonBasicTags();
                                GeoTiffTags pat$macro$34 = tiffTags.geoTiffTags();
                                DocumentationTags pat$macro$35 = tiffTags.documentationTags();
                                TileTags pat$macro$36 = tiffTags.tileTags();
                                CmykTags pat$macro$37 = tiffTags.cmykTags();
                                DataSampleFormatTags pat$macro$38 = tiffTags.dataSampleFormatTags();
                                ColimetryTags pat$macro$39 = tiffTags.colimetryTags();
                                JpegTags pat$macro$40 = tiffTags.jpegTags();
                                YCbCrTags pat$macro$41 = tiffTags.yCbCrTags();
                                NonStandardizedTags pat$macro$42 = tiffTags.nonStandardizedTags();
                                TiffType pat$macro$43 = tiffTags.tiffType();
                                List<TiffTags> pat$macro$44 = tiffTags.overviews();
                                .colon.colon colon2 = new .colon.colon((Object)pat$macro$31, (HList)new .colon.colon((Object)pat$macro$32, (HList)new .colon.colon((Object)pat$macro$33, (HList)new .colon.colon((Object)pat$macro$34, (HList)new .colon.colon((Object)pat$macro$35, (HList)new .colon.colon((Object)pat$macro$36, (HList)new .colon.colon((Object)pat$macro$37, (HList)new .colon.colon((Object)pat$macro$38, (HList)new .colon.colon((Object)pat$macro$39, (HList)new .colon.colon((Object)pat$macro$40, (HList)new .colon.colon((Object)pat$macro$41, (HList)new .colon.colon((Object)pat$macro$42, (HList)new .colon.colon((Object)pat$macro$43, (HList)new .colon.colon(pat$macro$44, (HList)HNil$.MODULE$))))))))))))));
                                return colon2;
                            }

                            public TiffTags from(.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>> p) {
                                List pat$macro$44;
                                TiffType pat$macro$43;
                                NonStandardizedTags pat$macro$42;
                                YCbCrTags pat$macro$41;
                                JpegTags pat$macro$40;
                                ColimetryTags pat$macro$39;
                                DataSampleFormatTags pat$macro$38;
                                CmykTags pat$macro$37;
                                TileTags pat$macro$36;
                                DocumentationTags pat$macro$35;
                                GeoTiffTags pat$macro$34;
                                NonBasicTags pat$macro$33;
                                BasicTags pat$macro$32;
                                MetadataTags pat$macro$31;
                                block3: {
                                    .colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>> colon2;
                                    block2: {
                                        colon2 = p;
                                        if (colon2 == null) break block2;
                                        pat$macro$31 = (MetadataTags)colon2.head();
                                        .colon.colon colon3 = (.colon.colon)colon2.tail();
                                        if (colon3 == null) break block2;
                                        pat$macro$32 = (BasicTags)colon3.head();
                                        .colon.colon colon4 = (.colon.colon)colon3.tail();
                                        if (colon4 == null) break block2;
                                        pat$macro$33 = (NonBasicTags)colon4.head();
                                        .colon.colon colon5 = (.colon.colon)colon4.tail();
                                        if (colon5 == null) break block2;
                                        pat$macro$34 = (GeoTiffTags)colon5.head();
                                        .colon.colon colon6 = (.colon.colon)colon5.tail();
                                        if (colon6 == null) break block2;
                                        pat$macro$35 = (DocumentationTags)colon6.head();
                                        .colon.colon colon7 = (.colon.colon)colon6.tail();
                                        if (colon7 == null) break block2;
                                        pat$macro$36 = (TileTags)colon7.head();
                                        .colon.colon colon8 = (.colon.colon)colon7.tail();
                                        if (colon8 == null) break block2;
                                        pat$macro$37 = (CmykTags)colon8.head();
                                        .colon.colon colon9 = (.colon.colon)colon8.tail();
                                        if (colon9 == null) break block2;
                                        pat$macro$38 = (DataSampleFormatTags)colon9.head();
                                        .colon.colon colon10 = (.colon.colon)colon9.tail();
                                        if (colon10 == null) break block2;
                                        pat$macro$39 = (ColimetryTags)colon10.head();
                                        .colon.colon colon11 = (.colon.colon)colon10.tail();
                                        if (colon11 == null) break block2;
                                        pat$macro$40 = (JpegTags)colon11.head();
                                        .colon.colon colon12 = (.colon.colon)colon11.tail();
                                        if (colon12 == null) break block2;
                                        pat$macro$41 = (YCbCrTags)colon12.head();
                                        .colon.colon colon13 = (.colon.colon)colon12.tail();
                                        if (colon13 == null) break block2;
                                        pat$macro$42 = (NonStandardizedTags)colon13.head();
                                        .colon.colon colon14 = (.colon.colon)colon13.tail();
                                        if (colon14 == null) break block2;
                                        pat$macro$43 = (TiffType)colon14.head();
                                        .colon.colon colon15 = (.colon.colon)colon14.tail();
                                        if (colon15 == null) break block2;
                                        pat$macro$44 = (List)colon15.head();
                                        HNil hNil = (HNil)colon15.tail();
                                        if (HNil$.MODULE$.equals(hNil)) break block3;
                                    }
                                    throw new MatchError(colon2);
                                }
                                TiffTags tiffTags = new TiffTags(pat$macro$31, pat$macro$32, pat$macro$33, pat$macro$34, pat$macro$35, pat$macro$36, pat$macro$37, pat$macro$38, pat$macro$39, pat$macro$40, pat$macro$41, pat$macro$42, pat$macro$43, (List<TiffTags>)pat$macro$44);
                                return tiffTags;
                            }

                            public Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1$anon$macro$45$1(Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1 $outer) {
                            }
                        }
                        this.inst$macro$15 = DerivedAsObjectEncoder$.MODULE$.deriveEncoder(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<TiffTags>(null){

                            public .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, HNil>>>>>>>>>>>>>> apply() {
                                return new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "metadataTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "basicTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "nonBasicTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "geoTiffTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "documentationTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "tileTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "cmykTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "dataSampleFormatTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "colimetryTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "jpegTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "yCbCrTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "nonStandardizedTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "tiffType"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "overviews"), (HList)HNil$.MODULE$))))))))))))));
                            }
                        }, (Generic)new Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1$anon$macro$45$1(null), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "overviews"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "tiffType"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "nonStandardizedTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "yCbCrTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "jpegTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "colimetryTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "dataSampleFormatTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "cmykTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "tileTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "documentationTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "geoTiffTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "nonBasicTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "basicTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "metadataTags"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$46()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$15;
            }

            public DerivedAsObjectEncoder<TiffTags> inst$macro$15() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$15$lzycompute() : this.inst$macro$15;
            }

            public Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$15$1(geotrellis.raster.io.geotiff.tags.TiffTags$anon$lazy$macro$47$1 )}, serializedLambda);
            }
        }
        DerivedAsObjectEncoder<TiffTags> inst$macro$48 = new Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$47$1().inst$macro$15();
        this.tiffTagsEncoder = semiauto$.MODULE$.deriveEncoder(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$48));
        public final class Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1
        implements scala.Serializable {
            private ReprDecoder<.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>> inst$macro$80;
            private DerivedDecoder<TiffTags> inst$macro$49;
            private volatile byte bitmap$0;

            private ReprDecoder<.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>> inst$macro$80$lzycompute() {
                Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.inst$macro$80 = new ReprDecoder<.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>>(null){
                            private final Decoder<MetadataTags> circeGenericDecoderFormetadataTags;
                            private final Decoder<BasicTags> circeGenericDecoderForbasicTags;
                            private final Decoder<NonBasicTags> circeGenericDecoderFornonBasicTags;
                            private final Decoder<GeoTiffTags> circeGenericDecoderForgeoTiffTags;
                            private final Decoder<DocumentationTags> circeGenericDecoderFordocumentationTags;
                            private final Decoder<TileTags> circeGenericDecoderFortileTags;
                            private final Decoder<CmykTags> circeGenericDecoderForcmykTags;
                            private final Decoder<DataSampleFormatTags> circeGenericDecoderFordataSampleFormatTags;
                            private final Decoder<ColimetryTags> circeGenericDecoderForcolimetryTags;
                            private final Decoder<JpegTags> circeGenericDecoderForjpegTags;
                            private final Decoder<YCbCrTags> circeGenericDecoderForyCbCrTags;
                            private final Decoder<NonStandardizedTags> circeGenericDecoderFornonStandardizedTags;
                            private final Decoder<TiffType> circeGenericDecoderFortiffType;
                            private final Decoder<List<TiffTags>> circeGenericDecoderForoverviews;

                            public final Either<DecodingFailure, .colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>> apply(HCursor c) {
                                return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFormetadataTags.tryDecode(c.downField("metadataTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForbasicTags.tryDecode(c.downField("basicTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFornonBasicTags.tryDecode(c.downField("nonBasicTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForgeoTiffTags.tryDecode(c.downField("geoTiffTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordocumentationTags.tryDecode(c.downField("documentationTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFortileTags.tryDecode(c.downField("tileTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForcmykTags.tryDecode(c.downField("cmykTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordataSampleFormatTags.tryDecode(c.downField("dataSampleFormatTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForcolimetryTags.tryDecode(c.downField("colimetryTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForjpegTags.tryDecode(c.downField("jpegTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForyCbCrTags.tryDecode(c.downField("yCbCrTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFornonStandardizedTags.tryDecode(c.downField("nonStandardizedTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFortiffType.tryDecode(c.downField("tiffType")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForoverviews.tryDecode(c.downField("overviews")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                            }

                            public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>> decodeAccumulating(HCursor c) {
                                return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFormetadataTags.tryDecodeAccumulating(c.downField("metadataTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForbasicTags.tryDecodeAccumulating(c.downField("basicTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFornonBasicTags.tryDecodeAccumulating(c.downField("nonBasicTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForgeoTiffTags.tryDecodeAccumulating(c.downField("geoTiffTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordocumentationTags.tryDecodeAccumulating(c.downField("documentationTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFortileTags.tryDecodeAccumulating(c.downField("tileTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForcmykTags.tryDecodeAccumulating(c.downField("cmykTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordataSampleFormatTags.tryDecodeAccumulating(c.downField("dataSampleFormatTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForcolimetryTags.tryDecodeAccumulating(c.downField("colimetryTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForjpegTags.tryDecodeAccumulating(c.downField("jpegTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForyCbCrTags.tryDecodeAccumulating(c.downField("yCbCrTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFornonStandardizedTags.tryDecodeAccumulating(c.downField("nonStandardizedTags")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFortiffType.tryDecodeAccumulating(c.downField("tiffType")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForoverviews.tryDecodeAccumulating(c.downField("overviews")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                            }
                            {
                                this.circeGenericDecoderFormetadataTags = MetadataTags$.MODULE$.metadataTagsDecoder();
                                this.circeGenericDecoderForbasicTags = BasicTags$.MODULE$.basicTagsDecoder();
                                this.circeGenericDecoderFornonBasicTags = NonBasicTags$.MODULE$.nonBasicTagsDecoder();
                                this.circeGenericDecoderForgeoTiffTags = GeoTiffTags$.MODULE$.geotiffTagsDecoder();
                                this.circeGenericDecoderFordocumentationTags = DocumentationTags$.MODULE$.documentationTagsDecoder();
                                this.circeGenericDecoderFortileTags = TileTags$.MODULE$.tileTagsDecoder();
                                this.circeGenericDecoderForcmykTags = CmykTags$.MODULE$.cmykTagsDecoder();
                                this.circeGenericDecoderFordataSampleFormatTags = DataSampleFormatTags$.MODULE$.dataSampleFormatTagsDecoder();
                                this.circeGenericDecoderForcolimetryTags = ColimetryTags$.MODULE$.colimetryTagsDecoder();
                                this.circeGenericDecoderForjpegTags = JpegTags$.MODULE$.jpegTagsDecoder();
                                this.circeGenericDecoderForyCbCrTags = YCbCrTags$.MODULE$.ycbcrTagsDecoder();
                                this.circeGenericDecoderFornonStandardizedTags = NonStandardizedTags$.MODULE$.nonStandardizedTagsDecoder();
                                this.circeGenericDecoderFortiffType = TiffType$.MODULE$.tiffTypeDecoder();
                                this.circeGenericDecoderForoverviews = Decoder$.MODULE$.decodeList(TiffTags$.MODULE$.tiffTagsDecoder());
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$80;
            }

            public ReprDecoder<.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>>> inst$macro$80() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$80$lzycompute() : this.inst$macro$80;
            }

            private DerivedDecoder<TiffTags> inst$macro$49$lzycompute() {
                Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        public final class Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1$anon$macro$79$1
                        implements Generic<TiffTags> {
                            public .colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>> to(TiffTags p) {
                                TiffTags tiffTags = p;
                                if (tiffTags == null) {
                                    throw new MatchError((Object)tiffTags);
                                }
                                MetadataTags pat$macro$65 = tiffTags.metadataTags();
                                BasicTags pat$macro$66 = tiffTags.basicTags();
                                NonBasicTags pat$macro$67 = tiffTags.nonBasicTags();
                                GeoTiffTags pat$macro$68 = tiffTags.geoTiffTags();
                                DocumentationTags pat$macro$69 = tiffTags.documentationTags();
                                TileTags pat$macro$70 = tiffTags.tileTags();
                                CmykTags pat$macro$71 = tiffTags.cmykTags();
                                DataSampleFormatTags pat$macro$72 = tiffTags.dataSampleFormatTags();
                                ColimetryTags pat$macro$73 = tiffTags.colimetryTags();
                                JpegTags pat$macro$74 = tiffTags.jpegTags();
                                YCbCrTags pat$macro$75 = tiffTags.yCbCrTags();
                                NonStandardizedTags pat$macro$76 = tiffTags.nonStandardizedTags();
                                TiffType pat$macro$77 = tiffTags.tiffType();
                                List<TiffTags> pat$macro$78 = tiffTags.overviews();
                                .colon.colon colon2 = new .colon.colon((Object)pat$macro$65, (HList)new .colon.colon((Object)pat$macro$66, (HList)new .colon.colon((Object)pat$macro$67, (HList)new .colon.colon((Object)pat$macro$68, (HList)new .colon.colon((Object)pat$macro$69, (HList)new .colon.colon((Object)pat$macro$70, (HList)new .colon.colon((Object)pat$macro$71, (HList)new .colon.colon((Object)pat$macro$72, (HList)new .colon.colon((Object)pat$macro$73, (HList)new .colon.colon((Object)pat$macro$74, (HList)new .colon.colon((Object)pat$macro$75, (HList)new .colon.colon((Object)pat$macro$76, (HList)new .colon.colon((Object)pat$macro$77, (HList)new .colon.colon(pat$macro$78, (HList)HNil$.MODULE$))))))))))))));
                                return colon2;
                            }

                            public TiffTags from(.colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>> p) {
                                List pat$macro$78;
                                TiffType pat$macro$77;
                                NonStandardizedTags pat$macro$76;
                                YCbCrTags pat$macro$75;
                                JpegTags pat$macro$74;
                                ColimetryTags pat$macro$73;
                                DataSampleFormatTags pat$macro$72;
                                CmykTags pat$macro$71;
                                TileTags pat$macro$70;
                                DocumentationTags pat$macro$69;
                                GeoTiffTags pat$macro$68;
                                NonBasicTags pat$macro$67;
                                BasicTags pat$macro$66;
                                MetadataTags pat$macro$65;
                                block3: {
                                    .colon.colon<MetadataTags, .colon.colon<BasicTags, .colon.colon<NonBasicTags, .colon.colon<GeoTiffTags, .colon.colon<DocumentationTags, .colon.colon<TileTags, .colon.colon<CmykTags, .colon.colon<DataSampleFormatTags, .colon.colon<ColimetryTags, .colon.colon<JpegTags, .colon.colon<YCbCrTags, .colon.colon<NonStandardizedTags, .colon.colon<TiffType, .colon.colon<List<TiffTags>, HNil>>>>>>>>>>>>>> colon2;
                                    block2: {
                                        colon2 = p;
                                        if (colon2 == null) break block2;
                                        pat$macro$65 = (MetadataTags)colon2.head();
                                        .colon.colon colon3 = (.colon.colon)colon2.tail();
                                        if (colon3 == null) break block2;
                                        pat$macro$66 = (BasicTags)colon3.head();
                                        .colon.colon colon4 = (.colon.colon)colon3.tail();
                                        if (colon4 == null) break block2;
                                        pat$macro$67 = (NonBasicTags)colon4.head();
                                        .colon.colon colon5 = (.colon.colon)colon4.tail();
                                        if (colon5 == null) break block2;
                                        pat$macro$68 = (GeoTiffTags)colon5.head();
                                        .colon.colon colon6 = (.colon.colon)colon5.tail();
                                        if (colon6 == null) break block2;
                                        pat$macro$69 = (DocumentationTags)colon6.head();
                                        .colon.colon colon7 = (.colon.colon)colon6.tail();
                                        if (colon7 == null) break block2;
                                        pat$macro$70 = (TileTags)colon7.head();
                                        .colon.colon colon8 = (.colon.colon)colon7.tail();
                                        if (colon8 == null) break block2;
                                        pat$macro$71 = (CmykTags)colon8.head();
                                        .colon.colon colon9 = (.colon.colon)colon8.tail();
                                        if (colon9 == null) break block2;
                                        pat$macro$72 = (DataSampleFormatTags)colon9.head();
                                        .colon.colon colon10 = (.colon.colon)colon9.tail();
                                        if (colon10 == null) break block2;
                                        pat$macro$73 = (ColimetryTags)colon10.head();
                                        .colon.colon colon11 = (.colon.colon)colon10.tail();
                                        if (colon11 == null) break block2;
                                        pat$macro$74 = (JpegTags)colon11.head();
                                        .colon.colon colon12 = (.colon.colon)colon11.tail();
                                        if (colon12 == null) break block2;
                                        pat$macro$75 = (YCbCrTags)colon12.head();
                                        .colon.colon colon13 = (.colon.colon)colon12.tail();
                                        if (colon13 == null) break block2;
                                        pat$macro$76 = (NonStandardizedTags)colon13.head();
                                        .colon.colon colon14 = (.colon.colon)colon13.tail();
                                        if (colon14 == null) break block2;
                                        pat$macro$77 = (TiffType)colon14.head();
                                        .colon.colon colon15 = (.colon.colon)colon14.tail();
                                        if (colon15 == null) break block2;
                                        pat$macro$78 = (List)colon15.head();
                                        HNil hNil = (HNil)colon15.tail();
                                        if (HNil$.MODULE$.equals(hNil)) break block3;
                                    }
                                    throw new MatchError(colon2);
                                }
                                TiffTags tiffTags = new TiffTags(pat$macro$65, pat$macro$66, pat$macro$67, pat$macro$68, pat$macro$69, pat$macro$70, pat$macro$71, pat$macro$72, pat$macro$73, pat$macro$74, pat$macro$75, pat$macro$76, pat$macro$77, (List<TiffTags>)pat$macro$78);
                                return tiffTags;
                            }

                            public Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1$anon$macro$79$1(Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1 $outer) {
                            }
                        }
                        this.inst$macro$49 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<TiffTags>(null){

                            public .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, HNil>>>>>>>>>>>>>> apply() {
                                return new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "metadataTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "basicTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "nonBasicTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "geoTiffTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "documentationTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "tileTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "cmykTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "dataSampleFormatTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "colimetryTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "jpegTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "yCbCrTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "nonStandardizedTags"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "tiffType"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "overviews"), (HList)HNil$.MODULE$))))))))))))));
                            }
                        }, (Generic)new Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1$anon$macro$79$1(null), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "overviews"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "tiffType"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "nonStandardizedTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "yCbCrTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "jpegTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "colimetryTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "dataSampleFormatTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "cmykTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "tileTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "documentationTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "geoTiffTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "nonBasicTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "basicTags"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "metadataTags"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$80()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$49;
            }

            public DerivedDecoder<TiffTags> inst$macro$49() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$49$lzycompute() : this.inst$macro$49;
            }

            public Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$49$1(geotrellis.raster.io.geotiff.tags.TiffTags$anon$lazy$macro$81$1 )}, serializedLambda);
            }
        }
        DerivedDecoder<TiffTags> inst$macro$82 = new Geotrellis_raster_io_geotiff_tags_TiffTags$anon$lazy$macro$81$1().inst$macro$49();
        this.tiffTagsDecoder = semiauto$.MODULE$.deriveDecoder(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$82));
    }
}

