/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.writer;

import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.Tiff$;
import geotrellis.raster.io.geotiff.writer.BigEndianToBytes$;
import geotrellis.raster.io.geotiff.writer.LittleEndianToBytes$;
import geotrellis.raster.io.geotiff.writer.TiffTagFieldValue;
import geotrellis.raster.io.geotiff.writer.TiffTagFieldValue$;
import geotrellis.raster.io.geotiff.writer.ToBytes;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015u!\u0002\u0010 \u0011\u0003Qc!\u0002\u0017 \u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002\u001c\u0002\t\u00039\u0004\"\u0002\u001c\u0002\t\u0003q\u0005\"\u0002\u001c\u0002\t\u00031\u0006\"\u0002\u001c\u0002\t\u0003qf\u0001\u0002\u0017 \u0001\u0005D\u0001\u0002P\u0004\u0003\u0002\u0003\u0006I!\u0010\u0005\tE\u001e\u0011\t\u0011)A\u0005G\")Ag\u0002C\u0001U\"9an\u0002b\u0001\n\u0007y\u0007BB:\bA\u0003%\u0001\u000f\u0003\u0005u\u000f!\u0015\r\u0011\"\u0001v\u0011!yx\u00011A\u0005\u0002\u0005\u0005\u0001\"CA\u0005\u000f\u0001\u0007I\u0011AA\u0006\u0011!\t\tb\u0002Q!\n\u0005\r\u0001bBA\n\u000f\u0011\u0005\u0011Q\u0003\u0005\b\u000379A\u0011AA\u000f\u0011\u001d\t\tc\u0002C\u0001\u0003GAq!a\n\b\t\u0003\tI\u0003C\u0004\u0002.\u001d!\t!a\f\t\u000f\u0005er\u0001\"\u0001\u0002<!9\u0011QI\u0004\u0005\u0002\u0005\u001d\u0003bBA)\u000f\u0011%\u00111\u000b\u0005\b\u0003#:A\u0011BA-\u0011%\t\tgBI\u0001\n\u0013\t\u0019\u0007C\u0004\u0002z\u001d!I!a\u001f\t\rY:A\u0011AA@\u0011%\t\u0019iBI\u0001\n\u0003\t\u0019'A\u0007HK>$\u0016N\u001a4Xe&$XM\u001d\u0006\u0003A\u0005\naa\u001e:ji\u0016\u0014(B\u0001\u0012$\u0003\u001d9Wm\u001c;jM\u001aT!\u0001J\u0013\u0002\u0005%|'B\u0001\u0014(\u0003\u0019\u0011\u0018m\u001d;fe*\t\u0001&\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001\u0001\u0005\u0002,\u00035\tqDA\u0007HK>$\u0016N\u001a4Xe&$XM]\n\u0003\u00039\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001+\u0003\u00159(/\u001b;f)\rA4(\u0011\t\u0003_eJ!A\u000f\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006y\r\u0001\r!P\u0001\bO\u0016|G+\u001b4g!\tqt(D\u0001\"\u0013\t\u0001\u0015EA\u0006HK>$\u0016N\u001a4ECR\f\u0007\"\u0002\"\u0004\u0001\u0004\u0019\u0015\u0001\u00029bi\"\u0004\"\u0001R&\u000f\u0005\u0015K\u0005C\u0001$1\u001b\u00059%B\u0001%*\u0003\u0019a$o\\8u}%\u0011!\nM\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002KaQ!\u0001h\u0014)R\u0011\u0015aD\u00011\u0001>\u0011\u0015\u0011E\u00011\u0001D\u0011\u0015\u0011F\u00011\u0001T\u00039y\u0007\u000f^5nSj,Gm\u0014:eKJ\u0004\"a\f+\n\u0005U\u0003$a\u0002\"p_2,\u0017M\u001c\u000b\u0003/v\u00032a\f-[\u0013\tI\u0006GA\u0003BeJ\f\u0017\u0010\u0005\u000207&\u0011A\f\r\u0002\u0005\u0005f$X\rC\u0003=\u000b\u0001\u0007Q\bF\u0002X?\u0002DQ\u0001\u0010\u0004A\u0002uBQA\u0015\u0004A\u0002M\u001b\"a\u0002\u0018\u0002\u0007\u0011|7\u000f\u0005\u0002eQ6\tQM\u0003\u0002%M*\tq-\u0001\u0003kCZ\f\u0017BA5f\u0005A!\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000eF\u0002lY6\u0004\"aK\u0004\t\u000bqR\u0001\u0019A\u001f\t\u000b\tT\u0001\u0019A2\u0002\u000fQ|')\u001f;fgV\t\u0001\u000f\u0005\u0002,c&\u0011!o\b\u0002\b)>\u0014\u0015\u0010^3t\u0003!!xNQ=uKN\u0004\u0013\u0001B%G\tN,\u0012A\u001e\t\u0004orldB\u0001={\u001d\t1\u00150C\u00012\u0013\tY\b'A\u0004qC\u000e\\\u0017mZ3\n\u0005ut(\u0001\u0002'jgRT!a\u001f\u0019\u0002\u000b%tG-\u001a=\u0016\u0005\u0005\r\u0001cA\u0018\u0002\u0006%\u0019\u0011q\u0001\u0019\u0003\u0007%sG/A\u0005j]\u0012,\u0007p\u0018\u0013fcR\u0019\u0001(!\u0004\t\u0013\u0005=q\"!AA\u0002\u0005\r\u0011a\u0001=%c\u00051\u0011N\u001c3fq\u0002\n\u0011b\u001e:ji\u0016\u0014\u0015\u0010^3\u0015\u0007a\n9\u0002\u0003\u0004\u0002\u001aE\u0001\rAW\u0001\u0006m\u0006dW/Z\u0001\u000boJLG/\u001a\"zi\u0016\u001cHc\u0001\u001d\u0002 !1\u0011\u0011\u0004\nA\u0002]\u000b!b\u001e:ji\u0016\u001c\u0006n\u001c:u)\rA\u0014Q\u0005\u0005\b\u00033\u0019\u0002\u0019AA\u0002\u0003!9(/\u001b;f\u0013:$Hc\u0001\u001d\u0002,!9\u0011\u0011\u0004\u000bA\u0002\u0005\r\u0011!C<sSR,Gj\u001c8h)\rA\u0014\u0011\u0007\u0005\b\u00033)\u0002\u0019AA\u001a!\ry\u0013QG\u0005\u0004\u0003o\u0001$\u0001\u0002'p]\u001e\f!b\u001e:ji\u00164En\\1u)\rA\u0014Q\b\u0005\b\u000331\u0002\u0019AA !\ry\u0013\u0011I\u0005\u0004\u0003\u0007\u0002$!\u0002$m_\u0006$\u0018aC<sSR,Gi\\;cY\u0016$2\u0001OA%\u0011\u001d\tIb\u0006a\u0001\u0003\u0017\u00022aLA'\u0013\r\ty\u0005\r\u0002\u0007\t>,(\r\\3\u0002\r\u0005\u0004\b/\u001a8e)\rA\u0014Q\u000b\u0005\u0007\u0003/B\u0002\u0019\u0001<\u0002\t1L7\u000f\u001e\u000b\u0006q\u0005m\u0013Q\f\u0005\u0006ye\u0001\r!\u0010\u0005\t\u0003?J\u0002\u0013!a\u0001'\u0006!A.Y:u\u0003A\t\u0007\u000f]3oI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002f)\u001a1+a\u001a,\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001d1\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\niGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA#\u00199qK:$7\t\\8vI>\u0003H/[7ju\u0016$Gc\u0001\u001d\u0002~!1\u0011qK\u000eA\u0002Y$2\u0001OAA\u0011\u001d\u0011F\u0004%AA\u0002M\u000bqb\u001e:ji\u0016$C-\u001a4bk2$H%\r")
public class GeoTiffWriter {
    private List<GeoTiffData> IFDs;
    private final GeoTiffData geoTiff;
    private final DataOutputStream dos;
    private final ToBytes toBytes;
    private int index;
    private volatile boolean bitmap$0;

    public ToBytes toBytes() {
        return this.toBytes;
    }

    private List<GeoTiffData> IFDs$lzycompute() {
        GeoTiffWriter geoTiffWriter = this;
        synchronized (geoTiffWriter) {
            if (!this.bitmap$0) {
                GeoTiffData geoTiffData = this.geoTiff;
                this.IFDs = this.geoTiff.overviews().$colon$colon((Object)geoTiffData);
                this.bitmap$0 = true;
            }
        }
        return this.IFDs;
    }

    public List<GeoTiffData> IFDs() {
        return !this.bitmap$0 ? this.IFDs$lzycompute() : this.IFDs;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public void writeByte(byte value) {
        this.dos.writeByte(value);
        this.index_$eq(this.index() + 1);
    }

    public void writeBytes(byte[] value) {
        this.dos.write(value, 0, value.length);
        this.index_$eq(this.index() + value.length);
    }

    public void writeShort(int value) {
        this.writeBytes(this.toBytes().apply((short)value));
    }

    public void writeInt(int value) {
        this.writeBytes(this.toBytes().apply(value));
    }

    public void writeLong(long value) {
        this.writeBytes(this.toBytes().apply(value));
    }

    public void writeFloat(float value) {
        this.writeBytes(this.toBytes().apply(value));
    }

    public void writeDouble(double value) {
        this.writeBytes(this.toBytes().apply(value));
    }

    private void append(List<GeoTiffData> list) {
        GeoTiffData geoTiffData = this.geoTiff;
        Iterator overviewsIter = ((IterableLike)this.geoTiff.overviews().$plus$colon((Object)geoTiffData, List$.MODULE$.canBuildFrom())).toIterator();
        overviewsIter.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            this.append(x$3, !overviewsIter.hasNext());
            return BoxedUnit.UNIT;
        });
    }

    private void append(GeoTiffData geoTiff, boolean last) {
        int tagDataStartOffset;
        TiffTagFieldValue offsetFieldValue;
        Tuple2<TiffTagFieldValue[], Function1<int[], TiffTagFieldValue>> tuple2 = TiffTagFieldValue$.MODULE$.collect(geoTiff);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TiffTagFieldValue[] fieldValues = (TiffTagFieldValue[])tuple2._1();
        Function1 offsetFieldValueBuilder = (Function1)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fieldValues, (Object)offsetFieldValueBuilder);
        Tuple2 tuple23 = tuple22;
        TiffTagFieldValue[] fieldValues2 = (TiffTagFieldValue[])tuple23._1();
        Function1 offsetFieldValueBuilder2 = (Function1)tuple23._2();
        SegmentBytes segments = geoTiff.imageData().segmentBytes();
        int segmentCount = segments.size();
        int segmentBytesCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentCount).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> segments.getSegmentByteCount(i), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int tagFieldByteCount = (fieldValues2.length + 1) * 12;
        int s = 0;
        for (int index$macro$1 = 0; index$macro$1 < fieldValues2.length; ++index$macro$1) {
            int len = fieldValues2[index$macro$1].value().length;
            if (len <= 4) continue;
            s += fieldValues2[index$macro$1].value().length;
        }
        if (segmentCount > 1) {
            s += segmentCount * 4;
        }
        int tagDataByteCount = s;
        int imageDataStartOffset = this.index() + 2 + 4 + tagFieldByteCount + tagDataByteCount;
        int[] offsets = (int[])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.Int());
        IntRef offset = IntRef.create((int)imageDataStartOffset);
        segments.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentCount)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GeoTiffWriter.$anonfun$append$3(offsets, offset, x0$1);
            return BoxedUnit.UNIT;
        });
        TiffTagFieldValue tiffTagFieldValue = offsetFieldValue = (TiffTagFieldValue)offsetFieldValueBuilder2.apply((Object)offsets);
        TiffTagFieldValue[] sortedTagFieldValues = (TiffTagFieldValue[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldValues2)).toList().$colon$colon((Object)tiffTagFieldValue).sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.tag()), (Ordering)Ordering.Int$.MODULE$)).toArray(ClassTag$.MODULE$.apply(TiffTagFieldValue.class));
        this.writeShort(sortedTagFieldValues.length);
        int tagDataOffset = tagDataStartOffset = this.index() + 4 + tagFieldByteCount;
        for (int index$macro$2 = 0; index$macro$2 < sortedTagFieldValues.length; ++index$macro$2) {
            int i2;
            TiffTagFieldValue tiffTagFieldValue2 = sortedTagFieldValues[index$macro$2];
            if (tiffTagFieldValue2 == null) {
                throw new MatchError((Object)tiffTagFieldValue2);
            }
            int tag = tiffTagFieldValue2.tag();
            int fieldType = tiffTagFieldValue2.fieldType();
            int length = tiffTagFieldValue2.length();
            byte[] value = tiffTagFieldValue2.value();
            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)tag), (Object)BoxesRunTime.boxToInteger((int)fieldType), (Object)BoxesRunTime.boxToInteger((int)length), (Object)value);
            Tuple4 tuple42 = tuple4;
            int tag2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
            int fieldType2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
            int length2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
            byte[] value2 = (byte[])tuple42._4();
            this.writeShort(tag2);
            this.writeShort(fieldType2);
            this.writeInt(length2);
            if (value2.length > 4) {
                this.writeInt(tagDataOffset);
                tagDataOffset += value2.length;
                continue;
            }
            for (i2 = 0; i2 < value2.length; ++i2) {
                this.writeByte(value2[i2]);
            }
            while (i2 < 4) {
                this.writeByte((byte)0);
                ++i2;
            }
        }
        if (last) {
            this.writeInt(0);
        } else {
            this.writeInt(tagDataOffset + segmentBytesCount);
        }
        Predef$.MODULE$.assert(this.index() == tagDataStartOffset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Writer error: index at ").append(this.index()).append(", should be ").append(tagDataStartOffset).toString());
        Predef$.MODULE$.assert(tagDataOffset == tagDataStartOffset + tagDataByteCount);
        for (int index$macro$3 = 0; index$macro$3 < sortedTagFieldValues.length; ++index$macro$3) {
            TiffTagFieldValue tiffTagFieldValue3 = sortedTagFieldValues[index$macro$3];
            if (tiffTagFieldValue3 == null) {
                throw new MatchError((Object)tiffTagFieldValue3);
            }
            int tag = tiffTagFieldValue3.tag();
            int fieldType = tiffTagFieldValue3.fieldType();
            int length = tiffTagFieldValue3.length();
            byte[] value = tiffTagFieldValue3.value();
            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)tag), (Object)BoxesRunTime.boxToInteger((int)fieldType), (Object)BoxesRunTime.boxToInteger((int)length), (Object)value);
            Tuple4 tuple43 = tuple4;
            int n = BoxesRunTime.unboxToInt((Object)tuple43._1());
            int n2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
            int n3 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            byte[] value3 = (byte[])tuple43._4();
            if (value3.length <= 4) continue;
            this.writeBytes(value3);
        }
        segments.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentCount)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            GeoTiffWriter.$anonfun$append$6(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private boolean append$default$2() {
        return true;
    }

    private void appendCloudOptimized(List<GeoTiffData> list) {
        int ifdCount = list.length();
        List dataOffsets = (List)list.map((Function1 & Serializable & scala.Serializable)geoTiff -> {
            Tuple2<TiffTagFieldValue[], Function1<int[], TiffTagFieldValue>> tuple2 = TiffTagFieldValue$.MODULE$.collect((GeoTiffData)geoTiff);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TiffTagFieldValue[] fieldValues = (TiffTagFieldValue[])tuple2._1();
            Function1 offsetFieldValueBuilder = (Function1)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)fieldValues, (Object)offsetFieldValueBuilder);
            Tuple2 tuple23 = tuple22;
            TiffTagFieldValue[] fieldValues2 = (TiffTagFieldValue[])tuple23._1();
            Function1 offsetFieldValueBuilder2 = (Function1)tuple23._2();
            SegmentBytes segments = geoTiff.imageData().segmentBytes();
            int segmentCount = segments.size();
            int segmentBytesCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentCount).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> segments.getSegmentByteCount(i), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int tagFieldByteCount = (fieldValues2.length + 1) * 12;
            int s = 0;
            for (int index$macro$1 = 0; index$macro$1 < fieldValues2.length; ++index$macro$1) {
                int len = fieldValues2[index$macro$1].value().length;
                if (len <= 4) continue;
                s += fieldValues2[index$macro$1].value().length;
            }
            if (segmentCount > 1) {
                s += segmentCount * 4;
            }
            int tagDataByteCount = s;
            int imageDataStartOffset = 6 + tagFieldByteCount + tagDataByteCount;
            return new Tuple3((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fieldValues2), (Object)offsetFieldValueBuilder2), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tagFieldByteCount)), (Object)BoxesRunTime.boxToInteger((int)tagDataByteCount)), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)imageDataStartOffset)), (Object)BoxesRunTime.boxToInteger((int)segmentBytesCount)));
        }, List$.MODULE$.canBuildFrom());
        Tuple2[] imageData = new Tuple2[ifdCount];
        for (int index$macro$4 = 0; index$macro$4 < ifdCount; ++index$macro$4) {
            int tagDataStartOffset;
            TiffTagFieldValue offsetFieldValue;
            Tuple3 tuple3 = new Tuple3(list.apply(index$macro$4), dataOffsets.apply(index$macro$4), (Object)BoxesRunTime.boxToBoolean((index$macro$4 + 1 == ifdCount ? 1 : 0) != 0));
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            GeoTiffData geoTiff2 = (GeoTiffData)tuple3._1();
            Tuple3 value = (Tuple3)tuple3._2();
            boolean last = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)geoTiff2, (Object)value, (Object)BoxesRunTime.boxToBoolean((boolean)last));
            Tuple3 tuple33 = tuple32;
            GeoTiffData geoTiff3 = (GeoTiffData)tuple33._1();
            Tuple3 value2 = (Tuple3)tuple33._2();
            boolean last2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
            Tuple2 tuple2 = (Tuple2)value2._1();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TiffTagFieldValue[] fieldValues = (TiffTagFieldValue[])tuple2._1();
            Function1 offsetFieldValueBuilder = (Function1)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)fieldValues, (Object)offsetFieldValueBuilder);
            Tuple2 tuple23 = tuple22;
            TiffTagFieldValue[] fieldValues2 = (TiffTagFieldValue[])tuple23._1();
            Function1 offsetFieldValueBuilder2 = (Function1)tuple23._2();
            SegmentBytes segments = geoTiff3.imageData().segmentBytes();
            int segmentCount = segments.size();
            Tuple2 tuple24 = (Tuple2)value2._2();
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            int tagFieldByteCount = tuple24._1$mcI$sp();
            int tagDataByteCount = tuple24._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tagFieldByteCount, tagDataByteCount);
            Tuple2.mcII.sp sp3 = sp2;
            int tagFieldByteCount2 = sp3._1$mcI$sp();
            int tagDataByteCount2 = sp3._2$mcI$sp();
            int imageDataStartOffset = BoxesRunTime.unboxToInt((Object)dataOffsets.slice(index$macro$4 + 1, dataOffsets.length()).foldLeft((Object)BoxesRunTime.boxToInteger((int)this.index()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)GeoTiffWriter.$anonfun$appendCloudOptimized$3(BoxesRunTime.unboxToInt((Object)x0$1), x1$1)))) + ((Tuple2)value2._3())._1$mcI$sp();
            int[] offsets = (int[])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.Int());
            IntRef offset = IntRef.create((int)imageDataStartOffset);
            segments.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentCount)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                GeoTiffWriter.$anonfun$appendCloudOptimized$4(offsets, offset, x0$2);
                return BoxedUnit.UNIT;
            });
            TiffTagFieldValue tiffTagFieldValue = offsetFieldValue = (TiffTagFieldValue)offsetFieldValueBuilder2.apply((Object)offsets);
            TiffTagFieldValue[] sortedTagFieldValues = (TiffTagFieldValue[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldValues2)).toList().$colon$colon((Object)tiffTagFieldValue).sortBy((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24.tag()), (Ordering)Ordering.Int$.MODULE$)).toArray(ClassTag$.MODULE$.apply(TiffTagFieldValue.class));
            this.writeShort(sortedTagFieldValues.length);
            int tagDataOffset = tagDataStartOffset = this.index() + 4 + tagFieldByteCount2;
            for (int index$macro$2 = 0; index$macro$2 < sortedTagFieldValues.length; ++index$macro$2) {
                int i;
                TiffTagFieldValue tiffTagFieldValue2 = sortedTagFieldValues[index$macro$2];
                if (tiffTagFieldValue2 == null) {
                    throw new MatchError((Object)tiffTagFieldValue2);
                }
                int tag = tiffTagFieldValue2.tag();
                int fieldType = tiffTagFieldValue2.fieldType();
                int length = tiffTagFieldValue2.length();
                byte[] value3 = tiffTagFieldValue2.value();
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)tag), (Object)BoxesRunTime.boxToInteger((int)fieldType), (Object)BoxesRunTime.boxToInteger((int)length), (Object)value3);
                Tuple4 tuple42 = tuple4;
                int tag2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
                int fieldType2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
                int length2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
                byte[] value4 = (byte[])tuple42._4();
                this.writeShort(tag2);
                this.writeShort(fieldType2);
                this.writeInt(length2);
                if (value4.length > 4) {
                    this.writeInt(tagDataOffset);
                    tagDataOffset += value4.length;
                    continue;
                }
                for (i = 0; i < value4.length; ++i) {
                    this.writeByte(value4[i]);
                }
                while (i < 4) {
                    this.writeByte((byte)0);
                    ++i;
                }
            }
            if (last2) {
                this.writeInt(0);
            } else {
                this.writeInt(tagDataOffset);
            }
            Predef$.MODULE$.assert(this.index() == tagDataStartOffset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Writer error: index at ").append(this.index()).append(", should be ").append(tagDataStartOffset).toString());
            Predef$.MODULE$.assert(tagDataOffset == tagDataStartOffset + tagDataByteCount2);
            for (int index$macro$3 = 0; index$macro$3 < sortedTagFieldValues.length; ++index$macro$3) {
                TiffTagFieldValue tiffTagFieldValue3 = sortedTagFieldValues[index$macro$3];
                if (tiffTagFieldValue3 == null) {
                    throw new MatchError((Object)tiffTagFieldValue3);
                }
                int tag = tiffTagFieldValue3.tag();
                int fieldType = tiffTagFieldValue3.fieldType();
                int length = tiffTagFieldValue3.length();
                byte[] value5 = tiffTagFieldValue3.value();
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)tag), (Object)BoxesRunTime.boxToInteger((int)fieldType), (Object)BoxesRunTime.boxToInteger((int)length), (Object)value5);
                Tuple4 tuple43 = tuple4;
                int n = BoxesRunTime.unboxToInt((Object)tuple43._1());
                int n2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
                int n3 = BoxesRunTime.unboxToInt((Object)tuple43._3());
                byte[] value6 = (byte[])tuple43._4();
                if (value6.length <= 4) continue;
                this.writeBytes(value6);
            }
            imageData[ifdCount - index$macro$4 - 1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)segments), (Object)BoxesRunTime.boxToInteger((int)segmentCount));
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])imageData)).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            GeoTiffWriter.$anonfun$appendCloudOptimized$7(this, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public void write(boolean optimizedOrder) {
        ByteOrder byteOrder = this.geoTiff.imageData().decompressor().byteOrder();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null)) {
            byte m = (byte)77;
            this.writeByte(m);
            this.writeByte(m);
        } else {
            byte i = (byte)73;
            this.writeByte(i);
            this.writeByte(i);
        }
        this.writeShort((short)Tiff$.MODULE$.code());
        this.writeInt(this.index() + 4);
        if (optimizedOrder) {
            this.appendCloudOptimized(this.IFDs());
        } else {
            this.append(this.IFDs());
        }
        this.dos.flush();
    }

    public boolean write$default$1() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$append$3(int[] offsets$1, IntRef offset$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            byte[] segment = (byte[])tuple2._2();
            offsets$1[i] = offset$1.elem;
            offset$1.elem += segment.length;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$append$6(GeoTiffWriter $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] segment = (byte[])tuple2._2();
        $this.writeBytes(segment);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$appendCloudOptimized$3(int x0$1, Tuple3 x1$1) {
        Tuple2 tuple2;
        int n;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
                if (tuple22 == null) break block2;
                int acc = tuple22._1$mcI$sp();
                Tuple3 tuple3 = (Tuple3)tuple22._2();
                n = acc;
                if (tuple3 != null && (tuple2 = (Tuple2)tuple3._3()) != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int absStartOffset = tuple2._1$mcI$sp();
        int bytesCount = tuple2._2$mcI$sp();
        int n2 = absStartOffset;
        int n3 = bytesCount;
        int n4 = n + n2 + n3;
        return n4;
    }

    public static final /* synthetic */ void $anonfun$appendCloudOptimized$4(int[] offsets$2, IntRef offset$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            byte[] segment = (byte[])tuple2._2();
            offsets$2[i] = offset$2.elem;
            offset$2.elem += segment.length;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$appendCloudOptimized$8(GeoTiffWriter $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] segment = (byte[])tuple2._2();
        $this.writeBytes(segment);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$appendCloudOptimized$7(GeoTiffWriter $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SegmentBytes segments = (SegmentBytes)tuple2._1();
        int segmentCount = tuple2._2$mcI$sp();
        segments.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentCount)).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            GeoTiffWriter.$anonfun$appendCloudOptimized$8($this, x0$4);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public GeoTiffWriter(GeoTiffData geoTiff, DataOutputStream dos) {
        this.geoTiff = geoTiff;
        this.dos = dos;
        ByteOrder byteOrder = geoTiff.imageData().decompressor().byteOrder();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        this.toBytes = !(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null) ? BigEndianToBytes$.MODULE$ : LittleEndianToBytes$.MODULE$;
        this.index = 0;
    }
}

