/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.ArrayTileResult;
import geotrellis.raster.mapalgebra.focal.CellwiseCalculation;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import scala.Function4;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A\u0001E\t\u00015!Ia\u0005\u0001B\u0001B\u0003%qd\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u0005<\u0001\t\u0005\t\u0015!\u0003=\u007f!)\u0001\t\u0001C\u0001\u0003\"9q\t\u0001a\u0001\n\u0003A\u0005bB%\u0001\u0001\u0004%\tA\u0013\u0005\u0007!\u0002\u0001\u000b\u0015\u0002\u001d\t\u000fE\u0003\u0001\u0019!C\u0001%\"9a\u000b\u0001a\u0001\n\u00039\u0006BB-\u0001A\u0003&1\u000bC\u0003[\u0001\u0011\u00051\fC\u0003b\u0001\u0011\u0005!\rC\u0003g\u0001\u0011\u0005q\rC\u0003i\u0001\u0011\u0005\u0011NA\u000bDK2dw/[:f\t>,(\r\\3Tk6\u001c\u0015\r\\2\u000b\u0005I\u0019\u0012!\u00024pG\u0006d'B\u0001\u000b\u0016\u0003)i\u0017\r]1mO\u0016\u0014'/\u0019\u0006\u0003-]\taA]1ti\u0016\u0014(\"\u0001\r\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0007\u0001Y2\u0005E\u0002\u001d;}i\u0011!E\u0005\u0003=E\u00111cQ3mY^L7/Z\"bY\u000e,H.\u0019;j_:\u0004\"\u0001I\u0011\u000e\u0003UI!AI\u000b\u0003\tQKG.\u001a\t\u00039\u0011J!!J\t\u0003\u001f\u0005\u0013(/Y=US2,'+Z:vYR\f\u0011A]\u0005\u0003M!J!!K\t\u0003!\u0019{7-\u00197DC2\u001cW\u000f\\1uS>t\u0017!\u00018\u0011\u0005qa\u0013BA\u0017\u0012\u00051qU-[4iE>\u0014\bn\\8e\u0003\u0019\u0011w.\u001e8egB\u0019\u0001gM\u001b\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012aa\u00149uS>t\u0007c\u0001\u00117q%\u0011q'\u0006\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\bC\u0001\u0019:\u0013\tQ\u0014GA\u0002J]R\fa\u0001^1sO\u0016$\bC\u0001\u000f>\u0013\tq\u0014C\u0001\u0006UCJ<W\r^\"fY2L!a\u000f\u0015\u0002\rqJg.\u001b;?)\u0015\u00115\tR#G!\ta\u0002\u0001C\u0003'\u000b\u0001\u0007q\u0004C\u0003+\u000b\u0001\u00071\u0006C\u0003/\u000b\u0001\u0007q\u0006C\u0003<\u000b\u0001\u0007A(A\u0003d_VtG/F\u00019\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011\u0001\u0007T\u0005\u0003\u001bF\u0012A!\u00168ji\"9qjBA\u0001\u0002\u0004A\u0014a\u0001=%c\u000511m\\;oi\u0002\nQ\u0001^8uC2,\u0012a\u0015\t\u0003aQK!!V\u0019\u0003\r\u0011{WO\u00197f\u0003%!x\u000e^1m?\u0012*\u0017\u000f\u0006\u0002L1\"9qJCA\u0001\u0002\u0004\u0019\u0016A\u0002;pi\u0006d\u0007%A\u0002bI\u0012$Ba\u0013/^?\")a\u0005\u0004a\u0001?!)a\f\u0004a\u0001q\u0005\t\u0001\u0010C\u0003a\u0019\u0001\u0007\u0001(A\u0001z\u0003\u0019\u0011X-\\8wKR!1j\u00193f\u0011\u00151S\u00021\u0001 \u0011\u0015qV\u00021\u00019\u0011\u0015\u0001W\u00021\u00019\u0003\u0015\u0011Xm]3u)\u0005Y\u0015\u0001C:fiZ\u000bG.^3\u0015\u0007-S7\u000eC\u0003_\u001f\u0001\u0007\u0001\bC\u0003a\u001f\u0001\u0007\u0001\b")
public class CellwiseDoubleSumCalc
extends CellwiseCalculation<Tile>
implements ArrayTileResult {
    private int count;
    private double total;
    private final int cols;
    private final int rows;
    private final MutableArrayTile resultTile;
    private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

    @Override
    public DataType resultCellType() {
        return ArrayTileResult.resultCellType$(this);
    }

    @Override
    public MutableArrayTile result() {
        return ArrayTileResult.result$(this);
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public MutableArrayTile resultTile() {
        return this.resultTile;
    }

    @Override
    public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
        return this.copyOriginalValue;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$cols_$eq(int x$1) {
        this.cols = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$rows_$eq(int x$1) {
        this.rows = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$resultTile_$eq(MutableArrayTile x$1) {
        this.resultTile = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
        this.copyOriginalValue = x$1;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public double total() {
        return this.total;
    }

    public void total_$eq(double x$1) {
        this.total = x$1;
    }

    @Override
    public void add(Tile r, int x, int y) {
        block2: {
            double v = r.getDouble(x, y);
            if (Double.isNaN(v)) break block2;
            if (!Double.isNaN(this.total())) {
                this.total_$eq(this.total() + v);
                this.count_$eq(this.count() + 1);
            } else {
                this.total_$eq(v);
                this.count_$eq(1);
            }
        }
    }

    @Override
    public void remove(Tile r, int x, int y) {
        block2: {
            double v = r.getDouble(x, y);
            if (Double.isNaN(v)) break block2;
            this.count_$eq(this.count() - 1);
            if (this.count() == 0) {
                this.total_$eq(Double.NaN);
            } else {
                this.total_$eq(this.total() - v);
            }
        }
    }

    @Override
    public void reset() {
        this.total_$eq(Double.NaN);
    }

    @Override
    public void setValue(int x, int y) {
        this.resultTile().setDouble(x, y, this.total());
    }

    public CellwiseDoubleSumCalc(Tile r, Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
        super(r, n, bounds, target);
        ArrayTileResult.$init$(this);
        this.count = 0;
        this.total = Double.NaN;
    }
}

