/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.GridBounds;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.Movement$;
import geotrellis.raster.mapalgebra.focal.ScanLineTraversalStrategy$;
import geotrellis.raster.mapalgebra.focal.SpiralZagTraversalStrategy$;
import geotrellis.raster.mapalgebra.focal.TraversalStrategy;
import geotrellis.raster.mapalgebra.focal.TraversalStrategy$;
import geotrellis.raster.mapalgebra.focal.ZigZagTraversalStrategy$;
import scala.Function0;
import scala.MatchError;
import scala.runtime.BoxedUnit;

public final class CursorStrategy$ {
    public static CursorStrategy$ MODULE$;

    static {
        new CursorStrategy$();
    }

    public <C extends Cursor> void execute(Cursor cursor, Function0<BoxedUnit> calc, GridBounds<Object> analysisArea) {
        this.execute(cursor, calc, analysisArea, TraversalStrategy$.MODULE$.DEFAULT());
    }

    public void execute(Cursor cursor, Function0<BoxedUnit> calc, GridBounds<Object> analysisArea, TraversalStrategy traversalStrategy) {
        TraversalStrategy traversalStrategy2 = traversalStrategy;
        if (ZigZagTraversalStrategy$.MODULE$.equals(traversalStrategy2)) {
            this.handleZigZag(analysisArea, cursor, calc);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ScanLineTraversalStrategy$.MODULE$.equals(traversalStrategy2)) {
            this.handleScanLine(analysisArea, cursor, calc);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SpiralZagTraversalStrategy$.MODULE$.equals(traversalStrategy2)) {
            this.handleSpiralZag(analysisArea, cursor, calc);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)traversalStrategy2);
        }
    }

    private void handleSpiralZag(GridBounds<Object> analysisArea, Cursor cursor, Function0<BoxedUnit> calc) {
        int colMax = analysisArea.colMax$mcI$sp();
        int rowMax = analysisArea.rowMax$mcI$sp();
        int colMin = analysisArea.colMin$mcI$sp();
        int rowMin = analysisArea.rowMin$mcI$sp();
        int col = colMin;
        int row = rowMin;
        boolean bl = true;
        boolean bl2 = true;
        boolean done = false;
        boolean zagTime = false;
        cursor.centerOn(col, row);
        while (!done && !zagTime) {
            while (col < colMax) {
                calc.apply$mcV$sp();
                cursor.move(Movement$.MODULE$.Right());
                ++col;
            }
            while (row < rowMax) {
                calc.apply$mcV$sp();
                cursor.move(Movement$.MODULE$.Down());
                ++row;
            }
            while (col > colMin) {
                calc.apply$mcV$sp();
                cursor.move(Movement$.MODULE$.Left());
                --col;
            }
            while (row > rowMin + 1) {
                calc.apply$mcV$sp();
                cursor.move(Movement$.MODULE$.Up());
                --row;
            }
            calc.apply$mcV$sp();
            if (++rowMin == --rowMax || ++colMin == --colMax) {
                done = true;
                continue;
            }
            cursor.move(Movement$.MODULE$.Right());
            if (++col - cursor.extent() < 0) continue;
            zagTime = true;
        }
        int direction = 1;
        while (row <= rowMax) {
            calc.apply$mcV$sp();
            if ((col += direction) < colMin || colMax < col) {
                ++row;
                col += (direction *= -1);
                cursor.move(Movement$.MODULE$.Down());
                continue;
            }
            if (direction == 1) {
                cursor.move(Movement$.MODULE$.Right());
                continue;
            }
            cursor.move(Movement$.MODULE$.Left());
        }
    }

    private void handleZigZag(GridBounds<Object> analysisArea, Cursor cursor, Function0<BoxedUnit> calc) {
        int colMax = analysisArea.colMax$mcI$sp();
        int rowMax = analysisArea.rowMax$mcI$sp();
        int colMin = analysisArea.colMin$mcI$sp();
        int rowMin = analysisArea.rowMin$mcI$sp();
        int col = colMin;
        int row = rowMin;
        int direction = 1;
        cursor.centerOn(col, row);
        while (row <= rowMax) {
            calc.apply$mcV$sp();
            if ((col += direction) < colMin || colMax < col) {
                ++row;
                col += (direction *= -1);
                cursor.move(Movement$.MODULE$.Down());
                continue;
            }
            if (direction == 1) {
                cursor.move(Movement$.MODULE$.Right());
                continue;
            }
            cursor.move(Movement$.MODULE$.Left());
        }
    }

    private void handleScanLine(GridBounds<Object> analysisArea, Cursor cursor, Function0<BoxedUnit> calc) {
        int colMax = analysisArea.colMax$mcI$sp();
        int rowMax = analysisArea.rowMax$mcI$sp();
        int colMin = analysisArea.colMin$mcI$sp();
        int rowMin = analysisArea.rowMin$mcI$sp();
        int col = colMin;
        int row = rowMin;
        cursor.centerOn(col, row);
        while (row <= rowMax) {
            calc.apply$mcV$sp();
            if (colMax < ++col) {
                col = colMin;
                cursor.centerOn(col, ++row);
                continue;
            }
            cursor.move(Movement$.MODULE$.Right());
        }
    }

    private CursorStrategy$() {
        MODULE$ = this;
    }
}

