/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.local;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Dimensions;
import geotrellis.raster.Grid;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.local.MaxN;
import geotrellis.raster.mapalgebra.local.MaxN$ArrayView$;
import geotrellis.raster.package$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class MaxN$
implements scala.Serializable {
    public static MaxN$ MODULE$;

    static {
        new MaxN$();
    }

    public int findNthIntInPlace(MaxN.ArrayView<Object> arr, int n) {
        int n2;
        while (true) {
            if (n >= arr.size()) {
                n2 = Integer.MIN_VALUE;
                break;
            }
            int pivot = BoxesRunTime.unboxToInt((Object)arr.apply(Random$.MODULE$.nextInt(arr.size())));
            Tuple2<MaxN.ArrayView<Object>, MaxN.ArrayView<Object>> tuple2 = arr.partitionInPlace((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 > pivot);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MaxN.ArrayView left = (MaxN.ArrayView)tuple2._1();
            MaxN.ArrayView right = (MaxN.ArrayView)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
            Tuple2 tuple23 = tuple22;
            MaxN.ArrayView left2 = (MaxN.ArrayView)tuple23._1();
            MaxN.ArrayView right2 = (MaxN.ArrayView)tuple23._2();
            if (left2.size() == n) {
                n2 = pivot;
                break;
            }
            if (left2.isEmpty()) {
                Tuple2<MaxN.ArrayView<Object>, MaxN.ArrayView<Object>> tuple24 = arr.partitionInPlace((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 == pivot);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                MaxN.ArrayView left3 = (MaxN.ArrayView)tuple24._1();
                MaxN.ArrayView right3 = (MaxN.ArrayView)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)left3, (Object)right3);
                Tuple2 tuple26 = tuple25;
                MaxN.ArrayView left4 = (MaxN.ArrayView)tuple26._1();
                MaxN.ArrayView right4 = (MaxN.ArrayView)tuple26._2();
                if (left4.size() > n) {
                    n2 = pivot;
                    break;
                }
                n -= left4.size();
                arr = right4;
                continue;
            }
            if (left2.size() < n) {
                n -= left2.size();
                arr = right2;
                continue;
            }
            arr = left2;
        }
        return n2;
    }

    public double findNthDoubleInPlace(MaxN.ArrayView<Object> arr, int n) {
        double d;
        while (true) {
            if (n >= arr.size()) {
                d = Double.NaN;
                break;
            }
            double pivot = BoxesRunTime.unboxToDouble((Object)arr.apply(Random$.MODULE$.nextInt(arr.size())));
            Tuple2<MaxN.ArrayView<Object>, MaxN.ArrayView<Object>> tuple2 = arr.partitionInPlace((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 > pivot);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MaxN.ArrayView left = (MaxN.ArrayView)tuple2._1();
            MaxN.ArrayView right = (MaxN.ArrayView)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
            Tuple2 tuple23 = tuple22;
            MaxN.ArrayView left2 = (MaxN.ArrayView)tuple23._1();
            MaxN.ArrayView right2 = (MaxN.ArrayView)tuple23._2();
            if (left2.size() == n) {
                d = pivot;
                break;
            }
            if (left2.isEmpty()) {
                Tuple2<MaxN.ArrayView<Object>, MaxN.ArrayView<Object>> tuple24 = arr.partitionInPlace((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$7 -> x$7 == pivot);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                MaxN.ArrayView left3 = (MaxN.ArrayView)tuple24._1();
                MaxN.ArrayView right3 = (MaxN.ArrayView)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)left3, (Object)right3);
                Tuple2 tuple26 = tuple25;
                MaxN.ArrayView left4 = (MaxN.ArrayView)tuple26._1();
                MaxN.ArrayView right4 = (MaxN.ArrayView)tuple26._2();
                if (left4.size() > n) {
                    d = pivot;
                    break;
                }
                n -= left4.size();
                arr = right4;
                continue;
            }
            if (left2.size() < n) {
                n -= left2.size();
                arr = right2;
                continue;
            }
            arr = left2;
        }
        return d;
    }

    public Tile apply(int n, Seq<Tile> rs) {
        return this.apply(n, (Traversable<Tile>)rs, Predef.DummyImplicit$.MODULE$.dummyImplicit());
    }

    public Tile apply(int n, Traversable<Tile> rs, Predef.DummyImplicit d) {
        package$.MODULE$.TraversableTileExtensions(rs).assertEqualDimensions();
        int layerCount = rs.toSeq().length();
        if (layerCount < n) {
            throw scala.sys.package$.MODULE$.error("Not enough values to compute Nth");
        }
        DataType newCellType = (DataType)((TraversableOnce)rs.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.cellType(), Traversable$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$10, x$11) -> x$10.union((DataType)x$11));
        Dimensions dimensions = ((Grid)rs.head()).dimensions();
        if (dimensions == null) {
            throw new MatchError(dimensions);
        }
        int cols = dimensions.cols$mcI$sp();
        int rows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(newCellType, cols2, rows2);
        IntRef index$macro$2 = IntRef.create((int)0);
        while (index$macro$2.elem < rows2) {
            IntRef index$macro$1 = IntRef.create((int)0);
            while (index$macro$1.elem < cols2) {
                if (newCellType.isFloatingPoint()) {
                    double maxN = this.findNthDoubleInPlace(MaxN$ArrayView$.MODULE$.apply((double[])((TraversableOnce)((TraversableLike)rs.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToDouble((double)r.getDouble(index$macro$1.elem, index$macro$2.elem)), Traversable$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)num -> !Double.isNaN(num))).toArray(ClassTag$.MODULE$.Double())), n);
                    tile.setDouble(index$macro$1.elem, index$macro$2.elem, maxN);
                } else {
                    int maxN = this.findNthIntInPlace(MaxN$ArrayView$.MODULE$.apply((int[])((TraversableOnce)((TraversableLike)rs.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)r.get(index$macro$1.elem, index$macro$2.elem)), Traversable$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)num -> num != Integer.MIN_VALUE)).toArray(ClassTag$.MODULE$.Int())), n);
                    tile.set(index$macro$1.elem, index$macro$2.elem, maxN);
                }
                ++index$macro$1.elem;
            }
            ++index$macro$2.elem;
        }
        return tile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MaxN$() {
        MODULE$ = this;
    }
}

