/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.merge;

import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.CellSize$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.package$;
import geotrellis.raster.resample.Resample;
import geotrellis.raster.resample.Resample$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.vector.Extent;
import java.io.Serializable;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001y2q\u0001B\u0003\u0011\u0002\u0007\u0005A\u0002C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003\u0007\u0001\u0011\u0005\u0001\u0005C\u0003\u0007\u0001\u0011\u0005!F\u0001\u000eTS:<G.\u001a2b]\u0012$\u0016\u000e\\3NKJ<W-T3uQ>$7O\u0003\u0002\u0007\u000f\u0005)Q.\u001a:hK*\u0011\u0001\"C\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003)\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0019A#F\f\u000e\u0003\u0015I!AF\u0003\u0003!QKG.Z'fe\u001e,W*\u001a;i_\u0012\u001c\bC\u0001\r\u001a\u001b\u00059\u0011B\u0001\u000e\b\u0005\u0011!\u0016\u000e\\3\u0002\r\u0011Jg.\u001b;%)\u0005i\u0002C\u0001\b\u001f\u0013\tyrB\u0001\u0003V]&$H\u0003B\f\"G!BQA\t\u0002A\u0002]\tQa\u001c;iKJDQ\u0001\n\u0002A\u0002\u0015\nqAY1tK\u000e{G\u000e\u0005\u0002\u000fM%\u0011qe\u0004\u0002\u0004\u0013:$\b\"B\u0015\u0003\u0001\u0004)\u0013a\u00022bg\u0016\u0014vn\u001e\u000b\u0006/-\u001aTG\u000e\u0005\u0006Y\r\u0001\r!L\u0001\u0007Kb$XM\u001c;\u0011\u00059\nT\"A\u0018\u000b\u0005AJ\u0011A\u0002<fGR|'/\u0003\u00023_\t1Q\t\u001f;f]RDQ\u0001N\u0002A\u00025\n1b\u001c;iKJ,\u0005\u0010^3oi\")!e\u0001a\u0001/!)qg\u0001a\u0001q\u00051Q.\u001a;i_\u0012\u0004\"!\u000f\u001f\u000e\u0003iR!aO\u0004\u0002\u0011I,7/Y7qY\u0016L!!\u0010\u001e\u0003\u001dI+7/Y7qY\u0016lU\r\u001e5pI\u0002")
public interface SinglebandTileMergeMethods
extends TileMergeMethods<Tile> {
    public static /* synthetic */ Tile merge$(SinglebandTileMergeMethods $this, Tile other, int baseCol, int baseRow) {
        return $this.merge(other, baseCol, baseRow);
    }

    @Override
    default public Tile merge(Tile other, int baseCol, int baseRow) {
        MutableArrayTile mutableTile = ((Tile)this.self()).mutable();
        package$.MODULE$.TraversableTileExtensions((Traversable<Tile>)((Traversable)new .colon.colon((Object)((Tile)this.self()), (List)new .colon.colon((Object)other, (List)Nil$.MODULE$)))).assertEqualDimensions();
        DataType dataType = ((CellGrid)this.self()).cellType();
        if (BitCellType$.MODULE$.equals(dataType)) {
            for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(other.rows()); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(other.cols()); ++index$macro$1) {
                    if (other.get(index$macro$1, index$macro$2) != 1) continue;
                    mutableTile.set(index$macro$1 + baseCol, index$macro$2 + baseRow, 1);
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : IntCellType$.MODULE$.equals(dataType))));
            if (bl) {
                for (int index$macro$4 = 0; index$macro$4 < BoxesRunTime.unboxToInt(other.rows()); ++index$macro$4) {
                    for (int index$macro$3 = 0; index$macro$3 < BoxesRunTime.unboxToInt(other.cols()); ++index$macro$3) {
                        if (((Tile)this.self()).get(index$macro$3 + baseCol, index$macro$4 + baseRow) != 0) continue;
                        mutableTile.set(index$macro$3 + baseCol, index$macro$4 + baseRow, other.get(index$macro$3, index$macro$4));
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType);
                if (bl2) {
                    for (int index$macro$6 = 0; index$macro$6 < BoxesRunTime.unboxToInt(other.rows()); ++index$macro$6) {
                        for (int index$macro$5 = 0; index$macro$5 < BoxesRunTime.unboxToInt(other.cols()); ++index$macro$5) {
                            if (((Tile)this.self()).getDouble(index$macro$5 + baseCol, index$macro$6 + baseRow) != 0.0) continue;
                            mutableTile.setDouble(index$macro$5 + baseCol, index$macro$6 + baseRow, other.getDouble(index$macro$5, index$macro$6));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType.isFloatingPoint()) {
                    for (int index$macro$8 = 0; index$macro$8 < BoxesRunTime.unboxToInt(other.rows()); ++index$macro$8) {
                        for (int index$macro$7 = 0; index$macro$7 < BoxesRunTime.unboxToInt(other.cols()); ++index$macro$7) {
                            if (!Double.isNaN(((Tile)this.self()).getDouble(index$macro$7 + baseCol, index$macro$8 + baseRow))) continue;
                            mutableTile.setDouble(index$macro$7 + baseCol, index$macro$8 + baseRow, other.getDouble(index$macro$7, index$macro$8));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    for (int index$macro$10 = 0; index$macro$10 < BoxesRunTime.unboxToInt(other.rows()); ++index$macro$10) {
                        for (int index$macro$9 = 0; index$macro$9 < BoxesRunTime.unboxToInt(other.cols()); ++index$macro$9) {
                            if (((Tile)this.self()).get(index$macro$9 + baseCol, index$macro$10 + baseRow) != Integer.MIN_VALUE) continue;
                            mutableTile.set(index$macro$9 + baseCol, index$macro$10 + baseRow, other.get(index$macro$9, index$macro$10));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return mutableTile;
    }

    public static /* synthetic */ Tile merge$(SinglebandTileMergeMethods $this, Extent extent, Extent otherExtent, Tile other, ResampleMethod method) {
        return $this.merge(extent, otherExtent, other, method);
    }

    @Override
    default public Tile merge(Extent extent, Extent otherExtent, Tile other, ResampleMethod method) {
        Tile tile;
        Option option = otherExtent.$amp(extent);
        if (option instanceof Some) {
            Some some = (Some)option;
            Extent sharedExtent = (Extent)some.value();
            MutableArrayTile mutableTile = ((Tile)this.self()).mutable();
            RasterExtent re = RasterExtent$.MODULE$.apply(extent, BoxesRunTime.unboxToInt(((Grid)this.self()).cols()), BoxesRunTime.unboxToInt(((Grid)this.self()).rows()));
            GridBounds<Object> gridBounds = re.gridBoundsFor$mcI$sp(sharedExtent, re.gridBoundsFor$default$2());
            CellSize targetCS = CellSize$.MODULE$.apply(sharedExtent, gridBounds.width$mcI$sp(), gridBounds.height$mcI$sp());
            DataType dataType = ((CellGrid)this.self()).cellType();
            boolean bl = BitCellType$.MODULE$.equals(dataType) ? true : (ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : IntCellType$.MODULE$.equals(dataType)))));
            if (bl) {
                Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
                JFunction2.mcIDD.sp & Serializable & scala.Serializable interpolate = (JFunction2.mcIDD.sp & Serializable & scala.Serializable)(x, y) -> resample.resample(x, y);
                for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(((Grid)this.self()).rows()); ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(((Grid)this.self()).cols()); ++index$macro$1) {
                        if (((Tile)this.self()).get(index$macro$1, index$macro$2) != 0) continue;
                        Tuple2<Object, Object> tuple2 = re.gridToMap$mcI$sp(index$macro$1, index$macro$2);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        double x2 = tuple2._1$mcD$sp();
                        double y2 = tuple2._2$mcD$sp();
                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x2, y2);
                        Tuple2.mcDD.sp sp3 = sp2;
                        double x3 = sp3._1$mcD$sp();
                        double y3 = sp3._2$mcD$sp();
                        int v = interpolate.apply$mcIDD$sp(x3, y3);
                        if (v == Integer.MIN_VALUE) continue;
                        mutableTile.set(index$macro$1, index$macro$2, v);
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType);
                if (bl2) {
                    Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
                    JFunction2.mcDDD.sp & Serializable & scala.Serializable interpolate = (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> resample.resampleDouble(x, y);
                    for (int index$macro$4 = 0; index$macro$4 < BoxesRunTime.unboxToInt(((Grid)this.self()).rows()); ++index$macro$4) {
                        for (int index$macro$3 = 0; index$macro$3 < BoxesRunTime.unboxToInt(((Grid)this.self()).cols()); ++index$macro$3) {
                            if (((Tile)this.self()).getDouble(index$macro$3, index$macro$4) != 0.0) continue;
                            Tuple2<Object, Object> tuple2 = re.gridToMap$mcI$sp(index$macro$3, index$macro$4);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            double x4 = tuple2._1$mcD$sp();
                            double y4 = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(x4, y4);
                            Tuple2.mcDD.sp sp5 = sp4;
                            double x5 = sp5._1$mcD$sp();
                            double y5 = sp5._2$mcD$sp();
                            double v = interpolate.apply$mcDDD$sp(x5, y5);
                            if (Double.isNaN(v)) continue;
                            mutableTile.setDouble(index$macro$3, index$macro$4, v);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType.isFloatingPoint()) {
                    Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
                    JFunction2.mcDDD.sp & Serializable & scala.Serializable interpolate = (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> resample.resampleDouble(x, y);
                    for (int index$macro$6 = 0; index$macro$6 < BoxesRunTime.unboxToInt(((Grid)this.self()).rows()); ++index$macro$6) {
                        for (int index$macro$5 = 0; index$macro$5 < BoxesRunTime.unboxToInt(((Grid)this.self()).cols()); ++index$macro$5) {
                            if (!Double.isNaN(((Tile)this.self()).getDouble(index$macro$5, index$macro$6))) continue;
                            Tuple2<Object, Object> tuple2 = re.gridToMap$mcI$sp(index$macro$5, index$macro$6);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            double x6 = tuple2._1$mcD$sp();
                            double y6 = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(x6, y6);
                            Tuple2.mcDD.sp sp7 = sp6;
                            double x7 = sp7._1$mcD$sp();
                            double y7 = sp7._2$mcD$sp();
                            mutableTile.setDouble(index$macro$5, index$macro$6, interpolate.apply$mcDDD$sp(x7, y7));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
                    JFunction2.mcIDD.sp & Serializable & scala.Serializable interpolate = (JFunction2.mcIDD.sp & Serializable & scala.Serializable)(x, y) -> resample.resample(x, y);
                    for (int index$macro$8 = 0; index$macro$8 < BoxesRunTime.unboxToInt(((Grid)this.self()).rows()); ++index$macro$8) {
                        for (int index$macro$7 = 0; index$macro$7 < BoxesRunTime.unboxToInt(((Grid)this.self()).cols()); ++index$macro$7) {
                            if (((Tile)this.self()).get(index$macro$7, index$macro$8) != Integer.MIN_VALUE) continue;
                            Tuple2<Object, Object> tuple2 = re.gridToMap$mcI$sp(index$macro$7, index$macro$8);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            double x8 = tuple2._1$mcD$sp();
                            double y8 = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp8 = new Tuple2.mcDD.sp(x8, y8);
                            Tuple2.mcDD.sp sp9 = sp8;
                            double x9 = sp9._1$mcD$sp();
                            double y9 = sp9._2$mcD$sp();
                            mutableTile.set(index$macro$7, index$macro$8, interpolate.apply$mcIDD$sp(x9, y9));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            tile = mutableTile;
        } else {
            tile = (Tile)this.self();
        }
        return tile;
    }

    public static void $init$(SinglebandTileMergeMethods $this) {
    }
}

