/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.rasterize.polygon;

import geotrellis.raster.PixelIsArea$;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.package;
import geotrellis.raster.rasterize.polygon.PolygonRasterizer$;
import geotrellis.vector.Intersection$;
import geotrellis.vector.MultiPolygon$;
import geotrellis.vector.Point$;
import geotrellis.vector.Polygon$;
import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class FractionalRasterizer$ {
    public static FractionalRasterizer$ MODULE$;

    static {
        new FractionalRasterizer$();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple4<Object, Object, Object, Object>> polygonToEdges(Polygon poly, RasterExtent re) {
        void var3_3;
        ArrayBuffer arrayBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Coordinate[] coords = poly.getExteriorRing().getCoordinates();
        for (int index$macro$1 = 1; index$macro$1 < coords.length; ++index$macro$1) {
            Coordinate coord1 = coords[index$macro$1 - 1];
            Coordinate coord2 = coords[index$macro$1];
            double col1 = re.mapXToGridDouble(coord1.x);
            double row1 = re.mapYToGridDouble(coord1.y);
            double col2 = re.mapXToGridDouble(coord2.x);
            double row2 = re.mapYToGridDouble(coord2.y);
            Tuple4 segment = col1 < col2 ? new Tuple4((Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1), (Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2)) : new Tuple4((Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2), (Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1));
            arrayBuffer.$plus$eq((Object)segment);
        }
        for (int index$macro$3 = 0; index$macro$3 < poly.getNumInteriorRing(); ++index$macro$3) {
            Coordinate[] coords2 = poly.getInteriorRingN(index$macro$3).getCoordinates();
            for (int index$macro$2 = 1; index$macro$2 < coords2.length; ++index$macro$2) {
                Coordinate coord1 = coords2[index$macro$2 - 1];
                Coordinate coord2 = coords2[index$macro$2];
                double col1 = re.mapXToGridDouble(coord1.x);
                double row1 = re.mapYToGridDouble(coord1.y);
                double col2 = re.mapXToGridDouble(coord2.x);
                double row2 = re.mapYToGridDouble(coord2.y);
                Tuple4 segment = col1 < col2 ? new Tuple4((Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1), (Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2)) : new Tuple4((Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2), (Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1));
                arrayBuffer.$plus$eq((Object)segment);
            }
        }
        return var3_3;
    }

    private void renderEdge(Tuple4<Object, Object, Object, Object> edge, RasterExtent re, MultiPolygon poly, Set<Tuple2<Object, Object>> seen, package.FractionCallback cb) {
        Tuple4<Object, Object, Object, Object> tuple4 = edge;
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        double x0 = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double y0 = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double x1 = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double y1 = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)x0), (Object)BoxesRunTime.boxToDouble((double)y0), (Object)BoxesRunTime.boxToDouble((double)x1), (Object)BoxesRunTime.boxToDouble((double)y1));
        Tuple4 tuple43 = tuple42;
        double x02 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        double y02 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
        double x12 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double y12 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        double m = (y12 - y02) / (x12 - x02);
        int colMin = (int)package$.MODULE$.floor(package$.MODULE$.min(x02, x12));
        int rowMin = (int)package$.MODULE$.floor(package$.MODULE$.min(y02, y12));
        int colMax = (int)package$.MODULE$.ceil(package$.MODULE$.max(x02, x12));
        int rowMax = (int)package$.MODULE$.ceil(package$.MODULE$.max(y02, y12));
        double xmin = re.gridColToMap$mcI$sp(colMin) - re.cellwidth() / (double)2;
        double ymin = re.gridRowToMap$mcI$sp(rowMax) + re.cellheight() / (double)2;
        double xmax = re.gridColToMap$mcI$sp(colMax) - re.cellwidth() / (double)2;
        double ymax = re.gridRowToMap$mcI$sp(rowMin) + re.cellheight() / (double)2;
        Polygon envelope = Polygon$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Point[]{Point$.MODULE$.apply(xmin, ymin), Point$.MODULE$.apply(xmin, ymax), Point$.MODULE$.apply(xmax, ymax), Point$.MODULE$.apply(xmax, ymin), Point$.MODULE$.apply(xmin, ymin)}), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        Geometry localPoly = poly.intersection((Geometry)envelope);
        if (package$.MODULE$.abs(m) <= 1.0) {
            for (int x = colMin; x <= colMax; ++x) {
                int _y = (int)package$.MODULE$.floor(m * ((double)x + 0.5 - x02) + y02);
                for (int i = -1; i <= 1; ++i) {
                    double fraction;
                    int y = _y + i;
                    Tuple2.mcII.sp pair = new Tuple2.mcII.sp(x, y);
                    double pixelMinX = re.gridColToMap$mcI$sp(x + 0) - re.cellwidth() / (double)2;
                    double pixelMaxX = re.gridColToMap$mcI$sp(x + 1) - re.cellwidth() / (double)2;
                    double pixelMinY = re.gridRowToMap$mcI$sp(y + 0) + re.cellheight() / (double)2;
                    double pixelMaxY = re.gridRowToMap$mcI$sp(y + 1) + re.cellheight() / (double)2;
                    Polygon pixel = Polygon$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Point[]{Point$.MODULE$.apply(pixelMinX, pixelMinY), Point$.MODULE$.apply(pixelMinX, pixelMaxY), Point$.MODULE$.apply(pixelMaxX, pixelMaxY), Point$.MODULE$.apply(pixelMaxX, pixelMinY), Point$.MODULE$.apply(pixelMinX, pixelMinY)}), Predef.DummyImplicit$.MODULE$.dummyImplicit());
                    double d = fraction = localPoly.isEmpty() ? 0.0 : BoxesRunTime.unboxToDouble((Object)((TraversableOnce)Intersection$.MODULE$.polygonalRegions((Geometry)pixel, localPoly).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.getArea()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$9, x$10) -> x$9 + x$10)) / pixel.getArea();
                    if (!(fraction > 0.0) || seen.contains((Object)pair)) continue;
                    seen.$plus$eq((Object)new Tuple2.mcII.sp(x, y));
                    cb.callback(x, y, fraction);
                }
            }
        } else {
            double m2 = (x12 - x02) / (y12 - y02);
            for (int y = rowMin; y <= rowMax; ++y) {
                int _x = (int)package$.MODULE$.floor(m2 * ((double)y + 0.5 - y02) + x02);
                for (int i = -1; i <= 1; ++i) {
                    double fraction;
                    int x = _x + i;
                    Tuple2.mcII.sp pair = new Tuple2.mcII.sp(x, y);
                    double pixelMinX = re.gridColToMap$mcI$sp(x + 0) - re.cellwidth() / (double)2;
                    double pixelMaxX = re.gridColToMap$mcI$sp(x + 1) - re.cellwidth() / (double)2;
                    double pixelMinY = re.gridRowToMap$mcI$sp(y + 0) + re.cellheight() / (double)2;
                    double pixelMaxY = re.gridRowToMap$mcI$sp(y + 1) + re.cellheight() / (double)2;
                    Polygon pixel = Polygon$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Point[]{Point$.MODULE$.apply(pixelMinX, pixelMinY), Point$.MODULE$.apply(pixelMinX, pixelMaxY), Point$.MODULE$.apply(pixelMaxX, pixelMaxY), Point$.MODULE$.apply(pixelMaxX, pixelMinY), Point$.MODULE$.apply(pixelMinX, pixelMinY)}), Predef.DummyImplicit$.MODULE$.dummyImplicit());
                    double d = fraction = localPoly.isEmpty() ? 0.0 : BoxesRunTime.unboxToDouble((Object)((TraversableOnce)Intersection$.MODULE$.polygonalRegions((Geometry)pixel, localPoly).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)x$11.getArea()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$12, x$13) -> x$12 + x$13)) / pixel.getArea();
                    if (!(fraction > 0.0) || seen.contains((Object)pair)) continue;
                    seen.$plus$eq((Object)new Tuple2.mcII.sp(x, y));
                    cb.callback(x, y, fraction);
                }
            }
        }
    }

    public void foreachCellByPolygon(Polygon poly, RasterExtent re, package.FractionCallback cb) {
        Set seen = Set$.MODULE$.empty();
        Rasterizer.Options option = new Rasterizer.Options(false, PixelIsArea$.MODULE$);
        this.polygonToEdges(poly, re).foreach((Function1 & Serializable & scala.Serializable)edge -> {
            FractionalRasterizer$.MODULE$.renderEdge((Tuple4<Object, Object, Object, Object>)edge, re, MultiPolygon$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{poly})), (Set<Tuple2<Object, Object>>)seen, cb);
            return BoxedUnit.UNIT;
        });
        PolygonRasterizer$.MODULE$.foreachCellByPolygon(poly, re, PolygonRasterizer$.MODULE$.foreachCellByPolygon$default$3(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> {
            block0: {
                Tuple2.mcII.sp pair = new Tuple2.mcII.sp(col, row);
                if (seen.contains((Object)pair)) break block0;
                cb.callback(col, row, 1.0);
            }
        });
    }

    public void foreachCellByMultiPolygon(MultiPolygon multipoly, RasterExtent re, package.FractionCallback cb) {
        Set seen = Set$.MODULE$.empty();
        Rasterizer.Options option = new Rasterizer.Options(false, PixelIsArea$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geotrellis.vector.package$.MODULE$.withExtraMultiPolygonMethods(multipoly).polygons())).foreach((Function1 & Serializable & scala.Serializable)poly -> {
            FractionalRasterizer$.$anonfun$foreachCellByMultiPolygon$1(re, multipoly, seen, cb, poly);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geotrellis.vector.package$.MODULE$.withExtraMultiPolygonMethods(multipoly).polygons())).foreach((Function1 & Serializable & scala.Serializable)poly -> {
            PolygonRasterizer$.MODULE$.foreachCellByPolygon(poly, re, PolygonRasterizer$.MODULE$.foreachCellByPolygon$default$3(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> {
                block0: {
                    Tuple2.mcII.sp pair = new Tuple2.mcII.sp(col, row);
                    if (seen$2.contains((Object)pair)) break block0;
                    cb$2.callback(col, row, 1.0);
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$foreachCellByMultiPolygon$1(RasterExtent re$2, MultiPolygon multipoly$1, Set seen$2, package.FractionCallback cb$2, Polygon poly) {
        MODULE$.polygonToEdges(poly, re$2).foreach((Function1 & Serializable & scala.Serializable)edge -> {
            FractionalRasterizer$.MODULE$.renderEdge((Tuple4<Object, Object, Object, Object>)edge, re$2, multipoly$1, (Set<Tuple2<Object, Object>>)seen$2, cb$2);
            return BoxedUnit.UNIT;
        });
    }

    private FractionalRasterizer$() {
        MODULE$ = this;
    }
}

