/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.reproject;

import cats.kernel.Monoid;
import cats.package$;
import geotrellis.proj4.CRS;
import geotrellis.proj4.Proj4Transform$;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.TileFeature;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.reproject.RasterRegionReproject;
import geotrellis.raster.reproject.RowTransform$;
import geotrellis.raster.resample.Resample;
import geotrellis.raster.resample.Resample$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.vector.AtLeastOneDimension;
import geotrellis.vector.Extent;
import geotrellis.vector.LineString$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class RasterRegionReproject$
implements scala.Serializable {
    public static RasterRegionReproject$ MODULE$;
    private final RasterRegionReproject<Tile> singlebandInstance;
    private final RasterRegionReproject<MultibandTile> multibandInstance;

    static {
        new RasterRegionReproject$();
    }

    public Function1<Object, Tuple3<int[], double[], double[]>> geotrellis$raster$reproject$RasterRegionReproject$$rowCoords(Polygon destRegion, RasterExtent destRasterExtent, Function2<Object, Object, Tuple2<Object, Object>> toSrcCrs, double errorThreshold) {
        Extent extent = destRasterExtent.extent();
        Function4<double[], double[], double[], double[], BoxedUnit> rowTransform = errorThreshold != 0.0 ? RowTransform$.MODULE$.approximate(toSrcCrs, errorThreshold) : RowTransform$.MODULE$.exact(toSrcCrs);
        return (Function1 & Serializable & scala.Serializable)i -> RasterRegionReproject$.$anonfun$rowCoords$1(destRasterExtent, destRegion, rowTransform, toSrcCrs, extent, BoxesRunTime.unboxToInt((Object)i));
    }

    public RasterRegionReproject<Tile> singlebandInstance() {
        return this.singlebandInstance;
    }

    public RasterRegionReproject<MultibandTile> multibandInstance() {
        return this.multibandInstance;
    }

    public <T extends CellGrid<Object>, D> RasterRegionReproject<TileFeature<T, D>> TileFeatureRasterRegionReproject(RasterRegionReproject<T> evidence$1, Monoid<D> evidence$2, Function1<T, TileMergeMethods<T>> ev) {
        return new RasterRegionReproject<TileFeature<T, D>>(evidence$1, evidence$2){
            private final RasterRegionReproject evidence$1$1;
            private final Monoid evidence$2$1;

            public Raster<TileFeature<T, D>> regionReproject(Raster<TileFeature<T, D>> raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod) {
                return RasterRegionReproject.regionReproject$(this, raster, src, dest, rasterExtent, region, resampleMethod);
            }

            public Raster<TileFeature<T, D>> regionReprojectMutable(Raster<TileFeature<T, D>> raster, CRS src, CRS dest, Raster<TileFeature<T, D>> target, Polygon region, ResampleMethod resampleMethod) {
                return RasterRegionReproject.regionReprojectMutable$(this, raster, src, dest, target, region, resampleMethod);
            }

            public void mutableRegionReproject(CellGrid target, Raster raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod) {
                RasterRegionReproject.mutableRegionReproject$(this, target, raster, src, dest, rasterExtent, region, resampleMethod);
            }

            public Raster<TileFeature<T, D>> regionReproject(Raster<TileFeature<T, D>> raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod, double errorThreshold) {
                Raster<A> srcRaster = raster.mapTile((Function1 & Serializable & scala.Serializable)x$35 -> x$35.tile());
                Raster<A> reprojected = ((RasterRegionReproject)Predef$.MODULE$.implicitly((Object)this.evidence$1$1)).regionReproject(srcRaster, src, dest, rasterExtent, region, resampleMethod, errorThreshold);
                return new Raster<TileFeature<T, D>>(new TileFeature<A, D>(reprojected.tile(), raster.tile().data()), raster.extent());
            }

            public Raster<TileFeature<T, D>> regionReprojectMutable(Raster<TileFeature<T, D>> raster, CRS src, CRS dest, Raster<TileFeature<T, D>> target, Polygon region, ResampleMethod resampleMethod, double errorThreshold) {
                Raster<A> srcRaster = raster.mapTile((Function1 & Serializable & scala.Serializable)x$36 -> x$36.tile());
                Raster<A> dstRaster = target.mapTile((Function1 & Serializable & scala.Serializable)x$37 -> x$37.tile());
                Raster<A> reprojected = ((RasterRegionReproject)Predef$.MODULE$.implicitly((Object)this.evidence$1$1)).regionReprojectMutable(srcRaster, src, dest, dstRaster, region, resampleMethod, errorThreshold);
                Object mergedData = package$.MODULE$.Monoid().apply(this.evidence$2$1).combine(target.tile().data(), raster.tile().data());
                return reprojected.mapTile((Function1 & Serializable & scala.Serializable)x$38 -> new TileFeature<CellGrid, Object>((CellGrid)x$38, mergedData));
            }
            {
                this.evidence$1$1 = evidence$1$1;
                this.evidence$2$1 = evidence$2$1;
                RasterRegionReproject.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$regionReproject$1(geotrellis.raster.TileFeature ), $anonfun$regionReprojectMutable$1(geotrellis.raster.TileFeature ), $anonfun$regionReprojectMutable$2(geotrellis.raster.TileFeature ), $anonfun$regionReprojectMutable$3(java.lang.Object geotrellis.raster.CellGrid )}, serializedLambda);
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Tuple2 scanlineCols$1(double xmin, double xmax, Extent extent$1, RasterExtent destRasterExtent$1) {
        int x0 = (int)((xmin - extent$1.xmin()) / destRasterExtent$1.cellwidth() + 0.5 - 1.0E-6);
        int x1 = (int)((xmax - extent$1.xmin()) / destRasterExtent$1.cellwidth() + 0.5 + 1.0E-6) - 1;
        int[] locations = (int[])Array$.MODULE$.ofDim(x1 - x0 + 1, ClassTag$.MODULE$.Int());
        double[] result = (double[])Array$.MODULE$.ofDim(x1 - x0 + 1, ClassTag$.MODULE$.Double());
        for (int index$macro$1 = x0; index$macro$1 <= x1; ++index$macro$1) {
            locations[index$macro$1 - x0] = index$macro$1;
            result[index$macro$1 - x0] = ((double)index$macro$1 + 0.5) * destRasterExtent$1.cellwidth() + extent$1.xmin();
        }
        return new Tuple2((Object)locations, (Object)result);
    }

    public static final /* synthetic */ Tuple3 $anonfun$rowCoords$1(RasterExtent destRasterExtent$1, Polygon destRegion$1, Function4 rowTransform$1, Function2 toSrcCrs$1, Extent extent$1, int i) {
        Tuple3 tuple3;
        if (i >= 0 && i < destRasterExtent$1.rows()) {
            Geometry[] geometryArray;
            LineString scanline = LineString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{destRasterExtent$1.gridToMap$mcI$sp(0, i), destRasterExtent$1.gridToMap$mcI$sp(destRasterExtent$1.cols() - 1, i)}), Predef.DummyImplicit$.MODULE$.dummyImplicit());
            Option option = geotrellis.vector.package$.MODULE$.withExtraLineStringMethods(scanline).$amp((Geometry)destRegion$1, (AtLeastOneDimension)geotrellis.vector.package$.MODULE$.polygonIsTwoDimensional()).toGeometry();
            if (None$.MODULE$.equals(option)) {
                geometryArray = (Geometry[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Geometry.class));
            } else if (option instanceof Some) {
                Geometry[] geometryArray2;
                Some some = (Some)option;
                Geometry g = (Geometry)some.value();
                if (g instanceof GeometryCollection) {
                    geometryArray2 = (Geometry[])geotrellis.vector.package$.MODULE$.withExtraGeometryCollectionMethods((GeometryCollection)g).geometries().toArray(ClassTag$.MODULE$.apply(Geometry.class));
                } else if (g instanceof LineString) {
                    geometryArray2 = (Geometry[])new LineString[]{(LineString)g};
                } else if (g instanceof Point) {
                    geometryArray2 = (Geometry[])new Point[]{(Point)g};
                } else if (g instanceof MultiLineString) {
                    geometryArray2 = (Geometry[])geotrellis.vector.package$.MODULE$.withExtraMultiLineStringMethods((MultiLineString)g).lines();
                } else if (g instanceof MultiPoint) {
                    geometryArray2 = (Geometry[])geotrellis.vector.package$.MODULE$.withExtraMultiPointMethods((MultiPoint)g).points();
                } else {
                    throw new IllegalStateException("Line/polygon intersection may only produce a set of Lines and Points");
                }
                geometryArray = geometryArray2;
            } else {
                throw new MatchError((Object)option);
            }
            Geometry[] chunks = geometryArray;
            tuple3 = (Tuple3)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chunks)).map((Function1 & Serializable & scala.Serializable)chunk -> {
                Tuple3 tuple3;
                Geometry geometry = chunk;
                if (geometry instanceof LineString) {
                    LineString lineString = (LineString)geometry;
                    Tuple2 tuple2 = RasterRegionReproject$.scanlineCols$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(lineString.getStartPoint()).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(lineString.getEndPoint()).x(), extent$1, destRasterExtent$1);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int[] pxarr = (int[])tuple2._1();
                    double[] xarr = (double[])tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)pxarr, (Object)xarr);
                    Tuple2 tuple23 = tuple22;
                    int[] pxarr2 = (int[])tuple23._1();
                    double[] xarr2 = (double[])tuple23._2();
                    double[] yarr = (double[])Array$.MODULE$.fill(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xarr2)).size(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> destRasterExtent$1.gridRowToMap$mcI$sp(i), ClassTag$.MODULE$.Double());
                    double[] xres = (double[])Array$.MODULE$.ofDim(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xarr2)).size(), ClassTag$.MODULE$.Double());
                    double[] yres = (double[])Array$.MODULE$.ofDim(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xarr2)).size(), ClassTag$.MODULE$.Double());
                    Object object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xarr2)).size() > 0 ? rowTransform$1.apply((Object)xarr2, (Object)yarr, (Object)xres, (Object)yres) : BoxedUnit.UNIT;
                    tuple3 = new Tuple3((Object)pxarr2, (Object)xres, (Object)yres);
                } else if (geometry instanceof Point) {
                    Point point = (Point)geometry;
                    Tuple2 tuple2 = (Tuple2)toSrcCrs$1.apply((Object)BoxesRunTime.boxToDouble((double)geotrellis.vector.package$.MODULE$.withExtraPointMethods(point).x()), (Object)BoxesRunTime.boxToDouble((double)geotrellis.vector.package$.MODULE$.withExtraPointMethods(point).y()));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double x = tuple2._1$mcD$sp();
                    double y = tuple2._2$mcD$sp();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
                    Tuple2.mcDD.sp sp3 = sp2;
                    double x2 = sp3._1$mcD$sp();
                    double y2 = sp3._2$mcD$sp();
                    tuple3 = new Tuple3((Object)new int[]{destRasterExtent$1.mapXToGrid$mcI$sp(geotrellis.vector.package$.MODULE$.withExtraPointMethods(point).x())}, (Object)new double[]{x2}, (Object)new double[]{y2});
                } else {
                    if (geometry != null) {
                        throw new IllegalStateException("Line-Polygon intersection cannot produce geometries that are not Points or Lines");
                    }
                    throw new MatchError((Object)geometry);
                }
                return tuple3;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).fold((Object)new Tuple3(Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), Array$.MODULE$.empty(ClassTag$.MODULE$.Double())), (Function2 & Serializable & scala.Serializable)(a1, a2) -> {
                Tuple3 tuple3 = a1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                int[] px1 = (int[])tuple3._1();
                double[] x1 = (double[])tuple3._2();
                double[] y1 = (double[])tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)px1, (Object)x1, (Object)y1);
                Tuple3 tuple33 = tuple32;
                int[] px12 = (int[])tuple33._1();
                double[] x12 = (double[])tuple33._2();
                double[] y12 = (double[])tuple33._3();
                Tuple3 tuple34 = a2;
                if (tuple34 == null) {
                    throw new MatchError((Object)tuple34);
                }
                int[] px2 = (int[])tuple34._1();
                double[] x2 = (double[])tuple34._2();
                double[] y2 = (double[])tuple34._3();
                Tuple3 tuple35 = new Tuple3((Object)px2, (Object)x2, (Object)y2);
                Tuple3 tuple36 = tuple35;
                int[] px22 = (int[])tuple36._1();
                double[] x22 = (double[])tuple36._2();
                double[] y22 = (double[])tuple36._3();
                return new Tuple3(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(px12)).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(px22)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x12)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x22)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(y12)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(y22)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            });
        } else {
            tuple3 = new Tuple3(Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
        }
        return tuple3;
    }

    private RasterRegionReproject$() {
        MODULE$ = this;
        this.singlebandInstance = new RasterRegionReproject<Tile>(){

            public Raster<Tile> regionReproject(Raster<Tile> raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod) {
                return RasterRegionReproject.regionReproject$(this, raster, src, dest, rasterExtent, region, resampleMethod);
            }

            public Raster<Tile> regionReprojectMutable(Raster<Tile> raster, CRS src, CRS dest, Raster<Tile> target, Polygon region, ResampleMethod resampleMethod) {
                return RasterRegionReproject.regionReprojectMutable$(this, raster, src, dest, target, region, resampleMethod);
            }

            public void mutableRegionReproject(CellGrid target, Raster raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod) {
                RasterRegionReproject.mutableRegionReproject$(this, target, raster, src, dest, rasterExtent, region, resampleMethod);
            }

            public Raster<Tile> regionReproject(Raster<Tile> raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod, double errorThreshold) {
                MutableArrayTile buffer = ArrayTile$.MODULE$.empty(raster.tile().cellType(), rasterExtent.cols(), rasterExtent.rows());
                this.reprojectToBuffer(raster, src, dest, buffer, rasterExtent, region, resampleMethod, errorThreshold);
                return new Raster<Tile>(buffer, rasterExtent.extent());
            }

            public Raster<Tile> regionReprojectMutable(Raster<Tile> raster, CRS src, CRS dest, Raster<Tile> target, Polygon region, ResampleMethod resampleMethod, double errorThreshold) {
                MutableArrayTile buffer = target.tile().mutable();
                RasterExtent bufferRE = target.rasterExtent();
                this.reprojectToBuffer(raster, src, dest, buffer, bufferRE, region, resampleMethod, errorThreshold);
                return new Raster<Tile>(buffer, bufferRE.extent());
            }

            private void reprojectToBuffer(Raster<Tile> raster, CRS src, CRS dest, MutableArrayTile target, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod, double errorThreshold) {
                Function2 trans = Proj4Transform$.MODULE$.apply(dest, src);
                Resample resampler = Resample$.MODULE$.apply(resampleMethod, raster.tile(), raster.extent(), new CellSize(raster.rasterExtent().cellwidth(), raster.rasterExtent().cellheight()));
                Function1<Object, Tuple3<int[], double[], double[]>> rowcoords = RasterRegionReproject$.MODULE$.geotrellis$raster$reproject$RasterRegionReproject$$rowCoords(region, rasterExtent, (Function2<Object, Object, Tuple2<Object, Object>>)trans, errorThreshold);
                if (raster.cellType().isFloatingPoint()) {
                    for (int index$macro$2 = 0; index$macro$2 < rasterExtent.rows(); ++index$macro$2) {
                        Tuple3 tuple3 = (Tuple3)rowcoords.apply((Object)BoxesRunTime.boxToInteger((int)index$macro$2));
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        int[] pxs = (int[])tuple3._1();
                        double[] xs = (double[])tuple3._2();
                        double[] ys = (double[])tuple3._3();
                        Tuple3 tuple32 = new Tuple3((Object)pxs, (Object)xs, (Object)ys);
                        Tuple3 tuple33 = tuple32;
                        int[] pxs2 = (int[])tuple33._1();
                        double[] xs2 = (double[])tuple33._2();
                        double[] ys2 = (double[])tuple33._3();
                        for (int index$macro$1 = 0; index$macro$1 < new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs2)).size(); ++index$macro$1) {
                            target.setDouble(pxs2[index$macro$1], index$macro$2, resampler.resampleDouble(xs2[index$macro$1], ys2[index$macro$1]));
                        }
                    }
                } else {
                    for (int index$macro$4 = 0; index$macro$4 < rasterExtent.rows(); ++index$macro$4) {
                        Tuple3 tuple3 = (Tuple3)rowcoords.apply((Object)BoxesRunTime.boxToInteger((int)index$macro$4));
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        int[] pxs = (int[])tuple3._1();
                        double[] xs = (double[])tuple3._2();
                        double[] ys = (double[])tuple3._3();
                        Tuple3 tuple34 = new Tuple3((Object)pxs, (Object)xs, (Object)ys);
                        Tuple3 tuple35 = tuple34;
                        int[] pxs3 = (int[])tuple35._1();
                        double[] xs3 = (double[])tuple35._2();
                        double[] ys3 = (double[])tuple35._3();
                        for (int index$macro$3 = 0; index$macro$3 < new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs3)).size(); ++index$macro$3) {
                            target.set(pxs3[index$macro$3], index$macro$4, resampler.resample(xs3[index$macro$3], ys3[index$macro$3]));
                        }
                    }
                }
            }
            {
                RasterRegionReproject.$init$(this);
            }
        };
        this.multibandInstance = new RasterRegionReproject<MultibandTile>(){

            public Raster<MultibandTile> regionReproject(Raster<MultibandTile> raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod) {
                return RasterRegionReproject.regionReproject$(this, raster, src, dest, rasterExtent, region, resampleMethod);
            }

            public Raster<MultibandTile> regionReprojectMutable(Raster<MultibandTile> raster, CRS src, CRS dest, Raster<MultibandTile> target, Polygon region, ResampleMethod resampleMethod) {
                return RasterRegionReproject.regionReprojectMutable$(this, raster, src, dest, target, region, resampleMethod);
            }

            public void mutableRegionReproject(CellGrid target, Raster raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod) {
                RasterRegionReproject.mutableRegionReproject$(this, target, raster, src, dest, rasterExtent, region, resampleMethod);
            }

            public Raster<MultibandTile> regionReproject(Raster<MultibandTile> raster, CRS src, CRS dest, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod, double errorThreshold) {
                MutableArrayTile[] bands = (MutableArrayTile[])Array$.MODULE$.ofDim(raster.tile().bandCount(), ClassTag$.MODULE$.apply(MutableArrayTile.class));
                for (int index$macro$1 = 0; index$macro$1 < bands.length; ++index$macro$1) {
                    bands[index$macro$1] = ArrayTile$.MODULE$.empty(raster.tile().band(index$macro$1).cellType(), rasterExtent.cols(), rasterExtent.rows());
                }
                this.reprojectToBuffer(raster, src, dest, bands, rasterExtent, region, resampleMethod, errorThreshold);
                return new Raster<MultibandTile>(MultibandTile$.MODULE$.apply((Traversable<Tile>)Predef$.MODULE$.wrapRefArray((Object[])bands)), rasterExtent.extent());
            }

            public Raster<MultibandTile> regionReprojectMutable(Raster<MultibandTile> raster, CRS src, CRS dest, Raster<MultibandTile> target, Polygon region, ResampleMethod resampleMethod, double errorThreshold) {
                RasterExtent bufferRE = target.rasterExtent();
                MutableArrayTile[] bands = (MutableArrayTile[])Array$.MODULE$.ofDim(raster.tile().bandCount(), ClassTag$.MODULE$.apply(MutableArrayTile.class));
                for (int index$macro$1 = 0; index$macro$1 < bands.length; ++index$macro$1) {
                    bands[index$macro$1] = target.tile().band(index$macro$1).mutable();
                }
                this.reprojectToBuffer(raster, src, dest, bands, bufferRE, region, resampleMethod, errorThreshold);
                return new Raster<MultibandTile>(MultibandTile$.MODULE$.apply((Traversable<Tile>)Predef$.MODULE$.wrapRefArray((Object[])bands)), bufferRE.extent());
            }

            private void reprojectToBuffer(Raster<MultibandTile> raster, CRS src, CRS dest, MutableArrayTile[] buffer, RasterExtent rasterExtent, Polygon region, ResampleMethod resampleMethod, double errorThreshold) {
                Function2 trans = Proj4Transform$.MODULE$.apply(dest, src);
                Function1<Object, Tuple3<int[], double[], double[]>> rowcoords = RasterRegionReproject$.MODULE$.geotrellis$raster$reproject$RasterRegionReproject$$rowCoords(region, rasterExtent, (Function2<Object, Object, Tuple2<Object, Object>>)trans, errorThreshold);
                Resample[] resampler = (Resample[])Array$.MODULE$.ofDim(raster.tile().bandCount(), ClassTag$.MODULE$.apply(Resample.class));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), raster.tile().bandCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> {
                    Tile band = (Tile)((MultibandTile)raster.tile()).bands().apply(b);
                    resampler$1[b] = Resample$.MODULE$.apply(resampleMethod, band, raster.extent(), raster.rasterExtent().cellSize());
                });
                if (raster.cellType().isFloatingPoint()) {
                    for (int index$macro$3 = 0; index$macro$3 < rasterExtent.rows(); ++index$macro$3) {
                        Tuple3 tuple3 = (Tuple3)rowcoords.apply((Object)BoxesRunTime.boxToInteger((int)index$macro$3));
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        int[] pxs = (int[])tuple3._1();
                        double[] xs = (double[])tuple3._2();
                        double[] ys = (double[])tuple3._3();
                        Tuple3 tuple32 = new Tuple3((Object)pxs, (Object)xs, (Object)ys);
                        Tuple3 tuple33 = tuple32;
                        int[] pxs2 = (int[])tuple33._1();
                        double[] xs2 = (double[])tuple33._2();
                        double[] ys2 = (double[])tuple33._3();
                        for (int index$macro$2 = 0; index$macro$2 < new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs2)).size(); ++index$macro$2) {
                            for (int index$macro$1 = 0; index$macro$1 < buffer.length; ++index$macro$1) {
                                buffer[index$macro$1].setDouble(pxs2[index$macro$2], index$macro$3, resampler[index$macro$1].resampleDouble(xs2[index$macro$2], ys2[index$macro$2]));
                            }
                        }
                    }
                } else {
                    for (int index$macro$6 = 0; index$macro$6 < rasterExtent.rows(); ++index$macro$6) {
                        Tuple3 tuple3 = (Tuple3)rowcoords.apply((Object)BoxesRunTime.boxToInteger((int)index$macro$6));
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        int[] pxs = (int[])tuple3._1();
                        double[] xs = (double[])tuple3._2();
                        double[] ys = (double[])tuple3._3();
                        Tuple3 tuple34 = new Tuple3((Object)pxs, (Object)xs, (Object)ys);
                        Tuple3 tuple35 = tuple34;
                        int[] pxs3 = (int[])tuple35._1();
                        double[] xs3 = (double[])tuple35._2();
                        double[] ys3 = (double[])tuple35._3();
                        for (int index$macro$5 = 0; index$macro$5 < new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs3)).size(); ++index$macro$5) {
                            for (int index$macro$4 = 0; index$macro$4 < buffer.length; ++index$macro$4) {
                                buffer[index$macro$4].set(pxs3[index$macro$5], index$macro$6, resampler[index$macro$4].resample(xs3[index$macro$5], ys3[index$macro$5]));
                            }
                        }
                    }
                }
            }
            {
                RasterRegionReproject.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$reprojectToBuffer$1(geotrellis.raster.Raster geotrellis.raster.resample.Resample[] geotrellis.raster.resample.ResampleMethod int )}, serializedLambda);
            }
        };
    }
}

