/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.reproject;

import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RowTransform$ {
    public static RowTransform$ MODULE$;

    static {
        new RowTransform$();
    }

    public Function4<double[], double[], double[], double[], BoxedUnit> exact(Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return (Function4 & java.io.Serializable & Serializable)(srcX, srcY, destX, destY) -> {
            RowTransform$.$anonfun$exact$1(transform, srcX, srcY, destX, destY);
            return BoxedUnit.UNIT;
        };
    }

    public Function4<double[], double[], double[], double[], BoxedUnit> approximate(Function2<Object, Object, Tuple2<Object, Object>> transform, double errorThreshold) {
        return errorThreshold == 0.0 ? this.exact(transform) : (Function4 & java.io.Serializable & Serializable)(srcX, srcY, destX, destY) -> {
            RowTransform$.$anonfun$approximate$1(transform, errorThreshold, srcX, srcY, destX, destY);
            return BoxedUnit.UNIT;
        };
    }

    private void computeApprox(Function2<Object, Object, Tuple2<Object, Object>> transform, double errorThreshold, double[] srcX, double[] srcY, double[] destX, double[] destY, int startIndex, int length) {
        block5: {
            BoxedUnit boxedUnit;
            block4: {
                double deltaY;
                double deltaX;
                double ymin;
                double xmin;
                double srcXMin;
                int midPoint;
                while (true) {
                    if (length == 2) {
                        return;
                    }
                    midPoint = startIndex + (length - 1) / 2;
                    Tuple2 tuple2 = (Tuple2)transform.apply((Object)BoxesRunTime.boxToDouble((double)srcX[midPoint]), (Object)BoxesRunTime.boxToDouble((double)srcY[midPoint]));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double xmid = tuple2._1$mcD$sp();
                    double ymid = tuple2._2$mcD$sp();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(xmid, ymid);
                    Tuple2.mcDD.sp sp3 = sp2;
                    double xmid2 = sp3._1$mcD$sp();
                    double ymid2 = sp3._2$mcD$sp();
                    destX[midPoint] = xmid2;
                    destY[midPoint] = ymid2;
                    if (length == 3) break block4;
                    double srcXMax = srcX[startIndex + length - 1];
                    srcXMin = srcX[startIndex];
                    double xmax = destX[startIndex + length - 1];
                    xmin = destX[startIndex];
                    double ymax = destY[startIndex + length - 1];
                    ymin = destY[startIndex];
                    double dx = srcXMax - srcXMin;
                    deltaX = (xmax - xmin) / dx;
                    deltaY = (ymax - ymin) / dx;
                    double dxmid = srcX[midPoint] - srcXMin;
                    double error = package$.MODULE$.abs(xmin + deltaX * dxmid - xmid2) + package$.MODULE$.abs(ymin + deltaY * dxmid - ymid2);
                    if (!(error > errorThreshold)) break;
                    this.computeApprox(transform, errorThreshold, srcX, srcY, destX, destY, startIndex, midPoint - startIndex + 1);
                    length = startIndex + length - midPoint;
                    startIndex = midPoint;
                }
                for (int index$macro$1 = startIndex + 1; index$macro$1 < startIndex + length - 1; ++index$macro$1) {
                    if (index$macro$1 == midPoint) continue;
                    double dxi = srcX[index$macro$1] - srcXMin;
                    destX[index$macro$1] = xmin + deltaX * dxi;
                    destY[index$macro$1] = ymin + deltaY * dxi;
                }
                boxedUnit = BoxedUnit.UNIT;
                break block5;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$exact$1(Function2 transform$1, double[] srcX, double[] srcY, double[] destX, double[] destY) {
        for (int index$macro$1 = 0; index$macro$1 < srcX.length; ++index$macro$1) {
            Tuple2 tuple2 = (Tuple2)transform$1.apply((Object)BoxesRunTime.boxToDouble((double)srcX[index$macro$1]), (Object)BoxesRunTime.boxToDouble((double)srcY[index$macro$1]));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double x = tuple2._1$mcD$sp();
            double y = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
            Tuple2.mcDD.sp sp3 = sp2;
            double x2 = sp3._1$mcD$sp();
            double y2 = sp3._2$mcD$sp();
            destX[index$macro$1] = x2;
            destY[index$macro$1] = y2;
        }
    }

    public static final /* synthetic */ void $anonfun$approximate$1(Function2 transform$2, double errorThreshold$1, double[] srcX, double[] srcY, double[] destX, double[] destY) {
        int len = srcX.length;
        Tuple2 tuple2 = (Tuple2)transform$2.apply((Object)BoxesRunTime.boxToDouble((double)srcX[0]), (Object)BoxesRunTime.boxToDouble((double)srcY[0]));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double xmin = tuple2._1$mcD$sp();
        double ymin = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(xmin, ymin);
        Tuple2.mcDD.sp sp3 = sp2;
        double xmin2 = sp3._1$mcD$sp();
        double ymin2 = sp3._2$mcD$sp();
        Tuple2 tuple22 = (Tuple2)transform$2.apply((Object)BoxesRunTime.boxToDouble((double)srcX[len - 1]), (Object)BoxesRunTime.boxToDouble((double)srcY[len - 1]));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        double xmax = tuple22._1$mcD$sp();
        double ymax = tuple22._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(xmax, ymax);
        Tuple2.mcDD.sp sp5 = sp4;
        double xmax2 = sp5._1$mcD$sp();
        double ymax2 = sp5._2$mcD$sp();
        destX[0] = xmin2;
        destY[0] = ymin2;
        destX[len - 1] = xmax2;
        destY[len - 1] = ymax2;
        MODULE$.computeApprox((Function2<Object, Object, Tuple2<Object, Object>>)transform$2, errorThreshold$1, srcX, srcY, destX, destY, 0, len);
    }

    private RowTransform$() {
        MODULE$ = this;
    }
}

