/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.reproject;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellSize;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import geotrellis.raster.reproject.RasterReprojectMethods;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.RowTransform$;
import geotrellis.raster.resample.Resample;
import geotrellis.raster.resample.Resample$;
import geotrellis.vector.Extent;
import scala.Array$;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple5;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3qa\u0001\u0003\u0011\u0002\u0007\u00051\u0002C\u0003%\u0001\u0011\u0005Q\u0005C\u0003\u0006\u0001\u0011\u0005\u0011F\u0001\u0011TS:<G.\u001a2b]\u0012\u0014\u0016m\u001d;feJ+\u0007O]8kK\u000e$X*\u001a;i_\u0012\u001c(BA\u0003\u0007\u0003%\u0011X\r\u001d:pU\u0016\u001cGO\u0003\u0002\b\u0011\u00051!/Y:uKJT\u0011!C\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rE\u0002\u0014)Yi\u0011\u0001B\u0005\u0003+\u0011\u0011aCU1ti\u0016\u0014(+\u001a9s_*,7\r^'fi\"|Gm\u001d\t\u0003/\u0005r!\u0001G\u0010\u000f\u0005eqbB\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011\u0001EB\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00113E\u0001\tTS:<G.\u001a2b]\u0012\u0014\u0016m\u001d;fe*\u0011\u0001EB\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0019\u0002\"!D\u0014\n\u0005!r!\u0001B+oSR$RA\u0006\u00161yyBQa\u000b\u0002A\u00021\n!\u0003^1sO\u0016$(+Y:uKJ,\u0005\u0010^3oiB\u0011QFL\u0007\u0002\r%\u0011qF\u0002\u0002\r%\u0006\u001cH/\u001a:FqR,g\u000e\u001e\u0005\u0006c\t\u0001\rAM\u0001\niJ\fgn\u001d4pe6\u0004\"aM\u001d\u000f\u0005Q:dBA\r6\u0013\t1\u0004\"A\u0003qe>TG'\u0003\u0002!q)\u0011a\u0007C\u0005\u0003um\u0012\u0011\u0002\u0016:b]N4wN]7\u000b\u0005\u0001B\u0004\"B\u001f\u0003\u0001\u0004\u0011\u0014\u0001E5om\u0016\u00148/\u001a+sC:\u001chm\u001c:n\u0011\u0015y$\u00011\u0001A\u0003\u001dy\u0007\u000f^5p]N\u0004\"!\u0011#\u000f\u0005M\u0011\u0015BA\"\u0005\u0003%\u0011V\r\u001d:pU\u0016\u001cG/\u0003\u0002F\r\n9q\n\u001d;j_:\u001c(BA\"\u0005\u0001")
public interface SinglebandRasterReprojectMethods
extends RasterReprojectMethods<Raster<Tile>> {
    public static /* synthetic */ Raster reproject$(SinglebandRasterReprojectMethods $this, RasterExtent targetRasterExtent, Function2 transform, Function2 inverseTransform, Reproject.Options options) {
        return $this.reproject(targetRasterExtent, (Function2<Object, Object, Tuple2<Object, Object>>)transform, (Function2<Object, Object, Tuple2<Object, Object>>)inverseTransform, options);
    }

    @Override
    default public Raster<Tile> reproject(RasterExtent targetRasterExtent, Function2<Object, Object, Tuple2<Object, Object>> transform, Function2<Object, Object, Tuple2<Object, Object>> inverseTransform, Reproject.Options options) {
        Raster raster = (Raster)this.self();
        if (raster == null) {
            throw new MatchError((Object)raster);
        }
        Tile tile = (Tile)raster.tile();
        Extent extent = raster.extent();
        Tuple2 tuple2 = new Tuple2((Object)tile, (Object)extent);
        Tuple2 tuple22 = tuple2;
        Tile tile2 = (Tile)tuple22._1();
        Extent extent2 = (Extent)tuple22._2();
        RasterExtent rasterExtent = targetRasterExtent;
        if (rasterExtent == null) {
            throw new MatchError((Object)rasterExtent);
        }
        Extent newExtent = rasterExtent.extent();
        double newCellWidth = rasterExtent.cellwidth();
        double newCellHeight = rasterExtent.cellheight();
        int newCols = rasterExtent.cols();
        int newRows = rasterExtent.rows();
        Tuple5 tuple5 = new Tuple5((Object)newExtent, (Object)BoxesRunTime.boxToDouble((double)newCellWidth), (Object)BoxesRunTime.boxToDouble((double)newCellHeight), (Object)BoxesRunTime.boxToInteger((int)newCols), (Object)BoxesRunTime.boxToInteger((int)newRows));
        Tuple5 tuple52 = tuple5;
        Extent newExtent2 = (Extent)tuple52._1();
        double newCellWidth2 = BoxesRunTime.unboxToDouble((Object)tuple52._2());
        double newCellHeight2 = BoxesRunTime.unboxToDouble((Object)tuple52._3());
        int newCols2 = BoxesRunTime.unboxToInt((Object)tuple52._4());
        int newRows2 = BoxesRunTime.unboxToInt((Object)tuple52._5());
        MutableArrayTile newTile = ArrayTile$.MODULE$.empty(tile2.cellType(), newCols2, newRows2);
        Function4<double[], double[], double[], double[], BoxedUnit> rowTransform = options.errorThreshold() != 0.0 ? RowTransform$.MODULE$.approximate(inverseTransform, options.errorThreshold()) : RowTransform$.MODULE$.exact(inverseTransform);
        Tuple2<Object, Object> tuple23 = targetRasterExtent.gridToMap$mcI$sp(0, 0);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        double topLeftX = tuple23._1$mcD$sp();
        double topLeftY = tuple23._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(topLeftX, topLeftY);
        Tuple2.mcDD.sp sp3 = sp2;
        double topLeftX2 = sp3._1$mcD$sp();
        double topLeftY2 = sp3._2$mcD$sp();
        double[] destX = (double[])Array$.MODULE$.ofDim(newCols2, ClassTag$.MODULE$.Double());
        double currX = topLeftX2;
        for (int index$macro$1 = 0; index$macro$1 < newCols2; ++index$macro$1) {
            destX[index$macro$1] = currX;
            currX += newCellWidth2;
        }
        double[] destY = package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(newCols2, ClassTag$.MODULE$.Double())), topLeftY2);
        double[] srcX = (double[])Array$.MODULE$.ofDim(newCols2, ClassTag$.MODULE$.Double());
        double[] srcY = (double[])Array$.MODULE$.ofDim(newCols2, ClassTag$.MODULE$.Double());
        Resample resampler = Resample$.MODULE$.apply(options.method(), tile2, extent2, new CellSize(newCellWidth2, newCellHeight2));
        if (tile2.cellType().isFloatingPoint()) {
            for (int index$macro$3 = 0; index$macro$3 < newRows2; ++index$macro$3) {
                rowTransform.apply((Object)destX, (Object)destY, (Object)srcX, (Object)srcY);
                for (int index$macro$2 = 0; index$macro$2 < newCols2; ++index$macro$2) {
                    double x = srcX[index$macro$2];
                    double y = srcY[index$macro$2];
                    double v = resampler.resampleDouble(x, y);
                    newTile.setDouble(index$macro$2, index$macro$3, v);
                    destY[index$macro$2] = destY[index$macro$2] - newCellHeight2;
                }
            }
        } else {
            for (int index$macro$5 = 0; index$macro$5 < newRows2; ++index$macro$5) {
                rowTransform.apply((Object)destX, (Object)destY, (Object)srcX, (Object)srcY);
                for (int index$macro$4 = 0; index$macro$4 < newCols2; ++index$macro$4) {
                    double x = srcX[index$macro$4];
                    double y = srcY[index$macro$4];
                    int v = resampler.resample(x, y);
                    newTile.set(index$macro$4, index$macro$5, v);
                    destY[index$macro$4] = destY[index$macro$4] - newCellHeight2;
                }
            }
        }
        return new Raster<Tile>(newTile, newExtent2);
    }

    public static void $init$(SinglebandRasterReprojectMethods $this) {
    }
}

