/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.Tile;
import geotrellis.raster.resample.Resample;
import geotrellis.vector.Extent;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple4;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4AAE\n\u00015!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u001d\u0001\u0004A1A\u0005\nEBa\u0001\u000f\u0001!\u0002\u0013\u0011\u0004bB\u001d\u0001\u0005\u0004%I!\r\u0005\u0007u\u0001\u0001\u000b\u0011\u0002\u001a\t\u000fm\u0002!\u0019!C\u0005c!1A\b\u0001Q\u0001\nIBq!\u0010\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004?\u0001\u0001\u0006IA\r\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0006\u0011\u0002!\t%\u0013\u0005\u0006\u0019\u0002!\t!\u0014\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006;\u0002!\tA\u0018\u0005\u0006G\u0002!I\u0001\u001a\u0002\u0011\u0005&d\u0017N\\3beJ+7/Y7qY\u0016T!\u0001F\u000b\u0002\u0011I,7/Y7qY\u0016T!AF\f\u0002\rI\f7\u000f^3s\u0015\u0005A\u0012AC4f_R\u0014X\r\u001c7jg\u000e\u00011C\u0001\u0001\u001c!\taR$D\u0001\u0014\u0013\tq2C\u0001\u0005SKN\fW\u000e\u001d7f\u0003\u0011!\u0018\u000e\\3\u0011\u0005\u0005\u0012S\"A\u000b\n\u0005\r*\"\u0001\u0002+jY\u0016\fa!\u001a=uK:$\bC\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0018\u0003\u00191Xm\u0019;pe&\u0011!f\n\u0002\u0007\u000bb$XM\u001c;\u0002\rqJg.\u001b;?)\ricf\f\t\u00039\u0001AQaH\u0002A\u0002\u0001BQ\u0001J\u0002A\u0002\u0015\nA\u0001_7j]V\t!\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004E_V\u0014G.Z\u0001\u0006q6Lg\u000eI\u0001\u0005q6\f\u00070A\u0003y[\u0006D\b%\u0001\u0003z[&t\u0017!B=nS:\u0004\u0013\u0001B=nCb\fQ!_7bq\u0002\nQB]3tC6\u0004H.\u001a,bY&$GcA!E\rB\u00111GQ\u0005\u0003\u0007R\u00121!\u00138u\u0011\u0015)E\u00021\u00013\u0003\u0005A\b\"B$\r\u0001\u0004\u0011\u0014!A=\u0002'I,7/Y7qY\u0016$u.\u001e2mKZ\u000bG.\u001b3\u0015\u0007IR5\nC\u0003F\u001b\u0001\u0007!\u0007C\u0003H\u001b\u0001\u0007!'A\u000fsKN|GN^3U_BdUM\u001a;D_>\u0014Hm]!oIJ\u000bG/[8t)\rq\u0015K\u0015\t\u0007g=\u000b\u0015I\r\u001a\n\u0005A#$A\u0002+va2,G\u0007C\u0003F\u001d\u0001\u0007!\u0007C\u0003H\u001d\u0001\u0007!'A\u0006cS2Lg.Z1s\u0013:$H#B!V/f[\u0006\"\u0002,\u0010\u0001\u0004\t\u0015a\u00027fMR\u001cu\u000e\u001c\u0005\u00061>\u0001\r!Q\u0001\u0007i>\u0004(k\\<\t\u000bi{\u0001\u0019\u0001\u001a\u0002\ra\u0014\u0016\r^5p\u0011\u0015av\u00021\u00013\u0003\u0019I(+\u0019;j_\u0006q!-\u001b7j]\u0016\f'\u000fR8vE2,G#\u0002\u001a`A\u0006\u0014\u0007\"\u0002,\u0011\u0001\u0004\t\u0005\"\u0002-\u0011\u0001\u0004\t\u0005\"\u0002.\u0011\u0001\u0004\u0011\u0004\"\u0002/\u0011\u0001\u0004\u0011\u0014\u0001\u00032jY&tW-\u0019:\u0015\u000bI*gm\u001a5\t\u000bY\u000b\u0002\u0019A!\t\u000ba\u000b\u0002\u0019A!\t\u000bi\u000b\u0002\u0019\u0001\u001a\t\u000bq\u000b\u0002\u0019\u0001\u001a")
public class BilinearResample
extends Resample {
    private final Tile tile;
    private final double xmin;
    private final double xmax;
    private final double ymin;
    private final double ymax;

    private double xmin() {
        return this.xmin;
    }

    private double xmax() {
        return this.xmax;
    }

    private double ymin() {
        return this.ymin;
    }

    private double ymax() {
        return this.ymax;
    }

    @Override
    public int resampleValid(double x, double y) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.resolveTopLeftCoordsAndRatios(x, y);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int leftCol = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int topRow = BoxesRunTime.unboxToInt((Object)tuple4._2());
        double xRatio = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double yRatio = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftCol), (Object)BoxesRunTime.boxToInteger((int)topRow), (Object)BoxesRunTime.boxToDouble((double)xRatio), (Object)BoxesRunTime.boxToDouble((double)yRatio));
        Tuple4 tuple43 = tuple42;
        int leftCol2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int topRow2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        double xRatio2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double yRatio2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        return this.bilinearInt(leftCol2, topRow2, xRatio2, yRatio2);
    }

    @Override
    public double resampleDoubleValid(double x, double y) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.resolveTopLeftCoordsAndRatios(x, y);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int leftCol = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int topRow = BoxesRunTime.unboxToInt((Object)tuple4._2());
        double xRatio = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double yRatio = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftCol), (Object)BoxesRunTime.boxToInteger((int)topRow), (Object)BoxesRunTime.boxToDouble((double)xRatio), (Object)BoxesRunTime.boxToDouble((double)yRatio));
        Tuple4 tuple43 = tuple42;
        int leftCol2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int topRow2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        double xRatio2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double yRatio2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        return this.bilinearDouble(leftCol2, topRow2, xRatio2, yRatio2);
    }

    public Tuple4<Object, Object, Object, Object> resolveTopLeftCoordsAndRatios(double x, double y) {
        double xRatio;
        double dleft = x - this.xmin();
        double dright = this.xmax() - x;
        double dtop = this.ymax() - y;
        double dbottom = y - this.ymin();
        int leftCol = (int)package$.MODULE$.floor(dleft / this.cellwidth());
        int topRow = (int)package$.MODULE$.floor(dtop / this.cellheight());
        double d = dleft < 0.0 ? 1.0 : (xRatio = dright < 0.0 ? 0.0 : dleft / this.cellwidth() - (double)leftCol);
        double yRatio = dtop < 0.0 ? 1.0 : (dbottom < 0.0 ? 0.0 : dtop / this.cellheight() - (double)topRow);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftCol), (Object)BoxesRunTime.boxToInteger((int)topRow), (Object)BoxesRunTime.boxToDouble((double)xRatio), (Object)BoxesRunTime.boxToDouble((double)yRatio));
    }

    public int bilinearInt(int leftCol, int topRow, double xRatio, double yRatio) {
        double v = this.bilinear(leftCol, topRow, xRatio, yRatio);
        return !Double.isNaN(v) ? (int)package$.MODULE$.round(v) : Integer.MIN_VALUE;
    }

    public double bilinearDouble(int leftCol, int topRow, double xRatio, double yRatio) {
        return this.bilinear(leftCol, topRow, xRatio, yRatio);
    }

    private double bilinear(int leftCol, int topRow, double xRatio, double yRatio) {
        double accumDivisor;
        double accum;
        block5: {
            double z;
            double z2;
            double z3;
            double z4;
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(leftCol + 1, topRow + 1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int rightCol = sp2._1$mcI$sp();
            int bottomRow = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(rightCol, bottomRow);
            Tuple2.mcII.sp sp4 = sp3;
            int rightCol2 = sp4._1$mcI$sp();
            int bottomRow2 = sp4._2$mcI$sp();
            Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(1.0 - xRatio, 1.0 - yRatio);
            if (sp5 == null) {
                throw new MatchError((Object)sp5);
            }
            double invXR = sp5._1$mcD$sp();
            double invYR = sp5._2$mcD$sp();
            Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(invXR, invYR);
            Tuple2.mcDD.sp sp7 = sp6;
            double invXR2 = sp7._1$mcD$sp();
            double invYR2 = sp7._2$mcD$sp();
            accum = 0.0;
            accumDivisor = 0.0;
            if (leftCol >= 0 && topRow >= 0 && leftCol < this.cols() && topRow < this.rows() && !Double.isNaN(z4 = this.tile.getDouble(leftCol, topRow))) {
                double mult = invXR2 * invYR2;
                accumDivisor += mult;
                accum += z4 * mult;
            }
            if (rightCol2 >= 0 && topRow >= 0 && rightCol2 < this.cols() && topRow < this.rows() && !Double.isNaN(z3 = this.tile.getDouble(rightCol2, topRow))) {
                double mult = (1.0 - invXR2) * invYR2;
                accumDivisor += mult;
                accum += z3 * mult;
            }
            if (leftCol >= 0 && bottomRow2 >= 0 && leftCol < this.cols() && bottomRow2 < this.rows() && !Double.isNaN(z2 = this.tile.getDouble(leftCol, bottomRow2))) {
                double mult = invXR2 * (1.0 - invYR2);
                accumDivisor += mult;
                accum += z2 * mult;
            }
            if (rightCol2 < 0 || bottomRow2 < 0 || rightCol2 >= this.cols() || bottomRow2 >= this.rows() || Double.isNaN(z = this.tile.getDouble(rightCol2, bottomRow2))) break block5;
            double mult = (1.0 - invXR2) * (1.0 - invYR2);
            accumDivisor += mult;
            accum += z * mult;
        }
        return accum / accumDivisor;
    }

    public BilinearResample(Tile tile, Extent extent) {
        this.tile = tile;
        super(tile, extent);
        this.xmin = extent.xmin() + this.cellwidth() / 2.0;
        this.xmax = extent.xmax() - this.cellwidth() / 2.0;
        this.ymin = extent.ymin() + this.cellheight() / 2.0;
        this.ymax = extent.ymax() - this.cellheight() / 2.0;
    }
}

