/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.summary.polygonal;

import geotrellis.raster.Grid;
import geotrellis.raster.PixelIsArea$;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.raster.summary.GridVisitor;
import geotrellis.raster.summary.polygonal.NoIntersection$;
import geotrellis.raster.summary.polygonal.PolygonalSummaryResult;
import geotrellis.raster.summary.polygonal.Summary;
import geotrellis.util.GetComponent;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import scala.Function2;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction2;

public final class PolygonalSummary$ {
    public static PolygonalSummary$ MODULE$;
    private final Rasterizer.Options DefaultOptions;

    static {
        new PolygonalSummary$();
    }

    public final Rasterizer.Options DefaultOptions() {
        return this.DefaultOptions;
    }

    public <A extends Grid<Object>, R> PolygonalSummaryResult<R> apply(A raster, Geometry geometry, GridVisitor<A, R> gridVisitor, Rasterizer.Options options, GetComponent<A, RasterExtent> getRasterExtent) {
        PolygonalSummaryResult<Nothing$> polygonalSummaryResult;
        RasterExtent rasterExtent = (RasterExtent)getRasterExtent.get().apply(raster);
        Polygon rasterArea = rasterExtent.extent().toPolygon();
        if (rasterArea.disjoint(geometry)) {
            polygonalSummaryResult = NoIntersection$.MODULE$;
        } else {
            Geometry geometry2 = geometry;
            if (geometry2.getDimension() == 2 && rasterArea.coveredBy(geometry2)) {
                for (int index$macro$2 = 0; index$macro$2 < rasterExtent.cols(); ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < rasterExtent.rows(); ++index$macro$1) {
                        gridVisitor.visit(raster, index$macro$2, index$macro$1);
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Rasterizer$.MODULE$.foreachCellByGeometry(geometry, rasterExtent, options, (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & java.io.Serializable & Serializable)(col, row) -> gridVisitor.visit(raster, col, row));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            polygonalSummaryResult = new Summary<R>(gridVisitor.result());
        }
        return polygonalSummaryResult;
    }

    private PolygonalSummary$() {
        MODULE$ = this;
        this.DefaultOptions = new Rasterizer.Options(true, PixelIsArea$.MODULE$);
    }
}

