/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.triangulation;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.vector.Extent;
import geotrellis.vector.mesh.HalfEdgeTable;
import geotrellis.vector.mesh.IndexedPointSet;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.triangulation.TriangleMap;
import scala.Double$;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple4;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DelaunayRasterizer$ {
    public static DelaunayRasterizer$ MODULE$;

    static {
        new DelaunayRasterizer$();
    }

    public void rasterize(MutableArrayTile tile, RasterExtent re, TriangleMap triangleMap, HalfEdgeTable halfEdgeTable, IndexedPointSet pointSet) {
        double w = re.cellwidth();
        double h = re.cellheight();
        int cols = re.cols();
        int rows = re.rows();
        Extent extent = re.extent();
        if (extent == null) {
            throw new MatchError((Object)extent);
        }
        double exmin = extent.xmin();
        double eymin = extent.ymin();
        double exmax = extent.xmax();
        double eymax = extent.ymax();
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)exmin), (Object)BoxesRunTime.boxToDouble((double)eymin), (Object)BoxesRunTime.boxToDouble((double)exmax), (Object)BoxesRunTime.boxToDouble((double)eymax));
        Tuple4 tuple42 = tuple4;
        double exmin2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
        double eymin2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
        double exmax2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
        double eymax2 = BoxesRunTime.unboxToDouble((Object)tuple42._4());
        triangleMap.triangleEdges().foreach((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)e -> DelaunayRasterizer$.rasterizeTriangle$1(e, halfEdgeTable, pointSet, eymin2, h, eymax2, exmin2, w, exmax2, cols, rows, tile));
    }

    public Tile rasterizeDelaunayTriangulation(DelaunayTriangulation dt, RasterExtent re) {
        return this.rasterizeDelaunayTriangulation(dt, re, DoubleConstantNoDataCellType$.MODULE$);
    }

    public Tile rasterizeDelaunayTriangulation(DelaunayTriangulation dt, RasterExtent re, DataType cellType) {
        MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, re.cols(), re.rows());
        this.rasterizeDelaunayTriangulation(dt, re, tile);
        return tile;
    }

    public void rasterizeDelaunayTriangulation(DelaunayTriangulation dt, RasterExtent re, MutableArrayTile tile) {
        this.rasterize(tile, re, dt.triangleMap(), dt.halfEdgeTable(), (IndexedPointSet)dt.pointSet());
    }

    private static final void rasterizeTriangle$1(int tri, HalfEdgeTable halfEdgeTable$1, IndexedPointSet pointSet$1, double eymin$1, double h$1, double eymax$1, double exmin$1, double w$1, double exmax$1, int cols$1, int rows$1, MutableArrayTile tile$1) {
        int e1 = tri;
        int v1 = halfEdgeTable$1.getDest(e1);
        double v1x = pointSet$1.getX(v1);
        double v1y = pointSet$1.getY(v1);
        double v1z = pointSet$1.getZ(v1);
        double s1x = pointSet$1.getX(halfEdgeTable$1.getSrc(e1));
        double s1y = pointSet$1.getY(halfEdgeTable$1.getSrc(e1));
        int e2 = halfEdgeTable$1.getNext(tri);
        int v2 = halfEdgeTable$1.getDest(e2);
        double v2x = pointSet$1.getX(v2);
        double v2y = pointSet$1.getY(v2);
        double v2z = pointSet$1.getZ(v2);
        double s2x = pointSet$1.getX(halfEdgeTable$1.getSrc(e2));
        double s2y = pointSet$1.getY(halfEdgeTable$1.getSrc(e2));
        int e3 = halfEdgeTable$1.getNext(halfEdgeTable$1.getNext(tri));
        int v3 = halfEdgeTable$1.getDest(e3);
        double v3x = pointSet$1.getX(v3);
        double v3y = pointSet$1.getY(v3);
        double v3z = pointSet$1.getZ(v3);
        double s3x = pointSet$1.getX(halfEdgeTable$1.getSrc(e3));
        double s3y = pointSet$1.getY(halfEdgeTable$1.getSrc(e3));
        double determinant = (v2y - v3y) * (v1x - v3x) + (v3x - v2x) * (v1y - v3y);
        double ymin = package$.MODULE$.min(v1y, package$.MODULE$.min(v2y, v3y));
        double ymax = package$.MODULE$.max(v1y, package$.MODULE$.max(v2y, v3y));
        double scanrow0 = package$.MODULE$.max(package$.MODULE$.ceil((ymin - eymin$1) / h$1 - 0.5), 0.0);
        for (double scany = eymin$1 + scanrow0 * h$1 + h$1 / (double)2; scany <= eymax$1 && scany <= ymax; scany += h$1) {
            double xmin = Double$.MODULE$.MinValue();
            double xmax = Double.MAX_VALUE;
            if (s1y != v1y) {
                double t = (scany - v1y) / (s1y - v1y);
                double xAtY1 = v1x + t * (s1x - v1x);
                if (v1y < s1y) {
                    if (xmin < xAtY1) {
                        xmin = xAtY1;
                    }
                } else if (xAtY1 < xmax) {
                    xmax = xAtY1;
                }
            }
            if (s2y != v2y) {
                double t = (scany - v2y) / (s2y - v2y);
                double xAtY2 = v2x + t * (s2x - v2x);
                if (v2y < s2y) {
                    if (xmin < xAtY2) {
                        xmin = xAtY2;
                    }
                } else if (xAtY2 < xmax) {
                    xmax = xAtY2;
                }
            }
            if (s3y != v3y) {
                double t = (scany - v3y) / (s3y - v3y);
                double xAtY3 = v3x + t * (s3x - v3x);
                if (v3y < s3y) {
                    if (xmin < xAtY3) {
                        xmin = xAtY3;
                    }
                } else if (xAtY3 < xmax) {
                    xmax = xAtY3;
                }
            }
            double scancol0 = package$.MODULE$.max(package$.MODULE$.ceil((xmin - exmin$1) / w$1 - 0.5), 0.0);
            for (double scanx = exmin$1 + scancol0 * w$1 + w$1 / (double)2; scanx <= exmax$1 && scanx <= xmax; scanx += w$1) {
                int col = (int)((scanx - exmin$1) / w$1);
                int row = (int)((eymax$1 - scany) / h$1);
                if (0 > col || col >= cols$1 || 0 > row || row >= rows$1) continue;
                double lambda1 = ((v2y - v3y) * (scanx - v3x) + (v3x - v2x) * (scany - v3y)) / determinant;
                double lambda2 = ((v3y - v1y) * (scanx - v3x) + (v1x - v3x) * (scany - v3y)) / determinant;
                double lambda3 = 1.0 - lambda1 - lambda2;
                double z = lambda1 * v1z + lambda2 * v2z + lambda3 * v3z;
                tile$1.setDouble(col, row, z);
            }
        }
    }

    private DelaunayRasterizer$() {
        MODULE$ = this;
    }
}

