/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.viewshed;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ApproxViewshed$
implements Serializable {
    public static ApproxViewshed$ MODULE$;

    static {
        new ApproxViewshed$();
    }

    public Tile apply(Tile r, int col, int row) {
        return package$.MODULE$.withTileLocalMethods(r).localEqual(this.offsets(r, col, row));
    }

    public Tile offsets(Tile r, int startCol, int startRow) {
        int rows = BoxesRunTime.unboxToInt(r.rows());
        int cols = BoxesRunTime.unboxToInt(r.cols());
        if (startCol < 0 || startCol >= cols || startRow < 0 && startRow >= rows) {
            throw scala.sys.package$.MODULE$.error("Point indices out of bounds");
        }
        double k = r.getDouble(startCol, startRow);
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(DoubleConstantNoDataCellType$.MODULE$, cols, rows);
        tile.setDouble(startCol, startRow, k);
        int maxLayer = BoxesRunTime.unboxToInt((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{rows - startRow, cols - startCol, startRow + 1, startCol + 1})).max((Ordering)Ordering.Int$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), maxLayer).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)layer -> {
            for (int index$macro$1 = 0; index$macro$1 < 2 * layer; ++index$macro$1) {
                ApproxViewshed$.doY$1(startCol - layer + index$macro$1, startRow - layer, rows, cols, r, layer, tile, startRow, startCol, k);
                ApproxViewshed$.doY$1(startCol + layer - index$macro$1, startRow + layer, rows, cols, r, layer, tile, startRow, startCol, k);
                ApproxViewshed$.doX$1(startCol - layer, startRow + layer - index$macro$1, rows, cols, r, layer, tile, startCol, startRow, k);
                ApproxViewshed$.doX$1(startCol + layer, startRow - layer + index$macro$1, rows, cols, r, layer, tile, startCol, startRow, k);
            }
        });
        return tile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final void doY$1(int x, int y, int rows$1, int cols$1, Tile r$1, int layer$1, MutableArrayTile tile$1, int startRow$1, int startCol$1, double k$1) {
        block4: {
            if (y < 0 || y >= rows$1 || x < 0 || x >= cols$1) break block4;
            double z = r$1.getDouble(x, y);
            if (layer$1 == 1) {
                tile$1.setDouble(x, y, z);
            } else {
                double closestHeight;
                double xVal = scala.math.package$.MODULE$.abs(1.0 / (double)(startRow$1 - y)) * (double)(startCol$1 - x) + (double)x;
                int xInt = (int)xVal;
                double d = startRow$1 == y ? tile$1.getDouble(x, y - scala.math.package$.MODULE$.signum(y - startRow$1)) : (closestHeight = RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(xVal)) ? tile$1.getDouble(xInt, y - scala.math.package$.MODULE$.signum(y - startRow$1)) : ((double)(xInt + 1) - xVal) * tile$1.getDouble(xInt, y - scala.math.package$.MODULE$.signum(y - startRow$1)) + (xVal - (double)xInt) * tile$1.getDouble(xInt + 1, y - scala.math.package$.MODULE$.signum(y - startRow$1)));
                if (y > startRow$1) {
                    tile$1.setDouble(x, y, scala.math.package$.MODULE$.max(z, 1.0 / (double)(startRow$1 - (y - 1)) * (k$1 - closestHeight) + closestHeight));
                } else {
                    tile$1.setDouble(x, y, scala.math.package$.MODULE$.max(z, -1.0 / (double)(startRow$1 - (y + 1)) * (k$1 - closestHeight) + closestHeight));
                }
            }
        }
    }

    private static final void doX$1(int x, int y, int rows$1, int cols$1, Tile r$1, int layer$1, MutableArrayTile tile$1, int startCol$1, int startRow$1, double k$1) {
        block4: {
            if (y < 0 || y >= rows$1 || x < 0 || x >= cols$1) break block4;
            double z = r$1.getDouble(x, y);
            if (layer$1 == 1) {
                tile$1.setDouble(x, y, z);
            } else {
                double closestHeight;
                double yVal = scala.math.package$.MODULE$.abs(1.0 / (double)(startCol$1 - x)) * (double)(startRow$1 - y) + (double)y;
                int yInt = (int)yVal;
                double d = startCol$1 == x ? tile$1.getDouble(x - scala.math.package$.MODULE$.signum(x - startCol$1), y) : (closestHeight = RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(yVal)) ? tile$1.getDouble(x - scala.math.package$.MODULE$.signum(x - startCol$1), yInt) : ((double)(yInt + 1) - yVal) * tile$1.getDouble(x - scala.math.package$.MODULE$.signum(x - startCol$1), yInt) + (yVal - (double)yInt) * tile$1.getDouble(x - scala.math.package$.MODULE$.signum(x - startCol$1), yInt + 1));
                if (x > startCol$1) {
                    tile$1.setDouble(x, y, scala.math.package$.MODULE$.max(z, 1.0 / (double)(startCol$1 - (x - 1)) * (k$1 - closestHeight) + closestHeight));
                } else {
                    tile$1.setDouble(x, y, scala.math.package$.MODULE$.max(z, -1.0 / (double)(startCol$1 - (x + 1)) * (k$1 - closestHeight) + closestHeight));
                }
            }
        }
    }

    private ApproxViewshed$() {
        MODULE$ = this;
    }
}

