/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.viewshed;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.raster.viewshed.R2Viewshed;
import geotrellis.raster.viewshed.R2Viewshed$And$;
import geotrellis.raster.viewshed.R2Viewshed$Debug$;
import geotrellis.raster.viewshed.R2Viewshed$FromEast$;
import geotrellis.raster.viewshed.R2Viewshed$FromInside$;
import geotrellis.raster.viewshed.R2Viewshed$FromNorth$;
import geotrellis.raster.viewshed.R2Viewshed$FromSouth$;
import geotrellis.raster.viewshed.R2Viewshed$FromWest$;
import geotrellis.raster.viewshed.R2Viewshed$Or$;
import geotrellis.raster.viewshed.R2Viewshed$RayComparator$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction2;

public final class R2Viewshed$
implements scala.Serializable {
    public static R2Viewshed$ MODULE$;

    static {
        new R2Viewshed$();
    }

    public void nop(Map<R2Viewshed.From, ArrayBuffer<R2Viewshed.Ray>> b) {
    }

    public MutableArrayTile generateEmptyViewshedTile(int cols, int rows, int debug) {
        return debug == 0 ? ArrayTile$.MODULE$.empty(IntConstantNoDataCellType$.MODULE$, cols, rows) : IntArrayTile$.MODULE$.fill(debug, cols, rows);
    }

    public int generateEmptyViewshedTile$default$3() {
        return 0;
    }

    private double thetaToAlpha(R2Viewshed.From from, R2Viewshed.Ray[] rays, double theta) {
        double d;
        R2Viewshed.From from2 = from;
        if (R2Viewshed$FromInside$.MODULE$.equals(from2)) {
            d = -Math.PI;
        } else {
            int place;
            int index = Arrays.binarySearch((Object[])rays, new R2Viewshed.Ray(theta, Double.NaN), R2Viewshed$RayComparator$.MODULE$);
            double d2 = index >= 0 ? rays[index].alpha() : ((place = -1 - index) == rays.length ? (scala.math.package$.MODULE$.abs(((R2Viewshed.Ray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays)).last()).theta() - theta) < scala.math.package$.MODULE$.abs(((R2Viewshed.Ray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays)).head()).theta() - theta - Math.PI * 2) ? ((R2Viewshed.Ray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays)).last()).alpha() : ((R2Viewshed.Ray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays)).head()).alpha()) : (place == 0 ? (scala.math.package$.MODULE$.abs(((R2Viewshed.Ray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays)).head()).theta() - theta) < scala.math.package$.MODULE$.abs(((R2Viewshed.Ray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays)).last()).theta() - theta + Math.PI * 2) ? ((R2Viewshed.Ray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays)).head()).alpha() : ((R2Viewshed.Ray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays)).last()).alpha()) : (scala.math.package$.MODULE$.abs(rays[place - 1].theta() - theta) < scala.math.package$.MODULE$.abs(rays[place].theta() - theta) ? rays[place - 1].alpha() : rays[place].alpha())));
            d = d2;
        }
        return d;
    }

    private double downwardCurvature(double distance) {
        return (double)6378137 * (1.0 - scala.math.package$.MODULE$.cos(distance / (double)6378137));
    }

    public Tile apply(Tile elevationTile, int startCol, int startRow, R2Viewshed.AggregationOperator op, boolean scatter) {
        int cols = BoxesRunTime.unboxToInt(elevationTile.cols());
        int rows = BoxesRunTime.unboxToInt(elevationTile.rows());
        double viewHeight = elevationTile.getDouble(startCol, startRow);
        R2Viewshed.AggregationOperator aggregationOperator = op;
        MutableArrayTile mutableArrayTile = R2Viewshed$Or$.MODULE$.equals(aggregationOperator) ? ArrayTile$.MODULE$.empty(IntCellType$.MODULE$, cols, rows) : ArrayTile$.MODULE$.empty(IntConstantNoDataCellType$.MODULE$, cols, rows);
        MutableArrayTile viewshedTile = mutableArrayTile;
        Tile x$1 = elevationTile;
        MutableArrayTile x$2 = viewshedTile;
        int x$3 = startCol;
        int x$4 = startRow;
        double x$5 = viewHeight;
        R2Viewshed$FromInside$ x$6 = R2Viewshed$FromInside$.MODULE$;
        Object x$7 = null;
        Function1 & Serializable & scala.Serializable x$8 = (Function1 & Serializable & scala.Serializable)b -> {
            R2Viewshed$.MODULE$.nop((Map<R2Viewshed.From, ArrayBuffer<R2Viewshed.Ray>>)b);
            return BoxedUnit.UNIT;
        };
        double x$9 = 1.0;
        double x$10 = Double.POSITIVE_INFINITY;
        boolean x$11 = false;
        R2Viewshed.AggregationOperator x$12 = op;
        double x$13 = Double.NEGATIVE_INFINITY;
        double x$14 = 0.0;
        double x$15 = -1.0;
        boolean x$16 = scatter;
        double x$17 = this.compute$default$16();
        this.compute(x$1, x$2, x$3, x$4, x$5, x$6, null, (Function1<Map<R2Viewshed.From, ArrayBuffer<R2Viewshed.Ray>>, BoxedUnit>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$17, x$16);
        return viewshedTile;
    }

    public R2Viewshed.AggregationOperator apply$default$4() {
        return R2Viewshed$Or$.MODULE$;
    }

    public boolean apply$default$5() {
        return false;
    }

    public Tile compute(Tile elevationTile, MutableArrayTile viewshedTile, int startCol, int startRow, double viewHeight, R2Viewshed.From from, R2Viewshed.Ray[] rays, Function1<Map<R2Viewshed.From, ArrayBuffer<R2Viewshed.Ray>>, BoxedUnit> tileCallback, double resolution, double maxDistance, boolean curvature, R2Viewshed.AggregationOperator operator, double altitude, double cameraDirection, double cameraFOV, double epsilon, boolean scatter) {
        int cols = BoxesRunTime.unboxToInt(elevationTile.cols());
        int rows = BoxesRunTime.unboxToInt(elevationTile.rows());
        RasterExtent re = RasterExtent$.MODULE$.apply(new Extent(0.0, 0.0, (double)cols, (double)rows), cols, rows);
        boolean inTile = 0 <= startCol && startCol < cols && 0 <= startRow && startRow <= rows;
        double vx = scala.math.package$.MODULE$.cos(cameraDirection);
        double vy = scala.math.package$.MODULE$.sin(cameraDirection);
        DoubleRef alpha = DoubleRef.create((double)Double.NaN);
        ObjectRef direction = ObjectRef.create((Object)R2Viewshed$FromInside$.MODULE$);
        BooleanRef terminated = BooleanRef.create((boolean)false);
        Function4 & Serializable & scala.Serializable clip = (Function4 & Serializable & scala.Serializable)(x0, y0, x1, y1) -> R2Viewshed$.clipAndQualifyRay$1(from, BoxesRunTime.unboxToInt((Object)x0), BoxesRunTime.unboxToInt((Object)y0), BoxesRunTime.unboxToInt((Object)x1), BoxesRunTime.unboxToInt((Object)y1), cameraFOV, vx, vy, inTile, rows, cols);
        ArrayBuffer northRays = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer eastRays = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer southRays = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer westRays = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        R2Viewshed.DirectedSegment[] northSegs = (R2Viewshed.DirectedSegment[])((TraversableOnce)package$.MODULE$.Range().apply(0, cols).flatMap((Function1 & Serializable & scala.Serializable)col -> Option$.MODULE$.option2Iterable((Option)clip.apply((Object)BoxesRunTime.boxToInteger((int)startCol), (Object)BoxesRunTime.boxToInteger((int)startRow), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)col)), (Object)BoxesRunTime.boxToInteger((int)(rows - 1)))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(R2Viewshed.DirectedSegment.class));
        R2Viewshed.DirectedSegment[] southSegs = (R2Viewshed.DirectedSegment[])((TraversableOnce)package$.MODULE$.Range().apply(0, cols).flatMap((Function1 & Serializable & scala.Serializable)col -> Option$.MODULE$.option2Iterable((Option)clip.apply((Object)BoxesRunTime.boxToInteger((int)startCol), (Object)BoxesRunTime.boxToInteger((int)startRow), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)col)), (Object)BoxesRunTime.boxToInteger((int)0))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(R2Viewshed.DirectedSegment.class));
        R2Viewshed.DirectedSegment[] eastSegs = (R2Viewshed.DirectedSegment[])((TraversableOnce)package$.MODULE$.Range().apply(0, rows).flatMap((Function1 & Serializable & scala.Serializable)row -> Option$.MODULE$.option2Iterable((Option)clip.apply((Object)BoxesRunTime.boxToInteger((int)startCol), (Object)BoxesRunTime.boxToInteger((int)startRow), (Object)BoxesRunTime.boxToInteger((int)(cols - 1)), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)row)))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(R2Viewshed.DirectedSegment.class));
        R2Viewshed.DirectedSegment[] westSegs = (R2Viewshed.DirectedSegment[])((TraversableOnce)package$.MODULE$.Range().apply(0, rows).flatMap((Function1 & Serializable & scala.Serializable)row -> Option$.MODULE$.option2Iterable((Option)clip.apply((Object)BoxesRunTime.boxToInteger((int)startCol), (Object)BoxesRunTime.boxToInteger((int)startRow), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)row)))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(R2Viewshed.DirectedSegment.class));
        int i = 0;
        direction.elem = R2Viewshed$FromSouth$.MODULE$;
        for (i = 0; i < northSegs.length; ++i) {
            R2Viewshed.DirectedSegment seg = northSegs[i];
            alpha.elem = this.thetaToAlpha(from, rays, seg.theta());
            terminated.elem = false;
            Rasterizer$.MODULE$.foreachCellInGridLine(seg.x0(), seg.y0(), seg.x1(), seg.y1(), null, re, false, (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> this.callback$1(col, row, startCol, startRow, viewshedTile, terminated, resolution, curvature, elevationTile, viewHeight, altitude, maxDistance, alpha, operator, scatter, direction));
            Object object = !terminated.elem && !seg.isRumpSegment() ? southRays.$plus$eq((Object)new R2Viewshed.Ray(seg.theta(), alpha.elem)) : BoxedUnit.UNIT;
        }
        direction.elem = R2Viewshed$FromNorth$.MODULE$;
        for (i = 0; i < southSegs.length; ++i) {
            R2Viewshed.DirectedSegment seg = southSegs[i];
            alpha.elem = this.thetaToAlpha(from, rays, seg.theta());
            terminated.elem = false;
            Rasterizer$.MODULE$.foreachCellInGridLine(seg.x0(), seg.y0(), seg.x1(), seg.y1(), null, re, false, (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> this.callback$1(col, row, startCol, startRow, viewshedTile, terminated, resolution, curvature, elevationTile, viewHeight, altitude, maxDistance, alpha, operator, scatter, direction));
            Object object = !terminated.elem && !seg.isRumpSegment() ? northRays.$plus$eq((Object)new R2Viewshed.Ray(seg.theta(), alpha.elem)) : BoxedUnit.UNIT;
        }
        direction.elem = R2Viewshed$FromWest$.MODULE$;
        if (cols <= startCol && startCol <= 2 * cols && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])eastSegs)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isNearVertical(epsilon))) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])eastSegs)).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isRumpSegment()))) {
            for (i = 0; i < rows; ++i) {
                viewshedTile.set(cols - 1, i, viewshedTile.get(cols - 2, i));
            }
        } else {
            for (i = 0; i < eastSegs.length; ++i) {
                R2Viewshed.DirectedSegment seg = eastSegs[i];
                alpha.elem = this.thetaToAlpha(from, rays, seg.theta());
                terminated.elem = false;
                Rasterizer$.MODULE$.foreachCellInGridLine(seg.x0(), seg.y0(), seg.x1(), seg.y1(), null, re, false, (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> this.callback$1(col, row, startCol, startRow, viewshedTile, terminated, resolution, curvature, elevationTile, viewHeight, altitude, maxDistance, alpha, operator, scatter, direction));
                Object object = !terminated.elem && !seg.isRumpSegment() ? westRays.$plus$eq((Object)new R2Viewshed.Ray(seg.theta(), alpha.elem)) : BoxedUnit.UNIT;
            }
        }
        direction.elem = R2Viewshed$FromEast$.MODULE$;
        if (-1 * cols < startCol && startCol < 0 && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])westSegs)).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isNearVertical(epsilon))) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])westSegs)).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isRumpSegment()))) {
            for (i = 0; i < rows; ++i) {
                viewshedTile.set(0, i, viewshedTile.get(1, i));
            }
        } else {
            for (i = 0; i < westSegs.length; ++i) {
                R2Viewshed.DirectedSegment seg = westSegs[i];
                alpha.elem = this.thetaToAlpha(from, rays, seg.theta());
                terminated.elem = false;
                Rasterizer$.MODULE$.foreachCellInGridLine(seg.x0(), seg.y0(), seg.x1(), seg.y1(), null, re, false, (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> this.callback$1(col, row, startCol, startRow, viewshedTile, terminated, resolution, curvature, elevationTile, viewHeight, altitude, maxDistance, alpha, operator, scatter, direction));
                Object object = !terminated.elem && !seg.isRumpSegment() ? eastRays.$plus$eq((Object)new R2Viewshed.Ray(seg.theta(), alpha.elem)) : BoxedUnit.UNIT;
            }
        }
        if (rows <= startRow && startRow <= 2 * rows && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])northSegs)).forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isNearHorizontal(epsilon))) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])northSegs)).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isRumpSegment()))) {
            for (i = 0; i < cols; ++i) {
                viewshedTile.set(i, rows - 1, viewshedTile.get(i, rows - 2));
            }
        }
        if (-1 * rows < startRow && startRow < 0 && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])southSegs)).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isNearHorizontal(epsilon))) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])southSegs)).forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isRumpSegment()))) {
            for (i = 0; i < cols; ++i) {
                viewshedTile.set(i, 0, viewshedTile.get(i, 1));
            }
        }
        Map bundle = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)R2Viewshed$FromSouth$.MODULE$), (Object)southRays), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)R2Viewshed$FromWest$.MODULE$), (Object)westRays), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)R2Viewshed$FromNorth$.MODULE$), (Object)northRays), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)R2Viewshed$FromEast$.MODULE$), (Object)eastRays)}));
        tileCallback.apply((Object)bundle);
        return viewshedTile;
    }

    public double compute$default$13() {
        return Double.NEGATIVE_INFINITY;
    }

    public double compute$default$14() {
        return 0.0;
    }

    public double compute$default$15() {
        return -1.0;
    }

    public double compute$default$16() {
        return 0.3183098861837907;
    }

    public boolean compute$default$17() {
        return true;
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Option clipAndQualifyRay$1(R2Viewshed.From from, int x0, int y0, int x1, int y1, double cameraFOV$1, double vx$1, double vy$1, boolean inTile$1, int rows$1, int cols$1) {
        double _theta = scala.math.package$.MODULE$.atan2((double)(y1 - y0), (double)(x1 - x0));
        double theta = _theta >= 0.0 ? _theta : _theta + Math.PI * 2;
        double m = (double)(y0 - y1) / (double)(x0 - x1);
        boolean bl = false;
        R2Viewshed.From from2 = null;
        R2Viewshed.From from3 = from;
        if (-1.0 < cameraFOV$1 && cameraFOV$1 < 1.0 && vx$1 * scala.math.package$.MODULE$.cos(theta) + vy$1 * scala.math.package$.MODULE$.sin(theta) < cameraFOV$1) {
            return None$.MODULE$;
        }
        if (R2Viewshed$FromInside$.MODULE$.equals(from3)) {
            bl = true;
            from2 = from3;
            if (inTile$1) {
                return new Some((Object)new R2Viewshed.DirectedSegment(x0, y0, x1, y1, theta));
            }
        }
        if (bl && !inTile$1) {
            throw new Exception();
        }
        if (R2Viewshed$FromNorth$.MODULE$.equals(from3)) {
            int y2 = rows$1 - 1;
            int x2 = (int)scala.math.package$.MODULE$.round((double)(y2 - y1) / m + (double)x1);
            return 0 <= x2 && x2 < cols$1 && y2 <= y0 && -scala.math.package$.MODULE$.sin(theta) > 0.0 ? new Some((Object)new R2Viewshed.DirectedSegment(x2, y2, x1, y1, theta)) : None$.MODULE$;
        }
        if (R2Viewshed$FromEast$.MODULE$.equals(from3)) {
            int x2 = cols$1 - 1;
            int y2 = (int)scala.math.package$.MODULE$.round(m * (double)(x2 - x1) + (double)y1);
            return 0 <= y2 && y2 < rows$1 && x2 <= x0 && -scala.math.package$.MODULE$.cos(theta) > 0.0 ? new Some((Object)new R2Viewshed.DirectedSegment(x2, y2, x1, y1, theta)) : None$.MODULE$;
        }
        if (R2Viewshed$FromSouth$.MODULE$.equals(from3)) {
            int y2 = 0;
            int x2 = (int)scala.math.package$.MODULE$.round((double)(y2 - y1) / m + (double)x1);
            return 0 <= x2 && x2 < cols$1 && y2 >= y0 && scala.math.package$.MODULE$.sin(theta) > 0.0 ? new Some((Object)new R2Viewshed.DirectedSegment(x2, y2, x1, y1, theta)) : None$.MODULE$;
        }
        if (!R2Viewshed$FromWest$.MODULE$.equals(from3)) throw new MatchError((Object)from3);
        int x2 = 0;
        int y2 = (int)scala.math.package$.MODULE$.round(m * (double)(x2 - x1) + (double)y1);
        return 0 <= y2 && y2 < rows$1 && x2 >= x0 && scala.math.package$.MODULE$.cos(theta) > 0.0 ? new Some((Object)new R2Viewshed.DirectedSegment(x2, y2, x1, y1, theta)) : None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void callback$1(int col, int row, int startCol$1, int startRow$1, MutableArrayTile viewshedTile$1, BooleanRef terminated$1, double resolution$1, boolean curvature$1, Tile elevationTile$1, double viewHeight$1, double altitude$1, double maxDistance$1, DoubleRef alpha$1, R2Viewshed.AggregationOperator operator$1, boolean scatter$1, ObjectRef direction$1) {
        double angle;
        if (col == startCol$1 && row == startRow$1) {
            viewshedTile$1.setDouble(col, row, 1.0);
            return;
        }
        if (terminated$1.elem) return;
        int deltax = startCol$1 - col;
        int deltay = startRow$1 - row;
        double distance = scala.math.package$.MODULE$.sqrt((double)(deltax * deltax + deltay * deltay)) * resolution$1;
        double drop = curvature$1 ? this.downwardCurvature(distance) : 0.0;
        double elevation = elevationTile$1.getDouble(col, row) - drop - viewHeight$1;
        double groundAngle = scala.math.package$.MODULE$.atan(elevation / distance);
        double d = angle = altitude$1 == Double.NEGATIVE_INFINITY ? groundAngle : scala.math.package$.MODULE$.atan((altitude$1 - drop - viewHeight$1) / distance);
        if (distance >= maxDistance$1) {
            terminated$1.elem = true;
        }
        if (terminated$1.elem) return;
        boolean groundVisible = alpha$1.elem <= groundAngle;
        boolean visible = alpha$1.elem <= angle;
        int current = viewshedTile$1.get(col, row);
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
        if (groundVisible) {
            alpha$1.elem = groundAngle;
        }
        boolean bl = false;
        R2Viewshed.AggregationOperator aggregationOperator = null;
        boolean bl2 = false;
        R2Viewshed.AggregationOperator aggregationOperator2 = null;
        R2Viewshed.AggregationOperator aggregationOperator3 = operator$1;
        if (R2Viewshed$Or$.MODULE$.equals(aggregationOperator3) && visible) {
            BoxedUnit boxedUnit;
            viewshedTile$1.set(col, row, 1);
            if (scatter$1) {
                R2Viewshed.From from = (R2Viewshed.From)direction$1.elem;
                boolean bl3 = R2Viewshed$FromNorth$.MODULE$.equals(from) ? true : R2Viewshed$FromSouth$.MODULE$.equals(from);
                if (bl3) {
                    BoxedUnit boxedUnit2;
                    if (col - 1 >= 0) {
                        double angle2;
                        double elevation2 = elevationTile$1.getDouble(col - 1, row) - drop - viewHeight$1;
                        double groundAngle2 = scala.math.package$.MODULE$.atan(elevation2 / distance);
                        double d2 = angle2 = altitude$1 == Double.NEGATIVE_INFINITY ? groundAngle2 : scala.math.package$.MODULE$.atan((altitude$1 - drop - viewHeight$1) / distance);
                        if (alpha$1.elem <= angle2) {
                            viewshedTile$1.set(col - 1, row, 1);
                        }
                    }
                    if (col + 1 < BoxesRunTime.unboxToInt(viewshedTile$1.cols()) && col + 1 < BoxesRunTime.unboxToInt(elevationTile$1.cols())) {
                        double angle3;
                        double elevation3 = elevationTile$1.getDouble(col + 1, row) - drop - viewHeight$1;
                        double groundAngle3 = scala.math.package$.MODULE$.atan(elevation3 / distance);
                        double d3 = angle3 = altitude$1 == Double.NEGATIVE_INFINITY ? groundAngle3 : scala.math.package$.MODULE$.atan((altitude$1 - drop - viewHeight$1) / distance);
                        if (alpha$1.elem <= angle3) {
                            viewshedTile$1.set(col + 1, row, 1);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                } else {
                    boolean bl4 = R2Viewshed$FromEast$.MODULE$.equals(from) ? true : R2Viewshed$FromWest$.MODULE$.equals(from);
                    if (bl4) {
                        BoxedUnit boxedUnit4;
                        if (row - 1 >= 0) {
                            double angle4;
                            double elevation4 = elevationTile$1.getDouble(col, row - 1) - drop - viewHeight$1;
                            double groundAngle4 = scala.math.package$.MODULE$.atan(elevation4 / distance);
                            double d4 = angle4 = altitude$1 == Double.NEGATIVE_INFINITY ? groundAngle4 : scala.math.package$.MODULE$.atan((altitude$1 - drop - viewHeight$1) / distance);
                            if (alpha$1.elem <= angle4) {
                                viewshedTile$1.set(col, row - 1, 1);
                            }
                        }
                        if (row + 1 < BoxesRunTime.unboxToInt(viewshedTile$1.rows()) && row + 1 < BoxesRunTime.unboxToInt(elevationTile$1.cols())) {
                            double angle5;
                            double elevation5 = elevationTile$1.getDouble(col, row + 1) - drop - viewHeight$1;
                            double groundAngle5 = scala.math.package$.MODULE$.atan(elevation5 / distance);
                            double d5 = angle5 = altitude$1 == Double.NEGATIVE_INFINITY ? groundAngle5 : scala.math.package$.MODULE$.atan((altitude$1 - drop - viewHeight$1) / distance);
                            if (alpha$1.elem <= angle5) {
                                viewshedTile$1.set(col, row + 1, 1);
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit5 = boxedUnit4;
                    } else {
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
            return;
        }
        if (R2Viewshed$And$.MODULE$.equals(aggregationOperator3)) {
            bl = true;
            aggregationOperator = aggregationOperator3;
            if (!visible) {
                viewshedTile$1.set(col, row, 0);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && visible && current == Integer.MIN_VALUE) {
            viewshedTile$1.set(col, row, 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (R2Viewshed$Debug$.MODULE$.equals(aggregationOperator3)) {
            bl2 = true;
            aggregationOperator2 = aggregationOperator3;
            if (visible && current == Integer.MIN_VALUE) {
                viewshedTile$1.set(col, row, 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl2 && visible && current != Integer.MIN_VALUE) {
            viewshedTile$1.set(col, row, 1 + current);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private R2Viewshed$() {
        MODULE$ = this;
    }
}

