/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import geotrellis.proj4.CRS;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff$;
import geotrellis.spark.store.s3.GeoTiffS3InputFormat$;
import geotrellis.spark.store.s3.S3RecordReader;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.services.s3.S3Client;

@ScalaSignature(bytes="\u0006\u0005\u001d4A!\u0002\u0004\u0001\u001f!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0005U9Um\u001c+jM\u001a\u001c6GU3d_J$'+Z1eKJT!a\u0002\u0005\u0002\u0005M\u001c$BA\u0005\u000b\u0003\u0015\u0019Ho\u001c:f\u0015\tYA\"A\u0003ta\u0006\u00148NC\u0001\u000e\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0003\u0012%QQR\"\u0001\u0004\n\u0005M1!AD*4%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\t\u0003+ai\u0011A\u0006\u0006\u0003/1\taA^3di>\u0014\u0018BA\r\u0017\u0005=\u0001&o\u001c6fGR,G-\u0012=uK:$\bCA\u000e\u001f\u001b\u0005a\"BA\u000f\r\u0003\u0019\u0011\u0018m\u001d;fe&\u0011q\u0004\b\u0002\u0005)&dW-\u0001\u0005tg\rc\u0017.\u001a8u!\t\u0011C&D\u0001$\u0015\t9AE\u0003\u0002&M\u0005A1/\u001a:wS\u000e,7O\u0003\u0002(Q\u00051\u0011m^:tI.T!!\u000b\u0016\u0002\r\u0005l\u0017M_8o\u0015\u0005Y\u0013\u0001C:pMR<\u0018M]3\n\u00055\u001a#\u0001C*4\u00072LWM\u001c;\u0002\u000f\r|g\u000e^3yiB\u0011\u0001'O\u0007\u0002c)\u0011!gM\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!\u0001N\u001b\u0002\r!\fGm\\8q\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\n\u0005i\n$A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqR\fa\u0001P5oSRtDcA\u001f?\u007fA\u0011\u0011\u0003\u0001\u0005\u0006A\r\u0001\r!\t\u0005\u0006]\r\u0001\raL\u0001\u0005e\u0016\fG\rF\u0002C\u0011V\u0003Ba\u0011$\u001555\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004UkBdWM\r\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u0004W\u0016L\bCA&S\u001d\ta\u0005\u000b\u0005\u0002N\t6\taJ\u0003\u0002P\u001d\u00051AH]8pizJ!!\u0015#\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#\u0012CQA\u0016\u0003A\u0002]\u000bQAY=uKN\u00042a\u0011-[\u0013\tIFIA\u0003BeJ\f\u0017\u0010\u0005\u0002D7&\u0011A\f\u0012\u0002\u0005\u0005f$X\r\u000b\u0004\u0001=\u0006\u0014G-\u001a\t\u0003\u0007~K!\u0001\u0019#\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0003\r\fQhR3p)&4gmU\u001aSK\u000e|'\u000f\u001a*fC\u0012,'\u000fI5tA\u0011,\u0007O]3dCR,G\r\f\u0011vg\u0016\u00043kM$f_RKgM\u001a*E\t\u0002Jgn\u001d;fC\u0012\fQa]5oG\u0016\f\u0013AZ\u0001\u0006c9\u0002d\u0006\r")
public class GeoTiffS3RecordReader
extends S3RecordReader<ProjectedExtent, Tile> {
    private final TaskAttemptContext context;

    @Override
    public Tuple2<ProjectedExtent, Tile> read(String key, byte[] bytes) {
        CRS crs;
        Raster raster;
        Option<CRS> inputCrs;
        block3: {
            ProjectedRaster projectedRaster;
            block2: {
                SinglebandGeoTiff geoTiff = SinglebandGeoTiff$.MODULE$.apply(bytes);
                inputCrs = GeoTiffS3InputFormat$.MODULE$.getCrs((JobContext)this.context);
                projectedRaster = geoTiff.projectedRaster();
                if (projectedRaster == null) break block2;
                raster = projectedRaster.raster();
                crs = projectedRaster.crs();
                if (raster != null) break block3;
            }
            throw new MatchError((Object)projectedRaster);
        }
        Tile tile = (Tile)raster.tile();
        Extent extent = raster.extent();
        Tuple3 tuple3 = new Tuple3((Object)tile, (Object)extent, (Object)crs);
        Tile tile2 = (Tile)tuple3._1();
        Extent extent2 = (Extent)tuple3._2();
        CRS crs2 = (CRS)tuple3._3();
        return new Tuple2((Object)new ProjectedExtent(extent2, (CRS)inputCrs.getOrElse((Function0 & Serializable)() -> crs2)), (Object)tile2);
    }

    public GeoTiffS3RecordReader(S3Client s3Client, TaskAttemptContext context) {
        this.context = context;
        super(s3Client);
    }
}

