/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import geotrellis.raster.io.geotiff.GeoTiffSegmentLayoutTransform;
import geotrellis.raster.io.geotiff.reader.GeoTiffInfo;
import geotrellis.raster.io.geotiff.reader.GeoTiffInfo$;
import geotrellis.spark.store.GeoTiffInfoReader;
import geotrellis.spark.store.RasterReader;
import geotrellis.spark.store.s3.S3GeoTiffInfoReader$;
import geotrellis.spark.store.s3.S3GeoTiffRDD;
import geotrellis.store.s3.AmazonS3URI;
import geotrellis.store.s3.package;
import geotrellis.store.s3.package$;
import geotrellis.store.s3.util.S3RangeReader;
import geotrellis.store.s3.util.S3RangeReader$;
import geotrellis.util.ByteReader;
import geotrellis.util.RangeReader;
import geotrellis.util.RangeReader$;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\u000b\u0017\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\to\u0001\u0011\t\u0011)A\u0005Y!A\u0001\b\u0001BC\u0002\u0013\u00051\u0006\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003-\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001\u0002\u0014\u0001\u0003\u0002\u0013\u0006I!\u0014\u0005\u0006;\u0002!\tA\u0018\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006u\u0002!\ta_\u0004\b\u0003+1\u0002\u0012AA\f\r\u0019)b\u0003#\u0001\u0002\u001a!1Q,\u0004C\u0001\u0003SAq!a\u000b\u000e\t\u0003\ti\u0003C\u0005\u0002F5\t\n\u0011\"\u0001\u0002H!I\u0011QL\u0007\u0012\u0002\u0013\u0005\u0011q\f\u0005\n\u0003Gj\u0011\u0013!C\u0001\u0003KB\u0011\"!\u001b\u000e#\u0003%\t!a\u001b\t\u0013\u0005=T\"!A\u0005\n\u0005E$aE*4\u000f\u0016|G+\u001b4g\u0013:4wNU3bI\u0016\u0014(BA\f\u0019\u0003\t\u00198G\u0003\u0002\u001a5\u0005)1\u000f^8sK*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0002;\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9\u0003&D\u0001\u0019\u0013\tI\u0003DA\tHK>$\u0016N\u001a4J]\u001a|'+Z1eKJ\faAY;dW\u0016$X#\u0001\u0017\u0011\u00055\"dB\u0001\u00183!\ty#%D\u00011\u0015\t\td$\u0001\u0004=e>|GOP\u0005\u0003g\t\na\u0001\u0015:fI\u00164\u0017BA\u001b7\u0005\u0019\u0019FO]5oO*\u00111GI\u0001\bEV\u001c7.\u001a;!\u0003\u0019\u0001(/\u001a4jq\u00069\u0001O]3gSb\u0004\u0013!\u00033fY&l\u0017\u000e^3s!\r\tC\bL\u0005\u0003{\t\u0012aa\u00149uS>t\u0017!C:ue\u0016\fW.\u001b8h!\t\t\u0003)\u0003\u0002BE\t9!i\\8mK\u0006t\u0017A\u0004;jM\u001a,\u0005\u0010^3og&|gn\u001d\t\u0004\t&ccBA#H\u001d\tyc)C\u0001$\u0013\tA%%A\u0004qC\u000e\\\u0017mZ3\n\u0005)[%aA*fc*\u0011\u0001JI\u0001\tgN\u001aE.[3oiB\u0019\u0011E\u0014)\n\u0005=\u0013#\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0005E[V\"\u0001*\u000b\u0005]\u0019&B\u0001+V\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001,X\u0003\u0019\two]:eW*\u0011\u0001,W\u0001\u0007C6\f'p\u001c8\u000b\u0003i\u000b\u0001b]8gi^\f'/Z\u0005\u00039J\u0013\u0001bU\u001aDY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f}\u000b'm\u00193fMB\u0011\u0001\rA\u0007\u0002-!)!&\u0003a\u0001Y!)\u0001(\u0003a\u0001Y!9!(\u0003I\u0001\u0002\u0004Y\u0004b\u0002 \n!\u0003\u0005\ra\u0010\u0005\b\u0005&\u0001\n\u00111\u0001D\u0011\u001da\u0015\u0002%CA\u00025\u000babZ3p)&4g-\u00138g_J#E\t\u0006\u0002jiB\u0019!N\u001d\u0017\u000e\u0003-T!\u0001\\7\u0002\u0007I$GM\u0003\u0002\u001c]*\u0011q\u000e]\u0001\u0007CB\f7\r[3\u000b\u0003E\f1a\u001c:h\u0013\t\u00198NA\u0002S\t\u0012CQ!\u001e\u0006A\u0004Y\f!a]2\u0011\u0005]DX\"A7\n\u0005el'\u0001D*qCJ\\7i\u001c8uKb$\u0018AD4fi\u001e+w\u000eV5gM&sgm\u001c\u000b\u0004y\u0006E\u0001cA?\u0002\u000e5\taPC\u0002\u0000\u0003\u0003\taA]3bI\u0016\u0014(\u0002BA\u0002\u0003\u000b\tqaZ3pi&4gM\u0003\u0003\u0002\b\u0005%\u0011AA5p\u0015\r\tY\u0001H\u0001\u0007e\u0006\u001cH/\u001a:\n\u0007\u0005=aPA\u0006HK>$\u0016N\u001a4J]\u001a|\u0007BBA\n\u0017\u0001\u0007A&A\u0002ve&\f1cU\u001aHK>$\u0016N\u001a4J]\u001a|'+Z1eKJ\u0004\"\u0001Y\u0007\u0014\t5\u0001\u00131\u0004\t\u0005\u0003;\t)#\u0004\u0002\u0002 )!\u0011qAA\u0011\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003?\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u0006\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f}\u000by#!\r\u00024!)!f\u0004a\u0001Y!)\u0001h\u0004a\u0001Y!9\u0011QG\bA\u0002\u0005]\u0012aB8qi&|gn\u001d\t\u0005\u0003s\tyDD\u0002a\u0003wI1!!\u0010\u0017\u00031\u00196gR3p)&4gM\u0015#E\u0013\u0011\t\t%a\u0011\u0003\u000f=\u0003H/[8og*\u0019\u0011Q\b\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tIEK\u0002<\u0003\u0017Z#!!\u0014\u0011\t\u0005=\u0013\u0011L\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/\u0012\u0013AC1o]>$\u0018\r^5p]&!\u00111LA)\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0005$fA \u0002L\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!a\u001a+\u0007\r\u000bY%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003[R3\u0001UA&\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\u0011\tI(!\t\u0002\t1\fgnZ\u0005\u0005\u0003{\n9H\u0001\u0004PE*,7\r\u001e")
public class S3GeoTiffInfoReader
implements GeoTiffInfoReader {
    private final String bucket;
    private final String prefix;
    private final Option<String> delimiter;
    private final boolean streaming;
    private final Seq<String> tiffExtensions;
    private final Function0<S3Client> s3Client;
    private transient Logger geotrellis$spark$store$GeoTiffInfoReader$$logger;
    private volatile transient boolean bitmap$trans$0;

    public static S3Client $lessinit$greater$default$6() {
        return S3GeoTiffInfoReader$.MODULE$.$lessinit$greater$default$6();
    }

    public static Seq<String> $lessinit$greater$default$5() {
        return S3GeoTiffInfoReader$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return S3GeoTiffInfoReader$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return S3GeoTiffInfoReader$.MODULE$.$lessinit$greater$default$3();
    }

    public static S3GeoTiffInfoReader apply(String bucket, String prefix, S3GeoTiffRDD.Options options) {
        return S3GeoTiffInfoReader$.MODULE$.apply(bucket, prefix, options);
    }

    public GeoTiffSegmentLayoutTransform getSegmentLayoutTransform(GeoTiffInfo geoTiffInfo) {
        return GeoTiffInfoReader.getSegmentLayoutTransform$((GeoTiffInfoReader)this, (GeoTiffInfo)geoTiffInfo);
    }

    public <O, I, K, V> RDD<Tuple2<K, V>> readWindows(RDD<URI> files, Function2<URI, I, K> uriToKey, int maxSize, long partitionBytes, O rasterReaderOptions, Option<Geometry> geometry, SparkContext sc, RasterReader<O, Tuple2<I, V>> rr) {
        return GeoTiffInfoReader.readWindows$((GeoTiffInfoReader)this, files, uriToKey, (int)maxSize, (long)partitionBytes, rasterReaderOptions, geometry, (SparkContext)sc, rr);
    }

    private Logger geotrellis$spark$store$GeoTiffInfoReader$$logger$lzycompute() {
        S3GeoTiffInfoReader s3GeoTiffInfoReader = this;
        synchronized (s3GeoTiffInfoReader) {
            if (!this.bitmap$trans$0) {
                this.geotrellis$spark$store$GeoTiffInfoReader$$logger = GeoTiffInfoReader.geotrellis$spark$store$GeoTiffInfoReader$$logger$((GeoTiffInfoReader)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.geotrellis$spark$store$GeoTiffInfoReader$$logger;
    }

    public Logger geotrellis$spark$store$GeoTiffInfoReader$$logger() {
        if (!this.bitmap$trans$0) {
            return this.geotrellis$spark$store$GeoTiffInfoReader$$logger$lzycompute();
        }
        return this.geotrellis$spark$store$GeoTiffInfoReader$$logger;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public RDD<String> geoTiffInfoRDD(SparkContext sc) {
        ListObjectsV2Request listObjectsV2Request;
        Option<String> option = this.delimiter;
        if (option instanceof Some) {
            Some some = (Some)option;
            String d = (String)some.value();
            listObjectsV2Request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(this.prefix()).delimiter(d).build();
        } else if (None$.MODULE$.equals(option)) {
            listObjectsV2Request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(this.prefix()).build();
        } else {
            throw new MatchError(option);
        }
        ListObjectsV2Request listObjectsRequest = listObjectsV2Request;
        Buffer s3objects = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((S3Client)this.s3Client.apply()).listObjectsV2(listObjectsRequest).contents()).asScala();
        Buffer s3keys = (Buffer)s3objects.map((Function1 & Serializable)x$1 -> x$1.key());
        return sc.parallelize(s3keys.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)).flatMap((Function1 & Serializable)key -> {
            if ($this.tiffExtensions.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)key.endsWith(x$1)))) {
                return new Some((Object)new StringBuilder(6).append("s3://").append(this.bucket()).append("/").append((String)key).toString());
            }
            return None$.MODULE$;
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public GeoTiffInfo getGeoTiffInfo(String uri) {
        AmazonS3URI s3Uri = new AmazonS3URI(uri);
        String bucket = s3Uri.getBucket();
        String key = s3Uri.getKey();
        String ovrKey = new StringBuilder(4).append(s3Uri.getKey()).append(".ovr").toString();
        None$ ovrReader = package.S3ClientExtension$.MODULE$.objectExists$extension(package$.MODULE$.S3ClientExtension((S3Client)this.s3Client.apply()), bucket, ovrKey) ? new Some((Object)RangeReader$.MODULE$.rangeReaderToStreamingByteReader((RangeReader)S3RangeReader$.MODULE$.apply(bucket, ovrKey, (S3Client)this.s3Client.apply()))) : None$.MODULE$;
        S3RangeReader s3rr = S3RangeReader$.MODULE$.apply(bucket, key, (S3Client)this.s3Client.apply());
        return GeoTiffInfo$.MODULE$.read((ByteReader)RangeReader$.MODULE$.rangeReaderToStreamingByteReader((RangeReader)s3rr), this.streaming, true, (Option)ovrReader);
    }

    public S3GeoTiffInfoReader(String bucket, String prefix, Option<String> delimiter, boolean streaming, Seq<String> tiffExtensions, Function0<S3Client> s3Client) {
        this.bucket = bucket;
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.streaming = streaming;
        this.tiffExtensions = tiffExtensions;
        this.s3Client = s3Client;
        GeoTiffInfoReader.$init$((GeoTiffInfoReader)this);
    }
}

