/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Tile;
import geotrellis.spark.store.RasterReader;
import geotrellis.spark.store.RasterReader$;
import geotrellis.spark.store.s3.BytesS3InputFormat;
import geotrellis.spark.store.s3.S3GeoTiffInfoReader;
import geotrellis.spark.store.s3.S3GeoTiffInfoReader$;
import geotrellis.spark.store.s3.S3GeoTiffRDD;
import geotrellis.spark.store.s3.S3GeoTiffRDD$Options$;
import geotrellis.spark.store.s3.S3InputFormat$;
import geotrellis.util.ByteReader$;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class S3GeoTiffRDD$ {
    public static final S3GeoTiffRDD$ MODULE$ = new S3GeoTiffRDD$();
    private static transient Logger logger;
    private static final int geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultMaxTileSize;
    private static final long geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultPartitionBytes;
    private static volatile transient boolean bitmap$trans$0;

    static {
        geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultMaxTileSize = 256;
        geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultPartitionBytes = 0x8000000L;
    }

    public final String GEOTIFF_TIME_TAG_DEFAULT() {
        return "TIFFTAG_DATETIME";
    }

    public final String GEOTIFF_TIME_FORMAT_DEFAULT() {
        return "yyyy:MM:dd HH:mm:ss";
    }

    private Logger logger$lzycompute() {
        S3GeoTiffRDD$ s3GeoTiffRDD$ = this;
        synchronized (s3GeoTiffRDD$) {
            if (!bitmap$trans$0) {
                logger = LoggerFactory.getLogger((String)"geotrellis.spark.store.s3.S3GeoTiffRDD");
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    private Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public int geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultMaxTileSize() {
        return geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultMaxTileSize;
    }

    public long geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultPartitionBytes() {
        return geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultPartitionBytes;
    }

    private Configuration configuration(String bucket, String prefix, S3GeoTiffRDD.Options options, SparkContext sc) {
        if (options.numPartitions().isDefined() && options.partitionBytes().isDefined()) {
            this.logger().warn("Both numPartitions and partitionBytes options are set. Only numPartitions would be passed into hadoop configuration.");
        }
        Configuration conf = sc.hadoopConfiguration();
        S3InputFormat$.MODULE$.setBucket(conf, bucket);
        S3InputFormat$.MODULE$.setPrefix(conf, prefix);
        S3InputFormat$.MODULE$.setExtensions(conf, options.tiffExtensions());
        S3InputFormat$.MODULE$.setCreateS3Client(conf, options.getClient());
        options.numPartitions().fold((Function0)(JFunction0.mcV.sp & Serializable)() -> S3InputFormat$.MODULE$.removePartitionCount(conf), (Function1)(JFunction1.mcVI.sp & Serializable)n -> {
            S3InputFormat$.MODULE$.setPartitionCount(conf, n);
            S3InputFormat$.MODULE$.removePartitionBytes(conf);
        });
        Object object = options.numPartitions().isEmpty() ? options.partitionBytes().fold((Function0)(JFunction0.mcV.sp & Serializable)() -> S3InputFormat$.MODULE$.removePartitionBytes(conf), (Function1)(JFunction1.mcVJ.sp & Serializable)x$1 -> S3InputFormat$.MODULE$.setPartitionBytes(conf, x$1)) : BoxedUnit.UNIT;
        options.delimiter().fold((Function0)(JFunction0.mcV.sp & Serializable)() -> S3InputFormat$.MODULE$.removeDelimiter(conf), (Function1 & Serializable)x$2 -> {
            S3InputFormat$.MODULE$.setDelimiter(conf, x$2);
            return BoxedUnit.UNIT;
        });
        return conf;
    }

    public <I, K, V> RDD<Tuple2<K, V>> apply(String bucket, String prefix, Function2<URI, I, K> uriToKey, S3GeoTiffRDD.Options options, Option<Geometry> geometry, SparkContext sc, RasterReader<S3GeoTiffRDD.Options, Tuple2<I, V>> rr) {
        Option<Object> option = options.maxTileSize();
        if (option instanceof Some) {
            Some some = (Some)option;
            int maxTileSize = BoxesRunTime.unboxToInt((Object)some.value());
            if (options.numPartitions().isDefined()) {
                this.logger().warn("numPartitions option is ignored");
            }
            S3GeoTiffInfoReader infoReader = S3GeoTiffInfoReader$.MODULE$.apply(bucket, prefix, options);
            return infoReader.readWindows((RDD<URI>)infoReader.geoTiffInfoRDD(sc).map((Function1 & Serializable)x$3 -> new URI((String)x$3), ClassTag$.MODULE$.apply(URI.class)), uriToKey, maxTileSize, BoxesRunTime.unboxToLong((Object)options.partitionBytes().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.geotrellis$spark$store$s3$S3GeoTiffRDD$$DefaultPartitionBytes())), options, geometry, sc, rr);
        }
        if (None$.MODULE$.equals(option)) {
            return sc.newAPIHadoopRDD(this.configuration(bucket, prefix, options, sc), BytesS3InputFormat.class, String.class, byte[].class).mapPartitions((Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    byte[] bytes = (byte[])tuple2._2();
                    Tuple2 tuple22 = (Tuple2)rr.readFully(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), (Object)options);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object k = tuple22._1();
                    Object v = tuple22._2();
                    Tuple2 tuple23 = new Tuple2(k, v);
                    Object k2 = tuple23._1();
                    Object v2 = tuple23._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(uriToKey.apply((Object)new URI(key), k2)), v2);
                }
                throw new MatchError((Object)tuple2);
            }), true, ClassTag$.MODULE$.apply(Tuple2.class));
        }
        throw new MatchError(option);
    }

    public <I, K, V> RDD<Tuple2<K, V>> apply(String bucket, String prefix, Function2<URI, I, K> uriToKey, S3GeoTiffRDD.Options options, SparkContext sc, RasterReader<S3GeoTiffRDD.Options, Tuple2<I, V>> rr) {
        return this.apply(bucket, prefix, uriToKey, options, (Option<Geometry>)None$.MODULE$, sc, rr);
    }

    public <K, V> RDD<Tuple2<K, V>> apply(String bucket, String prefix, S3GeoTiffRDD.Options options, SparkContext sc, RasterReader<S3GeoTiffRDD.Options, Tuple2<K, V>> rr) {
        return this.apply(bucket, prefix, (Function2 & Serializable)(x$6, key) -> key, options, sc, rr);
    }

    public <I, K> RDD<Tuple2<K, Tile>> singleband(String bucket, String prefix, Function2<URI, I, K> uriToKey, S3GeoTiffRDD.Options options, SparkContext sc, RasterReader<S3GeoTiffRDD.Options, Tuple2<I, Tile>> rr) {
        return this.apply(bucket, prefix, uriToKey, options, sc, rr);
    }

    public <K> RDD<Tuple2<K, Tile>> singleband(String bucket, String prefix, S3GeoTiffRDD.Options options, SparkContext sc, RasterReader<S3GeoTiffRDD.Options, Tuple2<K, Tile>> rr) {
        return this.apply(bucket, prefix, options, sc, rr);
    }

    public <I, K> RDD<Tuple2<K, MultibandTile>> multiband(String bucket, String prefix, Function2<URI, I, K> uriToKey, S3GeoTiffRDD.Options options, SparkContext sc, RasterReader<S3GeoTiffRDD.Options, Tuple2<I, MultibandTile>> rr) {
        return this.apply(bucket, prefix, uriToKey, options, sc, rr);
    }

    public <K> RDD<Tuple2<K, MultibandTile>> multiband(String bucket, String prefix, S3GeoTiffRDD.Options options, SparkContext sc, RasterReader<S3GeoTiffRDD.Options, Tuple2<K, MultibandTile>> rr) {
        return this.apply(bucket, prefix, options, sc, rr);
    }

    public RDD<Tuple2<ProjectedExtent, Tile>> spatial(String bucket, String prefix, SparkContext sc) {
        return this.spatial(bucket, prefix, S3GeoTiffRDD$Options$.MODULE$.DEFAULT(), sc);
    }

    public RDD<Tuple2<ProjectedExtent, Tile>> spatial(String bucket, String prefix, S3GeoTiffRDD.Options options, SparkContext sc) {
        return this.singleband(bucket, prefix, options, sc, RasterReader$.MODULE$.singlebandGeoTiffReader());
    }

    public RDD<Tuple2<ProjectedExtent, Tile>> spatial(String bucket, String prefix, Function2<URI, ProjectedExtent, ProjectedExtent> uriToKey, S3GeoTiffRDD.Options options, SparkContext sc) {
        return this.singleband(bucket, prefix, uriToKey, options, sc, RasterReader$.MODULE$.singlebandGeoTiffReader());
    }

    public RDD<Tuple2<ProjectedExtent, MultibandTile>> spatialMultiband(String bucket, String prefix, SparkContext sc) {
        return this.spatialMultiband(bucket, prefix, S3GeoTiffRDD$Options$.MODULE$.DEFAULT(), sc);
    }

    public RDD<Tuple2<ProjectedExtent, MultibandTile>> spatialMultiband(String bucket, String prefix, S3GeoTiffRDD.Options options, SparkContext sc) {
        return this.multiband(bucket, prefix, options, sc, RasterReader$.MODULE$.multibandGeoTiffReader());
    }

    public RDD<Tuple2<ProjectedExtent, MultibandTile>> spatialMultiband(String bucket, String prefix, Function2<URI, ProjectedExtent, ProjectedExtent> uriToKey, S3GeoTiffRDD.Options options, SparkContext sc) {
        return this.multiband(bucket, prefix, uriToKey, options, sc, RasterReader$.MODULE$.multibandGeoTiffReader());
    }

    public RDD<Tuple2<TemporalProjectedExtent, Tile>> temporal(String bucket, String prefix, SparkContext sc) {
        return this.temporal(bucket, prefix, S3GeoTiffRDD$Options$.MODULE$.DEFAULT(), sc);
    }

    public RDD<Tuple2<TemporalProjectedExtent, Tile>> temporal(String bucket, String prefix, S3GeoTiffRDD.Options options, SparkContext sc) {
        return this.singleband(bucket, prefix, options, sc, RasterReader$.MODULE$.temporalSinglebandGeoTiffReader());
    }

    public RDD<Tuple2<TemporalProjectedExtent, Tile>> temporal(String bucket, String prefix, Function2<URI, TemporalProjectedExtent, TemporalProjectedExtent> uriToKey, S3GeoTiffRDD.Options options, SparkContext sc) {
        return this.singleband(bucket, prefix, uriToKey, options, sc, RasterReader$.MODULE$.temporalSinglebandGeoTiffReader());
    }

    public RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> temporalMultiband(String bucket, String prefix, SparkContext sc) {
        return this.temporalMultiband(bucket, prefix, S3GeoTiffRDD$Options$.MODULE$.DEFAULT(), sc);
    }

    public RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> temporalMultiband(String bucket, String prefix, S3GeoTiffRDD.Options options, SparkContext sc) {
        return this.multiband(bucket, prefix, options, sc, RasterReader$.MODULE$.temporalMultibandGeoTiffReader());
    }

    public RDD<Tuple2<TemporalProjectedExtent, MultibandTile>> temporalMultiband(String bucket, String prefix, Function2<URI, TemporalProjectedExtent, TemporalProjectedExtent> uriToKey, S3GeoTiffRDD.Options options, SparkContext sc) {
        return this.multiband(bucket, prefix, uriToKey, options, sc, RasterReader$.MODULE$.temporalMultibandGeoTiffReader());
    }

    private S3GeoTiffRDD$() {
    }
}

