/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import geotrellis.store.hadoop.package$;
import geotrellis.store.s3.S3ClientProducer$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple4;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;

public final class S3InputFormat$ {
    public static final S3InputFormat$ MODULE$ = new S3InputFormat$();
    private static final String idRx = "[A-Z0-9]{20}";
    private static final String keyRx = "[a-zA-Z0-9+/]+={0,2}";
    private static final String slug = "[a-zA-Z0-9-.]+";
    private static final Regex S3UrlRx = new Regex(new StringBuilder(33).append("s3[an]?://(?:(").append(MODULE$.idRx()).append("):(").append(MODULE$.keyRx()).append(")@)?(").append(MODULE$.slug()).append(")/{0,1}(.*)").toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aws_id", "aws_key", "bucket", "prefix"}));

    public final int DEFAULT_PARTITION_BYTES() {
        return 0x10000000;
    }

    public final int DEFAULT_CHUNK_SIZE() {
        return 524288;
    }

    public final String ANONYMOUS() {
        return "s3.anonymous";
    }

    public final String AWS_ID() {
        return "s3.awsId";
    }

    public final String AWS_KEY() {
        return "s3.awsKey";
    }

    public final String BUCKET() {
        return "s3.bucket";
    }

    public final String PREFIX() {
        return "s3.prefix";
    }

    public final String EXTENSIONS() {
        return "s3.extensions";
    }

    public final String REGION() {
        return "s3.region";
    }

    public final String PARTITION_COUNT() {
        return "s3.partitionCount";
    }

    public final String PARTITION_BYTES() {
        return "S3.partitionBytes";
    }

    public final String CHUNK_SIZE() {
        return "s3.chunkSize";
    }

    public final String CRS_VALUE() {
        return "s3.crs";
    }

    public final String CREATE_S3CLIENT() {
        return "s3.client";
    }

    public final String DELIMITER() {
        return "s3.delimiter";
    }

    private String idRx() {
        return idRx;
    }

    private String keyRx() {
        return keyRx;
    }

    private String slug() {
        return slug;
    }

    public Regex S3UrlRx() {
        return S3UrlRx;
    }

    public void setCreateS3Client(Job job, Function0<S3Client> createClient) {
        this.setCreateS3Client(job.getConfiguration(), createClient);
    }

    public void setCreateS3Client(Configuration conf, Function0<S3Client> createClient) {
        package$.MODULE$.withHadoopConfigurationMethods(conf).setSerialized("s3.client", createClient);
    }

    public S3Client getS3Client(JobContext job) {
        Configuration conf = job.getConfiguration();
        String r = conf.get("s3.region", null);
        None$ maybeRegion = r != null ? new Some((Object)Region.of((String)r)) : None$.MODULE$;
        Option option = package$.MODULE$.withHadoopConfigurationMethods(conf).getSerializedOption("s3.client");
        if (option instanceof Some) {
            Some some = (Some)option;
            Function0 createS3Client = (Function0)some.value();
            return (S3Client)createS3Client.apply();
        }
        if (None$.MODULE$.equals(option)) {
            None$ none$ = maybeRegion;
            if (none$ instanceof Some) {
                Some some = (Some)none$;
                Region region = (Region)some.value();
                return (S3Client)S3Client.builder().region(region).build();
            }
            if (None$.MODULE$.equals(none$)) {
                return (S3Client)S3ClientProducer$.MODULE$.get().apply();
            }
            throw new MatchError((Object)none$);
        }
        throw new MatchError((Object)option);
    }

    public void removeCreateS3Client(Configuration conf) {
        conf.unset("s3.client");
    }

    public void setUrl(Job job, String url) {
        this.setUrl(job.getConfiguration(), url);
    }

    public void setUrl(Configuration conf, String url) {
        Option option;
        String string = url;
        if (string == null || (option = this.S3UrlRx().unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(4) != 0) {
            throw new MatchError((Object)string);
        }
        String id = (String)((LinearSeqOps)option.get()).apply(0);
        String key = (String)((LinearSeqOps)option.get()).apply(1);
        String bucket = (String)((LinearSeqOps)option.get()).apply(2);
        String prefix = (String)((LinearSeqOps)option.get()).apply(3);
        Tuple4 tuple4 = new Tuple4((Object)id, (Object)key, (Object)bucket, (Object)prefix);
        String id2 = (String)tuple4._1();
        String key2 = (String)tuple4._2();
        String bucket2 = (String)tuple4._3();
        String prefix2 = (String)tuple4._4();
        if (id2 != null && key2 != null) {
            conf.set("s3.awsId", id2);
            conf.set("s3.awsKey", key2);
        }
        conf.set("s3.bucket", bucket2);
        conf.set("s3.prefix", prefix2);
    }

    public void removeUrl(Configuration conf) {
        conf.unset("s3.awsId");
        conf.unset("s3.awsKey");
        this.removeBucket(conf);
        this.removePrefix(conf);
    }

    public void setBucket(Job job, String bucket) {
        this.setBucket(job.getConfiguration(), bucket);
    }

    public void setBucket(Configuration conf, String bucket) {
        conf.set("s3.bucket", bucket);
    }

    public void removeBucket(Configuration conf) {
        conf.unset("s3.bucket");
    }

    public void setPrefix(Job job, String prefix) {
        this.setPrefix(job.getConfiguration(), prefix);
    }

    public void setPrefix(Configuration conf, String prefix) {
        conf.set("s3.prefix", prefix);
    }

    public void removePrefix(Configuration conf) {
        conf.unset("s3.prefix");
    }

    public void setPartitionCount(Job job, int limit) {
        this.setPartitionCount(job.getConfiguration(), limit);
    }

    public void setPartitionCount(Configuration conf, int limit) {
        conf.set("s3.partitionCount", Integer.toString(limit));
    }

    public void removePartitionCount(Configuration conf) {
        conf.unset("s3.partitionCount");
    }

    public void setRegion(Job job, String region) {
        this.setRegion(job.getConfiguration(), region);
    }

    public void setRegion(Configuration conf, String region) {
        conf.set("s3.region", region);
    }

    public void removeRegion(Configuration conf) {
        conf.unset("s3.region");
    }

    public void setAnonymous(Job job) {
        this.setAnonymous(job.getConfiguration());
    }

    public void setAnonymous(Configuration conf) {
        conf.set("s3.anonymous", "true");
    }

    public void removeAnonymous(Configuration conf) {
        conf.unset("s3.anonymous");
    }

    public void setPartitionBytes(Job job, long bytes) {
        this.setPartitionBytes(job.getConfiguration(), bytes);
    }

    public void setPartitionBytes(Configuration conf, long bytes) {
        conf.set("S3.partitionBytes", Long.toString(bytes));
    }

    public void removePartitionBytes(Configuration conf) {
        conf.unset("S3.partitionBytes");
    }

    public void setChunkSize(Job job, int chunkSize) {
        this.setChunkSize(job.getConfiguration(), chunkSize);
    }

    public void setChunkSize(Configuration conf, int chunkSize) {
        conf.set("s3.chunkSize", Integer.toString(chunkSize));
    }

    public void removeChunkSize(Configuration conf) {
        conf.unset("s3.chunkSize");
    }

    public void setExtensions(Configuration conf, Seq<String> extensions) {
        conf.set("s3.extensions", extensions.mkString(","));
    }

    public void removeExtensions(Configuration conf) {
        conf.unset("s3.extensions");
    }

    public void setDelimiter(Job job, String delimiter) {
        this.setDelimiter(job.getConfiguration(), delimiter);
    }

    public void setDelimiter(Configuration conf, String delimiter) {
        conf.set("s3.delimiter", delimiter);
    }

    public Option<String> getDelimiter(JobContext job) {
        return this.getDelimiter(job.getConfiguration());
    }

    public Option<String> getDelimiter(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get("s3.delimiter"));
    }

    public void removeDelimiter(Configuration conf) {
        conf.unset("s3.delimiter");
    }

    private S3InputFormat$() {
    }
}

