/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import cats.effect.unsafe.IORuntime;
import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.EmptyBounds$;
import geotrellis.layer.KeyBounds$;
import geotrellis.spark.ContextRDD;
import geotrellis.spark.store.FilteringLayerReader;
import geotrellis.spark.store.s3.S3LayerReader$;
import geotrellis.spark.store.s3.S3RDDReader;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.LayerQuery;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.index.Index$;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import geotrellis.store.s3.S3LayerHeader;
import geotrellis.store.s3.S3LayerHeader$;
import geotrellis.store.s3.package$;
import geotrellis.util.Component;
import io.circe.Decoder;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001\u0002\n\u0014\u0001qA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Q!AA\u0006\u0001B\u0001J\u0003%Q\u0006\u0003\u0005A\u0001\t\u0005I\u0015!\u0003B\u0011!a\u0005A!A!\u0002\u0017i\u0005\"\u0002,\u0001\t\u00039\u0006bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007I\u0002\u0001\u000b\u0011B1\t\u000b\u0015\u0004A\u0011\u00014\t\u000b)\u0004A\u0011A6\b\u000f\u0005=5\u0003#\u0001\u0002\u0012\u001a1!c\u0005E\u0001\u0003'CaA\u0016\u0007\u0005\u0002\u0005m\u0005bBAO\u0019\u0011\u0005\u0011q\u0014\u0005\b\u0003;cA\u0011AAU\u0011%\ty\rDI\u0001\n\u0003\t\t\u000eC\u0005\u0002h2\t\n\u0011\"\u0001\u0002j\ni1k\r'bs\u0016\u0014(+Z1eKJT!\u0001F\u000b\u0002\u0005M\u001c$B\u0001\f\u0018\u0003\u0015\u0019Ho\u001c:f\u0015\tA\u0012$A\u0003ta\u0006\u00148NC\u0001\u001b\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\t\u0001Q\u0004E\u0002\u001f?\u0005j\u0011!F\u0005\u0003AU\u0011ACR5mi\u0016\u0014\u0018N\\4MCf,'OU3bI\u0016\u0014\bC\u0001\u0012%\u001b\u0005\u0019#B\u0001\f\u001a\u0013\t)3EA\u0004MCf,'/\u00133\u0002\u001d\u0005$HO]5ckR,7\u000b^8sKV\t\u0001\u0006\u0005\u0002#S%\u0011!f\t\u0002\u000f\u0003R$(/\u001b2vi\u0016\u001cFo\u001c:f\u0003=\tG\u000f\u001e:jEV$Xm\u0015;pe\u0016\u0004\u0013\u0001C:4\u00072LWM\u001c;\u0011\u00079\n4'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005!a$-\u001f8b[\u0016t\u0004C\u0001\u001b?\u001b\u0005)$B\u0001\u000b7\u0015\t9\u0004(\u0001\u0005tKJ4\u0018nY3t\u0015\tI$(\u0001\u0004boN\u001cHm\u001b\u0006\u0003wq\na!Y7bu>t'\"A\u001f\u0002\u0011M|g\r^<be\u0016L!aP\u001b\u0003\u0011M\u001b4\t\\5f]R\fqA];oi&lW\rE\u0002/c\t\u0003\"a\u0011&\u000e\u0003\u0011S!!\u0012$\u0002\rUt7/\u00194f\u0015\t9\u0005*\u0001\u0004fM\u001a,7\r\u001e\u0006\u0002\u0013\u0006!1-\u0019;t\u0013\tYEIA\u0005J\u001fJ+h\u000e^5nK\u0006\u00111o\u0019\t\u0003\u001dRk\u0011a\u0014\u0006\u00031AS!!\u0015*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0016aA8sO&\u0011Qk\u0014\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\tacVL\u0018\u000b\u00033n\u0003\"A\u0017\u0001\u000e\u0003MAQ\u0001\u0014\u0004A\u00045CQA\n\u0004A\u0002!Bq\u0001\f\u0004\u0011\n\u0003\u0007Q\u0006C\u0004A\rA%\t\u0019A!\u0002)\u0011,g-Y;mi:+X\u000eU1si&$\u0018n\u001c8t+\u0005\t\u0007C\u0001\u0018c\u0013\t\u0019wFA\u0002J]R\fQ\u0003Z3gCVdGOT;n!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0005sI\u0012\u0014V-\u00193feV\tq\r\u0005\u0002[Q&\u0011\u0011n\u0005\u0002\f'N\u0012F\t\u0012*fC\u0012,'/\u0001\u0003sK\u0006$W#\u00027u}\u0006\rA#C7\u0002t\u0005]\u0014\u0011QAC)Eq\u0017qAA\f\u0003O\tY$a\u0013\u0002R\u0005]\u0013Q\f\t\u0007_B\u0014X0!\u0001\u000e\u0003]I!!]\f\u0003\u0015\r{g\u000e^3yiJ#E\t\u0005\u0002ti2\u0001A!B;\u000b\u0005\u00041(!A&\u0012\u0005]T\bC\u0001\u0018y\u0013\tIxFA\u0004O_RD\u0017N\\4\u0011\u00059Z\u0018B\u0001?0\u0005\r\te.\u001f\t\u0003gz$Qa \u0006C\u0002Y\u0014\u0011A\u0016\t\u0004g\u0006\rAABA\u0003\u0015\t\u0007aOA\u0001N\u0011%\tIACA\u0001\u0002\b\tY!\u0001\u0006fm&$WM\\2fIE\u0002R!!\u0004\u0002\u0014Il!!a\u0004\u000b\u0007\u0005E1%\u0001\u0003bmJ|\u0017\u0002BA\u000b\u0003\u001f\u0011q\"\u0011<s_J+7m\u001c:e\u0007>$Wm\u0019\u0005\n\u00033Q\u0011\u0011!a\u0002\u00037\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0015\ti\"a\ts\u001b\t\tyBC\u0002\u0002\"e\tQ\u0001\\1zKJLA!!\n\u0002 \tI!i\\;oI\u0006\u0014G.\u001a\u0005\n\u0003SQ\u0011\u0011!a\u0002\u0003W\t!\"\u001a<jI\u0016t7-\u001a\u00134!\u0015\ti#a\u000es\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012!B2je\u000e,'BAA\u001b\u0003\tIw.\u0003\u0003\u0002:\u0005=\"a\u0002#fG>$WM\u001d\u0005\n\u0003{Q\u0011\u0011!a\u0002\u0003\u007f\t!\"\u001a<jI\u0016t7-\u001a\u00135!\u0015\t\t%a\u0012s\u001b\t\t\u0019EC\u0002\u0002F=\nqA]3gY\u0016\u001cG/\u0003\u0003\u0002J\u0005\r#\u0001C\"mCN\u001cH+Y4\t\u0013\u00055#\"!AA\u0004\u0005=\u0013AC3wS\u0012,gnY3%kA)\u0011QBA\n{\"I\u00111\u000b\u0006\u0002\u0002\u0003\u000f\u0011QK\u0001\u000bKZLG-\u001a8dK\u00122\u0004#BA!\u0003\u000fj\b\"CA-\u0015\u0005\u0005\t9AA.\u0003))g/\u001b3f]\u000e,Ge\u000e\t\u0007\u0003[\t9$!\u0001\t\u0013\u0005}#\"!AA\u0004\u0005\u0005\u0014AC3wS\u0012,gnY3%qAA\u00111MA5\u0003\u0003\ti'\u0004\u0002\u0002f)\u0019\u0011qM\r\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\n)GA\u0005D_6\u0004xN\\3oiB)\u0011QDA8e&!\u0011\u0011OA\u0010\u0005\u0019\u0011u.\u001e8eg\"1\u0011Q\u000f\u0006A\u0002\u0005\n!!\u001b3\t\u000f\u0005e$\u00021\u0001\u0002|\u0005IA/\u001b7f#V,'/\u001f\t\u0007E\u0005u$/!\u0001\n\u0007\u0005}4E\u0001\u0006MCf,'/U;fefDa!a!\u000b\u0001\u0004\t\u0017!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0004\u0002\b*\u0001\r!!#\u0002\u001f\u0019LG\u000e^3s\u0013:$W\r_(oYf\u00042ALAF\u0013\r\tii\f\u0002\b\u0005>|G.Z1o\u00035\u00196\u0007T1zKJ\u0014V-\u00193feB\u0011!\fD\n\u0004\u0019\u0005U\u0005c\u0001\u0018\u0002\u0018&\u0019\u0011\u0011T\u0018\u0003\r\u0005s\u0017PU3g)\t\t\t*A\u0003baBd\u0017\u0010\u0006\u0004\u0002\"\u0006\u0015\u0016q\u0015\u000b\u00043\u0006\r\u0006\"\u0002'\u000f\u0001\bi\u0005\"\u0002\u0014\u000f\u0001\u0004A\u0003B\u0002\u0017\u000f\t\u0003\u0007Q\u0006\u0006\u0005\u0002,\u0006=\u0016\u0011ZAg)\rI\u0016Q\u0016\u0005\u0006\u0019>\u0001\u001d!\u0014\u0005\b\u0003c{\u0001\u0019AAZ\u0003\u0019\u0011WoY6fiB!\u0011QWAb\u001d\u0011\t9,a0\u0011\u0007\u0005ev&\u0004\u0002\u0002<*\u0019\u0011QX\u000e\u0002\rq\u0012xn\u001c;?\u0013\r\t\tmL\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0017q\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005w\u0006C\u0004\u0002L>\u0001\r!a-\u0002\rA\u0014XMZ5y\u0011\u0019as\u0002\"a\u0001[\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a5+\u0007M\n)n\u000b\u0002\u0002XB!\u0011\u0011\\Ar\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0017!C;oG\",7m[3e\u0015\r\t\toL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAs\u00037\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u001e\u0016\u0004\u0005\u0006U\u0007")
public class S3LayerReader
extends FilteringLayerReader<LayerId> {
    private final AttributeStore attributeStore;
    private final Function0<S3Client> s3Client;
    private final Function0<IORuntime> runtime;
    private final SparkContext sc;
    private final int defaultNumPartitions;

    public static IORuntime $lessinit$greater$default$3() {
        return S3LayerReader$.MODULE$.$lessinit$greater$default$3();
    }

    public static S3Client $lessinit$greater$default$2() {
        return S3LayerReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static S3LayerReader apply(String bucket, String prefix, Function0<S3Client> s3Client, SparkContext sc) {
        return S3LayerReader$.MODULE$.apply(bucket, prefix, s3Client, sc);
    }

    public static S3LayerReader apply(AttributeStore attributeStore, Function0<S3Client> s3Client, SparkContext sc) {
        return S3LayerReader$.MODULE$.apply(attributeStore, s3Client, sc);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    public int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    public S3RDDReader rddReader() {
        return new S3RDDReader(this.s3Client, this.runtime);
    }

    public <K, V, M> ContextRDD<K, V, M> read(LayerId id, LayerQuery<K, M> tileQuery, int numPartitions, boolean filterIndexOnly, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, Decoder<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, Decoder<M> evidence$7, Component<M, Bounds<K>> evidence$8) {
        if (!this.attributeStore().layerExists(id)) {
            throw new package.LayerNotFoundError(id);
        }
        LayerAttributes layerAttributes = this.liftedTree1$1(id, evidence$7, evidence$4);
        if (layerAttributes == null) {
            throw new MatchError((Object)layerAttributes);
        }
        S3LayerHeader header = (S3LayerHeader)layerAttributes.header();
        Object metadata = layerAttributes.metadata();
        KeyIndex keyIndex = layerAttributes.keyIndex();
        Schema writerSchema = layerAttributes.schema();
        Tuple4 tuple4 = new Tuple4((Object)header, metadata, (Object)keyIndex, (Object)writerSchema);
        S3LayerHeader header2 = (S3LayerHeader)tuple4._1();
        Object metadata2 = tuple4._2();
        KeyIndex keyIndex2 = (KeyIndex)tuple4._3();
        Schema writerSchema2 = (Schema)tuple4._4();
        String bucket = header2.bucket();
        String prefix = header2.key();
        Seq queryKeyBounds = tileQuery.apply(metadata2);
        Object layerMetadata = geotrellis.util.package$.MODULE$.withSetComponentMethods(metadata2).setComponent(queryKeyBounds.foldLeft((Object)EmptyBounds$.MODULE$, (Function2 & Serializable)(x$2, x$3) -> x$2.combine((Bounds)x$3, evidence$2)), evidence$8);
        int maxWidth = Index$.MODULE$.digits(keyIndex2.toIndex(keyIndex2.keyBounds().maxKey()));
        Function1 & Serializable keyPath = (Function1 & Serializable)index -> package$.MODULE$.makePath((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{prefix, Index$.MODULE$.encode(index, maxWidth)}));
        Function1 & Serializable decompose = (Function1 & Serializable)bounds -> keyIndex2.indexRanges(KeyBounds$.MODULE$.keyBoundsToTuple(bounds));
        RDD<Tuple2<K, V>> rdd = this.rddReader().read(bucket, (Function1<BigInt, String>)keyPath, queryKeyBounds, decompose, filterIndexOnly, (Option<Schema>)new Some((Object)writerSchema2), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), evidence$1, evidence$2, evidence$5, this.sc);
        return new ContextRDD(rdd, layerMetadata);
    }

    private final /* synthetic */ LayerAttributes liftedTree1$1(LayerId id$1, Decoder evidence$7$1, ClassTag evidence$4$1) {
        LayerAttributes layerAttributes;
        try {
            layerAttributes = this.attributeStore().readLayerAttributes(id$1, S3LayerHeader$.MODULE$.s3LayerHeaderDecoder(), evidence$7$1, evidence$4$1);
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerReadError(id$1).initCause((Throwable)e);
        }
        catch (NoSuchBucketException e) {
            throw new package.LayerReadError(id$1).initCause((Throwable)e);
        }
        return layerAttributes;
    }

    public S3LayerReader(AttributeStore attributeStore, Function0<S3Client> s3Client, Function0<IORuntime> runtime, SparkContext sc) {
        this.attributeStore = attributeStore;
        this.s3Client = s3Client;
        this.runtime = runtime;
        this.sc = sc;
        this.defaultNumPartitions = sc.defaultParallelism();
    }
}

