/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import cats.effect.unsafe.IORuntime;
import cats.kernel.Semigroup;
import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.Metadata;
import geotrellis.spark.store.LayerWriter;
import geotrellis.spark.store.s3.S3LayerWriter$;
import geotrellis.spark.store.s3.S3RDDWriter;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.Writer;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec$;
import geotrellis.store.index.Index$;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.index.KeyIndexMethod;
import geotrellis.store.package;
import geotrellis.store.s3.S3AttributeStore;
import geotrellis.store.s3.S3LayerHeader;
import geotrellis.store.s3.S3LayerHeader$;
import geotrellis.util.Component;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@ScalaSignature(bytes="\u0006\u0005\rMf\u0001\u0002\u000f\u001e\u0001\u0019B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003>\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002\u0003/\u0001\u0005\u0003%\u000b\u0011B/\t\u0011\u0011\u0004!\u0011!S\u0001\n\u0015DQ\u0001\u001d\u0001\u0005\u0002EDQA\u001f\u0001\u0005\u0002mDaa \u0001\u0005\u0002\u0005\u0005\u0001bBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0003_\u0004A\u0011\u0002B0\u0011\u001d\u0011i\r\u0001C\t\u0005\u001fD!ba\u000b\u0001\u0011\u000b\u0007K\u0011BB\u0017\u000f\u001d\u0019\u0019%\bE\u0001\u0007\u000b2a\u0001H\u000f\t\u0002\r\u001d\u0003B\u00029\u0011\t\u0003\u0019I\u0005C\u0004\u0004LA!\ta!\u0014\t\u0013\ru\u0003#%A\u0005\u0002\r}\u0003bBB&!\u0011\u00051Q\u000f\u0005\b\u0007\u0017\u0002B\u0011AB@\u0011\u001d\u0019Y\u0005\u0005C\u0001\u0007\u001bCqaa\u0013\u0011\t\u0003\u0019\u0019\nC\u0004\u0004LA!\taa'\t\u0013\r\u0015\u0006#%A\u0005\u0002\r\u001d\u0006\"CBV!E\u0005I\u0011AB0\u0011%\u0019i\u000bEI\u0001\n\u0003\u0019yKA\u0007Tg1\u000b\u00170\u001a:Xe&$XM\u001d\u0006\u0003=}\t!a]\u001a\u000b\u0005\u0001\n\u0013!B:u_J,'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\u0005!\u0013AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001([A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u00042AL\u00182\u001b\u0005y\u0012B\u0001\u0019 \u0005-a\u0015-_3s/JLG/\u001a:\u0011\u0005I\"T\"A\u001a\u000b\u0005\u0001\u001a\u0013BA\u001b4\u0005\u001da\u0015-_3s\u0013\u0012\fa\"\u0019;ue&\u0014W\u000f^3Ti>\u0014X-F\u00019!\t\u0011\u0014(\u0003\u0002;g\tq\u0011\t\u001e;sS\n,H/Z*u_J,\u0017aD1uiJL'-\u001e;f'R|'/\u001a\u0011\u0002\r\t,8m[3u!\tqTI\u0004\u0002@\u0007B\u0011\u0001)K\u0007\u0002\u0003*\u0011!)J\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011K\u0013A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001R\u0015\u0002\u0013-,\u0017\u0010\u0015:fM&D\u0018!\u00059vi>\u0013'.Z2u\u001b>$\u0017NZ5feB!\u0001fS'N\u0013\ta\u0015FA\u0005Gk:\u001cG/[8ocA\u0011aJW\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0006[>$W\r\u001c\u0006\u0003=IS!a\u0015+\u0002\u0011M,'O^5dKNT!!\u0016,\u0002\r\u0005<8o\u001d3l\u0015\t9\u0006,\u0001\u0004b[\u0006TxN\u001c\u0006\u00023\u0006A1o\u001c4uo\u0006\u0014X-\u0003\u0002\\\u001f\n\u0001\u0002+\u001e;PE*,7\r\u001e*fcV,7\u000f^\u0001\tgN\u001aE.[3oiB\u0019\u0001F\u00181\n\u0005}K#\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0005\u0005\u0014W\"A)\n\u0005\r\f&\u0001C*4\u00072LWM\u001c;\u0002\u000fI,h\u000e^5nKB\u0019\u0001F\u00184\u0011\u0005\u001dtW\"\u00015\u000b\u0005%T\u0017AB;og\u00064WM\u0003\u0002lY\u00061QM\u001a4fGRT\u0011!\\\u0001\u0005G\u0006$8/\u0003\u0002pQ\nI\u0011j\u0014*v]RLW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fI$XO^<ysB\u00111\u000fA\u0007\u0002;!)a\u0007\u0003a\u0001q!)A\b\u0003a\u0001{!)\u0001\n\u0003a\u0001{!9\u0011\n\u0003I\u0001\u0002\u0004Q\u0005b\u0002/\t!\u0013\u0005\r!\u0018\u0005\bI\"\u0001J\u00111\u0001f\u0003%\u0011H\rZ,sSR,'/F\u0001}!\t\u0019X0\u0003\u0002\u007f;\tY1k\r*E\t^\u0013\u0018\u000e^3s\u0003%yg/\u001a:xe&$X-\u0006\u0005\u0002\u0004\u0005\u0005\u0012\u0011PAF)\u0019\t)!!1\u0002FRA\u0012qAA\u0007\u0003g\t\u0019%a\u0016\u0002b\u0005E\u0014QPAB\u0003\u001f\u000b)*a+\u0011\u0007!\nI!C\u0002\u0002\f%\u0012A!\u00168ji\"I\u0011q\u0002\u0006\u0002\u0002\u0003\u000f\u0011\u0011C\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBA\n\u00033\ti\"\u0004\u0002\u0002\u0016)\u0019\u0011qC\u001a\u0002\t\u00054(o\\\u0005\u0005\u00037\t)BA\bBmJ|'+Z2pe\u0012\u001cu\u000eZ3d!\u0011\ty\"!\t\r\u0001\u00119\u00111\u0005\u0006C\u0002\u0005\u0015\"!A&\u0012\t\u0005\u001d\u0012Q\u0006\t\u0004Q\u0005%\u0012bAA\u0016S\t9aj\u001c;iS:<\u0007c\u0001\u0015\u00020%\u0019\u0011\u0011G\u0015\u0003\u0007\u0005s\u0017\u0010C\u0005\u00026)\t\t\u0011q\u0001\u00028\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\u0005e\u0012qHA\u000f\u001b\t\tYDC\u0002\u0002>\r\nQ\u0001\\1zKJLA!!\u0011\u0002<\tI!i\\;oI\u0006\u0014G.\u001a\u0005\n\u0003\u000bR\u0011\u0011!a\u0002\u0003\u000f\n!\"\u001a<jI\u0016t7-\u001a\u00134!\u0019\tI%a\u0015\u0002\u001e5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0003dSJ\u001cWM\u0003\u0002\u0002R\u0005\u0011\u0011n\\\u0005\u0005\u0003+\nYEA\u0004F]\u000e|G-\u001a:\t\u0013\u0005e#\"!AA\u0004\u0005m\u0013AC3wS\u0012,gnY3%iA1\u0011\u0011JA/\u0003;IA!a\u0018\u0002L\t9A)Z2pI\u0016\u0014\b\"CA2\u0015\u0005\u0005\t9AA3\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0007\u0003O\ni'!\b\u000e\u0005\u0005%$bAA6S\u00059!/\u001a4mK\u000e$\u0018\u0002BA8\u0003S\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\n\u0003gR\u0011\u0011!a\u0002\u0003k\n!\"\u001a<jI\u0016t7-\u001a\u00137!\u0019\t\u0019\"!\u0007\u0002xA!\u0011qDA=\t\u001d\tYH\u0003b\u0001\u0003K\u0011\u0011A\u0016\u0005\n\u0003\u007fR\u0011\u0011!a\u0002\u0003\u0003\u000b!\"\u001a<jI\u0016t7-\u001a\u00138!\u0019\t9'!\u001c\u0002x!I\u0011Q\u0011\u0006\u0002\u0002\u0003\u000f\u0011qQ\u0001\u000bKZLG-\u001a8dK\u0012B\u0004CBA%\u0003'\nI\t\u0005\u0003\u0002 \u0005-EaBAG\u0015\t\u0007\u0011Q\u0005\u0002\u0002\u001b\"I\u0011\u0011\u0013\u0006\u0002\u0002\u0003\u000f\u00111S\u0001\u000bKZLG-\u001a8dK\u0012J\u0004CBA%\u0003;\nI\tC\u0005\u0002\u0018*\t\t\u0011q\u0001\u0002\u001a\u0006YQM^5eK:\u001cW\rJ\u00191!!\tY*!)\u0002\n\u0006\u0015VBAAO\u0015\r\tyjI\u0001\u0005kRLG.\u0003\u0003\u0002$\u0006u%!C\"p[B|g.\u001a8u!\u0019\tI$a*\u0002\u001e%!\u0011\u0011VA\u001e\u0005\u0019\u0011u.\u001e8eg\"I\u0011Q\u0016\u0006\u0002\u0002\u0003\u000f\u0011qV\u0001\fKZLG-\u001a8dK\u0012\n\u0014\u0007\u0005\u0004\u00022\u0006m\u0016\u0011\u0012\b\u0005\u0003g\u000b9LD\u0002A\u0003kK\u0011!\\\u0005\u0004\u0003sc\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003{\u000byLA\u0005TK6LwM]8va*\u0019\u0011\u0011\u00187\t\r\u0005\r'\u00021\u00012\u0003\tIG\rC\u0004\u0002H*\u0001\r!!3\u0002\u0007I$GM\u0005\u0004\u0002L\u0006=\u0017\u0011\u001e\u0004\u0007\u0003\u001b\u0004\u0001!!3\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\r\u0005E\u0017q\\Ar\u001b\t\t\u0019N\u0003\u0003\u0002H\u0006U'b\u0001\u0012\u0002X*!\u0011\u0011\\An\u0003\u0019\t\u0007/Y2iK*\u0011\u0011Q\\\u0001\u0004_J<\u0017\u0002BAq\u0003'\u00141A\u0015#E!\u001dA\u0013Q]A\u000f\u0003oJ1!a:*\u0005\u0019!V\u000f\u001d7feA1\u0011\u0011HAv\u0003\u0013KA!!<\u0002<\tAQ*\u001a;bI\u0006$\u0018-\u0001\u0004va\u0012\fG/Z\u000b\t\u0003g\fyP!\t\u00032QA\u0011Q\u001fB$\u0005\u0013\u0012)\u0006\u0006\r\u0002\b\u0005](\u0011\u0001B\u0004\u0005\u001b\u0011\u0019B!\u0007\u0003$\t%\"1\u0007B\u001d\u0005\u0003B\u0011\"!?\f\u0003\u0003\u0005\u001d!a?\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013G\r\t\u0007\u0003'\tI\"!@\u0011\t\u0005}\u0011q \u0003\b\u0003GY!\u0019AA\u0013\u0011%\u0011\u0019aCA\u0001\u0002\b\u0011)!A\u0006fm&$WM\\2fIE\u001a\u0004CBA\u001d\u0003\u007f\ti\u0010C\u0005\u0003\n-\t\t\u0011q\u0001\u0003\f\u0005YQM^5eK:\u001cW\rJ\u00195!\u0019\tI%a\u0015\u0002~\"I!qB\u0006\u0002\u0002\u0003\u000f!\u0011C\u0001\fKZLG-\u001a8dK\u0012\nT\u0007\u0005\u0004\u0002J\u0005u\u0013Q \u0005\n\u0005+Y\u0011\u0011!a\u0002\u0005/\t1\"\u001a<jI\u0016t7-\u001a\u00132mA1\u0011qMA7\u0003{D\u0011Ba\u0007\f\u0003\u0003\u0005\u001dA!\b\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013g\u000e\t\u0007\u0003'\tIBa\b\u0011\t\u0005}!\u0011\u0005\u0003\b\u0003wZ!\u0019AA\u0013\u0011%\u0011)cCA\u0001\u0002\b\u00119#A\u0006fm&$WM\\2fIEB\u0004CBA4\u0003[\u0012y\u0002C\u0005\u0003,-\t\t\u0011q\u0001\u0003.\u0005YQM^5eK:\u001cW\rJ\u0019:!\u0019\tI%a\u0015\u00030A!\u0011q\u0004B\u0019\t\u001d\tii\u0003b\u0001\u0003KA\u0011B!\u000e\f\u0003\u0003\u0005\u001dAa\u000e\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$#\u0007\r\t\u0007\u0003\u0013\niFa\f\t\u0013\tm2\"!AA\u0004\tu\u0012aC3wS\u0012,gnY3%eE\u0002\u0002\"a'\u0002\"\n=\"q\b\t\u0007\u0003s\t9+!@\t\u0013\t\r3\"!AA\u0004\t\u0015\u0013aC3wS\u0012,gnY3%eI\u0002b!!-\u0002<\n=\u0002BBAb\u0017\u0001\u0007\u0011\u0007C\u0004\u0002H.\u0001\rAa\u0013\u0013\r\t5#q\nB*\r\u0019\ti\r\u0001\u0001\u0003LA1\u0011\u0011[Ap\u0005#\u0002r\u0001KAs\u0003{\u0014y\u0002\u0005\u0004\u0002:\u0005-(q\u0006\u0005\n\u0005/Z\u0001\u0013!a\u0001\u00053\n\u0011\"\\3sO\u00164UO\\2\u0011\u0013!\u0012YFa\b\u0003 \t}\u0011b\u0001B/S\tIa)\u001e8di&|gNM\u000b\t\u0005C\u0012iGa$\u0003 RA!1\rB[\u0005o\u0013\u0019\r\u0006\r\u0002\b\t\u0015$q\u000eB;\u0005w\u0012\tIa\"\u0003\u0012\n]%\u0011\u0015BT\u0005_C\u0011Ba\u001a\r\u0003\u0003\u0005\u001dA!\u001b\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$#g\r\t\u0007\u0003'\tIBa\u001b\u0011\t\u0005}!Q\u000e\u0003\b\u0003Ga!\u0019AA\u0013\u0011%\u0011\t\bDA\u0001\u0002\b\u0011\u0019(A\u0006fm&$WM\\2fII\"\u0004CBA\u001d\u0003\u007f\u0011Y\u0007C\u0005\u0003x1\t\t\u0011q\u0001\u0003z\u0005YQM^5eK:\u001cW\r\n\u001a6!\u0019\tI%a\u0015\u0003l!I!Q\u0010\u0007\u0002\u0002\u0003\u000f!qP\u0001\fKZLG-\u001a8dK\u0012\u0012d\u0007\u0005\u0004\u0002J\u0005u#1\u000e\u0005\n\u0005\u0007c\u0011\u0011!a\u0002\u0005\u000b\u000b1\"\u001a<jI\u0016t7-\u001a\u00133oA1\u0011qMA7\u0005WB\u0011B!#\r\u0003\u0003\u0005\u001dAa#\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$#\u0007\u000f\t\u0007\u0003'\tIB!$\u0011\t\u0005}!q\u0012\u0003\b\u0003wb!\u0019AA\u0013\u0011%\u0011\u0019\nDA\u0001\u0002\b\u0011)*A\u0006fm&$WM\\2fIIJ\u0004CBA4\u0003[\u0012i\tC\u0005\u0003\u001a2\t\t\u0011q\u0001\u0003\u001c\u0006YQM^5eK:\u001cW\rJ\u001a1!\u0019\tI%a\u0015\u0003\u001eB!\u0011q\u0004BP\t\u001d\ti\t\u0004b\u0001\u0003KA\u0011Ba)\r\u0003\u0003\u0005\u001dA!*\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$3'\r\t\u0007\u0003\u0013\niF!(\t\u0013\t%F\"!AA\u0004\t-\u0016aC3wS\u0012,gnY3%gI\u0002\u0002\"a'\u0002\"\nu%Q\u0016\t\u0007\u0003s\t9Ka\u001b\t\u0013\tEF\"!AA\u0004\tM\u0016aC3wS\u0012,gnY3%gM\u0002b!!-\u0002<\nu\u0005BBAb\u0019\u0001\u0007\u0011\u0007C\u0004\u0002H2\u0001\rA!/\u0013\r\tm&Q\u0018Ba\r\u0019\ti\r\u0001\u0001\u0003:B1\u0011\u0011[Ap\u0005\u007f\u0003r\u0001KAs\u0005W\u0012i\t\u0005\u0004\u0002:\u0005-(Q\u0014\u0005\b\u0005/b\u0001\u0019\u0001Bc!\u0015A#q\u0019Bf\u0013\r\u0011I-\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0013!\u0012YF!$\u0003\u000e\n5\u0015AB0xe&$X-\u0006\u0005\u0003R\nu'1_B\u0002)!\u0011\u0019n!\u0004\u0004\u0010\rmA\u0003EA\u0004\u0005+\u0014yN!:\u0003l\nU(1`B\u0003\u0011%\u00119.DA\u0001\u0002\b\u0011I.A\u0006fm&$WM\\2fIM\"\u0004CBA\n\u00033\u0011Y\u000e\u0005\u0003\u0002 \tuGaBA\u0012\u001b\t\u0007\u0011Q\u0005\u0005\n\u0005Cl\u0011\u0011!a\u0002\u0005G\f1\"\u001a<jI\u0016t7-\u001a\u00134kA1\u0011\u0011JA*\u00057D\u0011Ba:\u000e\u0003\u0003\u0005\u001dA!;\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$3G\u000e\t\u0007\u0003O\niGa7\t\u0013\t5X\"!AA\u0004\t=\u0018aC3wS\u0012,gnY3%g]\u0002b!a\u0005\u0002\u001a\tE\b\u0003BA\u0010\u0005g$q!a\u001f\u000e\u0005\u0004\t)\u0003C\u0005\u0003x6\t\t\u0011q\u0001\u0003z\u0006YQM^5eK:\u001cW\rJ\u001a9!\u0019\t9'!\u001c\u0003r\"I!Q`\u0007\u0002\u0002\u0003\u000f!q`\u0001\fKZLG-\u001a8dK\u0012\u001a\u0014\b\u0005\u0004\u0002J\u0005M3\u0011\u0001\t\u0005\u0003?\u0019\u0019\u0001B\u0004\u0002\u000e6\u0011\r!!\n\t\u0013\r\u001dQ\"!AA\u0004\r%\u0011aC3wS\u0012,gnY3%iA\u0002\u0002\"a'\u0002\"\u000e\u000511\u0002\t\u0007\u0003s\t9Ka7\t\r\u0005\rW\u00021\u00012\u0011\u001d\t9-\u0004a\u0001\u0007#\u0011baa\u0005\u0004\u0016\reaABAg\u0001\u0001\u0019\t\u0002\u0005\u0004\u0002R\u0006}7q\u0003\t\bQ\u0005\u0015(1\u001cBy!\u0019\tI$a;\u0004\u0002!91QD\u0007A\u0002\r}\u0011\u0001C6fs&sG-\u001a=\u0011\r\r\u00052q\u0005Bn\u001b\t\u0019\u0019CC\u0002\u0004&M\nQ!\u001b8eKbLAa!\u000b\u0004$\tA1*Z=J]\u0012,\u00070\u0001\u0004m_\u001e<WM]\u000b\u0003\u0007_\u0001Ba!\r\u000485\u001111\u0007\u0006\u0005\u0007k\tY.A\u0003m_\u001e$4/\u0003\u0003\u0004:\rM\"A\u0002'pO\u001e,'\u000fK\u0002\u000f\u0007{\u00012\u0001KB \u0013\r\u0019\t%\u000b\u0002\niJ\fgn]5f]R\fQbU\u001aMCf,'o\u0016:ji\u0016\u0014\bCA:\u0011'\t\u0001r\u0005\u0006\u0002\u0004F\u0005)\u0011\r\u001d9msRY!oa\u0014\u0004R\rM3qKB-\u0011\u00151$\u00031\u00019\u0011\u0015a$\u00031\u0001>\u0011\u0019\u0019)F\u0005a\u0001{\u00051\u0001O]3gSbDQ!\u0013\nA\u0002)C\u0001ba\u0017\u0013!\u0013\u0005\r!X\u0001\nO\u0016$8\t\\5f]R\fq\"\u00199qYf$C-\u001a4bk2$H%N\u000b\u0003\u0007CR3\u0001YB2W\t\u0019)\u0007\u0005\u0003\u0004h\rETBAB5\u0015\u0011\u0019Yg!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAB8S\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\rM4\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G#\u0003:\u0004x\re41PB?\u0011\u00151D\u00031\u00019\u0011\u0015aD\u00031\u0001>\u0011\u0019\u0019)\u0006\u0006a\u0001{!1A\f\u0006CA\u0002u#2A]BA\u0011\u00191T\u00031\u0001\u0004\u0004B!1QQBE\u001b\t\u00199I\u0003\u0002\u001fg%!11RBD\u0005A\u00196'\u0011;ue&\u0014W\u000f^3Ti>\u0014X\rF\u0003s\u0007\u001f\u001b\t\n\u0003\u00047-\u0001\u000711\u0011\u0005\u0006\u0013Z\u0001\rA\u0013\u000b\be\u000eU5qSBM\u0011\u0015at\u00031\u0001>\u0011\u0019\u0019)f\u0006a\u0001{!1Al\u0006CA\u0002u#\u0012B]BO\u0007?\u001b\tka)\t\u000bqB\u0002\u0019A\u001f\t\r\rU\u0003\u00041\u0001>\u0011\u0015I\u0005\u00041\u0001K\u0011\u0019a\u0006\u0004\"a\u0001;\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"a!++\u0007)\u001b\u0019'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\rE&f\u00014\u0004d\u0001")
public class S3LayerWriter
implements LayerWriter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final String bucket;
    private final String keyPrefix;
    private final Function1<PutObjectRequest, PutObjectRequest> putObjectModifier;
    private final Function0<S3Client> s3Client;
    private final Function0<IORuntime> runtime;
    private volatile transient boolean bitmap$trans$0;

    public static IORuntime $lessinit$greater$default$6() {
        return S3LayerWriter$.MODULE$.$lessinit$greater$default$6();
    }

    public static S3Client $lessinit$greater$default$5() {
        return S3LayerWriter$.MODULE$.$lessinit$greater$default$5();
    }

    public static Function1<PutObjectRequest, PutObjectRequest> $lessinit$greater$default$4() {
        return S3LayerWriter$.MODULE$.$lessinit$greater$default$4();
    }

    public static S3LayerWriter apply(String bucket, String prefix, Function1<PutObjectRequest, PutObjectRequest> putObjectModifier, Function0<S3Client> s3Client) {
        return S3LayerWriter$.MODULE$.apply(bucket, prefix, putObjectModifier, s3Client);
    }

    public static S3LayerWriter apply(String bucket, String prefix, Function0<S3Client> s3Client) {
        return S3LayerWriter$.MODULE$.apply(bucket, prefix, s3Client);
    }

    public static S3LayerWriter apply(S3AttributeStore attributeStore, Function1<PutObjectRequest, PutObjectRequest> putObjectModifier) {
        return S3LayerWriter$.MODULE$.apply(attributeStore, putObjectModifier);
    }

    public static S3LayerWriter apply(S3AttributeStore attributeStore) {
        return S3LayerWriter$.MODULE$.apply(attributeStore);
    }

    public static S3LayerWriter apply(AttributeStore attributeStore, String bucket, String prefix, Function0<S3Client> s3Client) {
        return S3LayerWriter$.MODULE$.apply(attributeStore, bucket, prefix, s3Client);
    }

    public static S3Client apply$default$5() {
        return S3LayerWriter$.MODULE$.apply$default$5();
    }

    public static S3LayerWriter apply(AttributeStore attributeStore, String bucket, String prefix, Function1<PutObjectRequest, PutObjectRequest> putObjectModifier, Function0<S3Client> getClient) {
        return S3LayerWriter$.MODULE$.apply(attributeStore, bucket, prefix, putObjectModifier, getClient);
    }

    public <H, K, V, M> Option<LayerAttributes<H, M, K>> validateUpdate(LayerId id, M updateMetadata, Encoder<H> evidence$1, Decoder<H> evidence$2, AvroRecordCodec<K> evidence$3, Boundable<K> evidence$4, Encoder<K> evidence$5, ClassTag<K> evidence$6, AvroRecordCodec<V> evidence$7, Component<M, Bounds<K>> evidence$8, Semigroup<M> evidence$9, Encoder<M> evidence$10, Decoder<M> evidence$11) {
        return LayerWriter.validateUpdate$((LayerWriter)this, (LayerId)id, updateMetadata, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9, evidence$10, evidence$11);
    }

    public <K, V, M> Function2<V, V, V> update$default$3() {
        return LayerWriter.update$default$3$((LayerWriter)this);
    }

    public void write(Object id, RDD layer, KeyIndex keyIndex, AvroRecordCodec evidence$41, Encoder evidence$42, ClassTag evidence$43, AvroRecordCodec evidence$44, ClassTag evidence$45, Encoder evidence$46, Component evidence$47) {
        LayerWriter.write$((LayerWriter)this, (Object)id, (RDD)layer, (KeyIndex)keyIndex, (AvroRecordCodec)evidence$41, (Encoder)evidence$42, (ClassTag)evidence$43, (AvroRecordCodec)evidence$44, (ClassTag)evidence$45, (Encoder)evidence$46, (Component)evidence$47);
    }

    public void write(Object id, RDD layer, KeyIndexMethod keyIndexMethod, AvroRecordCodec evidence$48, Encoder evidence$49, ClassTag evidence$50, AvroRecordCodec evidence$51, ClassTag evidence$52, Encoder evidence$53, Component evidence$54) {
        LayerWriter.write$((LayerWriter)this, (Object)id, (RDD)layer, (KeyIndexMethod)keyIndexMethod, (AvroRecordCodec)evidence$48, (Encoder)evidence$49, (ClassTag)evidence$50, (AvroRecordCodec)evidence$51, (ClassTag)evidence$52, (Encoder)evidence$53, (Component)evidence$54);
    }

    public <K, V, M> Writer<LayerId, RDD<Tuple2<K, V>>> writer(KeyIndexMethod<K> keyIndexMethod, AvroRecordCodec<K> evidence$55, Encoder<K> evidence$56, ClassTag<K> evidence$57, AvroRecordCodec<V> evidence$58, ClassTag<V> evidence$59, Encoder<M> evidence$60, Component<M, Bounds<K>> evidence$61) {
        return LayerWriter.writer$((LayerWriter)this, keyIndexMethod, evidence$55, evidence$56, evidence$57, evidence$58, evidence$59, evidence$60, evidence$61);
    }

    public <K, V, M> Writer<LayerId, RDD<Tuple2<K, V>>> writer(KeyIndex<K> keyIndex, AvroRecordCodec<K> evidence$62, Encoder<K> evidence$63, ClassTag<K> evidence$64, AvroRecordCodec<V> evidence$65, ClassTag<V> evidence$66, Encoder<M> evidence$67, Component<M, Bounds<K>> evidence$68) {
        return LayerWriter.writer$((LayerWriter)this, keyIndex, evidence$62, evidence$63, evidence$64, evidence$65, evidence$66, evidence$67, evidence$68);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        S3LayerWriter s3LayerWriter = this;
        synchronized (s3LayerWriter) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(S3LayerWriter.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public S3RDDWriter rddWriter() {
        return new S3RDDWriter(this.s3Client, this.runtime);
    }

    public <K, V, M> void overwrite(LayerId id, RDD<Tuple2<K, V>> rdd, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, Encoder<K> evidence$3, Decoder<K> evidence$4, ClassTag<K> evidence$5, AvroRecordCodec<V> evidence$6, ClassTag<V> evidence$7, Encoder<M> evidence$8, Decoder<M> evidence$9, Component<M, Bounds<K>> evidence$10, Semigroup<M> evidence$11) {
        this.update(id, rdd, (Option<Function2<V, V, V>>)None$.MODULE$, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9, evidence$10, evidence$11);
    }

    public <K, V, M> void update(LayerId id, RDD<Tuple2<K, V>> rdd, Function2<V, V, V> mergeFunc, AvroRecordCodec<K> evidence$12, Boundable<K> evidence$13, Encoder<K> evidence$14, Decoder<K> evidence$15, ClassTag<K> evidence$16, AvroRecordCodec<V> evidence$17, ClassTag<V> evidence$18, Encoder<M> evidence$19, Decoder<M> evidence$20, Component<M, Bounds<K>> evidence$21, Semigroup<M> evidence$22) {
        this.update(id, rdd, (Option<Function2<V, V, V>>)new Some(mergeFunc), evidence$12, evidence$13, evidence$14, evidence$15, evidence$16, evidence$17, evidence$18, evidence$19, evidence$20, evidence$21, evidence$22);
    }

    private <K, V, M> void update(LayerId id, RDD<Tuple2<K, V>> rdd, Option<Function2<V, V, V>> mergeFunc, AvroRecordCodec<K> evidence$23, Boundable<K> evidence$24, Encoder<K> evidence$25, Decoder<K> evidence$26, ClassTag<K> evidence$27, AvroRecordCodec<V> evidence$28, ClassTag<V> evidence$29, Encoder<M> evidence$30, Decoder<M> evidence$31, Component<M, Bounds<K>> evidence$32, Semigroup<M> evidence$33) {
        Some some;
        LayerAttributes layerAttributes;
        Option option = this.validateUpdate(id, ((Metadata)rdd).metadata(), S3LayerHeader$.MODULE$.s3LayerHeaderEncoder(), S3LayerHeader$.MODULE$.s3LayerHeaderDecoder(), evidence$23, evidence$24, evidence$25, evidence$27, evidence$28, evidence$32, evidence$33, evidence$30, evidence$31);
        if (option instanceof Some && (layerAttributes = (LayerAttributes)(some = (Some)option).value()) != null) {
            S3LayerHeader header = (S3LayerHeader)layerAttributes.header();
            Object metadata = layerAttributes.metadata();
            KeyIndex keyIndex = layerAttributes.keyIndex();
            Schema writerSchema = layerAttributes.schema();
            String prefix = header.key();
            String bucket = header.bucket();
            int maxWidth = Index$.MODULE$.digits(keyIndex.toIndex(keyIndex.keyBounds().maxKey()));
            Function1 & Serializable keyPath = (Function1 & Serializable)key -> geotrellis.store.s3.package$.MODULE$.makePath((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{prefix, Index$.MODULE$.encode(keyIndex.toIndex(key), maxWidth)}));
            if (this.logger().isInfoEnabled()) {
                this.logger().info(new StringBuilder(30).append("Writing update for layer ").append(id).append(" to ").append(bucket).append(" ").append(prefix).toString());
            }
            this.attributeStore().writeLayerAttributes(id, (Object)header, metadata, keyIndex, writerSchema, S3LayerHeader$.MODULE$.s3LayerHeaderEncoder(), evidence$30, evidence$27);
            S3RDDWriter qual$1 = this.rddWriter();
            RDD<Tuple2<K, V>> x$1 = rdd;
            String x$2 = bucket;
            Function1 & Serializable x$3 = keyPath;
            Some x$4 = new Some((Object)writerSchema);
            Option<Function2<V, V, V>> x$5 = mergeFunc;
            Function1<PutObjectRequest, PutObjectRequest> x$6 = qual$1.update$default$6();
            qual$1.update(x$1, x$2, x$3, (Option<Schema>)x$4, x$5, x$6, evidence$23, evidence$27, evidence$28, evidence$29);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn(new StringBuilder(39).append("Skipping update with empty bounds for ").append(id).append(".").toString());
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public <K, V, M> void _write(LayerId id, RDD<Tuple2<K, V>> rdd, KeyIndex<K> keyIndex, AvroRecordCodec<K> evidence$34, Encoder<K> evidence$35, ClassTag<K> evidence$36, AvroRecordCodec<V> evidence$37, ClassTag<V> evidence$38, Encoder<M> evidence$39, Component<M, Bounds<K>> evidence$40) {
        Predef$.MODULE$.require(!this.attributeStore().layerExists(id), (Function0 & Serializable)() -> new StringBuilder(15).append(id).append(" already exists").toString());
        SparkContext sc = rdd.sparkContext();
        String prefix = geotrellis.store.s3.package$.MODULE$.makePath((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.keyPrefix, new StringBuilder(1).append(id.name()).append("/").append(id.zoom()).toString()}));
        Object metadata = ((Metadata)rdd).metadata();
        S3LayerHeader header = new S3LayerHeader(package$.MODULE$.classTag(evidence$36).toString(), package$.MODULE$.classTag(evidence$38).toString(), this.bucket, prefix, S3LayerHeader$.MODULE$.apply$default$5());
        int maxWidth = Index$.MODULE$.digits(keyIndex.toIndex(keyIndex.keyBounds().maxKey()));
        Function1 & Serializable keyPath = (Function1 & Serializable)key -> geotrellis.store.s3.package$.MODULE$.makePath((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{prefix, Index$.MODULE$.encode(keyIndex.toIndex(key), maxWidth)}));
        Schema schema = KeyValueRecordCodec$.MODULE$.apply(evidence$34, evidence$37).schema();
        try {
            this.attributeStore().writeLayerAttributes(id, (Object)header, metadata, keyIndex, schema, S3LayerHeader$.MODULE$.s3LayerHeaderEncoder(), evidence$39, evidence$36);
            if (this.logger().isInfoEnabled()) {
                this.logger().info(new StringBuilder(17).append("Saving RDD ").append(id.name()).append(" to ").append(this.bucket).append("  ").append(prefix).toString());
            }
            this.rddWriter().write(rdd, this.bucket, keyPath, this.putObjectModifier, evidence$34, evidence$36, evidence$37, evidence$38);
        }
        catch (Exception e) {
            throw new package.LayerWriteError(id, package.LayerWriteError$.MODULE$.$lessinit$greater$default$2()).initCause((Throwable)e);
        }
    }

    public S3LayerWriter(AttributeStore attributeStore, String bucket, String keyPrefix, Function1<PutObjectRequest, PutObjectRequest> putObjectModifier, Function0<S3Client> s3Client, Function0<IORuntime> runtime) {
        this.attributeStore = attributeStore;
        this.bucket = bucket;
        this.keyPrefix = keyPrefix;
        this.putObjectModifier = putObjectModifier;
        this.s3Client = s3Client;
        this.runtime = runtime;
        LayerWriter.$init$((LayerWriter)this);
    }
}

