/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import cats.effect.unsafe.IORuntime;
import geotrellis.layer.Boundable;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.spark.store.s3.S3RDDReader$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import geotrellis.store.avro.AvroEncoder$;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec$;
import geotrellis.store.index.IndexRanges$;
import geotrellis.store.index.MergeQueue$;
import geotrellis.store.util.IOUtils$;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\u0007\u000f\u0001]A\u0001B\u000b\u0001\u0003\u0002\u0013\u0006Ia\u000b\u0005\tw\u0001\u0011\t\u0011*A\u0005y!)q\t\u0001C\u0001\u0011\")Q\n\u0001C\u0001\u001d\"I\u0011q\u000f\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003+\u0003\u0011\u0013!C\u0001\u0003/;\u0011\"!)\u000f\u0003\u0003E\t!a)\u0007\u00115q\u0011\u0011!E\u0001\u0003KCaa\u0012\u0005\u0005\u0002\u0005U\u0006\"CA\\\u0011E\u0005I\u0011AA]\u0011%\ti\fCI\u0001\n\u0003\ty\fC\u0005\u0002D\"\t\t\u0011\"\u0003\u0002F\nY1k\r*E\tJ+\u0017\rZ3s\u0015\ty\u0001#\u0001\u0002tg)\u0011\u0011CE\u0001\u0006gR|'/\u001a\u0006\u0003'Q\tQa\u001d9be.T\u0011!F\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 O9\u0011\u0001%\n\b\u0003C\u0011j\u0011A\t\u0006\u0003GY\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005\u0019R\u0012a\u00029bG.\fw-Z\u0005\u0003Q%\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!A\n\u000e\u0002\u0011M\u001c4\t\\5f]R\u00042!\u0007\u0017/\u0013\ti#D\u0001\u0005=Eft\u0017-\\3?!\ty\u0013(D\u00011\u0015\ty\u0011G\u0003\u00023g\u0005A1/\u001a:wS\u000e,7O\u0003\u00025k\u00051\u0011m^:tI.T!AN\u001c\u0002\r\u0005l\u0017M_8o\u0015\u0005A\u0014\u0001C:pMR<\u0018M]3\n\u0005i\u0002$\u0001C*4\u00072LWM\u001c;\u0002\u000fI,h\u000e^5nKB\u0019\u0011\u0004L\u001f\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015AB;og\u00064WM\u0003\u0002C\u0007\u00061QM\u001a4fGRT\u0011\u0001R\u0001\u0005G\u0006$8/\u0003\u0002G\u007f\tI\u0011j\u0014*v]RLW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%[E\n\u0005\u0002K\u00015\ta\u0002C\u0004+\u0007A%\t\u0019A\u0016\t\u000fm\u001a\u0001\u0013\"a\u0001y\u0005!!/Z1e+\ry\u0015m\u001b\u000b\u0010!\u0006=\u00111EA\u001a\u0003\u0007\ni%a\u0016\u0002lQ1\u0011+\u001c<\u007f\u0003\u0007\u00012A\u0015.]\u001b\u0005\u0019&B\u0001+V\u0003\r\u0011H\r\u001a\u0006\u0003'YS!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO&\u00111l\u0015\u0002\u0004%\u0012#\u0005\u0003B\r^?*L!A\u0018\u000e\u0003\rQ+\b\u000f\\33!\t\u0001\u0017\r\u0004\u0001\u0005\u000b\t$!\u0019A2\u0003\u0003-\u000b\"\u0001Z4\u0011\u0005e)\u0017B\u00014\u001b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u00075\n\u0005%T\"aA!osB\u0011\u0001m\u001b\u0003\u0006Y\u0012\u0011\ra\u0019\u0002\u0002-\"9a\u000eBA\u0001\u0002\by\u0017AC3wS\u0012,gnY3%cA\u0019\u0001\u000f^0\u000e\u0003ET!A]:\u0002\t\u00054(o\u001c\u0006\u0003#QI!!^9\u0003\u001f\u00053(o\u001c*fG>\u0014HmQ8eK\u000eDqa\u001e\u0003\u0002\u0002\u0003\u000f\u00010\u0001\u0006fm&$WM\\2fII\u00022!\u001f?`\u001b\u0005Q(BA>\u0015\u0003\u0015a\u0017-_3s\u0013\ti(PA\u0005C_VtG-\u00192mK\"Aq\u0010BA\u0001\u0002\b\t\t!\u0001\u0006fm&$WM\\2fIM\u00022\u0001\u001d;k\u0011\u001d\t)\u0001\u0002a\u0002\u0003\u000f\t!a]2\u0011\t\u0005%\u00111B\u0007\u0002+&\u0019\u0011QB+\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000f\u0005EA\u00011\u0001\u0002\u0014\u00051!-^2lKR\u0004B!!\u0006\u0002\u001e9!\u0011qCA\r!\t\t#$C\u0002\u0002\u001ci\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0010\u0003C\u0011aa\u0015;sS:<'bAA\u000e5!9\u0011Q\u0005\u0003A\u0002\u0005\u001d\u0012aB6fsB\u000bG\u000f\u001b\t\b3\u0005%\u0012QFA\n\u0013\r\tYC\u0007\u0002\n\rVt7\r^5p]F\u00022aHA\u0018\u0013\r\t\t$\u000b\u0002\u0007\u0005&<\u0017J\u001c;\t\u000f\u0005UB\u00011\u0001\u00028\u0005q\u0011/^3ss.+\u0017PQ8v]\u0012\u001c\b#B\u0010\u0002:\u0005u\u0012bAA\u001eS\t\u00191+Z9\u0011\te\fydX\u0005\u0004\u0003\u0003R(!C&fs\n{WO\u001c3t\u0011\u001d\t)\u0005\u0002a\u0001\u0003\u000f\nq\u0002Z3d_6\u0004xn]3C_VtGm\u001d\t\b3\u0005%\u0012QHA%!\u0015y\u0012\u0011HA&!\u0019IR,!\f\u0002.!9\u0011q\n\u0003A\u0002\u0005E\u0013a\u00044jYR,'/\u00138eKb|e\u000e\\=\u0011\u0007e\t\u0019&C\u0002\u0002Vi\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002Z\u0011\u0001\n\u00111\u0001\u0002\\\u0005aqO]5uKJ\u001c6\r[3nCB)\u0011$!\u0018\u0002b%\u0019\u0011q\f\u000e\u0003\r=\u0003H/[8o!\u0011\t\u0019'a\u001a\u000e\u0005\u0005\u0015$B\u0001:W\u0013\u0011\tI'!\u001a\u0003\rM\u001b\u0007.Z7b\u0011%\ti\u0007\u0002I\u0001\u0002\u0004\ty'A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u00063\u0005u\u0013\u0011\u000f\t\u00043\u0005M\u0014bAA;5\t\u0019\u0011J\u001c;\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%mU1\u00111PAI\u0003'+\"!! +\t\u0005m\u0013qP\u0016\u0003\u0003\u0003\u0003B!a!\u0002\u000e6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0012\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0006\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)!-\u0002b\u0001G\u0012)A.\u0002b\u0001G\u0006q!/Z1eI\u0011,g-Y;mi\u0012:TCBAM\u0003;\u000by*\u0006\u0002\u0002\u001c*\"\u0011qNA@\t\u0015\u0011gA1\u0001d\t\u0015agA1\u0001d\u0003-\u00196G\u0015#E%\u0016\fG-\u001a:\u0011\u0005)C1\u0003\u0002\u0005\u0019\u0003O\u0003B!!+\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0002j_*\u0011\u0011\u0011W\u0001\u0005U\u00064\u0018-C\u0002)\u0003W#\"!a)\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tYLK\u0002/\u0003\u007f\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAAaU\ri\u0014qP\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003\u000f\u0004B!!3\u0002P6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy+\u0001\u0003mC:<\u0017\u0002BAi\u0003\u0017\u0014aa\u00142kK\u000e$\b")
public class S3RDDReader
implements Serializable {
    private final Function0<S3Client> s3Client;
    private final Function0<IORuntime> runtime;

    public static IORuntime $lessinit$greater$default$2() {
        return S3RDDReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static S3Client $lessinit$greater$default$1() {
        return S3RDDReader$.MODULE$.$lessinit$greater$default$1();
    }

    public <K, V> RDD<Tuple2<K, V>> read(String bucket, Function1<BigInt, String> keyPath, Seq<KeyBounds<K>> queryKeyBounds, Function1<KeyBounds<K>, Seq<Tuple2<BigInt, BigInt>>> decomposeBounds, boolean filterIndexOnly, Option<Schema> writerSchema, Option<Object> numPartitions, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, AvroRecordCodec<V> evidence$3, SparkContext sc) {
        if (queryKeyBounds.isEmpty()) {
            return sc.emptyRDD(ClassTag$.MODULE$.apply(Tuple2.class));
        }
        Seq ranges = queryKeyBounds.length() > 1 ? MergeQueue$.MODULE$.apply((IterableOnce)queryKeyBounds.flatMap(decomposeBounds)) : (Seq)queryKeyBounds.flatMap(decomposeBounds);
        Seq bins = IndexRanges$.MODULE$.bin(ranges, BoxesRunTime.unboxToInt((Object)numPartitions.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> sc.defaultParallelism())));
        Function1 & Serializable includeKey = (Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)S3RDDReader.$anonfun$read$2(queryKeyBounds, evidence$2, key));
        KeyValueRecordCodec _recordCodec = KeyValueRecordCodec$.MODULE$.apply(evidence$1, evidence$3);
        KryoWrapper kwWriterSchema = KryoWrapper$.MODULE$.apply(writerSchema, ClassTag$.MODULE$.apply(Option.class));
        RDD qual$1 = sc.parallelize(bins, bins.size(), ClassTag$.MODULE$.apply(Seq.class));
        Function1 & Serializable x$1 = (Function1 & Serializable)partition -> {
            IORuntime ioRuntime = (IORuntime)$this.runtime.apply();
            S3Client s3Client = (S3Client)$this.s3Client.apply();
            Schema writerSchema = (Schema)((Option)kwWriterSchema.value()).getOrElse((Function0 & Serializable)() -> _recordCodec.schema());
            return partition.flatMap((Function1 & Serializable)seq -> IOUtils$.MODULE$.parJoinEBO(seq.iterator(), (Function1 & Serializable)index -> {
                Vector vector;
                try {
                    GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key((String)keyPath.apply(index)).build();
                    ResponseInputStream is = s3Client.getObject(request);
                    byte[] bytes = IOUtils.toByteArray((InputStream)is);
                    is.close();
                    Vector recs = (Vector)AvroEncoder$.MODULE$.fromBinary(writerSchema, bytes, (AvroRecordCodec)_recordCodec);
                    vector = filterIndexOnly ? recs : (Vector)recs.filter((Function1 & Serializable)row -> BoxesRunTime.boxToBoolean((boolean)S3RDDReader.$anonfun$read$7(includeKey, row)));
                }
                catch (Throwable throwable) {
                    S3Exception s3Exception;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof S3Exception && (s3Exception = (S3Exception)throwable2).statusCode() == 404) {
                        vector = package$.MODULE$.Vector().empty();
                    }
                    throw throwable;
                }
                return vector;
            }, (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)S3RDDReader.$anonfun$read$8(x0$1)), ioRuntime));
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        return qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K, V> Option<Schema> read$default$6() {
        return None$.MODULE$;
    }

    public <K, V> Option<Object> read$default$7() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$read$2(Seq queryKeyBounds$1, Boundable evidence$2$1, Object key) {
        return KeyBounds$.MODULE$.KeyBoundsSeqMethods(queryKeyBounds$1, evidence$2$1).includeKey(key);
    }

    public static final /* synthetic */ boolean $anonfun$read$7(Function1 includeKey$1, Tuple2 row) {
        return BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply(row._1()));
    }

    public static final /* synthetic */ boolean $anonfun$read$8(Throwable x0$1) {
        boolean bl = false;
        S3Exception s3Exception = null;
        Throwable throwable = x0$1;
        if (throwable instanceof S3Exception) {
            bl = true;
            s3Exception = (S3Exception)throwable;
            if (s3Exception.statusCode() == 500) {
                return true;
            }
        }
        return bl && s3Exception.statusCode() == 503;
    }

    public S3RDDReader(Function0<S3Client> s3Client, Function0<IORuntime> runtime) {
        this.s3Client = s3Client;
        this.runtime = runtime;
    }
}

