/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import cats.ApplicativeError;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Sync;
import cats.effect.unsafe.IORuntime;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import geotrellis.layer.SpatialKey;
import geotrellis.store.LayerId;
import geotrellis.store.s3.S3ClientProducer$;
import geotrellis.store.util.IORuntimeTransient$;
import geotrellis.store.util.IOUtils$;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.rdd.RDD;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

public final class SaveToS3$ {
    public static final SaveToS3$ MODULE$ = new SaveToS3$();

    public Function1<SpatialKey, String> spatialKeyToPath(LayerId id, String pathTemplate) {
        return (Function1 & Serializable)key -> pathTemplate.replace("{x}", Integer.toString(key.col())).replace("{y}", Integer.toString(key.row())).replace("{z}", Integer.toString(id.zoom())).replace("{name}", id.name());
    }

    public <K, V> void apply(RDD<Tuple2<K, V>> rdd, Function1<K, String> keyToUri, Function1<PutObjectRequest, PutObjectRequest> putObjectModifier, Function0<S3Client> s3Client, Function0<IORuntime> runtime, Function1<V, byte[]> ev) {
        Function1 & Serializable keyToPrefix = (Function1 & Serializable)key -> {
            URI uri = new URI((String)keyToUri.apply(key));
            String string = uri.getScheme();
            String string2 = "s3";
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> new StringBuilder(34).append("SaveToS3 only supports s3 scheme: ").append(uri).toString());
            String bucket = uri.getAuthority();
            String prefix = uri.getPath().substring(1);
            return new Tuple2((Object)bucket, (Object)prefix);
        };
        rdd.foreachPartition((Function1 & Serializable)partition -> {
            SaveToS3$.$anonfun$apply$3(s3Client, ev, keyToPrefix, putObjectModifier, runtime, partition);
            return BoxedUnit.UNIT;
        });
    }

    public <K, V> Function1<PutObjectRequest, PutObjectRequest> apply$default$3() {
        return (Function1 & Serializable)p -> p;
    }

    public <K, V> S3Client apply$default$4() {
        return (S3Client)S3ClientProducer$.MODULE$.get().apply();
    }

    public <K, V> IORuntime apply$default$5() {
        return IORuntimeTransient$.MODULE$.IORuntime();
    }

    public static final /* synthetic */ boolean $anonfun$apply$7(Throwable x0$2) {
        S3Exception s3Exception;
        Throwable throwable = x0$2;
        return throwable instanceof S3Exception && (s3Exception = (S3Exception)throwable).statusCode() == 503;
    }

    public static final /* synthetic */ void $anonfun$apply$3(Function0 s3Client$1, Function1 ev$1, Function1 keyToPrefix$1, Function1 putObjectModifier$1, Function0 runtime$1, Iterator partition) {
        S3Client s3client = (S3Client)s3Client$1.apply();
        Stream requests = Stream.PartiallyAppliedFromBlockingIterator$.MODULE$.apply$extension(Stream$.MODULE$.fromBlockingIterator(), partition.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object data = tuple2._2();
                byte[] bytes = (byte[])ev$1.apply(data);
                Tuple2 tuple22 = (Tuple2)keyToPrefix$1.apply(key);
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                String bucket = (String)tuple22._1();
                String path = (String)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)bucket, (Object)path);
                String bucket2 = (String)tuple23._1();
                String path2 = (String)tuple23._2();
                PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket2).key(path2).contentLength(Predef$.MODULE$.long2Long((long)bytes.length)).build();
                RequestBody requestBody = RequestBody.fromBytes((byte[])bytes);
                return new Tuple2(putObjectModifier$1.apply((Object)request), (Object)requestBody);
            }
            throw new MatchError((Object)tuple2);
        }), 1, (Sync)IO$.MODULE$.asyncForIO());
        IORuntime ioRuntime = (IORuntime)runtime$1.apply();
        Function2 & Serializable write = (Function2 & Serializable)(request, requestBody) -> Stream$.MODULE$.eval(IOUtils$.MODULE$.IOBackoff((Object)IO$.MODULE$.blocking((Function0 & Serializable)() -> s3client.putObject(request, requestBody)), (ApplicativeError)IO$.MODULE$.asyncForIO(), (GenTemporal)IO$.MODULE$.asyncForIO()).retryEBO((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)SaveToS3$.$anonfun$apply$7(x0$2))));
        EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither((Either)((IO)Stream.NestedStreamOps$.MODULE$.parJoinUnbounded$extension(Stream$.MODULE$.NestedStreamOps(requests.map(Function$.MODULE$.tupled((Function2)write))), (GenConcurrent)IO$.MODULE$.asyncForIO()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).toVector()).attempt().unsafeRunSync(ioRuntime)), (Function1 & Serializable)x$2 -> {
            throw x$2;
        });
    }

    private SaveToS3$() {
    }
}

