/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.layer.TemporalProjectedExtent$;
import geotrellis.proj4.CRS;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff$;
import geotrellis.spark.store.s3.GeoTiffS3InputFormat$;
import geotrellis.spark.store.s3.S3RecordReader;
import geotrellis.spark.store.s3.TemporalGeoTiffS3InputFormat$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.sys.package$;
import software.amazon.awssdk.services.s3.S3Client;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0005\u000b\u0001MA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\te\u0001\u0011\t\u0011)A\u0005g!)q\b\u0001C\u0001\u0001\"9A\t\u0001b\u0001\n\u0003)\u0005B\u0002(\u0001A\u0003%a\tC\u0004P\u0001\t\u0007I\u0011\u0001)\t\re\u0003\u0001\u0015!\u0003R\u0011\u0015Q\u0006\u0001\"\u0001\\\u0005u!V-\u001c9pe\u0006dw)Z8US\u001a47k\r*fG>\u0014HMU3bI\u0016\u0014(BA\u0006\r\u0003\t\u00198G\u0003\u0002\u000e\u001d\u0005)1\u000f^8sK*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0002#\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0005+YAb$D\u0001\u000b\u0013\t9\"B\u0001\bTgI+7m\u001c:e%\u0016\fG-\u001a:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m\u0001\u0012!\u00027bs\u0016\u0014\u0018BA\u000f\u001b\u0005]!V-\u001c9pe\u0006d\u0007K]8kK\u000e$X\rZ#yi\u0016tG\u000f\u0005\u0002 E5\t\u0001E\u0003\u0002\"!\u00051!/Y:uKJL!a\t\u0011\u0003\tQKG.Z\u0001\tgN\u001aE.[3oiB\u0011a\u0005M\u0007\u0002O)\u00111\u0002\u000b\u0006\u0003S)\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003W1\na!Y<tg\u0012\\'BA\u0017/\u0003\u0019\tW.\u0019>p]*\tq&\u0001\u0005t_\u001a$x/\u0019:f\u0013\t\ttE\u0001\u0005Tg\rc\u0017.\u001a8u\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001N\u001f\u000e\u0003UR!AN\u001c\u0002\u00135\f\u0007O]3ek\u000e,'B\u0001\u001d:\u0003\u0019A\u0017\rZ8pa*\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h\u0013\tqTG\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002B\u0005\u000e\u0003\"!\u0006\u0001\t\u000b\u0011\u001a\u0001\u0019A\u0013\t\u000bI\u001a\u0001\u0019A\u001a\u0002\u000fQLW.\u001a+bOV\ta\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A.\u00198h\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\rM#(/\u001b8h\u0003!!\u0018.\\3UC\u001e\u0004\u0013!\u00043bi\u00164uN]7biR,'/F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003-*\u000bA\u0001^5nK&\u0011\u0001l\u0015\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\u0018A\u00043bi\u00164uN]7biR,'\u000fI\u0001\u0005e\u0016\fG\rF\u0002]E:\u0004B!\u00181\u0019=5\taLC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tgL\u0001\u0004UkBdWM\r\u0005\u0006G\"\u0001\r\u0001Z\u0001\u0004W\u0016L\bCA3m\u001d\t1'\u000e\u0005\u0002h=6\t\u0001N\u0003\u0002j%\u00051AH]8pizJ!a\u001b0\u0002\rA\u0013X\rZ3g\u0013\tiUN\u0003\u0002l=\")q\u000e\u0003a\u0001a\u0006)!-\u001f;fgB\u0019Q,]:\n\u0005It&!B!se\u0006L\bCA/u\u0013\t)hL\u0001\u0003CsR,\u0007F\u0002\u0001xunlh\u0010\u0005\u0002^q&\u0011\u0011P\u0018\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017aB7fgN\fw-Z\u0011\u0002y\u0006)E+Z7q_J\fGnR3p)&4gmU\u001aSK\u000e|'\u000f\u001a*fC\u0012,'\u000fI5tA\u0011,\u0007O]3dCR,G\r\f\u0011vg\u0016\u00043kM$f_RKgM\u001a*E\t\u0002Jgn\u001d;fC\u0012\fQa]5oG\u0016\f\u0013a`\u0001\u0006c9\u0002d\u0006\r")
public class TemporalGeoTiffS3RecordReader
extends S3RecordReader<TemporalProjectedExtent, Tile> {
    private final TaskAttemptContext context;
    private final String timeTag;
    private final DateTimeFormatter dateFormatter;

    public String timeTag() {
        return this.timeTag;
    }

    public DateTimeFormatter dateFormatter() {
        return this.dateFormatter;
    }

    @Override
    public Tuple2<TemporalProjectedExtent, Tile> read(String key, byte[] bytes) {
        CRS crs;
        Raster raster;
        Option<CRS> inputCrs;
        ZonedDateTime dateTime;
        block3: {
            ProjectedRaster projectedRaster;
            block2: {
                SinglebandGeoTiff geoTiff = SinglebandGeoTiff$.MODULE$.apply(bytes);
                String dateTimeString = (String)geoTiff.tags().headTags().getOrElse((Object)this.timeTag(), (Function0 & Serializable)() -> package$.MODULE$.error(new StringBuilder(38).append("There is no tag ").append(this.timeTag()).append(" in the GeoTiff header").toString()));
                dateTime = ZonedDateTime.from(this.dateFormatter().parse(dateTimeString));
                inputCrs = GeoTiffS3InputFormat$.MODULE$.getCrs((JobContext)this.context);
                projectedRaster = geoTiff.projectedRaster();
                if (projectedRaster == null) break block2;
                raster = projectedRaster.raster();
                crs = projectedRaster.crs();
                if (raster != null) break block3;
            }
            throw new MatchError((Object)projectedRaster);
        }
        Tile tile = (Tile)raster.tile();
        Extent extent = raster.extent();
        Tuple3 tuple3 = new Tuple3((Object)tile, (Object)extent, (Object)crs);
        Tile tile2 = (Tile)tuple3._1();
        Extent extent2 = (Extent)tuple3._2();
        CRS crs2 = (CRS)tuple3._3();
        return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(extent2, (CRS)inputCrs.getOrElse((Function0 & Serializable)() -> crs2), dateTime), (Object)tile2);
    }

    public TemporalGeoTiffS3RecordReader(S3Client s3Client, TaskAttemptContext context) {
        this.context = context;
        super(s3Client);
        this.timeTag = TemporalGeoTiffS3InputFormat$.MODULE$.getTimeTag((JobContext)context);
        this.dateFormatter = TemporalGeoTiffS3InputFormat$.MODULE$.getTimeFormatter((JobContext)context);
    }
}

