/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3;

import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.layer.TemporalProjectedExtent$;
import geotrellis.proj4.CRS;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.spark.store.s3.GeoTiffS3InputFormat$;
import geotrellis.spark.store.s3.S3InputFormat;
import geotrellis.spark.store.s3.S3RecordReader;
import geotrellis.spark.store.s3.TemporalGeoTiffS3InputFormat$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u00193Aa\u0001\u0003\u0001\u001b!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0001E\t)C+Z7q_J\fG.T;mi&\u0014\u0017M\u001c3HK>$\u0016N\u001a4Tg%s\u0007/\u001e;G_Jl\u0017\r\u001e\u0006\u0003\u000b\u0019\t!a]\u001a\u000b\u0005\u001dA\u0011!B:u_J,'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\u0005Y\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011C\u0001\u0001\u000f!\u0011y\u0001C\u0005\r\u000e\u0003\u0011I!!\u0005\u0003\u0003\u001bM\u001b\u0014J\u001c9vi\u001a{'/\\1u!\t\u0019b#D\u0001\u0015\u0015\t)\"\"A\u0003mCf,'/\u0003\u0002\u0018)\t9B+Z7q_J\fG\u000e\u0015:pU\u0016\u001cG/\u001a3FqR,g\u000e\u001e\t\u00033qi\u0011A\u0007\u0006\u00037)\taA]1ti\u0016\u0014\u0018BA\u000f\u001b\u00055iU\u000f\u001c;jE\u0006tG\rV5mK\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003\u001f\u0001\t!c\u0019:fCR,'+Z2pe\u0012\u0014V-\u00193feR\u00191E\n\u001b\u0011\t=!#\u0003G\u0005\u0003K\u0011\u0011abU\u001aSK\u000e|'\u000f\u001a*fC\u0012,'\u000fC\u0003(\u0005\u0001\u0007\u0001&A\u0003ta2LG\u000f\u0005\u0002*e5\t!F\u0003\u0002,Y\u0005IQ.\u00199sK\u0012,8-\u001a\u0006\u0003[9\na\u0001[1e_>\u0004(BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003\u0015%s\u0007/\u001e;Ta2LG\u000fC\u00036\u0005\u0001\u0007a'A\u0004d_:$X\r\u001f;\u0011\u0005%:\u0014B\u0001\u001d+\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;)\r\u0001Q\u0004)Q\"E!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005)!W\r\u001d:fG\u0006$X\rZ\u0001\b[\u0016\u001c8/Y4fC\u0005\u0011\u0015!\u0014+f[B|'/\u00197Nk2$\u0018NY1oI\u001e+w\u000eV5gMN\u001b\u0014J\u001c9vi\u001a{'/\\1uA%\u001c\b\u0005Z3qe\u0016\u001c\u0017\r^3eY\u0001*8/\u001a\u0011Tg\u001d+w\u000eV5gMJ#E\tI5ogR,\u0017\rZ\u0001\u0006g&t7-Z\u0011\u0002\u000b\u0006)\u0011G\f\u0019/a\u0001")
public class TemporalMultibandGeoTiffS3InputFormat
extends S3InputFormat<TemporalProjectedExtent, MultibandTile> {
    public S3RecordReader<TemporalProjectedExtent, MultibandTile> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new S3RecordReader<TemporalProjectedExtent, MultibandTile>(this, context){
            private final TaskAttemptContext context$1;

            public Tuple2<TemporalProjectedExtent, MultibandTile> read(String key, byte[] bytes) {
                CRS crs;
                Raster raster;
                ZonedDateTime dateTime;
                Option<CRS> inputCrs;
                block3: {
                    ProjectedRaster projectedRaster;
                    block2: {
                        MultibandGeoTiff geoTiff = MultibandGeoTiff$.MODULE$.apply(bytes);
                        String timeTag = TemporalGeoTiffS3InputFormat$.MODULE$.getTimeTag((JobContext)this.context$1);
                        DateTimeFormatter dateFormatter = TemporalGeoTiffS3InputFormat$.MODULE$.getTimeFormatter((JobContext)this.context$1);
                        inputCrs = GeoTiffS3InputFormat$.MODULE$.getCrs((JobContext)this.context$1);
                        String dateTimeString = (String)geoTiff.tags().headTags().getOrElse((Object)timeTag, (Function0 & Serializable)() -> package$.MODULE$.error(new StringBuilder(38).append("There is no tag ").append(timeTag).append(" in the GeoTiff header").toString()));
                        dateTime = ZonedDateTime.parse(dateTimeString, dateFormatter);
                        projectedRaster = geoTiff.projectedRaster();
                        if (projectedRaster == null) break block2;
                        raster = projectedRaster.raster();
                        crs = projectedRaster.crs();
                        if (raster != null) break block3;
                    }
                    throw new MatchError((Object)projectedRaster);
                }
                MultibandTile tile = (MultibandTile)raster.tile();
                Extent extent = raster.extent();
                Tuple3 tuple3 = new Tuple3((Object)tile, (Object)extent, (Object)crs);
                MultibandTile tile2 = (MultibandTile)tuple3._1();
                Extent extent2 = (Extent)tuple3._2();
                CRS crs2 = (CRS)tuple3._3();
                return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(extent2, (CRS)inputCrs.getOrElse((Function0 & Serializable)() -> crs2), dateTime), (Object)tile2);
            }
            {
                this.context$1 = context$1;
                super($outer.getS3Client((JobContext)context$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(java.lang.String ), $anonfun$read$2(geotrellis.proj4.CRS )}, serializedLambda);
            }
        };
    }
}

