/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3.geotiff;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import geotrellis.spark.store.hadoop.geotiff.GeoTiffMetadata;
import geotrellis.spark.store.hadoop.geotiff.GeoTiffMetadata$;
import geotrellis.spark.store.hadoop.geotiff.GeoTiffMetadataTree;
import geotrellis.spark.store.hadoop.geotiff.GeoTiffMetadataTree$;
import geotrellis.spark.store.hadoop.geotiff.JsonGeoTiffAttributeStore;
import geotrellis.spark.store.s3.geotiff.S3GeoTiffInput$;
import geotrellis.store.s3.AmazonS3URI;
import geotrellis.store.s3.S3ClientProducer$;
import geotrellis.util.annotations.experimental;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List;
import scala.io.Codec$;
import scala.io.Source$;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@experimental
public final class S3JsonGeoTiffAttributeStore$ {
    public static final S3JsonGeoTiffAttributeStore$ MODULE$ = new S3JsonGeoTiffAttributeStore$();

    @experimental
    public List<GeoTiffMetadata> readData(URI uri, Function0<S3Client> s3Client) {
        String string;
        AmazonS3URI s3Uri = new AmazonS3URI(uri);
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(s3Uri.getBucket()).key(s3Uri.getKey()).build();
        try (ResponseInputStream objStream = ((S3Client)s3Client.apply()).getObject(request);){
            string = Source$.MODULE$.fromInputStream((InputStream)objStream, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString(" ");
        }
        String json = string;
        return (List)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(package$.MODULE$.parse(json).flatMap((Function1 & Serializable)x$1 -> x$1.as(Decoder$.MODULE$.decodeList(GeoTiffMetadata$.MODULE$.GeoTiffMetadataDecoder())))), (Function1 & Serializable)x$2 -> {
            throw x$2;
        });
    }

    public S3Client readData$default$2() {
        return (S3Client)S3ClientProducer$.MODULE$.get().apply();
    }

    @experimental
    public GeoTiffMetadataTree<GeoTiffMetadata> readDataAsTree(URI uri, Function0<S3Client> s3Client) {
        return GeoTiffMetadataTree$.MODULE$.fromGeoTiffMetadataSeq(this.readData(uri, s3Client), GeoTiffMetadataTree$.MODULE$.fromGeoTiffMetadataSeq$default$2());
    }

    public S3Client readDataAsTree$default$2() {
        return (S3Client)S3ClientProducer$.MODULE$.get().apply();
    }

    public JsonGeoTiffAttributeStore apply(URI uri, Function0<S3Client> s3Client) {
        return new JsonGeoTiffAttributeStore(uri, (Function1 & Serializable)x$3 -> MODULE$.readDataAsTree((URI)x$3, s3Client));
    }

    public JsonGeoTiffAttributeStore apply(URI path, String name, URI uri, String pattern, boolean recursive, S3Client s3Client) {
        AmazonS3URI s3Uri = new AmazonS3URI(path);
        List<GeoTiffMetadata> data = S3GeoTiffInput$.MODULE$.list(name, uri, pattern, recursive, (Function0<S3Client>)(Function0 & Serializable)() -> S3GeoTiffInput$.MODULE$.list$default$5());
        JsonGeoTiffAttributeStore attributeStore = new JsonGeoTiffAttributeStore(path, (Function1 & Serializable)x$4 -> MODULE$.readDataAsTree((URI)x$4, (Function0<S3Client>)(Function0 & Serializable)() -> s3Client));
        String str = package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(data), (Encoder)Encoder$.MODULE$.encodeList(GeoTiffMetadata$.MODULE$.GeoTiffMetadataEncoder())).noSpaces();
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(s3Uri.getBucket()).key(s3Uri.getKey()).build();
        s3Client.putObject(request, RequestBody.fromBytes((byte[])str.getBytes("UTF-8")));
        return attributeStore;
    }

    public boolean apply$default$5() {
        return true;
    }

    public S3Client apply$default$6() {
        return (S3Client)S3ClientProducer$.MODULE$.get().apply();
    }

    private S3JsonGeoTiffAttributeStore$() {
    }
}

