/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.s3.slippy;

import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.spark.store.s3.slippy.S3SlippyTileReader$;
import geotrellis.spark.store.slippy.SlippyTileReader;
import geotrellis.spark.store.slippy.SlippyTileReader$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.S3Object;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\n\u0014\u0001yA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0005\u0002\u0011\t\u0011*A\u0005\u0007\"A1\u000b\u0001B\u0001B\u0003%A\u000bC\u0003d\u0001\u0011\u0005A\rC\u0004l\u0001\t\u0007I\u0011\u00017\t\rU\u0004\u0001\u0015!\u0003n\u0011\u001d1\bA1A\u0005\u0002]Da! \u0001!\u0002\u0013A\bb\u0002@\u0001\u0005\u0004%\ta\u001e\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u0002=\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005Mq!CA!'\u0005\u0005\t\u0012AA\"\r!\u00112#!A\t\u0002\u0005\u0015\u0003BB2\u000f\t\u0003\t\u0019\u0006C\u0005\u0002V9\t\n\u0011\"\u0001\u0002X!I\u0011\u0011\u000f\b\u0002\u0002\u0013%\u00111\u000f\u0002\u0013'N\u001aF.\u001b9qsRKG.\u001a*fC\u0012,'O\u0003\u0002\u0015+\u000511\u000f\\5qafT!AF\f\u0002\u0005M\u001c$B\u0001\r\u001a\u0003\u0015\u0019Ho\u001c:f\u0015\tQ2$A\u0003ta\u0006\u00148NC\u0001\u001d\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001+\tyRfE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007cA\u0014*W5\t\u0001F\u0003\u0002\u0015/%\u0011!\u0006\u000b\u0002\u0011'2L\u0007\u000f]=US2,'+Z1eKJ\u0004\"\u0001L\u0017\r\u0001\u0011)a\u0006\u0001b\u0001_\t\tA+\u0005\u00021gA\u0011\u0011%M\u0005\u0003e\t\u0012qAT8uQ&tw\r\u0005\u0002\"i%\u0011QG\t\u0002\u0004\u0003:L\u0018aA;sSB\u0011\u0001h\u0010\b\u0003su\u0002\"A\u000f\u0012\u000e\u0003mR!\u0001P\u000f\u0002\rq\u0012xn\u001c;?\u0013\tq$%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 #\u0003!\u00198g\u00117jK:$\bcA\u0011E\r&\u0011QI\t\u0002\ty\tLh.Y7f}A\u0011q)U\u0007\u0002\u0011*\u0011a#\u0013\u0006\u0003\u0015.\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003\u00196\u000ba!Y<tg\u0012\\'B\u0001(P\u0003\u0019\tW.\u0019>p]*\t\u0001+\u0001\u0005t_\u001a$x/\u0019:f\u0013\t\u0011\u0006J\u0001\u0005Tg\rc\u0017.\u001a8u\u0003%1'o\\7CsR,7\u000fE\u0003\"+^k6&\u0003\u0002WE\tIa)\u001e8di&|gN\r\t\u00031nk\u0011!\u0017\u0006\u00035n\tQ\u0001\\1zKJL!\u0001X-\u0003\u0015M\u0003\u0018\r^5bY.+\u0017\u0010E\u0002\"=\u0002L!a\u0018\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0005\n\u0017B\u00012#\u0005\u0011\u0011\u0015\u0010^3\u0002\rqJg.\u001b;?)\r)\u0017N\u001b\u000b\u0003M\"\u00042a\u001a\u0001,\u001b\u0005\u0019\u0002\"B*\u0005\u0001\u0004!\u0006\"\u0002\u001c\u0005\u0001\u00049\u0004b\u0002\"\u0005!\u0013\u0005\raQ\u0001\u0007a\u0006\u00148/\u001a3\u0016\u00035\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\u00079,GOC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Q|'aA+S\u0013\u00069\u0001/\u0019:tK\u0012\u0004\u0013A\u00022vG.,G/F\u0001y!\tIH0D\u0001{\u0015\tY\u0018/\u0001\u0003mC:<\u0017B\u0001!{\u0003\u001d\u0011WoY6fi\u0002\na\u0001\u001d:fM&D\u0018a\u00029sK\u001aL\u0007\u0010I\u0001\u0005e\u0016\fG\rF\u0003,\u0003\u000b\ty\u0001C\u0004\u0002\b-\u0001\r!!\u0003\u0002\ti|w.\u001c\t\u0004C\u0005-\u0011bAA\u0007E\t\u0019\u0011J\u001c;\t\r\u0005E1\u00021\u0001X\u0003)\u0019\b/\u0019;jC2\\W-\u001f\u000b\u0005\u0003+\ty\u0004\u0006\u0003\u0002\u0018\u0005M\u0002CBA\r\u0003S\ti#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\r\u0011H\r\u001a\u0006\u00045\u0005\u0005\"\u0002BA\u0012\u0003K\ta!\u00199bG\",'BAA\u0014\u0003\ry'oZ\u0005\u0005\u0003W\tYBA\u0002S\t\u0012\u0003R!IA\u0018/.J1!!\r#\u0005\u0019!V\u000f\u001d7fe!9\u0011Q\u0007\u0007A\u0004\u0005]\u0012AA:d!\u0011\tI$a\u000f\u000e\u0005\u0005}\u0011\u0002BA\u001f\u0003?\u0011Ab\u00159be.\u001cuN\u001c;fqRDq!a\u0002\r\u0001\u0004\tI!\u0001\nTgMc\u0017\u000e\u001d9z)&dWMU3bI\u0016\u0014\bCA4\u000f'\u0011q\u0001%a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014r\u0003\tIw.\u0003\u0003\u0002R\u0005-#\u0001D*fe&\fG.\u001b>bE2,GCAA\"\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011\u0011LA8+\t\tYFK\u0002G\u0003;Z#!a\u0018\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S\u0012\u0013AC1o]>$\u0018\r^5p]&!\u0011QNA2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006]A\u0011\raL\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003k\u00022!_A<\u0013\r\tIH\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class S3SlippyTileReader<T>
implements SlippyTileReader<T> {
    private final Function0<S3Client> s3Client;
    private final Function2<SpatialKey, byte[], T> fromBytes;
    private final URI parsed;
    private final String bucket;
    private final String prefix;

    public static <T> S3Client $lessinit$greater$default$2() {
        return S3SlippyTileReader$.MODULE$.$lessinit$greater$default$2();
    }

    public T read(int zoom, int x, int y) {
        return (T)SlippyTileReader.read$((SlippyTileReader)this, (int)zoom, (int)x, (int)y);
    }

    public URI parsed() {
        return this.parsed;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public T read(int zoom, SpatialKey spatialkey) {
        SeqOps seqOps;
        SeqOps seqOps2;
        String s3key = new File(this.prefix(), new StringBuilder(2).append(zoom).append("/").append(spatialkey.col()).append("/").append(spatialkey.row()).toString()).getPath();
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(s3key).build();
        List objectList = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(((S3Client)this.s3Client.apply()).listObjectsV2(listRequest).contents()).asScala()).toList();
        List list = objectList;
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(34).append("KeyNotFound: ").append(s3key).append(" not found in bucket ").append(this.bucket()).toString());
        }
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            S3Object s3obj = (S3Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            GetObjectRequest getRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket()).key(s3obj.key()).build();
            ResponseInputStream s3objStream = ((S3Client)this.s3Client.apply()).getObject(getRequest);
            byte[] bytes = IOUtils.toByteArray((InputStream)s3objStream);
            Object t = this.fromBytes.apply((Object)spatialkey, (Object)bytes);
            s3objStream.close();
            return (T)t;
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(42).append("Multiple keys found for prefix ").append(s3key).append(" in bucket ").append(this.bucket()).toString());
    }

    public RDD<Tuple2<SpatialKey, T>> read(int zoom, SparkContext sc) {
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(new File(this.prefix(), Integer.toString(zoom)).getPath()).build();
        Seq s3keys = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala()).flatMap((Function1 & Serializable)s3obj -> {
            Option option;
            String string = s3obj.key();
            if (string != null && !(option = SlippyTileReader$.MODULE$.TilePath().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                String x = (String)((LinearSeqOps)option.get()).apply(0);
                String y = (String)((LinearSeqOps)option.get()).apply(1);
                return new Some((Object)new Tuple2((Object)new SpatialKey(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(y))), (Object)s3obj.key()));
            }
            return None$.MODULE$;
        })).toSeq();
        int numPartitions = scala.math.package$.MODULE$.min(s3keys.size(), scala.math.package$.MODULE$.max(s3keys.size() / 10, 50));
        return RDD$.MODULE$.rddToPairRDDFunctions(sc.parallelize(s3keys, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(String.class), SpatialKey$.MODULE$.ordering()).partitionBy((Partitioner)new HashPartitioner(numPartitions)).mapPartitions((Function1 & Serializable)partition -> {
            S3Client s3Client = (S3Client)$this.s3Client.apply();
            return partition.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    SpatialKey spatialKey = (SpatialKey)tuple2._1();
                    String s3Key = (String)tuple2._2();
                    GetObjectRequest getRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket()).key(s3Key).build();
                    ResponseInputStream s3obj = s3Client.getObject(getRequest);
                    byte[] bytes = IOUtils.toByteArray((InputStream)s3obj);
                    Object t = $this.fromBytes.apply((Object)spatialKey, (Object)bytes);
                    s3obj.close();
                    return new Tuple2((Object)spatialKey, t);
                }
                throw new MatchError((Object)tuple2);
            });
        }, true, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public S3SlippyTileReader(String uri, Function0<S3Client> s3Client, Function2<SpatialKey, byte[], T> fromBytes) {
        this.s3Client = s3Client;
        this.fromBytes = fromBytes;
        SlippyTileReader.$init$((SlippyTileReader)this);
        this.parsed = new URI(uri);
        this.bucket = this.parsed().getHost();
        String path = this.parsed().getPath();
        this.prefix = path.substring(1, path.length());
    }
}

