/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3;

import geotrellis.store.AttributeStore;
import geotrellis.store.LayerDeleter;
import geotrellis.store.LayerId;
import geotrellis.store.package;
import geotrellis.store.s3.S3LayerDeleter$;
import geotrellis.store.s3.S3LayerHeader;
import geotrellis.store.s3.S3LayerHeader$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

@ScalaSignature(bytes="\u0006\u000154A\u0001D\u0007\u0001)!A!\u0005\u0001BC\u0002\u0013\u00051\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003%\u0011!A\u0003A!A%\u0002\u0013I\u0003\"B\u001d\u0001\t\u0003Q\u0004\"B \u0001\t\u0003\u0001\u0005\u0002\u0003$\u0001\u0011\u000b\u0007K\u0011B$\b\u000bQk\u0001\u0012A+\u0007\u000b1i\u0001\u0012\u0001,\t\u000beBA\u0011A,\t\u000baCA\u0011A-\t\u000baCA\u0011\u0001/\u0003\u001dM\u001bD*Y=fe\u0012+G.\u001a;fe*\u0011abD\u0001\u0003gNR!\u0001E\t\u0002\u000bM$xN]3\u000b\u0003I\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0019A$H\u0010\u000e\u0003=I!AH\b\u0003\u00191\u000b\u00170\u001a:EK2,G/\u001a:\u0011\u0005q\u0001\u0013BA\u0011\u0010\u0005\u001da\u0015-_3s\u0013\u0012\fa\"\u0019;ue&\u0014W\u000f^3Ti>\u0014X-F\u0001%!\taR%\u0003\u0002'\u001f\tq\u0011\t\u001e;sS\n,H/Z*u_J,\u0017aD1uiJL'-\u001e;f'R|'/\u001a\u0011\u0002\u0011M\u001c4\t\\5f]R\u00042A\u0006\u0016-\u0013\tYsC\u0001\u0005=Eft\u0017-\\3?!\tis'D\u0001/\u0015\tqqF\u0003\u00021c\u0005A1/\u001a:wS\u000e,7O\u0003\u00023g\u00051\u0011m^:tI.T!\u0001N\u001b\u0002\r\u0005l\u0017M_8o\u0015\u00051\u0014\u0001C:pMR<\u0018M]3\n\u0005ar#\u0001C*4\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\rYTH\u0010\t\u0003y\u0001i\u0011!\u0004\u0005\u0006E\u0011\u0001\r\u0001\n\u0005\u0007Q\u0011!\t\u0019A\u0015\u0002\r\u0011,G.\u001a;f)\t\tE\t\u0005\u0002\u0017\u0005&\u00111i\u0006\u0002\u0005+:LG\u000fC\u0003F\u000b\u0001\u0007q$\u0001\u0002jI\u00061An\\4hKJ,\u0012\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000bQ\u0001\\8hiMT\u0011!T\u0001\u0004_J<\u0017BA(K\u0005\u0019aunZ4fe\"\u0012a!\u0015\t\u0003-IK!aU\f\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018AD*4\u0019\u0006LXM\u001d#fY\u0016$XM\u001d\t\u0003y!\u0019\"\u0001C\u000b\u0015\u0003U\u000bQ!\u00199qYf$2a\u000f.\\\u0011\u0015\u0011#\u00021\u0001%\u0011\u0019A#\u0002\"a\u0001SQ!1(\u00186m\u0011\u0015q6\u00021\u0001`\u0003\u0019\u0011WoY6fiB\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"AY\f\u000e\u0003\rT!\u0001Z\n\u0002\rq\u0012xn\u001c;?\u0013\t1w#\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014\u0018\u0011\u0015Y7\u00021\u0001`\u0003\u0019\u0001(/\u001a4jq\"1\u0001f\u0003CA\u0002%\u0002")
public class S3LayerDeleter
implements LayerDeleter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final Function0<S3Client> s3Client;
    private volatile transient boolean bitmap$trans$0;

    public static S3LayerDeleter apply(String string, String string2, Function0<S3Client> function0) {
        return S3LayerDeleter$.MODULE$.apply(string, string2, function0);
    }

    public static S3LayerDeleter apply(AttributeStore attributeStore, Function0<S3Client> function0) {
        return S3LayerDeleter$.MODULE$.apply(attributeStore, function0);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private Logger logger$lzycompute() {
        S3LayerDeleter s3LayerDeleter = this;
        synchronized (s3LayerDeleter) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(S3LayerDeleter.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void delete(LayerId id) {
        try {
            S3LayerHeader header = (S3LayerHeader)this.attributeStore().readHeader(id, S3LayerHeader$.MODULE$.s3LayerHeaderDecoder());
            String bucket = header.bucket();
            String prefix = new StringBuilder(1).append(header.key()).append("/").toString();
            ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket).prefix(prefix).build();
            Iterable iter = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala();
            if (iter.isEmpty()) {
                throw new package.LayerDeleteError(id);
            }
            List objIdentifiers = ((TraversableOnce)iter.map((Function1 & Serializable & scala.Serializable)s3obj -> (ObjectIdentifier)ObjectIdentifier.builder().key(s3obj.key()).build(), Iterable$.MODULE$.canBuildFrom())).toList();
            Delete deleteDefinition = (Delete)Delete.builder().objects((ObjectIdentifier[])objIdentifiers.toArray(ClassTag$.MODULE$.apply(ObjectIdentifier.class))).build();
            DeleteObjectsRequest deleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete(deleteDefinition).build();
            ((S3Client)this.s3Client.apply()).deleteObjects(deleteRequest);
            this.attributeStore().delete(id);
        }
        catch (package.AttributeNotFoundError e) {
            if (this.logger().isInfoEnabled()) {
                this.logger().info(new StringBuilder(92).append("Metadata for ").append(id).append(" was not found. Any associated layer data (if any) will require manual deletion").toString());
            }
            throw new package.LayerDeleteError(id).initCause((Throwable)e);
        }
        catch (NoSuchBucketException e) {
            if (this.logger().isInfoEnabled()) {
                this.logger().info(new StringBuilder(109).append("Metadata for ").append(id).append(" was not found (no such bucket). Any associated layer data (if any) will require manual deletion").toString());
            }
            throw new package.LayerDeleteError(id).initCause((Throwable)e);
        }
    }

    public S3LayerDeleter(AttributeStore attributeStore, Function0<S3Client> s3Client) {
        this.attributeStore = attributeStore;
        this.s3Client = s3Client;
    }
}

