/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3;

import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.ContextCollection;
import geotrellis.layer.EmptyBounds$;
import geotrellis.layer.KeyBounds$;
import geotrellis.store.AttributeStore;
import geotrellis.store.CollectionLayerReader;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.LayerQuery;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.index.Index$;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import geotrellis.store.s3.S3CollectionLayerReader$;
import geotrellis.store.s3.S3CollectionReader;
import geotrellis.store.s3.S3CollectionReader$;
import geotrellis.store.s3.S3LayerHeader;
import geotrellis.store.s3.S3LayerHeader$;
import geotrellis.store.s3.package$;
import geotrellis.util.Component;
import io.circe.Decoder;
import java.io.Serializable;
import org.apache.avro.Schema;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\b\u0010\u0001YA\u0001B\b\u0001\u0003\u0006\u0004%\ta\b\u0005\tG\u0001\u0011\t\u0011)A\u0005A!AA\u0005\u0001B\u0001J\u0003%Q\u0005C\u00039\u0001\u0011\u0005\u0011\bC\u0003?\u0001\u0011\u0005q\bC\u0003D\u0001\u0011\u0005AiB\u0004\u0002<=A\t!!\u0010\u0007\r9y\u0001\u0012AA \u0011\u0019A\u0004\u0002\"\u0001\u0002H!9\u0011\u0011\n\u0005\u0005\u0002\u0005-\u0003bBA%\u0011\u0011\u0005\u0011q\n\u0005\n\u0003cB\u0011\u0013!C\u0001\u0003gB\u0011\"!#\t#\u0003%\t!a\u001d\u0003/M\u001b4i\u001c7mK\u000e$\u0018n\u001c8MCf,'OU3bI\u0016\u0014(B\u0001\t\u0012\u0003\t\u00198G\u0003\u0002\u0013'\u0005)1\u000f^8sK*\tA#\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001a\u0005\u0002\u0001/A\u0019\u0001$G\u000e\u000e\u0003EI!AG\t\u0003+\r{G\u000e\\3di&|g\u000eT1zKJ\u0014V-\u00193feB\u0011\u0001\u0004H\u0005\u0003;E\u0011q\u0001T1zKJLE-\u0001\bbiR\u0014\u0018NY;uKN#xN]3\u0016\u0003\u0001\u0002\"\u0001G\u0011\n\u0005\t\n\"AD!uiJL'-\u001e;f'R|'/Z\u0001\u0010CR$(/\u001b2vi\u0016\u001cFo\u001c:fA\u0005A1oM\"mS\u0016tG\u000fE\u0002'S-j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\ty\tLh.Y7f}A\u0011AFN\u0007\u0002[)\u0011\u0001C\f\u0006\u0003_A\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003cI\na!Y<tg\u0012\\'BA\u001a5\u0003\u0019\tW.\u0019>p]*\tQ'\u0001\u0005t_\u001a$x/\u0019:f\u0013\t9TF\u0001\u0005Tg\rc\u0017.\u001a8u\u0003\u0019a\u0014N\\5u}Q\u0019!\bP\u001f\u0011\u0005m\u0002Q\"A\b\t\u000by!\u0001\u0019\u0001\u0011\t\u000f\u0011\"\u0001\u0013\"a\u0001K\u0005\u00012m\u001c7mK\u000e$\u0018n\u001c8SK\u0006$WM]\u000b\u0002\u0001B\u00111(Q\u0005\u0003\u0005>\u0011!cU\u001aD_2dWm\u0019;j_:\u0014V-\u00193fe\u0006!!/Z1e+\u0011)u*\u0017/\u0015\u000f\u0019\u000b\u0019#a\n\u00022QaqI\u00184lkv\f\t!a\u0002\u0002\u000eA)\u0001jS'Y76\t\u0011J\u0003\u0002K'\u0005)A.Y=fe&\u0011A*\u0013\u0002\u0012\u0007>tG/\u001a=u\u0007>dG.Z2uS>t\u0007C\u0001(P\u0019\u0001!Q\u0001\u0015\u0004C\u0002E\u0013\u0011aS\t\u0003%V\u0003\"AJ*\n\u0005Q;#a\u0002(pi\"Lgn\u001a\t\u0003MYK!aV\u0014\u0003\u0007\u0005s\u0017\u0010\u0005\u0002O3\u0012)!L\u0002b\u0001#\n\ta\u000b\u0005\u0002O9\u0012)QL\u0002b\u0001#\n\tQ\nC\u0004`\r\u0005\u0005\t9\u00011\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002bI6k\u0011A\u0019\u0006\u0003GF\tA!\u0019<s_&\u0011QM\u0019\u0002\u0010\u0003Z\u0014xNU3d_J$7i\u001c3fG\"9qMBA\u0001\u0002\bA\u0017AC3wS\u0012,gnY3%eA\u0019\u0001*['\n\u0005)L%!\u0003\"pk:$\u0017M\u00197f\u0011\u001dag!!AA\u00045\f!\"\u001a<jI\u0016t7-\u001a\u00134!\rq7/T\u0007\u0002_*\u0011\u0001/]\u0001\u0006G&\u00148-\u001a\u0006\u0002e\u0006\u0011\u0011n\\\u0005\u0003i>\u0014q\u0001R3d_\u0012,'\u000fC\u0004w\r\u0005\u0005\t9A<\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0002yw6k\u0011!\u001f\u0006\u0003u\u001e\nqA]3gY\u0016\u001cG/\u0003\u0002}s\nA1\t\\1tgR\u000bw\rC\u0004\u007f\r\u0005\u0005\t9A@\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007E\u0002bIbC\u0011\"a\u0001\u0007\u0003\u0003\u0005\u001d!!\u0002\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007E\u0002ywbC\u0011\"!\u0003\u0007\u0003\u0003\u0005\u001d!a\u0003\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$s\u0007E\u0002ognC\u0011\"a\u0004\u0007\u0003\u0003\u0005\u001d!!\u0005\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0003\bE\u0004\u0002\u0014\u0005e1,!\b\u000e\u0005\u0005U!bAA\f'\u0005!Q\u000f^5m\u0013\u0011\tY\"!\u0006\u0003\u0013\r{W\u000e]8oK:$\b\u0003\u0002%\u0002 5K1!!\tJ\u0005\u0019\u0011u.\u001e8eg\"1\u0011Q\u0005\u0004A\u0002m\t!!\u001b3\t\u000f\u0005%b\u00011\u0001\u0002,\u0005Y!/Y:uKJ\fV/\u001a:z!\u0015A\u0012QF'\\\u0013\r\ty#\u0005\u0002\u000b\u0019\u0006LXM])vKJL\bbBA\u001a\r\u0001\u0007\u0011QG\u0001\u0010M&dG/\u001a:J]\u0012,\u0007p\u00148msB\u0019a%a\u000e\n\u0007\u0005erEA\u0004C_>dW-\u00198\u0002/M\u001b4i\u001c7mK\u000e$\u0018n\u001c8MCf,'OU3bI\u0016\u0014\bCA\u001e\t'\rA\u0011\u0011\t\t\u0004M\u0005\r\u0013bAA#O\t1\u0011I\\=SK\u001a$\"!!\u0010\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007i\ni\u0005C\u0003\u001f\u0015\u0001\u0007\u0001\u0005F\u0004;\u0003#\nY'a\u001c\t\u000f\u0005M3\u00021\u0001\u0002V\u00051!-^2lKR\u0004B!a\u0016\u0002f9!\u0011\u0011LA1!\r\tYfJ\u0007\u0003\u0003;R1!a\u0018\u0016\u0003\u0019a$o\\8u}%\u0019\u00111M\u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\t9'!\u001b\u0003\rM#(/\u001b8h\u0015\r\t\u0019g\n\u0005\b\u0003[Z\u0001\u0019AA+\u0003\u0019\u0001(/\u001a4jq\"9Ae\u0003I\u0005\u0002\u0004)\u0013aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U$fA\u0016\u0002x-\u0012\u0011\u0011\u0010\t\u0005\u0003w\n))\u0004\u0002\u0002~)!\u0011qPAA\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004\u001e\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9)! \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r")
public class S3CollectionLayerReader
extends CollectionLayerReader<LayerId> {
    private final AttributeStore attributeStore;
    private final Function0<S3Client> s3Client;

    public static S3Client $lessinit$greater$default$2() {
        return S3CollectionLayerReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static S3Client apply$default$3() {
        return S3CollectionLayerReader$.MODULE$.apply$default$3();
    }

    public static S3CollectionLayerReader apply(String string, String string2, Function0<S3Client> function0) {
        return S3CollectionLayerReader$.MODULE$.apply(string, string2, function0);
    }

    public static S3CollectionLayerReader apply(AttributeStore attributeStore) {
        return S3CollectionLayerReader$.MODULE$.apply(attributeStore);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    public S3CollectionReader collectionReader() {
        return new S3CollectionReader(this.s3Client, (Function0<ExecutionContext>)(Function0 & Serializable & scala.Serializable)() -> S3CollectionReader$.MODULE$.$lessinit$greater$default$2());
    }

    public <K, V, M> ContextCollection<K, V, M> read(LayerId id, LayerQuery<K, M> rasterQuery, boolean filterIndexOnly, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, Decoder<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, Decoder<M> evidence$7, Component<M, Bounds<K>> evidence$8) {
        if (!this.attributeStore().layerExists(id)) {
            throw new package.LayerNotFoundError(id);
        }
        LayerAttributes layerAttributes = this.liftedTree1$1(id, evidence$7, evidence$4);
        if (layerAttributes == null) {
            throw new MatchError((Object)layerAttributes);
        }
        S3LayerHeader header = (S3LayerHeader)layerAttributes.header();
        Object metadata = layerAttributes.metadata();
        KeyIndex keyIndex = layerAttributes.keyIndex();
        Schema writerSchema = layerAttributes.schema();
        Tuple4 tuple4 = new Tuple4((Object)header, metadata, (Object)keyIndex, (Object)writerSchema);
        Tuple4 tuple42 = tuple4;
        S3LayerHeader header2 = (S3LayerHeader)tuple42._1();
        Object metadata2 = tuple42._2();
        KeyIndex keyIndex2 = (KeyIndex)tuple42._3();
        Schema writerSchema2 = (Schema)tuple42._4();
        String bucket = header2.bucket();
        String prefix = header2.key();
        Seq queryKeyBounds = rasterQuery.apply(metadata2);
        Object layerMetadata = geotrellis.util.package$.MODULE$.withSetComponentMethods(metadata2).setComponent(queryKeyBounds.foldLeft((Object)EmptyBounds$.MODULE$, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.combine((Bounds)x$3, evidence$2)), evidence$8);
        int maxWidth = Index$.MODULE$.digits(keyIndex2.toIndex(keyIndex2.keyBounds().maxKey()));
        Function1 & Serializable & scala.Serializable keyPath = (Function1 & Serializable & scala.Serializable)index -> package$.MODULE$.makePath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prefix, Index$.MODULE$.encode(index, maxWidth)}));
        Function1 & Serializable & scala.Serializable decompose = (Function1 & Serializable & scala.Serializable)bounds -> keyIndex2.indexRanges(KeyBounds$.MODULE$.keyBoundsToTuple(bounds));
        Seq<Tuple2<K, V>> seq = this.collectionReader().read(bucket, (Function1<BigInt, String>)keyPath, queryKeyBounds, decompose, filterIndexOnly, (Option<Schema>)new Some((Object)writerSchema2), evidence$1, evidence$2, evidence$5);
        return new ContextCollection(seq, layerMetadata);
    }

    private final /* synthetic */ LayerAttributes liftedTree1$1(LayerId id$1, Decoder evidence$7$1, ClassTag evidence$4$1) {
        LayerAttributes layerAttributes;
        try {
            layerAttributes = this.attributeStore().readLayerAttributes(id$1, S3LayerHeader$.MODULE$.s3LayerHeaderDecoder(), evidence$7$1, evidence$4$1);
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerReadError(id$1).initCause((Throwable)e);
        }
        catch (NoSuchBucketException e) {
            throw new package.LayerReadError(id$1).initCause((Throwable)e);
        }
        return layerAttributes;
    }

    public S3CollectionLayerReader(AttributeStore attributeStore, Function0<S3Client> s3Client) {
        this.attributeStore = attributeStore;
        this.s3Client = s3Client;
    }
}

