/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3;

import geotrellis.layer.Boundable;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.store.avro.AvroEncoder$;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec$;
import geotrellis.store.index.MergeQueue$;
import geotrellis.store.s3.S3CollectionReader$;
import geotrellis.store.util.IOUtils$;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.commons.io.IOUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001\u0002\u0007\u000e\u0001QA\u0001B\b\u0001\u0003\u0002\u0013\u0006Ia\b\u0005\t_\u0001\u0011\t\u0011*A\u0005a!)q\u0007\u0001C\u0001q!)Q\b\u0001C\u0001}!I\u00111\t\u0001\u0012\u0002\u0013\u0005\u0011QI\u0004\n\u0003Cj\u0011\u0011!E\u0001\u0003G2\u0001\u0002D\u0007\u0002\u0002#\u0005\u0011Q\r\u0005\u0007o\u001d!\t!a\u001a\t\u0013\u0005%t!%A\u0005\u0002\u0005-\u0004\"CA8\u000fE\u0005I\u0011AA9\u0011%\t)hBA\u0001\n\u0013\t9H\u0001\nTg\r{G\u000e\\3di&|gNU3bI\u0016\u0014(B\u0001\b\u0010\u0003\t\u00198G\u0003\u0002\u0011#\u0005)1\u000f^8sK*\t!#\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\f\u001d\u0013\tirC\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005tg\rc\u0017.\u001a8u!\r1\u0002EI\u0005\u0003C]\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003G5j\u0011\u0001\n\u0006\u0003\u001d\u0015R!AJ\u0014\u0002\u0011M,'O^5dKNT!\u0001K\u0015\u0002\r\u0005<8o\u001d3l\u0015\tQ3&\u0001\u0004b[\u0006TxN\u001c\u0006\u0002Y\u0005A1o\u001c4uo\u0006\u0014X-\u0003\u0002/I\tA1kM\"mS\u0016tG/\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB\u0019a\u0003I\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q:\u0012AC2p]\u000e,(O]3oi&\u0011ag\r\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDcA\u001d<yA\u0011!\bA\u0007\u0002\u001b!9ad\u0001I\u0005\u0002\u0004y\u0002bB\u0018\u0004!\u0013\u0005\r\u0001M\u0001\u0005e\u0016\fG-F\u0002@%r#2\u0002Q9|\u0003\u000f\t\u0019\"!\b\u0002(Q!\u0011I\u00184o!\r\u0011%*\u0014\b\u0003\u0007\"s!\u0001R$\u000e\u0003\u0015S!AR\n\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012BA%\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0013'\u0003\u0007M+\u0017O\u0003\u0002J/A!aC\u0014)\\\u0013\tyuC\u0001\u0004UkBdWM\r\t\u0003#Jc\u0001\u0001B\u0003T\t\t\u0007AKA\u0001L#\t)\u0006\f\u0005\u0002\u0017-&\u0011qk\u0006\u0002\b\u001d>$\b.\u001b8h!\t1\u0012,\u0003\u0002[/\t\u0019\u0011I\\=\u0011\u0005EcF!B/\u0005\u0005\u0004!&!\u0001,\t\u000f}#\u0011\u0011!a\u0002A\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007\u0005$\u0007+D\u0001c\u0015\t\u0019w\"\u0001\u0003bmJ|\u0017BA3c\u0005=\teO]8SK\u000e|'\u000fZ\"pI\u0016\u001c\u0007bB4\u0005\u0003\u0003\u0005\u001d\u0001[\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA5m!6\t!N\u0003\u0002l#\u0005)A.Y=fe&\u0011QN\u001b\u0002\n\u0005>,h\u000eZ1cY\u0016Dqa\u001c\u0003\u0002\u0002\u0003\u000f\u0001/\u0001\u0006fm&$WM\\2fIM\u00022!\u00193\\\u0011\u0015\u0011H\u00011\u0001t\u0003\u0019\u0011WoY6fiB\u0011A\u000f\u001f\b\u0003kZ\u0004\"\u0001R\f\n\u0005]<\u0012A\u0002)sK\u0012,g-\u0003\u0002zu\n11\u000b\u001e:j]\u001eT!a^\f\t\u000bq$\u0001\u0019A?\u0002\u000f-,\u0017\u0010U1uQB)aC`A\u0001g&\u0011qp\u0006\u0002\n\rVt7\r^5p]F\u00022AQA\u0002\u0013\r\t)\u0001\u0014\u0002\u0007\u0005&<\u0017J\u001c;\t\u000f\u0005%A\u00011\u0001\u0002\f\u0005q\u0011/^3ss.+\u0017PQ8v]\u0012\u001c\b\u0003\u0002\"K\u0003\u001b\u0001B![A\b!&\u0019\u0011\u0011\u00036\u0003\u0013-+\u0017PQ8v]\u0012\u001c\bbBA\u000b\t\u0001\u0007\u0011qC\u0001\u0010I\u0016\u001cw.\u001c9pg\u0016\u0014u.\u001e8egB1aC`A\u0007\u00033\u0001BA\u0011&\u0002\u001cA1aCTA\u0001\u0003\u0003Aq!a\b\u0005\u0001\u0004\t\t#A\bgS2$XM]%oI\u0016DxJ\u001c7z!\r1\u00121E\u0005\u0004\u0003K9\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003S!\u0001\u0013!a\u0001\u0003W\tAb\u001e:ji\u0016\u00148k\u00195f[\u0006\u0004RAFA\u0017\u0003cI1!a\f\u0018\u0005\u0019y\u0005\u000f^5p]B!\u00111GA \u001b\t\t)DC\u0002d\u0003oQA!!\u000f\u0002<\u00051\u0011\r]1dQ\u0016T!!!\u0010\u0002\u0007=\u0014x-\u0003\u0003\u0002B\u0005U\"AB*dQ\u0016l\u0017-\u0001\bsK\u0006$G\u0005Z3gCVdG\u000f\n\u001c\u0016\r\u0005\u001d\u0013QLA0+\t\tIE\u000b\u0003\u0002,\u0005-3FAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]s#\u0001\u0006b]:|G/\u0019;j_:LA!a\u0017\u0002R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000bM+!\u0019\u0001+\u0005\u000bu+!\u0019\u0001+\u0002%M\u001b4i\u001c7mK\u000e$\u0018n\u001c8SK\u0006$WM\u001d\t\u0003u\u001d\u00192aB\u000b\u001c)\t\t\u0019'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003[R3AIA&\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u000f\u0016\u0004c\u0005-\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u001f\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006!A.\u00198h\u0015\t\t\u0019)\u0001\u0003kCZ\f\u0017\u0002BAD\u0003{\u0012aa\u00142kK\u000e$\b")
public class S3CollectionReader
implements scala.Serializable {
    private final Function0<S3Client> s3Client;
    private final Function0<ExecutionContext> executionContext;

    public static ExecutionContext $lessinit$greater$default$2() {
        return S3CollectionReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static S3Client $lessinit$greater$default$1() {
        return S3CollectionReader$.MODULE$.$lessinit$greater$default$1();
    }

    public <K, V> Seq<Tuple2<K, V>> read(String bucket, Function1<BigInt, String> keyPath, Seq<KeyBounds<K>> queryKeyBounds, Function1<KeyBounds<K>, Seq<Tuple2<BigInt, BigInt>>> decomposeBounds, boolean filterIndexOnly, Option<Schema> writerSchema, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, AvroRecordCodec<V> evidence$3) {
        if (queryKeyBounds.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        Seq ranges = queryKeyBounds.length() > 1 ? MergeQueue$.MODULE$.apply((TraversableOnce)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom())) : (Seq)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom());
        KeyValueRecordCodec recordCodec = KeyValueRecordCodec$.MODULE$.apply(evidence$1, evidence$3);
        ExecutionContext ec = (ExecutionContext)this.executionContext.apply();
        return IOUtils$.MODULE$.parJoin(ranges.iterator(), (Function1 & Serializable & scala.Serializable)index -> {
            Vector vector;
            block4: {
                try {
                    GetObjectRequest getRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key((String)keyPath.apply(index)).build();
                    ResponseInputStream s3obj = ((S3Client)$this.s3Client.apply()).getObject(getRequest);
                    byte[] bytes = IOUtils.toByteArray((InputStream)s3obj);
                    s3obj.close();
                    Vector recs = (Vector)AvroEncoder$.MODULE$.fromBinary((Schema)writerSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> recordCodec.schema()), bytes, (AvroRecordCodec)recordCodec);
                    if (filterIndexOnly) {
                        vector = recs;
                        break block4;
                    }
                    vector = (Vector)recs.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)S3CollectionReader.$anonfun$read$3(queryKeyBounds, evidence$2, row)));
                }
                catch (Throwable throwable) {
                    S3Exception s3Exception;
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof S3Exception) || (s3Exception = (S3Exception)throwable2).statusCode() != 404) {
                        throw throwable;
                    }
                    Vector vector2 = package$.MODULE$.Vector().empty();
                    vector = vector2;
                }
            }
            return vector;
        }, ec);
    }

    public <K, V> Option<Schema> read$default$6() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$read$3(Seq queryKeyBounds$1, Boundable evidence$2$1, Tuple2 row) {
        return KeyBounds$.MODULE$.KeyBoundsSeqMethods(queryKeyBounds$1, evidence$2$1).includeKey(row._1());
    }

    public S3CollectionReader(Function0<S3Client> s3Client, Function0<ExecutionContext> executionContext) {
        this.s3Client = s3Client;
        this.executionContext = executionContext;
    }
}

