/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3;

import geotrellis.store.AttributeStore;
import geotrellis.store.LayerDeleter;
import geotrellis.store.LayerId;
import geotrellis.store.package;
import geotrellis.store.s3.S3LayerDeleter$;
import geotrellis.store.s3.S3LayerHeader;
import geotrellis.store.s3.S3LayerHeader$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001\u0002\t\u0012\u0001aA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Q!AA\u0006\u0001B\u0001J\u0003%Q\u0006\u0003\u0005>\u0001\t\u0015\r\u0011\"\u0001?\u0011!\u0011\u0005A!A!\u0002\u0013y\u0004\"B\"\u0001\t\u0003!\u0005\"\u0002&\u0001\t\u0003Y\u0005\u0002C)\u0001\u0011\u000b\u0007K\u0011\u0002*\b\u000b}\u000b\u0002\u0012\u00011\u0007\u000bA\t\u0002\u0012A1\t\u000b\rSA\u0011\u00012\t\u000b\rTA\u0011\u00013\t\u000b\rTA\u0011A4\t\u000b\rTA\u0011A6\t\u000fqT\u0011\u0013!C\u0001{\nq1k\r'bs\u0016\u0014H)\u001a7fi\u0016\u0014(B\u0001\n\u0014\u0003\t\u00198G\u0003\u0002\u0015+\u0005)1\u000f^8sK*\ta#\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007c\u0001\u0011\"G5\t1#\u0003\u0002#'\taA*Y=fe\u0012+G.\u001a;feB\u0011\u0001\u0005J\u0005\u0003KM\u0011q\u0001T1zKJLE-\u0001\bbiR\u0014\u0018NY;uKN#xN]3\u0016\u0003!\u0002\"\u0001I\u0015\n\u0005)\u001a\"AD!uiJL'-\u001e;f'R|'/Z\u0001\u0010CR$(/\u001b2vi\u0016\u001cFo\u001c:fA\u0005A1oM\"mS\u0016tG\u000fE\u0002\u001b]AJ!aL\u000e\u0003\u0011q\u0012\u0017P\\1nKz\u0002\"!M\u001e\u000e\u0003IR!AE\u001a\u000b\u0005Q*\u0014\u0001C:feZL7-Z:\u000b\u0005Y:\u0014AB1xgN$7N\u0003\u00029s\u00051\u0011-\\1{_:T\u0011AO\u0001\tg>4Go^1sK&\u0011AH\r\u0002\t'N\u001aE.[3oi\u0006a!/Z9vKN$H*[7jiV\tq\b\u0005\u0002\u001b\u0001&\u0011\u0011i\u0007\u0002\u0004\u0013:$\u0018!\u0004:fcV,7\u000f\u001e'j[&$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u000b\u001eC\u0015\n\u0005\u0002G\u00015\t\u0011\u0003C\u0003'\r\u0001\u0007\u0001\u0006\u0003\u0004-\r\u0011\u0005\r!\f\u0005\b{\u0019\u0001\n\u00111\u0001@\u0003\u0019!W\r\\3uKR\u0011Aj\u0014\t\u000355K!AT\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006!\u001e\u0001\raI\u0001\u0003S\u0012\fa\u0001\\8hO\u0016\u0014X#A*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016!\u00027pOR\u001a(\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002[+\n1Aj\\4hKJD#\u0001\u0003/\u0011\u0005ii\u0016B\u00010\u001c\u0005%!(/\u00198tS\u0016tG/\u0001\bTg1\u000b\u00170\u001a:EK2,G/\u001a:\u0011\u0005\u0019S1C\u0001\u0006\u001a)\u0005\u0001\u0017!B1qa2LHcA#fM\")a\u0005\u0004a\u0001Q!1A\u0006\u0004CA\u00025\"B!\u00125jU\")a%\u0004a\u0001Q!1A&\u0004CA\u00025BQ!P\u0007A\u0002}\"B!\u00127zw\")QN\u0004a\u0001]\u00061!-^2lKR\u0004\"a\u001c<\u000f\u0005A$\bCA9\u001c\u001b\u0005\u0011(BA:\u0018\u0003\u0019a$o\\8u}%\u0011QoG\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002v7!)!P\u0004a\u0001]\u00061\u0001O]3gSbDa\u0001\f\b\u0005\u0002\u0004i\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001\u007fU\tytp\u000b\u0002\u0002\u0002A!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011!C;oG\",7m[3e\u0015\r\tYaG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\b\u0003\u000b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class S3LayerDeleter
implements LayerDeleter<LayerId> {
    private transient Logger logger;
    private final AttributeStore attributeStore;
    private final Function0<S3Client> s3Client;
    private final int requestLimit;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$3() {
        return S3LayerDeleter$.MODULE$.$lessinit$greater$default$3();
    }

    public static S3LayerDeleter apply(String string, String string2, Function0<S3Client> function0) {
        return S3LayerDeleter$.MODULE$.apply(string, string2, function0);
    }

    public static S3LayerDeleter apply(AttributeStore attributeStore, Function0<S3Client> function0, int n) {
        return S3LayerDeleter$.MODULE$.apply(attributeStore, function0, n);
    }

    public static S3LayerDeleter apply(AttributeStore attributeStore, Function0<S3Client> function0) {
        return S3LayerDeleter$.MODULE$.apply(attributeStore, function0);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    public int requestLimit() {
        return this.requestLimit;
    }

    private Logger logger$lzycompute() {
        S3LayerDeleter s3LayerDeleter = this;
        synchronized (s3LayerDeleter) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(S3LayerDeleter.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void delete(LayerId id) {
        try {
            S3LayerHeader header = (S3LayerHeader)this.attributeStore().readHeader(id, S3LayerHeader$.MODULE$.s3LayerHeaderDecoder());
            String bucket = header.bucket();
            String prefix = new StringBuilder(1).append(header.key()).append("/").toString();
            ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket).prefix(prefix).build();
            Iterable iter = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala();
            if (iter.isEmpty()) {
                throw new package.LayerDeleteError(id);
            }
            ((IterableLike)iter.map((Function1 & Serializable & scala.Serializable)s3obj -> (ObjectIdentifier)ObjectIdentifier.builder().key(s3obj.key()).build(), Iterable$.MODULE$.canBuildFrom())).grouped(this.requestLimit()).foreach((Function1 & Serializable & scala.Serializable)objIdentifiersChunk -> {
                Delete deleteDefinition = (Delete)Delete.builder().objects((ObjectIdentifier[])objIdentifiersChunk.toSeq().toArray(ClassTag$.MODULE$.apply(ObjectIdentifier.class))).build();
                DeleteObjectsRequest deleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete(deleteDefinition).build();
                return ((S3Client)$this.s3Client.apply()).deleteObjects(deleteRequest);
            });
            this.attributeStore().delete(id);
        }
        catch (package.AttributeNotFoundError e) {
            if (this.logger().isInfoEnabled()) {
                this.logger().info(new StringBuilder(92).append("Metadata for ").append(id).append(" was not found. Any associated layer data (if any) will require manual deletion").toString());
            }
            throw new package.LayerDeleteError(id).initCause((Throwable)e);
        }
        catch (NoSuchBucketException e) {
            if (this.logger().isInfoEnabled()) {
                this.logger().info(new StringBuilder(109).append("Metadata for ").append(id).append(" was not found (no such bucket). Any associated layer data (if any) will require manual deletion").toString());
            }
            throw new package.LayerDeleteError(id).initCause((Throwable)e);
        }
    }

    public S3LayerDeleter(AttributeStore attributeStore, Function0<S3Client> s3Client, int requestLimit) {
        this.attributeStore = attributeStore;
        this.s3Client = s3Client;
        this.requestLimit = requestLimit;
    }
}

