/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmazonS3URI {
    private static final Pattern ENDPOINT_PATTERN = Pattern.compile("^(.+\\.)?s3[.-]([a-z0-9-]+)\\.");
    private static final Pattern VERSION_ID_PATTERN = Pattern.compile("[&;]");
    private final URI uri;
    private final boolean isPathStyle;
    private final String bucket;
    private final String key;
    private final String versionId;
    private final String region;

    public AmazonS3URI(String string) {
        this(string, true);
    }

    public AmazonS3URI(String string, boolean bl) {
        this(URI.create(AmazonS3URI.preprocessUrlStr(string, bl)), bl);
    }

    public AmazonS3URI(URI uRI) {
        this(uRI, false);
    }

    private AmazonS3URI(URI uRI, boolean bl) {
        if (uRI == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        this.uri = uRI;
        if ("s3".equalsIgnoreCase(uRI.getScheme())) {
            this.region = null;
            this.versionId = null;
            this.isPathStyle = false;
            this.bucket = uRI.getAuthority();
            if (this.bucket == null) {
                throw new IllegalArgumentException("Invalid S3 URI: no bucket: " + uRI);
            }
            String string = uRI.getPath();
            this.key = string.length() <= 1 ? null : uRI.getPath().substring(1);
            return;
        }
        String string = uRI.getHost();
        if (string == null) {
            throw new IllegalArgumentException("Invalid S3 URI: no hostname: " + uRI);
        }
        Matcher matcher = ENDPOINT_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid S3 URI: hostname does not appear to be a valid S3 endpoint: " + uRI);
        }
        String string2 = matcher.group(1);
        if (string2 == null || string2.isEmpty()) {
            String string3;
            this.isPathStyle = true;
            String string4 = string3 = bl ? uRI.getPath() : uRI.getRawPath();
            if ("".equals(string3) || "/".equals(string3)) {
                this.bucket = null;
                this.key = null;
            } else {
                int n = string3.indexOf(47, 1);
                if (n == -1) {
                    this.bucket = AmazonS3URI.decode(string3.substring(1));
                    this.key = null;
                } else if (n == string3.length() - 1) {
                    this.bucket = AmazonS3URI.decode(string3.substring(1, n));
                    this.key = null;
                } else {
                    this.bucket = AmazonS3URI.decode(string3.substring(1, n));
                    this.key = AmazonS3URI.decode(string3.substring(n + 1));
                }
            }
        } else {
            this.isPathStyle = false;
            this.bucket = string2.substring(0, string2.length() - 1);
            String string5 = uRI.getPath();
            this.key = string5 == null || string5.isEmpty() || "/".equals(uRI.getPath()) ? null : uRI.getPath().substring(1);
        }
        this.versionId = AmazonS3URI.parseVersionId(uRI.getRawQuery());
        this.region = "amazonaws".equals(matcher.group(2)) ? null : matcher.group(2);
    }

    private static String parseVersionId(String string) {
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = VERSION_ID_PATTERN.split(string)) {
                if (!string2.startsWith("versionId=")) continue;
                return AmazonS3URI.decode(string2.substring(10));
            }
        }
        return null;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isPathStyle() {
        return this.isPathStyle;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        return "";
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getRegion() {
        return this.region;
    }

    public String toString() {
        return this.uri.toString();
    }

    private static String preprocessUrlStr(String string, boolean bl) {
        if (bl) {
            try {
                return URLEncoder.encode(string, "UTF-8").replace("%3A", ":").replace("%2F", "/").replace("+", "%20");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return string;
    }

    private static String decode(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '%') continue;
            return AmazonS3URI.decode(string, i);
        }
        return string;
    }

    private static String decode(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, n));
        AmazonS3URI.appendDecoded(stringBuilder, string, n);
        for (int i = n + 3; i < string.length(); ++i) {
            if (string.charAt(i) == '%') {
                AmazonS3URI.appendDecoded(stringBuilder, string, i);
                i += 2;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    private static void appendDecoded(StringBuilder stringBuilder, String string, int n) {
        if (n > string.length() - 3) {
            throw new IllegalStateException("Invalid percent-encoded string:\"" + string + "\".");
        }
        char c = string.charAt(n + 1);
        char c2 = string.charAt(n + 2);
        char c3 = (char)(AmazonS3URI.fromHex(c) << 4 | AmazonS3URI.fromHex(c2));
        stringBuilder.append(c3);
    }

    private static int fromHex(char c) {
        if (c < '0') {
            throw new IllegalStateException("Invalid percent-encoded string: bad character '" + c + "' in escape sequence.");
        }
        if (c <= '9') {
            return c - 48;
        }
        if (c < 'A') {
            throw new IllegalStateException("Invalid percent-encoded string: bad character '" + c + "' in escape sequence.");
        }
        if (c <= 'F') {
            return c - 65 + 10;
        }
        if (c < 'a') {
            throw new IllegalStateException("Invalid percent-encoded string: bad character '" + c + "' in escape sequence.");
        }
        if (c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalStateException("Invalid percent-encoded string: bad character '" + c + "' in escape sequence.");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AmazonS3URI amazonS3URI = (AmazonS3URI)object;
        if (this.isPathStyle != amazonS3URI.isPathStyle) {
            return false;
        }
        if (!this.uri.equals(amazonS3URI.uri)) {
            return false;
        }
        if (this.bucket != null ? !this.bucket.equals(amazonS3URI.bucket) : amazonS3URI.bucket != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(amazonS3URI.key) : amazonS3URI.key != null) {
            return false;
        }
        if (this.versionId != null ? !this.versionId.equals(amazonS3URI.versionId) : amazonS3URI.versionId != null) {
            return false;
        }
        return this.region != null ? this.region.equals(amazonS3URI.region) : amazonS3URI.region == null;
    }

    public int hashCode() {
        int n = this.uri.hashCode();
        n = 31 * n + (this.isPathStyle ? 1 : 0);
        n = 31 * n + (this.bucket != null ? this.bucket.hashCode() : 0);
        n = 31 * n + (this.key != null ? this.key.hashCode() : 0);
        n = 31 * n + (this.versionId != null ? this.versionId.hashCode() : 0);
        n = 31 * n + (this.region != null ? this.region.hashCode() : 0);
        return n;
    }
}

