/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3.cog;

import geotrellis.layer.SpatialKey;
import geotrellis.raster.CellGrid;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.resample.TileResampleMethods;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerId;
import geotrellis.store.cog.COGReader;
import geotrellis.store.cog.COGValueReader;
import geotrellis.store.cog.OverzoomingCOGValueReader;
import geotrellis.store.cog.ZoomRange;
import geotrellis.store.cog.package$;
import geotrellis.store.index.Index$;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import geotrellis.store.s3.S3AttributeStore;
import geotrellis.store.s3.S3LayerHeader;
import geotrellis.store.s3.S3LayerHeader$;
import geotrellis.store.s3.cog.S3COGValueReader$;
import geotrellis.util.Component;
import io.circe.Decoder;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.PartialFunction;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.S3Exception;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0006\r\u0001UA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tO\u0001\u0011\t\u0011)A\u0005G!A\u0001\u0006\u0001B\u0001J\u0003%\u0011\u0006C\u0003:\u0001\u0011\u0005!\bC\u0003@\u0001\u0011\u0005\u0001iB\u0004\u0002$1A\t!!\n\u0007\r-a\u0001\u0012AA\u0014\u0011\u0019It\u0001\"\u0001\u0002*!9\u00111F\u0004\u0005\u0002\u00055\u0002\"CA\u001d\u000fE\u0005I\u0011AA\u001e\u0005A\u00196gQ(H-\u0006dW/\u001a*fC\u0012,'O\u0003\u0002\u000e\u001d\u0005\u00191m\\4\u000b\u0005=\u0001\u0012AA:4\u0015\t\t\"#A\u0003ti>\u0014XMC\u0001\u0014\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005uyR\"\u0001\u0010\u000b\u00055\u0001\u0012B\u0001\u0011\u001f\u0005eye/\u001a:{_>l\u0017N\\4D\u001f\u001e3\u0016\r\\;f%\u0016\fG-\u001a:\u0002\u001d\u0005$HO]5ckR,7\u000b^8sKV\t1\u0005\u0005\u0002%K5\t\u0001#\u0003\u0002'!\tq\u0011\t\u001e;sS\n,H/Z*u_J,\u0017aD1uiJL'-\u001e;f'R|'/\u001a\u0011\u0002\u0011M\u001c4\t\\5f]R\u00042a\u0006\u0016-\u0013\tY\u0003D\u0001\u0005=Eft\u0017-\\3?!\tis'D\u0001/\u0015\tyqF\u0003\u00021c\u0005A1/\u001a:wS\u000e,7O\u0003\u00023g\u00051\u0011m^:tI.T!\u0001N\u001b\u0002\r\u0005l\u0017M_8o\u0015\u00051\u0014\u0001C:pMR<\u0018M]3\n\u0005ar#\u0001C*4\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\rYTH\u0010\t\u0003y\u0001i\u0011\u0001\u0004\u0005\u0006C\u0011\u0001\ra\t\u0005\bQ\u0011\u0001J\u00111\u0001*\u0003\u0019\u0011X-\u00193feV\u0019\u0011\t\u0013*\u0015\u0007\t\u000bI\u0002\u0006\u0004D=\"T\u0018Q\u0001\t\u0005;\u00113\u0015+\u0003\u0002F=\tI1iT$SK\u0006$WM\u001d\t\u0003\u000f\"c\u0001\u0001B\u0003J\u000b\t\u0007!JA\u0001L#\tYe\n\u0005\u0002\u0018\u0019&\u0011Q\n\u0007\u0002\b\u001d>$\b.\u001b8h!\t9r*\u0003\u0002Q1\t\u0019\u0011I\\=\u0011\u0005\u001d\u0013F!B*\u0006\u0005\u0004!&!\u0001,\u0012\u0005-+\u0006c\u0001,Z76\tqK\u0003\u0002Y%\u00051!/Y:uKJL!AW,\u0003\u0011\r+G\u000e\\$sS\u0012\u0004\"a\u0006/\n\u0005uC\"aA%oi\"9q,BA\u0001\u0002\b\u0001\u0017AC3wS\u0012,gnY3%cA\u0019\u0011M\u001a$\u000e\u0003\tT!a\u00193\u0002\u000b\rL'oY3\u000b\u0003\u0015\f!![8\n\u0005\u001d\u0014'a\u0002#fG>$WM\u001d\u0005\bS\u0016\t\t\u0011q\u0001k\u0003))g/\u001b3f]\u000e,GE\r\t\u0004W^4eB\u00017u\u001d\ti'O\u0004\u0002oc6\tqN\u0003\u0002q)\u00051AH]8pizJ\u0011aE\u0005\u0003gJ\tQ\u0001\\1zKJL!!\u001e<\u0002\u000fA\f7m[1hK*\u00111OE\u0005\u0003qf\u0014\u0001c\u00159bi&\fGnQ8na>tWM\u001c;\u000b\u0005U4\bbB>\u0006\u0003\u0003\u0005\u001d\u0001`\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004\u0003B?\u0002\u0002\u0019k\u0011A \u0006\u0003\u007fb\tqA]3gY\u0016\u001cG/C\u0002\u0002\u0004y\u0014\u0001b\u00117bgN$\u0016m\u001a\u0005\n\u0003\u000f)\u0011\u0011!a\u0002\u0003\u0013\t!\"\u001a<jI\u0016t7-\u001a\u00135!\u0015\tY!!\u0006R\u001b\t\tiAC\u0002@\u0003\u001fQA!!\u0005\u0002\u0014\u00059q-Z8uS\u001a4'BA3X\u0013\u0011\t9\"!\u0004\u0003\u001b\u001d+w\u000eV5gMJ+\u0017\rZ3s\u0011\u001d\tY\"\u0002a\u0001\u0003;\tq\u0001\\1zKJLE\rE\u0002%\u0003?I1!!\t\u0011\u0005\u001da\u0015-_3s\u0013\u0012\f\u0001cU\u001aD\u001f\u001e3\u0016\r\\;f%\u0016\fG-\u001a:\u0011\u0005q:1CA\u0004\u0017)\t\t)#A\u0003baBd\u0017\u0010F\u0002<\u0003_Aa!I\u0005A\u0002\u0005E\u0002\u0003BA\u001a\u0003ki\u0011AD\u0005\u0004\u0003oq!\u0001E*4\u0003R$(/\u001b2vi\u0016\u001cFo\u001c:f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\b\u0016\u0004Y\u0005}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0003$\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class S3COGValueReader
implements OverzoomingCOGValueReader {
    private final AttributeStore attributeStore;

    public static S3Client $lessinit$greater$default$2() {
        return S3COGValueReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static S3COGValueReader apply(S3AttributeStore s3AttributeStore) {
        return S3COGValueReader$.MODULE$.apply(s3AttributeStore);
    }

    public LayerId getLayerId(LayerId id) {
        return OverzoomingCOGValueReader.getLayerId$((OverzoomingCOGValueReader)this, (LayerId)id);
    }

    public <K, V extends CellGrid<Object>> COGReader<K, V> overzoomingReader(LayerId layerId, ResampleMethod resampleMethod, Decoder<K> evidence$1, Component<K, SpatialKey> evidence$2, ClassTag<K> evidence$3, GeoTiffReader<V> evidence$4, Function1<V, TileResampleMethods<V>> evidence$5) {
        return OverzoomingCOGValueReader.overzoomingReader$((OverzoomingCOGValueReader)this, (LayerId)layerId, (ResampleMethod)resampleMethod, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5);
    }

    public COGReader baseReader(Object layerId, Function4 keyPath, Function1 fullPath, Function1 exceptionHandler, Decoder evidence$5, Component evidence$6, ClassTag evidence$7, GeoTiffReader evidence$8) {
        return COGValueReader.baseReader$((COGValueReader)this, (Object)layerId, (Function4)keyPath, (Function1)fullPath, (Function1)exceptionHandler, (Decoder)evidence$5, (Component)evidence$6, (ClassTag)evidence$7, (GeoTiffReader)evidence$8);
    }

    public <K, V extends CellGrid<Object>> Function1<K, PartialFunction<Throwable, Nothing$>> baseReader$default$4() {
        return COGValueReader.baseReader$default$4$((COGValueReader)this);
    }

    public <K, V extends CellGrid<Object>> ResampleMethod overzoomingReader$default$2() {
        return COGValueReader.overzoomingReader$default$2$((COGValueReader)this);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    public <K, V extends CellGrid<Object>> COGReader<K, V> reader(LayerId layerId, Decoder<K> evidence$1, Component<K, SpatialKey> evidence$2, ClassTag<K> evidence$3, GeoTiffReader<V> evidence$4) {
        S3LayerHeader s3LayerHeader;
        try {
            s3LayerHeader = (S3LayerHeader)this.attributeStore().readHeader(new LayerId(layerId.name(), 0), S3LayerHeader$.MODULE$.s3LayerHeaderDecoder());
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerNotFoundError(layerId).initCause((Throwable)e);
        }
        catch (NoSuchBucketException e) {
            throw new package.LayerNotFoundError(layerId).initCause((Throwable)e);
        }
        S3LayerHeader header = s3LayerHeader;
        return this.baseReader(layerId, (Function4 & Serializable & scala.Serializable)(key, maxWidth, baseKeyIndex, zoomRange) -> S3COGValueReader.keyPath$1(key, BoxesRunTime.unboxToInt((Object)maxWidth), baseKeyIndex, zoomRange, header, layerId), (Function1 & Serializable & scala.Serializable)path -> new URI(new StringBuilder(5).append("s3://").append((String)path).toString()), (Function1 & Serializable & scala.Serializable)key -> new scala.Serializable(null, key, layerId){
            public static final long serialVersionUID = 0L;
            private final Object key$1;
            private final LayerId layerId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                S3Exception s3Exception;
                A1 A1 = x1;
                if (A1 instanceof S3Exception && (s3Exception = (S3Exception)A1).statusCode() == 404) {
                    throw new package.ValueNotFoundError(this.key$1, this.layerId$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                S3Exception s3Exception;
                Throwable throwable = x1;
                return throwable instanceof S3Exception && (s3Exception = (S3Exception)throwable).statusCode() == 404;
            }
            {
                this.key$1 = key$1;
                this.layerId$1 = layerId$1;
            }
        }, evidence$1, evidence$2, evidence$3, evidence$4);
    }

    private static final String keyPath$1(Object key, int maxWidth, KeyIndex baseKeyIndex, ZoomRange zoomRange, S3LayerHeader header$1, LayerId layerId$1) {
        return new StringBuilder(6).append(header$1.bucket()).append("/").append(header$1.key()).append("/").append(layerId$1.name()).append("/").append(zoomRange.minZoom()).append("_").append(zoomRange.maxZoom()).append("/").append(Index$.MODULE$.encode(baseKeyIndex.toIndex(key), maxWidth)).append(".").append(package$.MODULE$.Extension()).toString();
    }

    public S3COGValueReader(AttributeStore attributeStore, Function0<S3Client> s3Client) {
        this.attributeStore = attributeStore;
        COGValueReader.$init$((COGValueReader)this);
        OverzoomingCOGValueReader.$init$((OverzoomingCOGValueReader)this);
    }
}

