/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import com.github.blemale.scaffeine.Cache;
import geotrellis.store.AttributeCaching;
import geotrellis.store.AttributeStore;
import geotrellis.store.BlobLayerAttributeStore;
import geotrellis.store.COGLayerAttributes;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.LayerId$;
import geotrellis.store.LayerType;
import geotrellis.store.cog.ZoomRange;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import geotrellis.store.s3.S3AttributeStore$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.syntax.package;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.avro.Schema;
import org.apache.commons.io.IOUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u0011\"\u0001!B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005k!A\u0011\t\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u00036\u0011!\u0019\u0005A!A%\u0002\u0013!\u0005\"\u0002+\u0001\t\u0003)\u0006\"B.\u0001\t\u0003a\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"B6\u0001\t\u0003a\u0007\"\u00028\u0001\t\u0013y\u0007bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u00111\u0010\u0001\u0005\u0002\u0005m\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\tY\u000b\u0001C!\u0003[C!\"a/\u0001\u0011\u000b\u0007I\u0011AA_\u000f\u001d\t9-\tE\u0001\u0003\u00134a\u0001I\u0011\t\u0002\u0005-\u0007B\u0002+\u0018\t\u0003\tY\u000eC\u0005\u0002^^\u0011\r\u0011\"\u0002\u0002`\"A\u0011q]\f!\u0002\u001b\t\t\u000fC\u0004\u0002j^!\t!a;\t\u0013\u0005Ux#%A\u0005\u0002\u0005]\bbBAu/\u0011\u0005!Q\u0002\u0005\n\u0005'9\u0012\u0013!C\u0001\u0003oD\u0011B!\u0006\u0018\u0003\u0003%IAa\u0006\u0003!M\u001b\u0014\t\u001e;sS\n,H/Z*u_J,'B\u0001\u0012$\u0003\t\u00198G\u0003\u0002%K\u0005)1\u000f^8sK*\ta%\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u0001S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0007C\u0001\u00192\u001b\u0005\u0019\u0013B\u0001\u001a$\u0005]\u0011En\u001c2MCf,'/\u0011;ue&\u0014W\u000f^3Ti>\u0014X-\u0001\u0004ck\u000e\\W\r^\u000b\u0002kA\u0011a'\u0010\b\u0003om\u0002\"\u0001O\u0016\u000e\u0003eR!AO\u0014\u0002\rq\u0012xn\u001c;?\u0013\ta4&\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f,\u0003\u001d\u0011WoY6fi\u0002\na\u0001\u001d:fM&D\u0018a\u00029sK\u001aL\u0007\u0010I\u0001\tgN\u001aE.[3oiB\u0019!&R$\n\u0005\u0019[#\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0005!\u0013V\"A%\u000b\u0005\tR%BA&M\u0003!\u0019XM\u001d<jG\u0016\u001c(BA'O\u0003\u0019\two]:eW*\u0011q\nU\u0001\u0007C6\f'p\u001c8\u000b\u0003E\u000b\u0001b]8gi^\f'/Z\u0005\u0003'&\u0013\u0001bU\u001aDY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\tYC\u0016L\u0017\t\u0003/\u0002i\u0011!\t\u0005\u0006g\u0019\u0001\r!\u000e\u0005\u0006\u0003\u001a\u0001\r!\u000e\u0005\b\u0007\u001a\u0001J\u00111\u0001E\u0003\u0011\u0001\u0018\r\u001e5\u0015\u0005Uj\u0006\"\u00020\b\u0001\u0004y\u0016!\u00029beR\u001c\bc\u0001\u0016ak%\u0011\u0011m\u000b\u0002\u000byI,\u0007/Z1uK\u0012t\u0014!D1uiJL'-\u001e;f!\u0006$\b\u000eF\u00026I&DQ!\u001a\u0005A\u0002\u0019\f!!\u001b3\u0011\u0005A:\u0017B\u00015$\u0005\u001da\u0015-_3s\u0013\u0012DQA\u001b\u0005A\u0002U\nQ\"\u0019;ue&\u0014W\u000f^3OC6,\u0017aD1uiJL'-\u001e;f!J,g-\u001b=\u0015\u0005Uj\u0007\"\u00026\n\u0001\u0004)\u0014a\u0002:fC\u0012\\U-_\u000b\u0003a^$2!]A\u000b)\r\u0011\u0018\u0011\u0001\t\u0005UM4W/\u0003\u0002uW\t1A+\u001e9mKJ\u0002\"A^<\r\u0001\u0011)\u0001P\u0003b\u0001s\n\tA+\u0005\u0002{{B\u0011!f_\u0005\u0003y.\u0012qAT8uQ&tw\r\u0005\u0002+}&\u0011qp\u000b\u0002\u0004\u0003:L\b\"CA\u0002\u0015\u0005\u0005\t9AA\u0003\u0003))g/\u001b3f]\u000e,G%\r\t\u0006\u0003\u000f\t\t\"^\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005)1-\u001b:dK*\u0011\u0011qB\u0001\u0003S>LA!a\u0005\u0002\n\t9A)Z2pI\u0016\u0014\bBBA\f\u0015\u0001\u0007Q'A\u0002lKf\fAA]3bIV!\u0011QDA\u0012)\u0019\ty\"a\u000b\u00020Q!\u0011\u0011EA\u0013!\r1\u00181\u0005\u0003\u0006q.\u0011\r!\u001f\u0005\n\u0003OY\u0011\u0011!a\u0002\u0003S\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\t9!!\u0005\u0002\"!1\u0011QF\u0006A\u0002\u0019\fq\u0001\\1zKJLE\rC\u0003k\u0017\u0001\u0007Q'A\u0004sK\u0006$\u0017\t\u001c7\u0016\t\u0005U\u0012\u0011\t\u000b\u0005\u0003o\tI\u0005\u0006\u0003\u0002:\u0005\r\u0003C\u0002\u001c\u0002<\u0019\fy$C\u0002\u0002>}\u00121!T1q!\r1\u0018\u0011\t\u0003\u0006q2\u0011\r!\u001f\u0005\n\u0003\u000bb\u0011\u0011!a\u0002\u0003\u000f\n!\"\u001a<jI\u0016t7-\u001a\u00134!\u0019\t9!!\u0005\u0002@!)!\u000e\u0004a\u0001k\u0005)qO]5uKV!\u0011qJA3)!\t\t&a\u001a\u0002j\u0005-D\u0003BA*\u00033\u00022AKA+\u0013\r\t9f\u000b\u0002\u0005+:LG\u000fC\u0005\u0002\\5\t\t\u0011q\u0001\u0002^\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\r\u0005\u001d\u0011qLA2\u0013\u0011\t\t'!\u0003\u0003\u000f\u0015s7m\u001c3feB\u0019a/!\u001a\u0005\u000bal!\u0019A=\t\r\u00055R\u00021\u0001g\u0011\u0015QW\u00021\u00016\u0011\u001d\ti'\u0004a\u0001\u0003G\nQA^1mk\u0016\f1\u0002\\1zKJ,\u00050[:ugR!\u00111OA=!\rQ\u0013QO\u0005\u0004\u0003oZ#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003[q\u0001\u0019\u00014\u0002\r\u0011,G.\u001a;f)\u0019\t\u0019&a \u0002\u0002\"1\u0011QF\bA\u0002\u0019DQA[\bA\u0002U\n\u0011\u0002\\1zKJ\\U-_:\u0015\t\u0005\u001d\u0015\u0011\u0014\t\u0006\u0003\u0013\u000b\u0019*\u000e\b\u0005\u0003\u0017\u000byID\u00029\u0003\u001bK\u0011\u0001L\u0005\u0004\u0003#[\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003+\u000b9JA\u0002TKFT1!!%,\u0011\u0019\ti\u0003\u0005a\u0001MR!\u00111KAO\u0011\u0019\ti#\u0005a\u0001M\u0006AA.Y=fe&#7/\u0006\u0002\u0002$B)\u0011\u0011RAJM\u0006\u0019\u0012M^1jY\u0006\u0014G.Z!uiJL'-\u001e;fgR!\u0011qQAU\u0011\u0019\tic\u0005a\u0001M\u0006\u0019\u0012M^1jY\u0006\u0014G.\u001a.p_6dUM^3mgR!\u0011qVA\\!\u0019\tI)a%\u00022B\u0019!&a-\n\u0007\u0005U6FA\u0002J]RDa!!/\u0015\u0001\u0004)\u0014!\u00037bs\u0016\u0014h*Y7f\u0003\u0019\u0019G.[3oiV\tq\tK\u0002\u0016\u0003\u0003\u00042AKAb\u0013\r\t)m\u000b\u0002\niJ\fgn]5f]R\f\u0001cU\u001aBiR\u0014\u0018NY;uKN#xN]3\u0011\u0005];2\u0003B\f*\u0003\u001b\u0004B!a4\u0002X6\u0011\u0011\u0011\u001b\u0006\u0005\u0003\u001f\t\u0019N\u0003\u0002\u0002V\u0006!!.\u0019<b\u0013\u0011\tI.!5\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005%\u0017aA*F!V\u0011\u0011\u0011]\b\u0003\u0003G\f#!!:\u0002\u0005}{\u0016\u0001B*F!\u0002\nQ!\u00199qYf$rAVAw\u0003_\f\u0019\u0010C\u000347\u0001\u0007Q\u0007\u0003\u0004\u0002rn\u0001\r!N\u0001\u0005e>|G\u000fC\u0004D7A%\t\u0019\u0001#\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*\"!!?+\u0007\u001d\u000bYp\u000b\u0002\u0002~B!\u0011q B\u0005\u001b\t\u0011\tA\u0003\u0003\u0003\u0004\t\u0015\u0011!C;oG\",7m[3e\u0015\r\u00119aK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0006\u0005\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\u00151&q\u0002B\t\u0011\u0015\u0019T\u00041\u00016\u0011\u0019\u0019U\u0004\"a\u0001\t\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0007\u0011\t\tm!\u0011E\u0007\u0003\u0005;QAAa\b\u0002T\u0006!A.\u00198h\u0013\u0011\u0011\u0019C!\b\u0003\r=\u0013'.Z2u\u0001")
public class S3AttributeStore
implements BlobLayerAttributeStore {
    private transient S3Client client;
    private final String bucket;
    private final String prefix;
    private final Function0<S3Client> s3Client;
    private transient Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache;
    private volatile transient byte bitmap$trans$0;

    public static S3Client $lessinit$greater$default$3() {
        return S3AttributeStore$.MODULE$.$lessinit$greater$default$3();
    }

    public static S3AttributeStore apply(String bucket, Function0<S3Client> s3Client) {
        return S3AttributeStore$.MODULE$.apply(bucket, s3Client);
    }

    public static S3Client apply$default$3() {
        return S3AttributeStore$.MODULE$.apply$default$3();
    }

    public static S3AttributeStore apply(String bucket, String root, Function0<S3Client> s3Client) {
        return S3AttributeStore$.MODULE$.apply(bucket, root, s3Client);
    }

    public static String SEP() {
        return S3AttributeStore$.MODULE$.SEP();
    }

    public <H> H readHeader(LayerId id, Decoder<H> evidence$18) {
        return (H)BlobLayerAttributeStore.readHeader$((BlobLayerAttributeStore)this, (LayerId)id, evidence$18);
    }

    public <M> M readMetadata(LayerId id, Decoder<M> evidence$19) {
        return (M)BlobLayerAttributeStore.readMetadata$((BlobLayerAttributeStore)this, (LayerId)id, evidence$19);
    }

    public <K> KeyIndex<K> readKeyIndex(LayerId id, ClassTag<K> evidence$20) {
        return BlobLayerAttributeStore.readKeyIndex$((BlobLayerAttributeStore)this, (LayerId)id, evidence$20);
    }

    public <K> Map<ZoomRange, KeyIndex<K>> readKeyIndexes(LayerId id, ClassTag<K> evidence$21) {
        return BlobLayerAttributeStore.readKeyIndexes$((BlobLayerAttributeStore)this, (LayerId)id, evidence$21);
    }

    public Schema readSchema(LayerId id) {
        return BlobLayerAttributeStore.readSchema$((BlobLayerAttributeStore)this, (LayerId)id);
    }

    public <H, M, K> LayerAttributes<H, M, K> readLayerAttributes(LayerId id, Decoder<H> evidence$22, Decoder<M> evidence$23, ClassTag<K> evidence$24) {
        return BlobLayerAttributeStore.readLayerAttributes$((BlobLayerAttributeStore)this, (LayerId)id, evidence$22, evidence$23, evidence$24);
    }

    public <H, M, K> void writeLayerAttributes(LayerId id, H header, M metadata, KeyIndex<K> keyIndex, Schema schema, Encoder<H> evidence$25, Encoder<M> evidence$26, ClassTag<K> evidence$27) {
        BlobLayerAttributeStore.writeLayerAttributes$((BlobLayerAttributeStore)this, (LayerId)id, header, metadata, keyIndex, (Schema)schema, evidence$25, evidence$26, evidence$27);
    }

    public <H, M> COGLayerAttributes<H, M> readCOGLayerAttributes(LayerId id, Decoder<H> evidence$28, Decoder<M> evidence$29) {
        return BlobLayerAttributeStore.readCOGLayerAttributes$((BlobLayerAttributeStore)this, (LayerId)id, evidence$28, evidence$29);
    }

    public <H, M> void writeCOGLayerAttributes(LayerId id, H header, M metadata, Encoder<H> evidence$30, Encoder<M> evidence$31) {
        BlobLayerAttributeStore.writeCOGLayerAttributes$((BlobLayerAttributeStore)this, (LayerId)id, header, metadata, evidence$30, evidence$31);
    }

    public boolean isCOGLayer(LayerId id) {
        return AttributeStore.isCOGLayer$((AttributeStore)this, (LayerId)id);
    }

    public LayerType layerType(LayerId id) {
        return AttributeStore.layerType$((AttributeStore)this, (LayerId)id);
    }

    public Map<String, Seq<Object>> layersWithZoomLevels() {
        return AttributeStore.layersWithZoomLevels$((AttributeStore)this);
    }

    public void copy(LayerId from, LayerId to) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to);
    }

    public void copy(LayerId from, LayerId to, Seq<String> attributes) {
        AttributeStore.copy$((AttributeStore)this, (LayerId)from, (LayerId)to, attributes);
    }

    public <T> T cacheRead(LayerId layerId, String attributeName, Decoder<T> evidence$1) {
        return (T)AttributeCaching.cacheRead$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, evidence$1);
    }

    public LayerType cacheLayerType(LayerId layerId, LayerType layerType) {
        return AttributeCaching.cacheLayerType$((AttributeCaching)this, (LayerId)layerId, (LayerType)layerType);
    }

    public <T> void cacheWrite(LayerId layerId, String attributeName, T value, Encoder<T> evidence$2) {
        AttributeCaching.cacheWrite$((AttributeCaching)this, (LayerId)layerId, (String)attributeName, value, evidence$2);
    }

    public void clearCache() {
        AttributeCaching.clearCache$((AttributeCaching)this);
    }

    public void clearCache(LayerId id) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id);
    }

    public void clearCache(LayerId id, String attribute) {
        AttributeCaching.clearCache$((AttributeCaching)this, (LayerId)id, (String)attribute);
    }

    private Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache$lzycompute() {
        S3AttributeStore s3AttributeStore = this;
        synchronized (s3AttributeStore) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.geotrellis$store$AttributeCaching$$cache = AttributeCaching.geotrellis$store$AttributeCaching$$cache$((AttributeCaching)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.geotrellis$store$AttributeCaching$$cache;
    }

    public Cache<Tuple2<LayerId, String>, Json> geotrellis$store$AttributeCaching$$cache() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.geotrellis$store$AttributeCaching$$cache$lzycompute();
        }
        return this.geotrellis$store$AttributeCaching$$cache;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    private S3Client client$lzycompute() {
        S3AttributeStore s3AttributeStore = this;
        synchronized (s3AttributeStore) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.client = (S3Client)this.s3Client.apply();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.client;
    }

    public S3Client client() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.client$lzycompute();
        }
        return this.client;
    }

    public String path(Seq<String> parts) {
        return ((IterableOnceOps)((IterableOps)parts.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1))))).map((Function1 & Serializable)s -> {
            if (s.endsWith("/")) {
                return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(s), 1);
            }
            return s;
        })).mkString("/");
    }

    public String attributePath(LayerId id, String attributeName) {
        return this.path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prefix(), "_attributes", new StringBuilder(9).append(attributeName).append("__").append(id.name()).append("__").append(id.zoom()).append(".json").toString()}));
    }

    public String attributePrefix(String attributeName) {
        return this.path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prefix(), "_attributes", new StringBuilder(2).append(attributeName).append("__").toString()}));
    }

    private <T> Tuple2<LayerId, T> readKey(String key, Decoder<T> evidence$1) {
        String string;
        GetObjectRequest getRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket()).key(key).build();
        try (ResponseInputStream s3objStream = ((S3Client)this.s3Client.apply()).getObject(getRequest);){
            string = IOUtils.toString((InputStream)s3objStream, (Charset)Charset.forName("UTF-8"));
        }
        String json = string;
        return (Tuple2)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.parse(json).flatMap((Function1 & Serializable)x$2 -> x$2.as(Decoder$.MODULE$.decodeTuple2((Decoder)LayerId$.MODULE$.codecForLayerId(), evidence$1)))), (Function1 & Serializable)x$3 -> {
            throw x$3;
        });
    }

    public <T> T read(LayerId layerId, String attributeName, Decoder<T> evidence$2) {
        Object object;
        try {
            object = this.readKey(this.attributePath(layerId, attributeName), evidence$2)._2();
        }
        catch (S3Exception e) {
            throw new package.AttributeNotFoundError(attributeName, layerId).initCause((Throwable)e);
        }
        return (T)object;
    }

    public <T> Map<LayerId, T> readAll(String attributeName, Decoder<T> evidence$3) {
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(this.attributePrefix(attributeName)).build();
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala()).map((Function1 & Serializable)s3obj -> {
            Tuple2 tuple2;
            try {
                tuple2 = this.readKey(s3obj.key(), evidence$3);
            }
            catch (S3Exception e) {
                throw new package.LayerIOError(new StringBuilder(33).append("Unable to list ").append(attributeName).append(" attributes from ").append(this.bucket()).append("/").append(s3obj.key()).toString()).initCause((Throwable)e);
            }
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <T> void write(LayerId layerId, String attributeName, T value, Encoder<T> evidence$4) {
        String key = this.attributePath(layerId, attributeName);
        String str = package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)new Tuple2((Object)layerId, value)), (Encoder)Encoder$.MODULE$.encodeTuple2((Encoder)LayerId$.MODULE$.codecForLayerId(), evidence$4)).noSpaces();
        PutObjectRequest putRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket()).key(key).build();
        RequestBody requestBody = RequestBody.fromBytes((byte[])str.getBytes("UTF-8"));
        ((S3Client)this.s3Client.apply()).putObject(putRequest, requestBody);
    }

    public boolean layerExists(LayerId layerId) {
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(this.path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prefix(), "_attributes"}))).build();
        return ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala()).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)S3AttributeStore.$anonfun$layerExists$1(layerId, x$4)));
    }

    public void delete(LayerId layerId, String attributeName) {
        DeleteObjectRequest deleteRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket()).key(this.attributePath(layerId, attributeName)).build();
        ((S3Client)this.s3Client.apply()).deleteObject(deleteRequest);
        this.clearCache(layerId, attributeName);
    }

    private Seq<String> layerKeys(LayerId layerId) {
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(this.path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prefix(), "_attributes"}))).build();
        return ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala()).map((Function1 & Serializable)x$5 -> x$5.key())).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains(new StringBuilder(9).append("__").append(layerId.name()).append("__").append(layerId.zoom()).append(".json").toString())))).toSeq();
    }

    public void delete(LayerId layerId) {
        Seq identifiers = (Seq)this.layerKeys(layerId).map((Function1 & Serializable)key -> (ObjectIdentifier)ObjectIdentifier.builder().key(key).build());
        Delete deleteDefinition = (Delete)Delete.builder().objects((ObjectIdentifier[])identifiers.toArray(ClassTag$.MODULE$.apply(ObjectIdentifier.class))).build();
        DeleteObjectsRequest deleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket()).delete(deleteDefinition).build();
        ((S3Client)this.s3Client.apply()).deleteObjects(deleteRequest);
        this.clearCache(layerId);
    }

    public Seq<LayerId> layerIds() {
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(this.path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prefix(), "_attributes/metadata"}))).build();
        return (Seq)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala()).map((Function1 & Serializable)s3obj -> {
            SeqOps seqOps;
            List list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])new File(s3obj.key()).getName().split("__")))), 2)).toList();
            if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
                throw new MatchError((Object)list);
            }
            String zoomStr = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            String name = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Tuple2 tuple2 = new Tuple2((Object)zoomStr, (Object)name);
            String zoomStr2 = (String)tuple2._1();
            String name2 = (String)tuple2._2();
            return new LayerId(name2, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(zoomStr2.replace(".json", ""))));
        })).toSeq().distinct();
    }

    public Seq<String> availableAttributes(LayerId layerId) {
        return (Seq)this.layerKeys(layerId).map((Function1 & Serializable)key -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])new File((String)key).getName().split("__"))));
    }

    public Seq<Object> availableZoomLevels(String layerName) {
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket()).prefix(this.path((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prefix(), new StringBuilder(22).append("_attributes/metadata").append("__").append(layerName).toString()}))).build();
        return (Seq)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala()).flatMap((Function1 & Serializable)s3obj -> {
            String foundName;
            SeqOps seqOps;
            List list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])new File(s3obj.key()).getName().split("__")))), 2)).toList();
            if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
                throw new MatchError((Object)list);
            }
            String zoomStr = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            String foundName2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Tuple2 tuple2 = new Tuple2((Object)zoomStr, (Object)foundName2);
            String zoomStr2 = (String)tuple2._1();
            String string = foundName = (String)tuple2._2();
            String string2 = layerName;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(zoomStr2.replace(".json", "")))));
            }
            return None$.MODULE$;
        })).toSeq().distinct();
    }

    public static final /* synthetic */ boolean $anonfun$layerExists$1(LayerId layerId$1, S3Object x$4) {
        return x$4.key().endsWith(new StringBuilder(9).append(AttributeStore.Fields$.MODULE$.metadata()).append("__").append(layerId$1.name()).append("__").append(layerId$1.zoom()).append(".json").toString());
    }

    public S3AttributeStore(String bucket, String prefix, Function0<S3Client> s3Client) {
        this.bucket = bucket;
        this.prefix = prefix;
        this.s3Client = s3Client;
        AttributeCaching.$init$((AttributeCaching)this);
        AttributeStore.$init$((AttributeStore)this);
        BlobLayerAttributeStore.$init$((BlobLayerAttributeStore)this);
    }
}

