/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3;

import geotrellis.store.AttributeStore;
import geotrellis.store.AttributeStoreProvider;
import geotrellis.store.CollectionLayerReader;
import geotrellis.store.CollectionLayerReaderProvider;
import geotrellis.store.LayerId;
import geotrellis.store.ValueReader;
import geotrellis.store.ValueReaderProvider;
import geotrellis.store.s3.AmazonS3URI;
import geotrellis.store.s3.S3AttributeStore;
import geotrellis.store.s3.S3ClientProducer$;
import geotrellis.store.s3.S3CollectionLayerReader;
import geotrellis.store.s3.S3CollectionLayerReader$;
import geotrellis.store.s3.S3ValueReader;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.services.s3.S3Client;

@ScalaSignature(bytes="\u0006\u0005%3AAB\u0004\u0001\u001d!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C\u0001s!)!\t\u0001C\u0001\u0007\nI2kM\"pY2,7\r^5p]2\u000b\u00170\u001a:Qe>4\u0018\u000eZ3s\u0015\tA\u0011\"\u0001\u0002tg)\u0011!bC\u0001\u0006gR|'/\u001a\u0006\u0002\u0019\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M)\u0001aD\u000b\u001a9A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003%I!\u0001G\u0005\u0003-\u0005#HO]5ckR,7\u000b^8sKB\u0013xN^5eKJ\u0004\"A\u0006\u000e\n\u0005mI!a\u0005,bYV,'+Z1eKJ\u0004&o\u001c<jI\u0016\u0014\bC\u0001\f\u001e\u0013\tq\u0012BA\u000fD_2dWm\u0019;j_:d\u0015-_3s%\u0016\fG-\u001a:Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\tq!\u0001\u0006dC:\u0004&o\\2fgN$\"!\n\u0015\u0011\u0005A1\u0013BA\u0014\u0012\u0005\u001d\u0011un\u001c7fC:DQ!\u000b\u0002A\u0002)\n1!\u001e:j!\tY\u0003'D\u0001-\u0015\tic&A\u0002oKRT\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022Y\t\u0019QKU%\u0002\u001d\u0005$HO]5ckR,7\u000b^8sKR\u0011Ag\u000e\t\u0003-UJ!AN\u0005\u0003\u001d\u0005#HO]5ckR,7\u000b^8sK\")\u0011f\u0001a\u0001U\u0005Ya/\u00197vKJ+\u0017\rZ3s)\rQ\u0004)\u0011\t\u0004-mj\u0014B\u0001\u001f\n\u0005-1\u0016\r\\;f%\u0016\fG-\u001a:\u0011\u0005Yq\u0014BA \n\u0005\u001da\u0015-_3s\u0013\u0012DQ!\u000b\u0003A\u0002)BQA\u0003\u0003A\u0002Q\nQcY8mY\u0016\u001cG/[8o\u0019\u0006LXM\u001d*fC\u0012,'\u000fF\u0002E\u000f\"\u00032AF#>\u0013\t1\u0015BA\u000bD_2dWm\u0019;j_:d\u0015-_3s%\u0016\fG-\u001a:\t\u000b%*\u0001\u0019\u0001\u0016\t\u000b))\u0001\u0019\u0001\u001b")
public class S3CollectionLayerProvider
implements AttributeStoreProvider,
ValueReaderProvider,
CollectionLayerReaderProvider {
    public boolean canProcess(URI uri) {
        String string = uri.getScheme();
        if (string != null) {
            String string2 = string;
            String string3 = string2.toLowerCase();
            String string4 = "s3";
            return !(string3 != null ? !string3.equals(string4) : string4 != null);
        }
        if (string == null) {
            return false;
        }
        throw new MatchError((Object)string);
    }

    public AttributeStore attributeStore(URI uri) {
        String string;
        AmazonS3URI s3Uri = new AmazonS3URI(uri);
        Option option = Option$.MODULE$.apply((Object)s3Uri.getKey());
        if (option instanceof Some) {
            String s;
            Some some = (Some)option;
            string = s = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        String prefix = string;
        return new S3AttributeStore(s3Uri.getBucket(), prefix, (Function0<S3Client>)(Function0 & Serializable)() -> (S3Client)S3ClientProducer$.MODULE$.get().apply());
    }

    public ValueReader<LayerId> valueReader(URI uri, AttributeStore store) {
        return new S3ValueReader(store, (Function0<S3Client>)(Function0 & Serializable)() -> (S3Client)S3ClientProducer$.MODULE$.get().apply());
    }

    public CollectionLayerReader<LayerId> collectionLayerReader(URI uri, AttributeStore store) {
        return new S3CollectionLayerReader(store, (Function0<S3Client>)(Function0 & Serializable)() -> S3CollectionLayerReader$.MODULE$.$lessinit$greater$default$2());
    }
}

