/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3;

import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerCopier;
import geotrellis.store.LayerId;
import geotrellis.store.LayerType;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import geotrellis.store.s3.S3AttributeStore;
import geotrellis.store.s3.S3LayerCopier$;
import geotrellis.store.s3.S3LayerHeader;
import geotrellis.store.s3.S3LayerHeader$;
import geotrellis.store.s3.package$;
import geotrellis.util.Component;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import org.apache.avro.Schema;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.S3Object;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\t\u0013\u0001eA\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005S!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003/\u0011!Q\u0004A!A%\u0002\u0013Y\u0004\"B&\u0001\t\u0003a\u0005\"B*\u0001\t\u000b!\u0006\"\u00029\u0001\t\u0003\txaBAF%!\u0005\u0011Q\u0012\u0004\u0007#IA\t!a$\t\r-SA\u0011AAI\u0011\u001d\t\u0019J\u0003C\u0001\u0003+Cq!a%\u000b\t\u0003\ty\nC\u0004\u0002\u0014*!\t!!,\t\u000f\u0005M%\u0002\"\u0001\u00026\"I\u0011q\u0018\u0006\u0012\u0002\u0013\u0005\u0011\u0011\u0019\u0002\u000e'Nb\u0015-_3s\u0007>\u0004\u0018.\u001a:\u000b\u0005M!\u0012AA:4\u0015\t)b#A\u0003ti>\u0014XMC\u0001\u0018\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\u0005\u0012C%D\u0001\u0015\u0013\t\u0019CCA\u0006MCf,'oQ8qS\u0016\u0014\bCA\u0011&\u0013\t1CCA\u0004MCf,'/\u00133\u0002\u001d\u0005$HO]5ckR,7\u000b^8sKV\t\u0011\u0006\u0005\u0002\"U%\u00111\u0006\u0006\u0002\u000f\u0003R$(/\u001b2vi\u0016\u001cFo\u001c:f\u0003=\tG\u000f\u001e:jEV$Xm\u0015;pe\u0016\u0004\u0013A\u00033fgR\u0014UoY6fiB\u0011qF\u000e\b\u0003aQ\u0002\"!\r\u000f\u000e\u0003IR!a\r\r\u0002\rq\u0012xn\u001c;?\u0013\t)D$\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u001d\u00035!Wm\u001d;LKf\u0004&/\u001a4jq\u0006A1oM\"mS\u0016tG\u000fE\u0002\u001cyyJ!!\u0010\u000f\u0003\u0011q\u0012\u0017P\\1nKz\u0002\"aP%\u000e\u0003\u0001S!aE!\u000b\u0005\t\u001b\u0015\u0001C:feZL7-Z:\u000b\u0005\u0011+\u0015AB1xgN$7N\u0003\u0002G\u000f\u00061\u0011-\\1{_:T\u0011\u0001S\u0001\tg>4Go^1sK&\u0011!\n\u0011\u0002\t'N\u001aE.[3oi\u00061A(\u001b8jiz\"R!T(Q#J\u0003\"A\u0014\u0001\u000e\u0003IAQa\n\u0004A\u0002%BQ!\f\u0004A\u00029BQ!\u000f\u0004A\u00029BqA\u000f\u0004\u0011\n\u0003\u00071(A\u0006d_BLH*[:uS:<GCB+Y3ncg\u000e\u0005\u0002\u001c-&\u0011q\u000b\b\u0002\u0005+:LG\u000fC\u0003;\u000f\u0001\u0007a\bC\u0003[\u000f\u0001\u0007a&\u0001\u0004ck\u000e\\W\r\u001e\u0005\u00069\u001e\u0001\r!X\u0001\bY&\u001cH/\u001b8h!\rq6M\u001a\b\u0003?\u0006t!!\r1\n\u0003uI!A\u0019\u000f\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\t\u0013R,'/\u00192mK*\u0011!\r\b\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u0002\u000bQ!\\8eK2L!a\u001b5\u0003\u0011M\u001btJ\u00196fGRDQ!\\\u0004A\u0002\u0011\nAA\u001a:p[\")qn\u0002a\u0001I\u0005\u0011Ao\\\u0001\u0005G>\u0004\u00180\u0006\u0004s}\u0006U\u0013q\r\u000b\u0006g\u0006\u001d\u0015\u0011\u0012\u000b\u0015+R\fy!a\b\u00024\u0005u\u0012QJA-\u0003?\nY'!\u001d\t\u000fUD\u0011\u0011!a\u0002m\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007]TH0D\u0001y\u0015\tIH#\u0001\u0003bmJ|\u0017BA>y\u0005=\teO]8SK\u000e|'\u000fZ\"pI\u0016\u001c\u0007CA?\u007f\u0019\u0001!aa \u0005C\u0002\u0005\u0005!!A&\u0012\t\u0005\r\u0011\u0011\u0002\t\u00047\u0005\u0015\u0011bAA\u00049\t9aj\u001c;iS:<\u0007cA\u000e\u0002\f%\u0019\u0011Q\u0002\u000f\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0012!\t\t\u0011q\u0001\u0002\u0014\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\u000b\u0005U\u00111\u0004?\u000e\u0005\u0005]!bAA\r-\u0005)A.Y=fe&!\u0011QDA\f\u0005%\u0011u.\u001e8eC\ndW\rC\u0005\u0002\"!\t\t\u0011q\u0001\u0002$\u0005QQM^5eK:\u001cW\rJ\u001a\u0011\u000b\u0005\u0015\u0012q\u0006?\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tQaY5sG\u0016T!!!\f\u0002\u0005%|\u0017\u0002BA\u0019\u0003O\u0011q!\u00128d_\u0012,'\u000fC\u0005\u00026!\t\t\u0011q\u0001\u00028\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\u000b\u0005\u0015\u0012\u0011\b?\n\t\u0005m\u0012q\u0005\u0002\b\t\u0016\u001cw\u000eZ3s\u0011%\ty\u0004CA\u0001\u0002\b\t\t%\u0001\u0006fm&$WM\\2fIU\u0002R!a\u0011\u0002Jql!!!\u0012\u000b\u0007\u0005\u001dC$A\u0004sK\u001adWm\u0019;\n\t\u0005-\u0013Q\t\u0002\t\u00072\f7o\u001d+bO\"I\u0011q\n\u0005\u0002\u0002\u0003\u000f\u0011\u0011K\u0001\u000bKZLG-\u001a8dK\u00122\u0004\u0003B<{\u0003'\u00022!`A+\t\u001d\t9\u0006\u0003b\u0001\u0003\u0003\u0011\u0011A\u0016\u0005\n\u00037B\u0011\u0011!a\u0002\u0003;\n!\"\u001a<jI\u0016t7-\u001a\u00138!\u0019\t\u0019%!\u0013\u0002T!I\u0011\u0011\r\u0005\u0002\u0002\u0003\u000f\u00111M\u0001\u000bKZLG-\u001a8dK\u0012B\u0004CBA\u0013\u0003_\t)\u0007E\u0002~\u0003O\"q!!\u001b\t\u0005\u0004\t\tAA\u0001N\u0011%\ti\u0007CA\u0001\u0002\b\ty'\u0001\u0006fm&$WM\\2fIe\u0002b!!\n\u0002:\u0005\u0015\u0004\"CA:\u0011\u0005\u0005\t9AA;\u0003-)g/\u001b3f]\u000e,G%\r\u0019\u0011\u0011\u0005]\u0014QPA3\u0003\u0003k!!!\u001f\u000b\u0007\u0005md#\u0001\u0003vi&d\u0017\u0002BA@\u0003s\u0012\u0011bQ8na>tWM\u001c;\u0011\u000b\u0005U\u00111\u0011?\n\t\u0005\u0015\u0015q\u0003\u0002\u0007\u0005>,h\u000eZ:\t\u000b5D\u0001\u0019\u0001\u0013\t\u000b=D\u0001\u0019\u0001\u0013\u0002\u001bM\u001bD*Y=fe\u000e{\u0007/[3s!\tq%b\u0005\u0002\u000b5Q\u0011\u0011QR\u0001\u0006CB\u0004H.\u001f\u000b\n\u001b\u0006]\u0015\u0011TAN\u0003;CQa\n\u0007A\u0002%BQ!\f\u0007A\u00029BQ!\u000f\u0007A\u00029BaA\u000f\u0007\u0005\u0002\u0004YDcC'\u0002\"\u0006\r\u0016qUAU\u0003WCQAW\u0007A\u00029Ba!!*\u000e\u0001\u0004q\u0013!C6fsB\u0013XMZ5y\u0011\u0015iS\u00021\u0001/\u0011\u0015IT\u00021\u0001/\u0011\u0019QT\u0002\"a\u0001wQ9Q*a,\u00022\u0006M\u0006\"\u0002.\u000f\u0001\u0004q\u0003BBAS\u001d\u0001\u0007a\u0006\u0003\u0004;\u001d\u0011\u0005\ra\u000f\u000b\u0004\u001b\u0006]\u0006BB\u0014\u0010\u0001\u0004\tI\fE\u0002O\u0003wK1!!0\u0013\u0005A\u00196'\u0011;ue&\u0014W\u000f^3Ti>\u0014X-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0007T3APAcW\t\t9\r\u0005\u0003\u0002J\u0006MWBAAf\u0015\u0011\ti-a4\u0002\u0013Ut7\r[3dW\u0016$'bAAi9\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00171\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class S3LayerCopier
implements LayerCopier<LayerId> {
    private final AttributeStore attributeStore;
    private final String destBucket;
    private final String destKeyPrefix;
    private final Function0<S3Client> s3Client;

    public static S3Client $lessinit$greater$default$4() {
        return S3LayerCopier$.MODULE$.$lessinit$greater$default$4();
    }

    public static S3LayerCopier apply(S3AttributeStore attributeStore) {
        return S3LayerCopier$.MODULE$.apply(attributeStore);
    }

    public static S3LayerCopier apply(String bucket, String keyPrefix, Function0<S3Client> s3Client) {
        return S3LayerCopier$.MODULE$.apply(bucket, keyPrefix, s3Client);
    }

    public static S3LayerCopier apply(String bucket, String keyPrefix, String destBucket, String destKeyPrefix, Function0<S3Client> s3Client) {
        return S3LayerCopier$.MODULE$.apply(bucket, keyPrefix, destBucket, destKeyPrefix, s3Client);
    }

    public static S3LayerCopier apply(AttributeStore attributeStore, String destBucket, String destKeyPrefix, Function0<S3Client> s3Client) {
        return S3LayerCopier$.MODULE$.apply(attributeStore, destBucket, destKeyPrefix, s3Client);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    public final void copyListing(S3Client s3Client, String bucket, Iterable<S3Object> listing, LayerId from, LayerId to) {
        listing.foreach((Function1 & Serializable)s3obj -> {
            CopyObjectRequest request = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(bucket).sourceKey(s3obj.key()).destinationBucket(bucket).destinationKey(s3obj.key().replace(new StringBuilder(1).append(from.name()).append("/").append(from.zoom()).toString(), new StringBuilder(1).append(to.name()).append("/").append(to.zoom()).toString())).build();
            return s3Client.copyObject(request);
        });
    }

    public <K, V, M> void copy(LayerId from, LayerId to, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, Encoder<K> evidence$3, Decoder<K> evidence$4, ClassTag<K> evidence$5, AvroRecordCodec<V> evidence$6, ClassTag<V> evidence$7, Encoder<M> evidence$8, Decoder<M> evidence$9, Component<M, Bounds<K>> evidence$10) {
        if (!this.attributeStore().layerExists(from)) {
            throw new package.LayerNotFoundError(from);
        }
        if (this.attributeStore().layerExists(to)) {
            throw new package.LayerExistsError(to);
        }
        LayerAttributes layerAttributes = this.liftedTree1$1(from, evidence$9, evidence$5);
        if (layerAttributes == null) {
            throw new MatchError((Object)layerAttributes);
        }
        S3LayerHeader header = (S3LayerHeader)layerAttributes.header();
        Object metadata = layerAttributes.metadata();
        KeyIndex keyIndex = layerAttributes.keyIndex();
        Schema schema = layerAttributes.schema();
        Tuple4 tuple4 = new Tuple4((Object)header, metadata, (Object)keyIndex, (Object)schema);
        S3LayerHeader header2 = (S3LayerHeader)tuple4._1();
        Object metadata2 = tuple4._2();
        KeyIndex keyIndex2 = (KeyIndex)tuple4._3();
        Schema schema2 = (Schema)tuple4._4();
        String bucket = header2.bucket();
        String prefix = header2.key();
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket).prefix(prefix).build();
        Iterable objIter = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)((S3Client)this.s3Client.apply()).listObjectsV2Paginator(listRequest).contents()).asScala();
        this.copyListing((S3Client)this.s3Client.apply(), bucket, (Iterable<S3Object>)objIter, from, to);
        this.attributeStore().copy(from, to);
        String x$1 = this.destBucket;
        String x$2 = package$.MODULE$.makePath((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.destKeyPrefix, new StringBuilder(1).append(to.name()).append("/").append(to.zoom()).toString()}));
        String x$3 = header2.copy$default$1();
        String x$4 = header2.copy$default$2();
        LayerType x$5 = header2.copy$default$5();
        this.attributeStore().writeLayerAttributes(to, (Object)header2.copy(x$3, x$4, x$1, x$2, x$5), metadata2, keyIndex2, schema2, S3LayerHeader$.MODULE$.s3LayerHeaderEncoder(), evidence$8, evidence$5);
    }

    private final /* synthetic */ LayerAttributes liftedTree1$1(LayerId from$2, Decoder evidence$9$1, ClassTag evidence$5$1) {
        LayerAttributes layerAttributes;
        try {
            layerAttributes = this.attributeStore().readLayerAttributes(from$2, S3LayerHeader$.MODULE$.s3LayerHeaderDecoder(), evidence$9$1, evidence$5$1);
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerReadError(from$2).initCause((Throwable)e);
        }
        catch (NoSuchBucketException e) {
            throw new package.LayerReadError(from$2).initCause((Throwable)e);
        }
        return layerAttributes;
    }

    public S3LayerCopier(AttributeStore attributeStore, String destBucket, String destKeyPrefix, Function0<S3Client> s3Client) {
        this.attributeStore = attributeStore;
        this.destBucket = destBucket;
        this.destKeyPrefix = destKeyPrefix;
        this.s3Client = s3Client;
    }
}

