/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.store.s3.cog;

import cats.effect.unsafe.IORuntime;
import geotrellis.layer.Boundable;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.raster.CellGrid;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerId;
import geotrellis.store.LayerQuery;
import geotrellis.store.cog.COGCollectionLayerReader;
import geotrellis.store.cog.ZoomRange;
import geotrellis.store.index.Index$;
import geotrellis.store.package;
import geotrellis.store.s3.S3AttributeStore;
import geotrellis.store.s3.S3LayerHeader;
import geotrellis.store.s3.S3LayerHeader$;
import geotrellis.store.s3.cog.S3COGCollectionLayerReader$;
import geotrellis.store.s3.package$;
import geotrellis.store.s3.package$S3ClientExtension$;
import geotrellis.util.Component;
import io.circe.Decoder;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\t\u0012\u0001iA\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!\n\u0005\tS\u0001\u0011\t\u0011)A\u0005M!A!\u0006\u0001B\u0001J\u0003%1\u0006\u0003\u0005?\u0001\t\u0005I\u0015!\u0003@\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011)\t\t\t\u0001EC\u0002\u0013\r\u00111Q\u0004\b\u0003\u001b\u000b\u0002\u0012AAH\r\u0019\u0001\u0012\u0003#\u0001\u0002\u0012\"1!*\u0003C\u0001\u00033Cq!a'\n\t\u0003\ti\nC\u0004\u0002\u001c&!\t!!+\t\u0013\u0005\u0015\u0017\"%A\u0005\u0002\u0005\u001d\u0007\"CAo\u0013E\u0005I\u0011AAd\u0011%\ty.CI\u0001\n\u0003\t\tO\u0001\u000eTg\r{uiQ8mY\u0016\u001cG/[8o\u0019\u0006LXM\u001d*fC\u0012,'O\u0003\u0002\u0013'\u0005\u00191m\\4\u000b\u0005Q)\u0012AA:4\u0015\t1r#A\u0003ti>\u0014XMC\u0001\u0019\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\t\u00011\u0004E\u0002\u001d=\u0001j\u0011!\b\u0006\u0003%UI!aH\u000f\u00031\r{uiQ8mY\u0016\u001cG/[8o\u0019\u0006LXM\u001d*fC\u0012,'\u000f\u0005\u0002\"E5\tQ#\u0003\u0002$+\t9A*Y=fe&#\u0017AD1uiJL'-\u001e;f'R|'/Z\u000b\u0002MA\u0011\u0011eJ\u0005\u0003QU\u0011a\"\u0011;ue&\u0014W\u000f^3Ti>\u0014X-A\bbiR\u0014\u0018NY;uKN#xN]3!\u0003!\u00198g\u00117jK:$\bc\u0001\u00170c5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0005=Eft\u0017-\\3?!\t\u0011D(D\u00014\u0015\t!BG\u0003\u00026m\u0005A1/\u001a:wS\u000e,7O\u0003\u00028q\u00051\u0011m^:tI.T!!\u000f\u001e\u0002\r\u0005l\u0017M_8o\u0015\u0005Y\u0014\u0001C:pMR<\u0018M]3\n\u0005u\u001a$\u0001C*4\u00072LWM\u001c;\u0002\u000fI,h\u000e^5nKB\u0019Af\f!\u0011\u0005\u0005CU\"\u0001\"\u000b\u0005\r#\u0015AB;og\u00064WM\u0003\u0002F\r\u00061QM\u001a4fGRT\u0011aR\u0001\u0005G\u0006$8/\u0003\u0002J\u0005\nI\u0011j\u0014*v]RLW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1su\n\u0015\t\u0003\u001b\u0002i\u0011!\u0005\u0005\u0006I\u0015\u0001\rA\n\u0005\bU\u0015\u0001J\u00111\u0001,\u0011\u001dqT\u0001%CA\u0002}\nAA]3bIV\u00191+[:\u0015\u000bQ\u000b\u0019(a\u001e\u0015\u001bU\u000b\t\"!\u000b\u00024\u0005\u001d\u0013qKA7%\r1\u0006l \u0004\u0005/\u0002\u0001QK\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002ZC\u0012t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005uK\u0012A\u0002\u001fs_>$h(C\u0001/\u0013\t\u0001W&A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'aA*fc*\u0011\u0001-\f\t\u0005Y\u0015<'/\u0003\u0002g[\t1A+\u001e9mKJ\u0002\"\u0001[5\r\u0001\u0011)!N\u0002b\u0001W\n\t1*\u0005\u0002m_B\u0011A&\\\u0005\u0003]6\u0012qAT8uQ&tw\r\u0005\u0002-a&\u0011\u0011/\f\u0002\u0004\u0003:L\bC\u00015t\t\u0015!hA1\u0001v\u0005\u00051\u0016C\u00017w!\r9(\u0010`\u0007\u0002q*\u0011\u0011pF\u0001\u0007e\u0006\u001cH/\u001a:\n\u0005mD(\u0001C\"fY2<%/\u001b3\u0011\u00051j\u0018B\u0001@.\u0005\rIe\u000e\u001e\t\u0007\u0003\u0003\t9!a\u0003\u000e\u0005\u0005\r!bAA\u0003/\u0005)A.Y=fe&!\u0011\u0011BA\u0002\u0005!iU\r^1eCR\f\u0007#BA\u0001\u0003\u001b9\u0017\u0002BA\b\u0003\u0007\u0011\u0011\u0003V5mK2\u000b\u00170\u001a:NKR\fG-\u0019;b\u0011%\t\u0019BBA\u0001\u0002\b\t)\"\u0001\u0006fm&$WM\\2fIE\u0002R!a\u0006\u0002$\u001dtA!!\u0007\u0002\"9!\u00111DA\u0010\u001d\rY\u0016QD\u0005\u00021%\u0019\u0011QA\f\n\u0007\u0001\f\u0019!\u0003\u0003\u0002&\u0005\u001d\"\u0001E*qCRL\u0017\r\\\"p[B|g.\u001a8u\u0015\r\u0001\u00171\u0001\u0005\n\u0003W1\u0011\u0011!a\u0002\u0003[\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0015\t\t!a\fh\u0013\u0011\t\t$a\u0001\u0003\u0013\t{WO\u001c3bE2,\u0007\"CA\u001b\r\u0005\u0005\t9AA\u001c\u0003))g/\u001b3f]\u000e,Ge\r\t\u0006\u0003s\t\u0019eZ\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005)1-\u001b:dK*\u0011\u0011\u0011I\u0001\u0003S>LA!!\u0012\u0002<\t9A)Z2pI\u0016\u0014\b\"CA%\r\u0005\u0005\t9AA&\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0006\u0003\u001b\n\u0019fZ\u0007\u0003\u0003\u001fR1!!\u0015.\u0003\u001d\u0011XM\u001a7fGRLA!!\u0016\u0002P\tA1\t\\1tgR\u000bw\rC\u0005\u0002Z\u0019\t\t\u0011q\u0001\u0002\\\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\u000b\u0005u\u0013\u0011\u000e:\u000e\u0005\u0005}#\u0002BA1\u0003G\naA]3bI\u0016\u0014(\u0002BA3\u0003O\nqaZ3pi&4gMC\u0002\u0002BaLA!a\u001b\u0002`\tiq)Z8US\u001a4'+Z1eKJD\u0011\"a\u001c\u0007\u0003\u0003\u0005\u001d!!\u001d\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007E\u0003\u0002N\u0005M#\u000f\u0003\u0004\u0002v\u0019\u0001\r\u0001I\u0001\u0003S\u0012Dq!!\u001f\u0007\u0001\u0004\tY(A\u0006sCN$XM])vKJL\bCB\u0011\u0002~\u001d\fY!C\u0002\u0002\u0000U\u0011!\u0002T1zKJ\fV/\u001a:z\u0003%IwNU;oi&lW-F\u0001AQ\r9\u0011q\u0011\t\u0004Y\u0005%\u0015bAAF[\tIAO]1og&,g\u000e^\u0001\u001b'N\u001aujR\"pY2,7\r^5p]2\u000b\u00170\u001a:SK\u0006$WM\u001d\t\u0003\u001b&\u00192!CAJ!\ra\u0013QS\u0005\u0004\u0003/k#AB!osJ+g\r\u0006\u0002\u0002\u0010\u0006)\u0011\r\u001d9msR\u0019A*a(\t\r\u0011Z\u0001\u0019AAQ!\u0011\t\u0019+!*\u000e\u0003MI1!a*\u0014\u0005A\u00196'\u0011;ue&\u0014W\u000f^3Ti>\u0014X\rF\u0004M\u0003W\u000by,a1\t\u000f\u00055F\u00021\u0001\u00020\u00061!-^2lKR\u0004B!!-\u0002::!\u00111WA[!\tYV&C\u0002\u000286\na\u0001\u0015:fI\u00164\u0017\u0002BA^\u0003{\u0013aa\u0015;sS:<'bAA\\[!9\u0011\u0011\u0019\u0007A\u0002\u0005=\u0016A\u00029sK\u001aL\u0007\u0010C\u0004+\u0019A%\t\u0019A\u0016\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*\"!!3+\u0007E\nYm\u000b\u0002\u0002NB!\u0011qZAm\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017!C;oG\",7m[3e\u0015\r\t9.L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAn\u0003#\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a9+\u0007\u0001\u000bY\r")
public class S3COGCollectionLayerReader
extends COGCollectionLayerReader<LayerId> {
    private transient IORuntime ioRuntime;
    private final AttributeStore attributeStore;
    private final Function0<S3Client> s3Client;
    private final Function0<IORuntime> runtime;
    private volatile transient boolean bitmap$trans$0;

    public static IORuntime $lessinit$greater$default$3() {
        return S3COGCollectionLayerReader$.MODULE$.$lessinit$greater$default$3();
    }

    public static S3Client $lessinit$greater$default$2() {
        return S3COGCollectionLayerReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static S3Client apply$default$3() {
        return S3COGCollectionLayerReader$.MODULE$.apply$default$3();
    }

    public static S3COGCollectionLayerReader apply(String bucket, String prefix, Function0<S3Client> s3Client) {
        return S3COGCollectionLayerReader$.MODULE$.apply(bucket, prefix, s3Client);
    }

    public static S3COGCollectionLayerReader apply(S3AttributeStore attributeStore) {
        return S3COGCollectionLayerReader$.MODULE$.apply(attributeStore);
    }

    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    private IORuntime ioRuntime$lzycompute() {
        S3COGCollectionLayerReader s3COGCollectionLayerReader = this;
        synchronized (s3COGCollectionLayerReader) {
            if (!this.bitmap$trans$0) {
                this.ioRuntime = (IORuntime)this.runtime.apply();
                this.bitmap$trans$0 = true;
            }
        }
        return this.ioRuntime;
    }

    public IORuntime ioRuntime() {
        if (!this.bitmap$trans$0) {
            return this.ioRuntime$lzycompute();
        }
        return this.ioRuntime;
    }

    public <K, V extends CellGrid<Object>> Seq<Tuple2<K, V>> read(LayerId id, LayerQuery<K, TileLayerMetadata<K>> rasterQuery, Component<K, SpatialKey> evidence$1, Boundable<K> evidence$2, Decoder<K> evidence$3, ClassTag<K> evidence$4, GeoTiffReader<V> evidence$5, ClassTag<V> evidence$6) {
        S3LayerHeader s3LayerHeader;
        try {
            s3LayerHeader = (S3LayerHeader)this.attributeStore().readHeader(new LayerId(id.name(), 0), S3LayerHeader$.MODULE$.s3LayerHeaderDecoder());
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerNotFoundError(id).initCause((Throwable)e);
        }
        catch (NoSuchBucketException e) {
            throw new package.LayerNotFoundError(id).initCause((Throwable)e);
        }
        S3LayerHeader header = s3LayerHeader;
        String bucket = header.bucket();
        String prefix = header.key();
        return this.baseRead(id, rasterQuery, (Function2 & Serializable)(zoomRange, maxWidth) -> S3COGCollectionLayerReader.getKeyPath$1(zoomRange, BoxesRunTime.unboxToInt((Object)maxWidth), bucket, prefix, id), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)package$S3ClientExtension$.MODULE$.objectExists$extension(package$.MODULE$.S3ClientExtension((S3Client)this.s3Client.apply()), x$1)), (Function1 & Serializable)path -> new URI(new StringBuilder(5).append("s3://").append((String)path).toString()), evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, Predef$.MODULE$.$conforms());
    }

    private static final Function1 getKeyPath$1(ZoomRange zoomRange, int maxWidth, String bucket$1, String prefix$1, LayerId id$1) {
        return (Function1 & Serializable)index -> new StringBuilder(6).append(bucket$1).append("/").append(prefix$1).append("/").append(id$1.name()).append("/").append(zoomRange.minZoom()).append("_").append(zoomRange.maxZoom()).append("/").append(Index$.MODULE$.encode(index, maxWidth)).append(".").append(geotrellis.store.cog.package$.MODULE$.Extension()).toString();
    }

    public S3COGCollectionLayerReader(AttributeStore attributeStore, Function0<S3Client> s3Client, Function0<IORuntime> runtime) {
        this.attributeStore = attributeStore;
        this.s3Client = s3Client;
        this.runtime = runtime;
    }
}

