/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.pipeline.ast;

import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.FloatingLayoutScheme$;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutLevel;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.LocalLayoutScheme;
import geotrellis.layer.LocalLayoutScheme$;
import geotrellis.layer.MapKeyTransform;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpaceTimeKey;
import geotrellis.layer.SpaceTimeKey$;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TemporalKey;
import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.layer.TemporalProjectedExtent$;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.layer.TileLayerMetadata$;
import geotrellis.layer.ZoomedLayoutScheme;
import geotrellis.layer.ZoomedLayoutScheme$;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.reproject.RasterRegionReproject;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.TileReprojectMethods;
import geotrellis.raster.resample.PointResampleMethod;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.spark.pipeline.json.transform.Pyramid;
import geotrellis.spark.pipeline.json.transform.Reproject;
import geotrellis.spark.pipeline.json.transform.RetileToLayout;
import geotrellis.spark.pipeline.json.transform.TileToLayout;
import geotrellis.spark.pipeline.package$;
import geotrellis.spark.pyramid.Pyramid;
import geotrellis.spark.pyramid.Pyramid$;
import geotrellis.spark.reproject.Reproject;
import geotrellis.spark.tiling.Tiler;
import geotrellis.spark.tiling.TilerKeyMethods;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Stream;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Transform$
implements scala.Serializable {
    public static Transform$ MODULE$;

    static {
        new Transform$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <I, V extends CellGrid<Object>> RDD<Tuple2<I, V>> perTileReproject(Reproject arg, RDD<Tuple2<I, V>> rdd, Component<I, ProjectedExtent> evidence$1, Function1<V, TileReprojectMethods<V>> evidence$2) {
        LayoutDefinition layoutDefinition;
        Tuple2 tuple2 = new Tuple2(arg.scheme(), arg.maxZoom());
        if (tuple2 == null) return geotrellis.spark.package$.MODULE$.withProjectedExtentReprojectMethods(rdd, evidence$1, evidence$2).reproject(package$.MODULE$.withGetCRS(arg).getCRS());
        Either either = (Either)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!(either instanceof Left)) return geotrellis.spark.package$.MODULE$.withProjectedExtentReprojectMethods(rdd, evidence$1, evidence$2).reproject(package$.MODULE$.withGetCRS(arg).getCRS());
        Left left = (Left)either;
        LayoutScheme layoutScheme = (LayoutScheme)left.value();
        if (!(layoutScheme instanceof ZoomedLayoutScheme)) return geotrellis.spark.package$.MODULE$.withProjectedExtentReprojectMethods(rdd, evidence$1, evidence$2).reproject(package$.MODULE$.withGetCRS(arg).getCRS());
        ZoomedLayoutScheme zoomedLayoutScheme = (ZoomedLayoutScheme)layoutScheme;
        if (!(option instanceof Some)) return geotrellis.spark.package$.MODULE$.withProjectedExtentReprojectMethods(rdd, evidence$1, evidence$2).reproject(package$.MODULE$.withGetCRS(arg).getCRS());
        Some some = (Some)option;
        int mz = BoxesRunTime.unboxToInt((Object)some.value());
        LayoutLevel layoutLevel = zoomedLayoutScheme.levelForZoom(mz);
        if (layoutLevel == null) throw new MatchError((Object)layoutLevel);
        LayoutDefinition layoutDefinition2 = layoutDefinition = layoutLevel.layout();
        LayoutDefinition layoutDefinition3 = layoutDefinition2;
        PointResampleMethod x$1 = arg.resampleMethod();
        Some x$2 = new Some((Object)layoutDefinition3.cellSize());
        double x$3 = Reproject.Options$.MODULE$.apply$default$2();
        Option x$4 = Reproject.Options$.MODULE$.apply$default$3();
        Option x$5 = Reproject.Options$.MODULE$.apply$default$4();
        return geotrellis.spark.package$.MODULE$.withProjectedExtentReprojectMethods(rdd, evidence$1, evidence$2).reproject(package$.MODULE$.withGetCRS(arg).getCRS(), new Reproject.Options((ResampleMethod)x$1, x$3, x$4, x$5, (Option)x$2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, V>> bufferedReproject(Reproject arg, RDD<Tuple2<K, V>> rdd, Component<K, SpatialKey> evidence$3, Boundable<K> evidence$4, ClassTag<K> evidence$5, ClassTag<V> evidence$6, RasterRegionReproject<V> evidence$7, Stitcher<V> evidence$8, Function1<V, TileReprojectMethods<V>> evidence$9, Function1<V, CropMethods<V>> evidence$10, Function1<V, TileMergeMethods<V>> evidence$11, Function1<V, TilePrototypeMethods<V>> evidence$12) {
        Either either;
        Tuple2 tuple2 = new Tuple2(arg.scheme(), arg.maxZoom());
        if (tuple2 != null) {
            Left left;
            LayoutScheme layoutScheme;
            Either either2 = (Either)tuple2._1();
            Option option = (Option)tuple2._2();
            if (either2 instanceof Left && (layoutScheme = (LayoutScheme)(left = (Left)either2).value()) instanceof ZoomedLayoutScheme) {
                ZoomedLayoutScheme zoomedLayoutScheme = (ZoomedLayoutScheme)layoutScheme;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int mz = BoxesRunTime.unboxToInt((Object)some.value());
                    LayoutLevel layoutLevel = zoomedLayoutScheme.levelForZoom(mz);
                    if (layoutLevel == null) throw new MatchError((Object)layoutLevel);
                    int zoom = layoutLevel.zoom();
                    LayoutDefinition layoutDefinition = layoutLevel.layout();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layoutDefinition);
                    Tuple2 tuple23 = tuple22;
                    int zoom2 = tuple23._1$mcI$sp();
                    LayoutDefinition layoutDefinition2 = (LayoutDefinition)tuple23._2();
                    PointResampleMethod x$1 = arg.resampleMethod();
                    Some x$2 = new Some((Object)layoutDefinition2.cellSize());
                    double x$3 = Reproject.Options$.MODULE$.apply$default$2();
                    Option x$4 = Reproject.Options$.MODULE$.apply$default$3();
                    Option x$5 = Reproject.Options$.MODULE$.apply$default$4();
                    return (RDD)geotrellis.spark.package$.MODULE$.withTileRDDReprojectMethods(rdd, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9, evidence$10, evidence$11, evidence$12).reproject(package$.MODULE$.withGetCRS(arg).getCRS(), layoutDefinition2, Reproject.Options$.MODULE$.rasterReprojectOptionsToOptions(new Reproject.Options((ResampleMethod)x$1, x$3, x$4, x$5, (Option)x$2)))._2();
                }
            }
        }
        if (tuple2 != null && (either = (Either)tuple2._1()) instanceof Left) {
            Left left = (Left)either;
            LayoutScheme layoutScheme = (LayoutScheme)left.value();
            return (RDD)geotrellis.spark.package$.MODULE$.withTileRDDReprojectMethods(rdd, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9, evidence$10, evidence$11, evidence$12).reproject(package$.MODULE$.withGetCRS(arg).getCRS(), layoutScheme, Reproject.Options$.MODULE$.resampleMethodToOptions((ResampleMethod)arg.resampleMethod()))._2();
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Either either3 = (Either)tuple2._1();
        if (!(either3 instanceof Right)) throw new MatchError((Object)tuple2);
        Right right = (Right)either3;
        LayoutDefinition layoutDefinition = (LayoutDefinition)right.value();
        return (RDD)geotrellis.spark.package$.MODULE$.withTileRDDReprojectMethods(rdd, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9, evidence$10, evidence$11, evidence$12).reproject(package$.MODULE$.withGetCRS(arg).getCRS(), layoutDefinition, Reproject.Options$.MODULE$.resampleMethodToOptions((ResampleMethod)arg.resampleMethod()))._2();
    }

    public <K, I, V extends CellGrid<Object>> RDD<Tuple2<K, V>> tileToLayout(TileToLayout arg, RDD<Tuple2<I, V>> rdd, Boundable<K> evidence$13, Component<K, SpatialKey> evidence$14, ClassTag<K> evidence$15, Component<I, ProjectedExtent> evidence$16, Function1<I, TilerKeyMethods<I, K>> evidence$17, Function1<V, TileReprojectMethods<V>> evidence$18, Function1<V, TileMergeMethods<V>> evidence$19, Function1<V, TilePrototypeMethods<V>> evidence$20, ClassTag<V> evidence$21) {
        TileLayerMetadata md;
        Tuple2 tuple2 = geotrellis.spark.package$.MODULE$.withCollectMetadataMethods(rdd).collectMetadata((LayoutScheme)FloatingLayoutScheme$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)arg.tileSize().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 256))), evidence$13, evidence$14, evidence$17, evidence$16);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TileLayerMetadata tileLayerMetadata = md = (TileLayerMetadata)tuple2._2();
        TileLayerMetadata md2 = tileLayerMetadata;
        TileLayerMetadata md3 = md2.copy((DataType)arg.cellType().getOrElse((Function0 & Serializable & scala.Serializable)() -> md2.cellType()), md2.copy$default$2(), md2.copy$default$3(), md2.copy$default$4(), md2.copy$default$5());
        return geotrellis.spark.package$.MODULE$.withTilerMethods(rdd, evidence$21, evidence$19, evidence$20).tileToLayout(md3, Tiler.Options$.MODULE$.methodToOptions((ResampleMethod)arg.resampleMethod()), evidence$14, evidence$15, evidence$17);
    }

    public <V extends CellGrid<Object>> RDD<Tuple2<SpatialKey, V>> retileToLayoutSpatial(RetileToLayout arg, RDD<Tuple2<SpatialKey, V>> rdd, Function1<V, TileReprojectMethods<V>> evidence$22, Function1<V, TileMergeMethods<V>> evidence$23, Function1<V, TilePrototypeMethods<V>> evidence$24, ClassTag<V> evidence$25) {
        TileLayerMetadata md = (TileLayerMetadata)((Metadata)rdd).metadata();
        MapKeyTransform mapKeyTransform = md.mapTransform();
        RDD projectedRDD = rdd.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new ProjectedExtent(mapKeyTransform.apply((SpatialKey)x._1()), ((TileLayerMetadata)((Metadata)rdd).metadata()).crs()), x._2()), ClassTag$.MODULE$.apply(Tuple2.class));
        KeyBounds bounds = ((TileLayerMetadata)((Metadata)rdd).metadata()).bounds().get();
        KeyBounds spatialBounds = KeyBounds$.MODULE$.apply(mapKeyTransform.apply(((TileLayerMetadata)((Metadata)rdd).metadata()).extent()));
        LayoutDefinition x$1 = arg.layoutDefinition();
        KeyBounds x$2 = new KeyBounds(geotrellis.util.package$.MODULE$.withSetComponentMethods(bounds.minKey()).setComponent(spatialBounds.minKey(), (SetComponent)geotrellis.util.package$.MODULE$.identityComponent()), geotrellis.util.package$.MODULE$.withSetComponentMethods(bounds.maxKey()).setComponent(spatialBounds.maxKey(), (SetComponent)geotrellis.util.package$.MODULE$.identityComponent()));
        DataType x$3 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$1();
        Extent x$4 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$3();
        CRS x$5 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$4();
        TileLayerMetadata retiledLayerMetadata = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy(x$3, x$1, x$4, x$5, (Bounds)x$2);
        return geotrellis.spark.package$.MODULE$.withTilerMethods(projectedRDD, evidence$25, evidence$23, evidence$24).tileToLayout(retiledLayerMetadata, Tiler.Options$.MODULE$.methodToOptions((ResampleMethod)arg.resampleMethod()), geotrellis.util.package$.MODULE$.identityComponent(), ClassTag$.MODULE$.apply(SpatialKey.class), (Function1 & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTilerKeyMethods(self, geotrellis.util.package$.MODULE$.identityComponent()));
    }

    public <V extends CellGrid<Object>> RDD<Tuple2<SpaceTimeKey, V>> retileToLayoutTemporal(RetileToLayout arg, RDD<Tuple2<SpaceTimeKey, V>> rdd, Function1<V, TileReprojectMethods<V>> evidence$26, Function1<V, TileMergeMethods<V>> evidence$27, Function1<V, TilePrototypeMethods<V>> evidence$28, ClassTag<V> evidence$29) {
        TileLayerMetadata md = (TileLayerMetadata)((Metadata)rdd).metadata();
        MapKeyTransform mapKeyTransform = md.mapTransform();
        RDD projectedRDD = rdd.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new TemporalProjectedExtent(mapKeyTransform.apply(x._1(), SpaceTimeKey$.MODULE$.spatialComponent()), ((TileLayerMetadata)((Metadata)rdd).metadata()).crs(), ((TemporalKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(x._1()).getComponent((GetComponent)SpaceTimeKey$.MODULE$.temporalComponent())).instant()), x._2()), ClassTag$.MODULE$.apply(Tuple2.class));
        KeyBounds bounds = ((TileLayerMetadata)((Metadata)rdd).metadata()).bounds().get();
        KeyBounds spatialBounds = KeyBounds$.MODULE$.apply(mapKeyTransform.apply(((TileLayerMetadata)((Metadata)rdd).metadata()).extent()));
        LayoutDefinition x$1 = arg.layoutDefinition();
        KeyBounds x$2 = new KeyBounds(geotrellis.util.package$.MODULE$.withSetComponentMethods(bounds.minKey()).setComponent(spatialBounds.minKey(), (SetComponent)SpaceTimeKey$.MODULE$.spatialComponent()), geotrellis.util.package$.MODULE$.withSetComponentMethods(bounds.maxKey()).setComponent(spatialBounds.maxKey(), (SetComponent)SpaceTimeKey$.MODULE$.spatialComponent()));
        DataType x$3 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$1();
        Extent x$4 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$3();
        CRS x$5 = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy$default$4();
        TileLayerMetadata retiledLayerMetadata = ((TileLayerMetadata)((Metadata)rdd).metadata()).copy(x$3, x$1, x$4, x$5, (Bounds)x$2);
        return geotrellis.spark.package$.MODULE$.withTilerMethods(projectedRDD, evidence$29, evidence$27, evidence$28).tileToLayout(retiledLayerMetadata, Tiler.Options$.MODULE$.methodToOptions((ResampleMethod)arg.resampleMethod()), SpaceTimeKey$.MODULE$.spatialComponent(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), (Function1 & Serializable & scala.Serializable)self -> geotrellis.spark.package$.MODULE$.withProjectedExtentTemporalTilerKeyMethods(self, TemporalProjectedExtent$.MODULE$.projectedExtentComponent(), TemporalProjectedExtent$.MODULE$.temporalComponent()));
    }

    public <K, V extends CellGrid<Object>> Stream<Tuple2<Object, RDD<Tuple2<K, V>>>> pyramid(Pyramid arg, RDD<Tuple2<K, V>> rdd, Component<K, SpatialKey> evidence$30, AvroRecordCodec<K> evidence$31, ClassTag<K> evidence$32, AvroRecordCodec<V> evidence$33, ClassTag<V> evidence$34, Function1<V, TileMergeMethods<V>> evidence$35, Function1<V, TilePrototypeMethods<V>> evidence$36) {
        return Transform$.pyramid$1((ResampleMethod)arg.resampleMethod(), rdd, arg, evidence$30, evidence$32, evidence$34, evidence$35, evidence$36);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Stream pyramid$1(ResampleMethod resampleMethod, RDD rdd$3, Pyramid arg$1, Component evidence$30$1, ClassTag evidence$32$1, ClassTag evidence$34$1, Function1 evidence$35$1, Function1 evidence$36$1) {
        Tuple2 tuple2;
        Predef$.MODULE$.require(!((TileLayerMetadata)((Metadata)rdd$3).metadata()).bounds().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Can not pyramid an empty RDD");
        Partitioner part = (Partitioner)rdd$3.partitioner().getOrElse((Function0 & Serializable & scala.Serializable)() -> new HashPartitioner(rdd$3.partitions().length));
        Option<Object> option = arg$1.startZoom();
        if (option instanceof Some) {
            Some some = (Some)option;
            int zoom = BoxesRunTime.unboxToInt((Object)some.value());
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)zoom)), (Object)ZoomedLayoutScheme$.MODULE$.apply(((TileLayerMetadata)((Metadata)rdd$3).metadata()).crs(), TileLayerMetadata$.MODULE$.toLayoutDefinition((TileLayerMetadata)((Metadata)rdd$3).metadata()).tileRows(), ZoomedLayoutScheme$.MODULE$.apply$default$3()));
        } else if (None$.MODULE$.equals(option)) {
            int zoom = LocalLayoutScheme$.MODULE$.inferLayoutLevel(((TileLayerMetadata)((Metadata)rdd$3).metadata()).layout());
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)zoom)), (Object)new LocalLayoutScheme());
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        int baseZoom = tuple22._1$mcI$sp();
        LayoutScheme scheme = (LayoutScheme)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)baseZoom), (Object)scheme);
        Tuple2 tuple24 = tuple23;
        int baseZoom2 = tuple24._1$mcI$sp();
        LayoutScheme scheme2 = (LayoutScheme)tuple24._2();
        return Pyramid$.MODULE$.levelStream(rdd$3, scheme2, baseZoom2, BoxesRunTime.unboxToInt((Object)arg$1.endZoom().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), new Pyramid.Options(resampleMethod, geotrellis.spark.package$.MODULE$.partitionerToOption(part)), evidence$30$1, evidence$32$1, evidence$34$1, evidence$35$1, evidence$36$1, TileLayerMetadata$.MODULE$.layoutComponent(evidence$30$1), TileLayerMetadata$.MODULE$.boundsComponent(evidence$30$1));
    }

    private Transform$() {
        MODULE$ = this;
    }
}

