/*
 * Copyright 2016 Azavea
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package geotrellis.spark.io.hadoop.formats

import org.apache.hadoop.fs._

import org.apache.hadoop.mapreduce._
import org.apache.hadoop.mapreduce.lib.input._

class BytesFileInputFormat extends FileInputFormat[Path, Array[Byte]] {
  override def isSplitable(context: JobContext, fileName: Path) = false

  override def createRecordReader(split: InputSplit, context: TaskAttemptContext): RecordReader[Path, Array[Byte]] = {
    new BinaryFileRecordReader( bytes => split.asInstanceOf[FileSplit].getPath -> bytes)
  }
}
