/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark;

import cats.Contravariant;
import cats.Functor;
import cats.Invariant;
import cats.implicits$;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.CellSize$;
import geotrellis.raster.DataType;
import geotrellis.spark.Boundable;
import geotrellis.spark.Bounds;
import geotrellis.spark.Bounds$;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.KeyBounds$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata;
import geotrellis.spark.merge.Mergable;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.LayoutLevel;
import geotrellis.spark.tiling.LayoutScheme;
import geotrellis.spark.tiling.TilerKeyMethods;
import geotrellis.spark.tiling.ZoomedLayoutScheme;
import geotrellis.util.Component;
import geotrellis.util.Component$;
import geotrellis.util.GetComponent;
import geotrellis.util.GetComponent$;
import geotrellis.util.package$;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TileLayerMetadata$
implements scala.Serializable {
    public static TileLayerMetadata$ MODULE$;
    private final Functor<TileLayerMetadata> tileLayerMetadataFunctor;

    static {
        new TileLayerMetadata$();
    }

    public LayoutDefinition toLayoutDefinition(TileLayerMetadata<?> md) {
        return md.layout();
    }

    public <K> GetComponent<TileLayerMetadata<K>, Extent> extentComponent() {
        return GetComponent$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$3 -> x$3.extent());
    }

    public <K> GetComponent<TileLayerMetadata<K>, CRS> crsComponent() {
        return GetComponent$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$4 -> x$4.crs());
    }

    public <K> Component<TileLayerMetadata<K>, LayoutDefinition> layoutComponent(Component<K, SpatialKey> evidence$1) {
        return Component$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$5 -> x$5.layout(), (Function2 & Serializable & scala.Serializable)(md, l) -> {
            LayoutDefinition x$43 = l;
            DataType x$44 = md.copy$default$1();
            Extent x$45 = md.copy$default$3();
            CRS x$46 = md.copy$default$4();
            Bounds x$47 = md.copy$default$5();
            return md.copy(x$44, x$43, x$45, x$46, x$47);
        });
    }

    public <K> Component<TileLayerMetadata<K>, Bounds<K>> boundsComponent(Component<K, SpatialKey> evidence$2) {
        return Component$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$6 -> x$6.bounds(), (Function2 & Serializable & scala.Serializable)(md, b) -> md.updateBounds(b, evidence$2));
    }

    public <K> Mergable<TileLayerMetadata<K>> mergable(Boundable<K> evidence$3) {
        return new Mergable<TileLayerMetadata<K>>(evidence$3){
            private final Boundable evidence$3$1;

            public TileLayerMetadata<K> merge(TileLayerMetadata<K> t1, TileLayerMetadata<K> t2) {
                return t1.combine(t2, this.evidence$3$1);
            }
            {
                this.evidence$3$1 = evidence$3$1;
            }
        };
    }

    public Functor<TileLayerMetadata> tileLayerMetadataFunctor() {
        return this.tileLayerMetadataFunctor;
    }

    private <K, V extends CellGrid, K2> Tuple4<Extent, DataType, CellSize, KeyBounds<K2>> collectMetadata(RDD<Tuple2<K, V>> rdd, Function1<K, TilerKeyMethods<K, K2>> evidence$4, Component<K2, SpatialKey> evidence$5, Boundable<K2> evidence$6) {
        return (Tuple4)rdd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            CellGrid grid = (CellGrid)tuple2._2();
            Extent extent = ((TilerKeyMethods)evidence$4.apply(key)).extent();
            Object boundsKey = ((TilerKeyMethods)evidence$4.apply(key)).translate(new SpatialKey(0, 0));
            Tuple4 tuple4 = new Tuple4((Object)extent, (Object)grid.cellType(), (Object)CellSize$.MODULE$.apply(extent, grid.cols(), grid.rows()), new KeyBounds(boundsKey, boundsKey));
            return tuple4;
        }, ClassTag$.MODULE$.apply(Tuple4.class)).reduce((Function2 & Serializable & scala.Serializable)(tuple1, tuple2) -> {
            Tuple4 tuple4 = tuple1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Extent extent1 = (Extent)tuple4._1();
            DataType cellType1 = (DataType)tuple4._2();
            CellSize cellSize1 = (CellSize)tuple4._3();
            KeyBounds bounds1 = (KeyBounds)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)extent1, (Object)cellType1, (Object)cellSize1, (Object)bounds1);
            Tuple4 tuple43 = tuple42;
            Extent extent12 = (Extent)tuple43._1();
            DataType cellType12 = (DataType)tuple43._2();
            CellSize cellSize12 = (CellSize)tuple43._3();
            KeyBounds bounds12 = (KeyBounds)tuple43._4();
            Tuple4 tuple44 = tuple2;
            if (tuple44 == null) {
                throw new MatchError((Object)tuple44);
            }
            Extent extent2 = (Extent)tuple44._1();
            DataType cellType2 = (DataType)tuple44._2();
            CellSize cellSize2 = (CellSize)tuple44._3();
            KeyBounds bounds2 = (KeyBounds)tuple44._4();
            Tuple4 tuple45 = new Tuple4((Object)extent2, (Object)cellType2, (Object)cellSize2, (Object)bounds2);
            Tuple4 tuple46 = tuple45;
            Extent extent22 = (Extent)tuple46._1();
            DataType cellType22 = (DataType)tuple46._2();
            CellSize cellSize22 = (CellSize)tuple46._3();
            KeyBounds bounds22 = (KeyBounds)tuple46._4();
            return new Tuple4((Object)extent12.combine(extent22), (Object)cellType12.union(cellType22), (Object)(cellSize12.resolution() < cellSize22.resolution() ? cellSize12 : cellSize22), (Object)bounds12.combine((Bounds)bounds22, evidence$6));
        });
    }

    private <K, V extends CellGrid, K2> Tuple5<Extent, DataType, CellSize, KeyBounds<K2>, CRS> collectMetadataWithCRS(RDD<Tuple2<K, V>> rdd, GetComponent<K, ProjectedExtent> evidence$7, Function1<K, TilerKeyMethods<K, K2>> evidence$8, Component<K2, SpatialKey> evidence$9, Boundable<K2> evidence$10) {
        Tuple5 tuple5 = (Tuple5)rdd.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            CellGrid grid;
            Object key;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null) {
                key = tuple22._1();
                grid = (CellGrid)tuple22._2();
                ProjectedExtent projectedExtent = (ProjectedExtent)package$.MODULE$.withGetComponentMethods(key).getComponent(evidence$7);
                if (projectedExtent == null) {
                    throw new MatchError((Object)projectedExtent);
                }
                Extent extent = projectedExtent.extent();
                CRS crs = projectedExtent.crs();
                tuple2 = new Tuple2((Object)extent, (Object)crs);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            Extent extent = (Extent)tuple23._1();
            CRS crs = (CRS)tuple23._2();
            Object boundsKey = ((TilerKeyMethods)evidence$8.apply(key)).translate(new SpatialKey(0, 0));
            Tuple5 tuple5 = new Tuple5((Object)extent, (Object)grid.cellType(), (Object)CellSize$.MODULE$.apply(extent, grid.cols(), grid.rows()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CRS[]{crs})), new KeyBounds(boundsKey, boundsKey));
            return tuple5;
        }, ClassTag$.MODULE$.apply(Tuple5.class)).reduce((Function2 & Serializable & scala.Serializable)(tuple1, tuple2) -> {
            Tuple5 tuple5 = tuple1;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Extent extent1 = (Extent)tuple5._1();
            DataType cellType1 = (DataType)tuple5._2();
            CellSize cellSize1 = (CellSize)tuple5._3();
            Set crs1 = (Set)tuple5._4();
            KeyBounds bounds1 = (KeyBounds)tuple5._5();
            Tuple5 tuple52 = new Tuple5((Object)extent1, (Object)cellType1, (Object)cellSize1, (Object)crs1, (Object)bounds1);
            Tuple5 tuple53 = tuple52;
            Extent extent12 = (Extent)tuple53._1();
            DataType cellType12 = (DataType)tuple53._2();
            CellSize cellSize12 = (CellSize)tuple53._3();
            Set crs12 = (Set)tuple53._4();
            KeyBounds bounds12 = (KeyBounds)tuple53._5();
            Tuple5 tuple54 = tuple2;
            if (tuple54 == null) {
                throw new MatchError((Object)tuple54);
            }
            Extent extent2 = (Extent)tuple54._1();
            DataType cellType2 = (DataType)tuple54._2();
            CellSize cellSize2 = (CellSize)tuple54._3();
            Set crs2 = (Set)tuple54._4();
            KeyBounds bounds2 = (KeyBounds)tuple54._5();
            Tuple5 tuple55 = new Tuple5((Object)extent2, (Object)cellType2, (Object)cellSize2, (Object)crs2, (Object)bounds2);
            Tuple5 tuple56 = tuple55;
            Extent extent22 = (Extent)tuple56._1();
            DataType cellType22 = (DataType)tuple56._2();
            CellSize cellSize22 = (CellSize)tuple56._3();
            Set crs22 = (Set)tuple56._4();
            KeyBounds bounds22 = (KeyBounds)tuple56._5();
            return new Tuple5((Object)extent12.combine(extent22), (Object)cellType12.union(cellType22), (Object)(cellSize12.resolution() < cellSize22.resolution() ? cellSize12 : cellSize22), (Object)crs12.$plus$plus((GenTraversableOnce)crs22), (Object)bounds12.combine((Bounds)bounds22, evidence$10));
        });
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Extent extent = (Extent)tuple5._1();
        DataType cellType = (DataType)tuple5._2();
        CellSize cellSize = (CellSize)tuple5._3();
        Set crsSet = (Set)tuple5._4();
        KeyBounds bounds = (KeyBounds)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)extent, (Object)cellType, (Object)cellSize, (Object)crsSet, (Object)bounds);
        Tuple5 tuple53 = tuple52;
        Extent extent2 = (Extent)tuple53._1();
        DataType cellType2 = (DataType)tuple53._2();
        CellSize cellSize2 = (CellSize)tuple53._3();
        Set crsSet2 = (Set)tuple53._4();
        KeyBounds bounds2 = (KeyBounds)tuple53._5();
        Predef$.MODULE$.require(crsSet2.size() == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Multiple CRS tags found: ").append(crsSet2).toString());
        return new Tuple5((Object)extent2, (Object)cellType2, (Object)cellSize2, (Object)bounds2, crsSet2.head());
    }

    public <K, V extends CellGrid, K2> TileLayerMetadata<K2> fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, LayoutDefinition layout, Function1<K, TilerKeyMethods<K, K2>> evidence$11, Component<K2, SpatialKey> evidence$12, Boundable<K2> evidence$13) {
        Tuple4<Extent, DataType, CellSize, KeyBounds<K2>> tuple4 = this.collectMetadata(rdd, evidence$11, evidence$12, evidence$13);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Extent extent = (Extent)tuple4._1();
        DataType cellType = (DataType)tuple4._2();
        KeyBounds bounds = (KeyBounds)tuple4._4();
        Tuple3 tuple3 = new Tuple3((Object)extent, (Object)cellType, (Object)bounds);
        Tuple3 tuple32 = tuple3;
        Extent extent2 = (Extent)tuple32._1();
        DataType cellType2 = (DataType)tuple32._2();
        KeyBounds bounds2 = (KeyBounds)tuple32._3();
        Bounds kb = bounds2.setSpatialBounds((KeyBounds)KeyBounds$.MODULE$.apply(layout.mapTransform().apply(extent2)), (Component)evidence$12);
        return new TileLayerMetadata(cellType2, layout, extent2, crs, kb);
    }

    public <K, V extends CellGrid, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, LayoutScheme scheme, Function1<K, TilerKeyMethods<K, K2>> evidence$14, Component<K2, SpatialKey> evidence$15, Boundable<K2> evidence$16) {
        Tuple4<Extent, DataType, CellSize, KeyBounds<K2>> tuple4 = this.collectMetadata(rdd, evidence$14, evidence$15, evidence$16);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Extent extent = (Extent)tuple4._1();
        DataType cellType = (DataType)tuple4._2();
        CellSize cellSize = (CellSize)tuple4._3();
        KeyBounds bounds = (KeyBounds)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds);
        Tuple4 tuple43 = tuple42;
        Extent extent2 = (Extent)tuple43._1();
        DataType cellType2 = (DataType)tuple43._2();
        CellSize cellSize2 = (CellSize)tuple43._3();
        KeyBounds bounds2 = (KeyBounds)tuple43._4();
        LayoutLevel layoutLevel = scheme.levelFor(extent2, cellSize2);
        if (layoutLevel == null) {
            throw new MatchError((Object)layoutLevel);
        }
        int zoom = layoutLevel.zoom();
        LayoutDefinition layout = layoutLevel.layout();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layout);
        Tuple2 tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = (LayoutDefinition)((Object)tuple22._2());
        Bounds kb = bounds2.setSpatialBounds((KeyBounds)KeyBounds$.MODULE$.apply(layout2.mapTransform().apply(extent2)), (Component)evidence$15);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom2), new TileLayerMetadata(cellType2, layout2, extent2, crs, kb));
    }

    public <K, V extends CellGrid, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, ZoomedLayoutScheme scheme, Function1<K, TilerKeyMethods<K, K2>> evidence$17, Component<K2, SpatialKey> evidence$18, Boundable<K2> evidence$19) {
        return this._fromRDD(rdd, crs, scheme, (Option<Object>)None$.MODULE$, evidence$17, evidence$18, evidence$19);
    }

    public <K, V extends CellGrid, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, ZoomedLayoutScheme scheme, int maxZoom, Function1<K, TilerKeyMethods<K, K2>> evidence$20, Component<K2, SpatialKey> evidence$21, Boundable<K2> evidence$22) {
        return this._fromRDD(rdd, crs, scheme, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxZoom)), evidence$20, evidence$21, evidence$22);
    }

    private <K, V extends CellGrid, K2> Tuple2<Object, TileLayerMetadata<K2>> _fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, ZoomedLayoutScheme scheme, Option<Object> maxZoom, Function1<K, TilerKeyMethods<K, K2>> evidence$23, Component<K2, SpatialKey> evidence$24, Boundable<K2> evidence$25) {
        Tuple4<Extent, DataType, CellSize, KeyBounds<K2>> tuple4 = this.collectMetadata(rdd, evidence$23, evidence$24, evidence$25);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Extent extent = (Extent)tuple4._1();
        DataType cellType = (DataType)tuple4._2();
        CellSize cellSize = (CellSize)tuple4._3();
        KeyBounds bounds = (KeyBounds)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds);
        Tuple4 tuple43 = tuple42;
        Extent extent2 = (Extent)tuple43._1();
        DataType cellType2 = (DataType)tuple43._2();
        CellSize cellSize2 = (CellSize)tuple43._3();
        KeyBounds bounds2 = (KeyBounds)tuple43._4();
        Option<Object> option = maxZoom;
        LayoutLevel layoutLevel = option instanceof Some ? scheme.levelForZoom(BoxesRunTime.unboxToInt((Object)maxZoom.get())) : scheme.levelFor(extent2, cellSize2);
        LayoutLevel layoutLevel2 = layoutLevel;
        if (layoutLevel2 == null) {
            throw new MatchError((Object)layoutLevel2);
        }
        int zoom = layoutLevel2.zoom();
        LayoutDefinition layout = layoutLevel2.layout();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layout);
        Tuple2 tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = (LayoutDefinition)((Object)tuple22._2());
        Bounds kb = bounds2.setSpatialBounds((KeyBounds)KeyBounds$.MODULE$.apply(layout2.mapTransform().apply(extent2)), (Component)evidence$24);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom2), new TileLayerMetadata(cellType2, layout2, extent2, crs, kb));
    }

    public <K, V extends CellGrid, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, LayoutScheme scheme, GetComponent<K, ProjectedExtent> evidence$26, Function1<K, TilerKeyMethods<K, K2>> evidence$27, Component<K2, SpatialKey> evidence$28, Boundable<K2> evidence$29) {
        Tuple5<Extent, DataType, CellSize, KeyBounds<K2>, CRS> tuple5 = this.collectMetadataWithCRS(rdd, evidence$26, evidence$27, evidence$28, evidence$29);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        Extent extent = (Extent)tuple5._1();
        DataType cellType = (DataType)tuple5._2();
        CellSize cellSize = (CellSize)tuple5._3();
        KeyBounds bounds = (KeyBounds)tuple5._4();
        CRS crs = (CRS)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds, (Object)crs);
        Tuple5 tuple53 = tuple52;
        Extent extent2 = (Extent)tuple53._1();
        DataType cellType2 = (DataType)tuple53._2();
        CellSize cellSize2 = (CellSize)tuple53._3();
        KeyBounds bounds2 = (KeyBounds)tuple53._4();
        CRS crs2 = (CRS)tuple53._5();
        LayoutLevel layoutLevel = scheme.levelFor(extent2, cellSize2);
        if (layoutLevel == null) {
            throw new MatchError((Object)layoutLevel);
        }
        int zoom = layoutLevel.zoom();
        LayoutDefinition layout = layoutLevel.layout();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layout);
        Tuple2 tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = (LayoutDefinition)((Object)tuple22._2());
        Bounds kb = bounds2.setSpatialBounds((KeyBounds)KeyBounds$.MODULE$.apply(layout2.mapTransform().apply(extent2)), (Component)evidence$28);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom2), new TileLayerMetadata(cellType2, layout2, extent2, crs2, kb));
    }

    public <K, V extends CellGrid, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, ZoomedLayoutScheme scheme, GetComponent<K, ProjectedExtent> evidence$30, Function1<K, TilerKeyMethods<K, K2>> evidence$31, Component<K2, SpatialKey> evidence$32, Boundable<K2> evidence$33) {
        return this._fromRDD(rdd, scheme, (Option<Object>)None$.MODULE$, evidence$30, evidence$31, evidence$32, evidence$33);
    }

    public <K, V extends CellGrid, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, ZoomedLayoutScheme scheme, int maxZoom, GetComponent<K, ProjectedExtent> evidence$34, Function1<K, TilerKeyMethods<K, K2>> evidence$35, Component<K2, SpatialKey> evidence$36, Boundable<K2> evidence$37) {
        return this._fromRDD(rdd, scheme, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxZoom)), evidence$34, evidence$35, evidence$36, evidence$37);
    }

    private <K, V extends CellGrid, K2> Tuple2<Object, TileLayerMetadata<K2>> _fromRDD(RDD<Tuple2<K, V>> rdd, ZoomedLayoutScheme scheme, Option<Object> maxZoom, GetComponent<K, ProjectedExtent> evidence$38, Function1<K, TilerKeyMethods<K, K2>> evidence$39, Component<K2, SpatialKey> evidence$40, Boundable<K2> evidence$41) {
        Tuple5<Extent, DataType, CellSize, KeyBounds<K2>, CRS> tuple5 = this.collectMetadataWithCRS(rdd, evidence$38, evidence$39, evidence$40, evidence$41);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        Extent extent = (Extent)tuple5._1();
        DataType cellType = (DataType)tuple5._2();
        CellSize cellSize = (CellSize)tuple5._3();
        KeyBounds bounds = (KeyBounds)tuple5._4();
        CRS crs = (CRS)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds, (Object)crs);
        Tuple5 tuple53 = tuple52;
        Extent extent2 = (Extent)tuple53._1();
        DataType cellType2 = (DataType)tuple53._2();
        CellSize cellSize2 = (CellSize)tuple53._3();
        KeyBounds bounds2 = (KeyBounds)tuple53._4();
        CRS crs2 = (CRS)tuple53._5();
        Option<Object> option = maxZoom;
        LayoutLevel layoutLevel = option instanceof Some ? scheme.levelForZoom(BoxesRunTime.unboxToInt((Object)maxZoom.get())) : scheme.levelFor(extent2, cellSize2);
        LayoutLevel layoutLevel2 = layoutLevel;
        if (layoutLevel2 == null) {
            throw new MatchError((Object)layoutLevel2);
        }
        int zoom = layoutLevel2.zoom();
        LayoutDefinition layout = layoutLevel2.layout();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layout);
        Tuple2 tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = (LayoutDefinition)((Object)tuple22._2());
        Bounds kb = bounds2.setSpatialBounds((KeyBounds)KeyBounds$.MODULE$.apply(layout2.mapTransform().apply(extent2)), (Component)evidence$40);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom2), new TileLayerMetadata(cellType2, layout2, extent2, crs2, kb));
    }

    public <K, V extends CellGrid, K2> TileLayerMetadata<K2> fromRDD(RDD<Tuple2<K, V>> rdd, LayoutDefinition layoutDefinition, GetComponent<K, ProjectedExtent> evidence$42, Function1<K, TilerKeyMethods<K, K2>> evidence$43, Component<K2, SpatialKey> evidence$44, Boundable<K2> evidence$45) {
        Tuple5<Extent, DataType, CellSize, KeyBounds<K2>, CRS> tuple5 = this.collectMetadataWithCRS(rdd, evidence$42, evidence$43, evidence$44, evidence$45);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        Extent extent = (Extent)tuple5._1();
        DataType cellType = (DataType)tuple5._2();
        CellSize cellSize = (CellSize)tuple5._3();
        KeyBounds bounds = (KeyBounds)tuple5._4();
        CRS crs = (CRS)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds, (Object)crs);
        Tuple5 tuple53 = tuple52;
        Extent extent2 = (Extent)tuple53._1();
        DataType cellType2 = (DataType)tuple53._2();
        CellSize cellSize2 = (CellSize)tuple53._3();
        KeyBounds bounds2 = (KeyBounds)tuple53._4();
        CRS crs2 = (CRS)tuple53._5();
        Bounds kb = bounds2.setSpatialBounds((KeyBounds)KeyBounds$.MODULE$.apply(layoutDefinition.mapTransform().apply(extent2)), (Component)evidence$44);
        return new TileLayerMetadata(cellType2, layoutDefinition, extent2, crs2, kb);
    }

    public <K> TileLayerMetadata<K> apply(DataType cellType, LayoutDefinition layout, Extent extent, CRS crs, Bounds<K> bounds) {
        return new TileLayerMetadata<K>(cellType, layout, extent, crs, bounds);
    }

    public <K> Option<Tuple5<DataType, LayoutDefinition, Extent, CRS, Bounds<K>>> unapply(TileLayerMetadata<K> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.cellType(), (Object)x$0.layout(), (Object)x$0.extent(), (Object)x$0.crs(), x$0.bounds()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TileLayerMetadata$() {
        MODULE$ = this;
        this.tileLayerMetadataFunctor = new Functor<TileLayerMetadata>(){

            public Object imap(Object fa, Function1 f, Function1 g) {
                return Functor.imap$((Functor)this, (Object)fa, (Function1)f, (Function1)g);
            }

            public final Object fmap(Object fa, Function1 f) {
                return Functor.fmap$((Functor)this, (Object)fa, (Function1)f);
            }

            public Object widen(Object fa) {
                return Functor.widen$((Functor)this, (Object)fa);
            }

            public <A, B> Function1<TileLayerMetadata<A>, TileLayerMetadata<B>> lift(Function1<A, B> f) {
                return Functor.lift$((Functor)this, f);
            }

            public Object void(Object fa) {
                return Functor.void$((Functor)this, (Object)fa);
            }

            public Object fproduct(Object fa, Function1 f) {
                return Functor.fproduct$((Functor)this, (Object)fa, (Function1)f);
            }

            public Object as(Object fa, Object b) {
                return Functor.as$((Functor)this, (Object)fa, (Object)b);
            }

            public Object tupleLeft(Object fa, Object b) {
                return Functor.tupleLeft$((Functor)this, (Object)fa, (Object)b);
            }

            public Object tupleRight(Object fa, Object b) {
                return Functor.tupleRight$((Functor)this, (Object)fa, (Object)b);
            }

            public <G> Functor<?> compose(Functor<G> evidence$1) {
                return Functor.compose$((Functor)this, evidence$1);
            }

            public <G> Contravariant<?> composeContravariant(Contravariant<G> evidence$2) {
                return Functor.composeContravariant$((Functor)this, evidence$2);
            }

            public <G> Invariant<?> compose(Invariant<G> evidence$1) {
                return Invariant.compose$((Invariant)this, evidence$1);
            }

            public <G> Invariant<?> composeFunctor(Functor<G> evidence$2) {
                return Invariant.composeFunctor$((Invariant)this, evidence$2);
            }

            public <A, B> TileLayerMetadata<B> map(TileLayerMetadata<A> fa, Function1<A, B> f) {
                Bounds x$48 = (Bounds)implicits$.MODULE$.toFunctorOps(fa.bounds(), Bounds$.MODULE$.boundsFunctor()).map(f);
                DataType x$49 = fa.copy$default$1();
                LayoutDefinition x$50 = fa.copy$default$2();
                Extent x$51 = fa.copy$default$3();
                CRS x$52 = fa.copy$default$4();
                return fa.copy(x$49, x$50, x$51, x$52, x$48);
            }
            {
                Invariant.$init$((Invariant)this);
                Functor.$init$((Functor)this);
            }
        };
    }
}

