/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.buffer;

import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.buffer.BufferSizes;
import geotrellis.spark.buffer.BufferedTile;
import geotrellis.spark.buffer.Direction;
import geotrellis.spark.buffer.Direction$Bottom$;
import geotrellis.spark.buffer.Direction$BottomLeft$;
import geotrellis.spark.buffer.Direction$BottomRight$;
import geotrellis.spark.buffer.Direction$Center$;
import geotrellis.spark.buffer.Direction$DirectionOp$;
import geotrellis.spark.buffer.Direction$Left$;
import geotrellis.spark.buffer.Direction$Right$;
import geotrellis.spark.buffer.Direction$Top$;
import geotrellis.spark.buffer.Direction$TopLeft$;
import geotrellis.spark.buffer.Direction$TopRight$;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.util.package$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.log4j.Logger;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

public final class BufferTiles$ {
    public static BufferTiles$ MODULE$;
    private final Logger logger;

    static {
        new BufferTiles$();
    }

    public Logger logger() {
        return this.logger;
    }

    public <K, V extends CellGrid> Seq<Tuple2<K, Tuple2<Direction, V>>> collectWithTileNeighbors(K key, V tile, Function1<SpatialKey, Object> includeKey, Function1<SpatialKey, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$1, Function1<V, CropMethods<V>> evidence$2) {
        SpatialKey spatialKey = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent(evidence$1);
        if (spatialKey == null) {
            throw new MatchError((Object)spatialKey);
        }
        int col = spatialKey.col();
        int row = spatialKey.row();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
        Tuple2.mcII.sp sp3 = sp2;
        int col2 = sp3._1$mcI$sp();
        int row2 = sp3._2$mcI$sp();
        ArrayBuffer parts = new ArrayBuffer(9);
        int cols = tile.cols();
        int rows = tile.rows();
        BufferTiles$.addSlice$1(new SpatialKey(col2, row2), (Function0 & Serializable & scala.Serializable)() -> Direction$Center$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        BufferTiles$.addSlice$1(new SpatialKey(col2 - 1, row2), (Function0 & Serializable & scala.Serializable)() -> Direction$Right$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        BufferTiles$.addSlice$1(new SpatialKey(col2 + 1, row2), (Function0 & Serializable & scala.Serializable)() -> Direction$Left$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        BufferTiles$.addSlice$1(new SpatialKey(col2, row2 - 1), (Function0 & Serializable & scala.Serializable)() -> Direction$Bottom$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        BufferTiles$.addSlice$1(new SpatialKey(col2, row2 + 1), (Function0 & Serializable & scala.Serializable)() -> Direction$Top$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        BufferTiles$.addSlice$1(new SpatialKey(col2 - 1, row2 - 1), (Function0 & Serializable & scala.Serializable)() -> Direction$BottomRight$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        BufferTiles$.addSlice$1(new SpatialKey(col2 + 1, row2 - 1), (Function0 & Serializable & scala.Serializable)() -> Direction$BottomLeft$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        BufferTiles$.addSlice$1(new SpatialKey(col2 + 1, row2 + 1), (Function0 & Serializable & scala.Serializable)() -> Direction$TopLeft$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        BufferTiles$.addSlice$1(new SpatialKey(col2 - 1, row2 + 1), (Function0 & Serializable & scala.Serializable)() -> Direction$TopRight$.MODULE$, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2, parts, cols, rows);
        return parts;
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> bufferWithNeighbors(RDD<Tuple2<K, Iterable<Tuple2<Direction, V>>>> rdd, Component<K, SpatialKey> evidence$3, ClassTag<K> evidence$4, Stitcher<V> evidence$5, ClassTag<V> evidence$6) {
        RDD<Tuple2<K, Iterable<Tuple2<Direction, V>>>> x$46 = rdd;
        ClassTag<K> x$47 = evidence$4;
        ClassTag x$48 = ClassTag$.MODULE$.apply(Iterable.class);
        Null$ x$49 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$46);
        RDD r = RDD$.MODULE$.rddToPairRDDFunctions(x$46, x$47, x$48, null).flatMapValues((Function1 & Serializable & scala.Serializable)neighbors -> Option$.MODULE$.option2Iterable(neighbors.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BufferTiles$.$anonfun$bufferWithNeighbors$2(x$2))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CellGrid centerTile = (CellGrid)tuple2._2();
            BufferSizes bufferSizes = (BufferSizes)neighbors.foldLeft((Object)new BufferSizes(0, 0, 0, 0), (Function2 & Serializable & scala.Serializable)(acc, tup) -> {
                BufferSizes bufferSizes;
                Tuple2 tuple2 = tup;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Direction direction = (Direction)tuple2._1();
                CellGrid slice = (CellGrid)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)direction, (Object)slice);
                Tuple2 tuple23 = tuple22;
                Direction direction2 = (Direction)tuple23._1();
                CellGrid slice2 = (CellGrid)tuple23._2();
                Direction direction3 = direction2;
                if (Direction$Left$.MODULE$.equals(direction3)) {
                    bufferSizes = acc.copy(slice2.cols(), acc.copy$default$2(), acc.copy$default$3(), acc.copy$default$4());
                } else if (Direction$Right$.MODULE$.equals(direction3)) {
                    int x$50 = slice2.cols();
                    int x$51 = acc.copy$default$1();
                    int x$52 = acc.copy$default$3();
                    int x$53 = acc.copy$default$4();
                    bufferSizes = acc.copy(x$51, x$50, x$52, x$53);
                } else if (Direction$Top$.MODULE$.equals(direction3)) {
                    int x$54 = slice2.rows();
                    int x$55 = acc.copy$default$1();
                    int x$56 = acc.copy$default$2();
                    int x$57 = acc.copy$default$3();
                    bufferSizes = acc.copy(x$55, x$56, x$57, x$54);
                } else if (Direction$Bottom$.MODULE$.equals(direction3)) {
                    int x$58 = slice2.rows();
                    int x$59 = acc.copy$default$1();
                    int x$60 = acc.copy$default$2();
                    int x$61 = acc.copy$default$4();
                    bufferSizes = acc.copy(x$59, x$60, x$58, x$61);
                } else if (Direction$BottomRight$.MODULE$.equals(direction3)) {
                    int x$62 = slice2.rows();
                    int x$63 = slice2.cols();
                    int x$64 = acc.copy$default$1();
                    int x$65 = acc.copy$default$4();
                    bufferSizes = acc.copy(x$64, x$63, x$62, x$65);
                } else if (Direction$BottomLeft$.MODULE$.equals(direction3)) {
                    int x$66 = slice2.rows();
                    int x$67 = slice2.cols();
                    int x$68 = acc.copy$default$2();
                    int x$69 = acc.copy$default$4();
                    bufferSizes = acc.copy(x$67, x$68, x$66, x$69);
                } else if (Direction$TopRight$.MODULE$.equals(direction3)) {
                    int x$70 = slice2.rows();
                    int x$71 = slice2.cols();
                    int x$72 = acc.copy$default$1();
                    int x$73 = acc.copy$default$3();
                    bufferSizes = acc.copy(x$72, x$71, x$73, x$70);
                } else if (Direction$TopLeft$.MODULE$.equals(direction3)) {
                    int x$74 = slice2.rows();
                    int x$75 = slice2.cols();
                    int x$76 = acc.copy$default$2();
                    int x$77 = acc.copy$default$3();
                    bufferSizes = acc.copy(x$75, x$76, x$77, x$74);
                } else {
                    bufferSizes = acc;
                }
                return bufferSizes;
            });
            Iterable pieces = (Iterable)neighbors.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2.mcII.sp sp2;
                CellGrid slice;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2.mcII.sp sp3;
                    Direction direction = (Direction)tuple2._1();
                    slice = (CellGrid)tuple2._2();
                    Direction direction2 = direction;
                    if (Direction$Center$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left(), bufferSizes.top());
                    } else if (Direction$Left$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(0, bufferSizes.top());
                    } else if (Direction$Right$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left() + centerTile.cols(), bufferSizes.top());
                    } else if (Direction$Top$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left(), 0);
                    } else if (Direction$Bottom$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left(), bufferSizes.top() + centerTile.rows());
                    } else if (Direction$TopLeft$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(0, 0);
                    } else if (Direction$TopRight$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left() + centerTile.cols(), 0);
                    } else if (Direction$BottomLeft$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(0, bufferSizes.top() + centerTile.rows());
                    } else if (Direction$BottomRight$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left() + centerTile.cols(), bufferSizes.top() + centerTile.rows());
                    } else {
                        throw new MatchError((Object)direction2);
                    }
                    Tuple2.mcII.sp sp4 = sp3;
                    if (sp4 == null) {
                        throw new MatchError((Object)sp4);
                    }
                    int updateColMin = sp4._1$mcI$sp();
                    int updateRowMin = sp4._2$mcI$sp();
                    sp2 = new Tuple2.mcII.sp(updateColMin, updateRowMin);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcII.sp sp5 = sp2;
                int updateColMin = sp5._1$mcI$sp();
                int updateRowMin = sp5._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)slice, (Object)new Tuple2.mcII.sp(updateColMin, updateRowMin));
                return tuple22;
            }, Iterable$.MODULE$.canBuildFrom());
            int cols = centerTile.cols() + bufferSizes.left() + bufferSizes.right();
            int rows = centerTile.rows() + bufferSizes.top() + bufferSizes.bottom();
            CellGrid stitched = ((Stitcher)Predef$.MODULE$.implicitly((Object)evidence$5)).stitch(pieces, cols, rows);
            BufferedTile<CellGrid> bufferedTile = new BufferedTile<CellGrid>(stitched, new GridBounds(bufferSizes.left(), bufferSizes.top(), cols - bufferSizes.right() - 1, rows - bufferSizes.bottom() - 1));
            return bufferedTile;
        })));
        return r;
    }

    public <K, V extends CellGrid> Seq<Tuple2<K, BufferedTile<V>>> bufferWithNeighbors(Seq<Tuple2<K, Seq<Tuple2<Direction, V>>>> seq, Component<K, SpatialKey> evidence$7, Stitcher<V> evidence$8) {
        return (Seq)seq.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Seq neighbors = (Seq)tuple2._2();
            Option opt = neighbors.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)BufferTiles$.$anonfun$bufferWithNeighbors$7(x$5))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                CellGrid centerTile = (CellGrid)tuple2._2();
                BufferSizes bufferSizes = (BufferSizes)neighbors.foldLeft((Object)new BufferSizes(0, 0, 0, 0), (Function2 & Serializable & scala.Serializable)(acc, tup) -> {
                    BufferSizes bufferSizes;
                    Tuple2 tuple2 = tup;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Direction direction = (Direction)tuple2._1();
                    CellGrid slice = (CellGrid)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)direction, (Object)slice);
                    Tuple2 tuple23 = tuple22;
                    Direction direction2 = (Direction)tuple23._1();
                    CellGrid slice2 = (CellGrid)tuple23._2();
                    Direction direction3 = direction2;
                    if (Direction$Left$.MODULE$.equals(direction3)) {
                        bufferSizes = acc.copy(slice2.cols(), acc.copy$default$2(), acc.copy$default$3(), acc.copy$default$4());
                    } else if (Direction$Right$.MODULE$.equals(direction3)) {
                        int x$78 = slice2.cols();
                        int x$79 = acc.copy$default$1();
                        int x$80 = acc.copy$default$3();
                        int x$81 = acc.copy$default$4();
                        bufferSizes = acc.copy(x$79, x$78, x$80, x$81);
                    } else if (Direction$Top$.MODULE$.equals(direction3)) {
                        int x$82 = slice2.rows();
                        int x$83 = acc.copy$default$1();
                        int x$84 = acc.copy$default$2();
                        int x$85 = acc.copy$default$3();
                        bufferSizes = acc.copy(x$83, x$84, x$85, x$82);
                    } else if (Direction$Bottom$.MODULE$.equals(direction3)) {
                        int x$86 = slice2.rows();
                        int x$87 = acc.copy$default$1();
                        int x$88 = acc.copy$default$2();
                        int x$89 = acc.copy$default$4();
                        bufferSizes = acc.copy(x$87, x$88, x$86, x$89);
                    } else if (Direction$BottomRight$.MODULE$.equals(direction3)) {
                        int x$90 = slice2.rows();
                        int x$91 = slice2.cols();
                        int x$92 = acc.copy$default$1();
                        int x$93 = acc.copy$default$4();
                        bufferSizes = acc.copy(x$92, x$91, x$90, x$93);
                    } else if (Direction$BottomLeft$.MODULE$.equals(direction3)) {
                        int x$94 = slice2.rows();
                        int x$95 = slice2.cols();
                        int x$96 = acc.copy$default$2();
                        int x$97 = acc.copy$default$4();
                        bufferSizes = acc.copy(x$95, x$96, x$94, x$97);
                    } else if (Direction$TopRight$.MODULE$.equals(direction3)) {
                        int x$98 = slice2.rows();
                        int x$99 = slice2.cols();
                        int x$100 = acc.copy$default$1();
                        int x$101 = acc.copy$default$3();
                        bufferSizes = acc.copy(x$100, x$99, x$101, x$98);
                    } else if (Direction$TopLeft$.MODULE$.equals(direction3)) {
                        int x$102 = slice2.rows();
                        int x$103 = slice2.cols();
                        int x$104 = acc.copy$default$2();
                        int x$105 = acc.copy$default$3();
                        bufferSizes = acc.copy(x$103, x$104, x$105, x$102);
                    } else {
                        bufferSizes = acc;
                    }
                    return bufferSizes;
                });
                Seq pieces = (Seq)neighbors.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    Tuple2.mcII.sp sp2;
                    CellGrid slice;
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 != null) {
                        Tuple2.mcII.sp sp3;
                        Direction direction = (Direction)tuple2._1();
                        slice = (CellGrid)tuple2._2();
                        Direction direction2 = direction;
                        if (Direction$Center$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left(), bufferSizes.top());
                        } else if (Direction$Left$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(0, bufferSizes.top());
                        } else if (Direction$Right$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left() + centerTile.cols(), bufferSizes.top());
                        } else if (Direction$Top$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left(), 0);
                        } else if (Direction$Bottom$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left(), bufferSizes.top() + centerTile.rows());
                        } else if (Direction$TopLeft$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(0, 0);
                        } else if (Direction$TopRight$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left() + centerTile.cols(), 0);
                        } else if (Direction$BottomLeft$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(0, bufferSizes.top() + centerTile.rows());
                        } else if (Direction$BottomRight$.MODULE$.equals(direction2)) {
                            sp3 = new Tuple2.mcII.sp(bufferSizes.left() + centerTile.cols(), bufferSizes.top() + centerTile.rows());
                        } else {
                            throw new MatchError((Object)direction2);
                        }
                        Tuple2.mcII.sp sp4 = sp3;
                        if (sp4 == null) {
                            throw new MatchError((Object)sp4);
                        }
                        int updateColMin = sp4._1$mcI$sp();
                        int updateRowMin = sp4._2$mcI$sp();
                        sp2 = new Tuple2.mcII.sp(updateColMin, updateRowMin);
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Tuple2.mcII.sp sp5 = sp2;
                    int updateColMin = sp5._1$mcI$sp();
                    int updateRowMin = sp5._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)slice, (Object)new Tuple2.mcII.sp(updateColMin, updateRowMin));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom());
                int cols = centerTile.cols() + bufferSizes.left() + bufferSizes.right();
                int rows = centerTile.rows() + bufferSizes.top() + bufferSizes.bottom();
                CellGrid stitched = ((Stitcher)Predef$.MODULE$.implicitly((Object)evidence$8)).stitch((Iterable)pieces, cols, rows);
                BufferedTile<CellGrid> bufferedTile = new BufferedTile<CellGrid>(stitched, new GridBounds(bufferSizes.left(), bufferSizes.top(), cols - bufferSizes.right() - 1, rows - bufferSizes.bottom() - 1));
                return bufferedTile;
            });
            Iterable iterable = opt.isEmpty() ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), opt.get())));
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <K, V extends CellGrid> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> rdd, int bufferSize, Component<K, SpatialKey> evidence$9, Stitcher<V> evidence$10, Function1<V, CropMethods<V>> evidence$11) {
        return this.apply(rdd, bufferSize, new GridBounds(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), evidence$9, evidence$10, evidence$11);
    }

    public <K, V extends CellGrid> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, Function1<K, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$12, Stitcher<V> evidence$13, Function1<V, CropMethods<V>> evidence$14) {
        return this.apply(seq, (Seq)seq.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), getBufferSizes.apply(key));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom()), evidence$12, evidence$13, evidence$14);
    }

    public <K, V extends CellGrid> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, Seq<Tuple2<K, BufferSizes>> bufferSizesPerKey, Component<K, SpatialKey> evidence$15, Stitcher<V> evidence$16, Function1<V, CropMethods<V>> evidence$17) {
        Seq contributingKeys = (Seq)bufferSizesPerKey.flatMap((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple3 tuple3;
            BufferSizes bufferSizes;
            Object key;
            Tuple2 tuple2 = x0$7;
            if (tuple2 != null) {
                key = tuple2._1();
                bufferSizes = (BufferSizes)tuple2._2();
                SpatialKey spatialKey = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$15);
                if (spatialKey == null) {
                    throw new MatchError((Object)spatialKey);
                }
                int col = spatialKey.col();
                int row = spatialKey.row();
                tuple3 = new Tuple3((Object)spatialKey, (Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row));
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple32 = tuple3;
            SpatialKey spatialKey = (SpatialKey)tuple32._1();
            int col = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int row = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(key, (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col - 1, row), (SetComponent)evidence$15), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col + 1, row), (SetComponent)evidence$15), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col, row - 1), (SetComponent)evidence$15), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col, row + 1), (SetComponent)evidence$15), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col - 1, row - 1), (SetComponent)evidence$15), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col + 1, row - 1), (SetComponent)evidence$15), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col + 1, row + 1), (SetComponent)evidence$15), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes)), new Tuple2(package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(col - 1, row + 1), (SetComponent)evidence$15), (Object)new Tuple2((Object)spatialKey, (Object)bufferSizes))}));
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        Seq surroundingBufferSizes = contributingKeys.groupBy((Function1 & Serializable & scala.Serializable)x$9 -> x$9._1()).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> ((TraversableOnce)x$10.map((Function1 & Serializable & scala.Serializable)x$11 -> (Tuple2)x$11._2(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).toSeq();
        Seq grouped = ((TraversableLike)((TraversableLike)seq.zip((GenIterable)surroundingBufferSizes, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$8 -> {
            CellGrid tile;
            Object key2;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$8;
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    key2 = tuple23._1();
                    tile = (CellGrid)tuple23._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Map bufferSizesMap = (Map)tuple2._2();
            Seq<Tuple2<Object, Tuple2<Direction, CellGrid>>> seq = MODULE$.collectWithTileNeighbors(key2, tile, (Function1<SpatialKey, Object>)(Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)bufferSizesMap.contains((Object)key)), (Function1<SpatialKey, BufferSizes>)bufferSizesMap, evidence$15, evidence$17);
            return seq;
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$12 -> x$12._1()).mapValues((Function1 & Serializable & scala.Serializable)x$13 -> (Seq)x$13.map((Function1 & Serializable & scala.Serializable)x$14 -> (Tuple2)x$14._2(), Seq$.MODULE$.canBuildFrom())).toSeq();
        return this.bufferWithNeighbors(grouped, evidence$15, evidence$16);
    }

    public <K, V extends CellGrid> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, int bufferSize, GridBounds layerBounds, Component<K, SpatialKey> evidence$18, Stitcher<V> evidence$19, Function1<V, CropMethods<V>> evidence$20) {
        BufferSizes bufferSizes = new BufferSizes(bufferSize, bufferSize, bufferSize, bufferSize);
        Seq grouped = ((TraversableLike)seq.flatMap((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key2 = tuple2._1();
            CellGrid tile = (CellGrid)tuple2._2();
            Seq<Tuple2<Object, Tuple2<Direction, CellGrid>>> seq = MODULE$.collectWithTileNeighbors(key2, tile, (Function1<SpatialKey, Object>)(Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)layerBounds.contains(key.col(), key.row())), (Function1<SpatialKey, BufferSizes>)(Function1 & Serializable & scala.Serializable)key -> bufferSizes, evidence$18, evidence$20);
            return seq;
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$15 -> x$15._1()).mapValues((Function1 & Serializable & scala.Serializable)x$16 -> (Seq)x$16.map((Function1 & Serializable & scala.Serializable)x$17 -> (Tuple2)x$17._2(), Seq$.MODULE$.canBuildFrom())).toSeq();
        return this.bufferWithNeighbors(grouped, evidence$18, evidence$19);
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> rdd, int bufferSize, Component<K, SpatialKey> evidence$21, ClassTag<K> evidence$22, Stitcher<V> evidence$23, ClassTag<V> evidence$24, Function1<V, CropMethods<V>> evidence$25) {
        return this.apply(rdd, (Function1 & Serializable & scala.Serializable)x$18 -> new BufferSizes(bufferSize, bufferSize, bufferSize, bufferSize), (Option<Partitioner>)None$.MODULE$, evidence$21, evidence$22, evidence$23, evidence$25);
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> rdd, int bufferSize, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$26, ClassTag<K> evidence$27, Stitcher<V> evidence$28, ClassTag<V> evidence$29, Function1<V, CropMethods<V>> evidence$30) {
        return this.apply(rdd, (Function1 & Serializable & scala.Serializable)x$19 -> new BufferSizes(bufferSize, bufferSize, bufferSize, bufferSize), partitioner, evidence$26, evidence$27, evidence$28, evidence$30);
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> rdd, int bufferSize, GridBounds layerBounds, Component<K, SpatialKey> evidence$31, ClassTag<K> evidence$32, Stitcher<V> evidence$33, ClassTag<V> evidence$34, Function1<V, CropMethods<V>> evidence$35) {
        return this.apply(rdd, bufferSize, layerBounds, (Option<Partitioner>)None$.MODULE$, evidence$31, evidence$32, evidence$33, evidence$34, evidence$35);
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> rdd, int bufferSize, GridBounds layerBounds, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$36, ClassTag<K> evidence$37, Stitcher<V> evidence$38, ClassTag<V> evidence$39, Function1<V, CropMethods<V>> evidence$40) {
        return this.apply(rdd, (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)BufferTiles$.$anonfun$apply$19(layerBounds, evidence$36, key)), (Function1 & Serializable & scala.Serializable)x$20 -> new BufferSizes(bufferSize, bufferSize, bufferSize, bufferSize), partitioner, evidence$36, evidence$37, evidence$38, evidence$40);
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> layer, Function1<K, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$41, ClassTag<K> evidence$42, Stitcher<V> evidence$43, Function1<V, CropMethods<V>> evidence$44) {
        return this.apply(layer, getBufferSizes, (Option<Partitioner>)None$.MODULE$, evidence$41, evidence$42, evidence$43, evidence$44);
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> layer, Function1<K, BufferSizes> getBufferSizes, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$45, ClassTag<K> evidence$46, Stitcher<V> evidence$47, Function1<V, CropMethods<V>> evidence$48) {
        return this.apply(layer, (Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)BufferTiles$.$anonfun$apply$21(x$21)), getBufferSizes, partitioner, evidence$45, evidence$46, evidence$47, evidence$48);
    }

    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> layer, Function1<K, Object> includeKey, Function1<K, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$49, ClassTag<K> evidence$50, Stitcher<V> evidence$51, Function1<V, CropMethods<V>> evidence$52) {
        return this.apply(layer, includeKey, getBufferSizes, (Option<Partitioner>)None$.MODULE$, evidence$49, evidence$50, evidence$51, evidence$52);
    }

    /*
     * Unable to fully structure code
     */
    public <K, V extends CellGrid> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> layer, Function1<K, Object> includeKey, Function1<K, BufferSizes> getBufferSizes, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$53, ClassTag<K> evidence$54, Stitcher<V> evidence$55, Function1<V, CropMethods<V>> evidence$56) {
        block7: {
            block8: {
                block6: {
                    leftDirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$TopLeft$.MODULE$, Direction$Left$.MODULE$, Direction$BottomLeft$.MODULE$}));
                    hmidDirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$Top$.MODULE$, Direction$Center$.MODULE$, Direction$Bottom$.MODULE$}));
                    rightDirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$TopRight$.MODULE$, Direction$Right$.MODULE$, Direction$BottomRight$.MODULE$}));
                    topDirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$TopLeft$.MODULE$, Direction$Top$.MODULE$, Direction$TopRight$.MODULE$}));
                    vmidDirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$Left$.MODULE$, Direction$Center$.MODULE$, Direction$Right$.MODULE$}));
                    botDirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$BottomLeft$.MODULE$, Direction$Bottom$.MODULE$, Direction$BottomRight$.MODULE$}));
                    var18_15 = new Tuple2((Object)layer.partitioner(), partitioner);
                    if (var18_15 == null || !((var19_16 = (Option)var18_15._2()) instanceof Some)) break block6;
                    var10_17 = partitioner;
                    break block7;
                }
                if (var18_15 == null) break block8;
                var20_18 = (Option)var18_15._1();
                var21_19 = (Option)var18_15._2();
                if (!(var20_18 instanceof Some) || !None$.MODULE$.equals(var21_19)) break block8;
                var10_17 = layer.partitioner();
                break block7;
            }
            if (var18_15 == null) ** GOTO lbl-1000
            var22_20 = (Option)var18_15._1();
            var23_21 = (Option)var18_15._2();
            if (None$.MODULE$.equals(var22_20) && None$.MODULE$.equals(var23_21)) {
                var10_17 = None$.MODULE$;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var18_15);
            }
        }
        targetPartitioner = var10_17;
        sliced = layer.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$22(scala.Function1 scala.Function1 geotrellis.util.Component scala.Function1 scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.Tuple2 ), (Lscala/Tuple2;)Lscala/collection/Seq;)(includeKey, getBufferSizes, evidence$53, evidence$56, (Seq)leftDirs, (Seq)hmidDirs, (Seq)rightDirs, (Seq)topDirs, (Seq)vmidDirs, (Seq)botDirs), ClassTag$.MODULE$.apply(Tuple2.class));
        var26_24 = targetPartitioner;
        if (var26_24 instanceof Some) {
            var27_25 = (Some)var26_24;
            p = (Partitioner)var27_25.value();
            x$108 = sliced;
            x$109 = evidence$54;
            x$110 = ClassTag$.MODULE$.apply(Tuple3.class);
            x$111 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$108);
            var9_31 = RDD$.MODULE$.rddToPairRDDFunctions(x$108, x$109, x$110, null).groupByKey(p);
        } else if (None$.MODULE$.equals(var26_24)) {
            x$112 = sliced;
            x$113 = evidence$54;
            x$114 = ClassTag$.MODULE$.apply(Tuple3.class);
            x$115 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$112);
            var9_31 = RDD$.MODULE$.rddToPairRDDFunctions(x$112, x$113, x$114, null).groupByKey();
        } else {
            throw new MatchError((Object)var26_24);
        }
        x$116 = grouped = var9_31;
        x$117 = evidence$54;
        x$118 = ClassTag$.MODULE$.apply(Iterable.class);
        x$119 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$116);
        return RDD$.MODULE$.rddToPairRDDFunctions(x$116, x$117, x$118, null).flatMapValues((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$25(geotrellis.raster.stitch.Stitcher scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Iterable ), (Lscala/collection/Iterable;)Lscala/collection/TraversableOnce;)(evidence$55, (Seq)leftDirs, (Seq)hmidDirs, (Seq)rightDirs, (Seq)topDirs, (Seq)vmidDirs, (Seq)botDirs));
    }

    private static final void addSlice$1(SpatialKey spatialKey, Function0 direction, Object key$1, CellGrid tile$1, Function1 includeKey$1, Function1 getBufferSizes$1, Component evidence$1$1, Function1 evidence$2$1, ArrayBuffer parts$1, int cols$1, int rows$1) {
        block18: {
            CellGrid cellGrid;
            if (!BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply((Object)spatialKey))) break block18;
            BufferSizes bufferSizes = (BufferSizes)getBufferSizes$1.apply((Object)spatialKey);
            Direction direction2 = (Direction)direction.apply();
            if (Direction$Center$.MODULE$.equals(direction2)) {
                cellGrid = tile$1;
            } else if (Direction$Right$.MODULE$.equals(direction2)) {
                boolean x$30 = true;
                boolean x$31 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, 0, bufferSizes.right() - 1, rows$1 - 1, new Crop.Options(x$31, x$30));
            } else if (Direction$Left$.MODULE$.equals(direction2)) {
                boolean x$32 = true;
                boolean x$33 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(cols$1 - bufferSizes.left(), 0, cols$1 - 1, rows$1 - 1, new Crop.Options(x$33, x$32));
            } else if (Direction$Top$.MODULE$.equals(direction2)) {
                boolean x$34 = true;
                boolean x$35 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, rows$1 - bufferSizes.top(), cols$1 - 1, rows$1 - 1, new Crop.Options(x$35, x$34));
            } else if (Direction$Bottom$.MODULE$.equals(direction2)) {
                boolean x$36 = true;
                boolean x$37 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, 0, cols$1 - 1, bufferSizes.bottom() - 1, new Crop.Options(x$37, x$36));
            } else if (Direction$TopLeft$.MODULE$.equals(direction2)) {
                boolean x$38 = true;
                boolean x$39 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(cols$1 - bufferSizes.left(), rows$1 - bufferSizes.top(), cols$1 - 1, rows$1 - 1, new Crop.Options(x$39, x$38));
            } else if (Direction$TopRight$.MODULE$.equals(direction2)) {
                boolean x$40 = true;
                boolean x$41 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, rows$1 - bufferSizes.top(), bufferSizes.right() - 1, rows$1 - 1, new Crop.Options(x$41, x$40));
            } else if (Direction$BottomLeft$.MODULE$.equals(direction2)) {
                boolean x$42 = true;
                boolean x$43 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(cols$1 - bufferSizes.left(), 0, cols$1 - 1, bufferSizes.bottom() - 1, new Crop.Options(x$43, x$42));
            } else if (Direction$BottomRight$.MODULE$.equals(direction2)) {
                boolean x$44 = true;
                boolean x$45 = Crop.Options$.MODULE$.apply$default$1();
                cellGrid = (CellGrid)((CropMethods)evidence$2$1.apply((Object)tile$1)).crop(0, 0, bufferSizes.right() - 1, bufferSizes.bottom() - 1, new Crop.Options(x$45, x$44));
            } else {
                throw new MatchError((Object)direction2);
            }
            CellGrid part = cellGrid;
            parts$1.$plus$eq((Object)new Tuple2(package$.MODULE$.withSetComponentMethods(key$1).setComponent((Object)spatialKey, (SetComponent)evidence$1$1), (Object)new Tuple2(direction.apply(), (Object)part)));
        }
    }

    public static final /* synthetic */ boolean $anonfun$bufferWithNeighbors$2(Tuple2 x$2) {
        Object object = x$2._1();
        Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
        return !(object != null ? !object.equals(direction$Center$) : direction$Center$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$bufferWithNeighbors$7(Tuple2 x$5) {
        Object object = x$5._1();
        Direction$Center$ direction$Center$ = Direction$Center$.MODULE$;
        return !(object != null ? !object.equals(direction$Center$) : direction$Center$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$19(GridBounds layerBounds$1, Component evidence$36$1, Object key) {
        SpatialKey k = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$36$1);
        return layerBounds$1.contains(k.col(), k.row());
    }

    public static final /* synthetic */ boolean $anonfun$apply$21(Object x$21) {
        return true;
    }

    private static final Tuple2 genSection$1(Direction neighbor, Function1 getBufferSizes$2, Component evidence$53$1, Function1 evidence$56$1, Seq leftDirs$1, Seq hmidDirs$1, Seq rightDirs$1, Seq topDirs$1, Seq vmidDirs$1, Seq botDirs$1, Object key$2, CellGrid tile$2, int x$120, int y$1, int cols$2, int rows$2) {
        boolean bl;
        boolean bl2;
        Tuple2.mcII.sp sp2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        Tuple2.mcII.sp sp3;
        boolean bl6;
        Tuple2<Object, Object> tuple2 = Direction$DirectionOp$.MODULE$.offsetOf(neighbor);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int xOfs = tuple2._1$mcI$sp();
        int yOfs = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(xOfs, yOfs);
        Tuple2.mcII.sp sp5 = sp4;
        int xOfs2 = sp5._1$mcI$sp();
        int yOfs2 = sp5._2$mcI$sp();
        Object targetKey = package$.MODULE$.withSetComponentMethods(key$2).setComponent((Object)new SpatialKey(x$120 + xOfs2, y$1 + yOfs2), (SetComponent)evidence$53$1);
        Product targetDir = Direction$DirectionOp$.MODULE$.opp(neighbor);
        BufferSizes bs = (BufferSizes)getBufferSizes$2.apply(targetKey);
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)leftDirs$1.contains((Object)neighbor)), (Object)BoxesRunTime.boxToBoolean((boolean)hmidDirs$1.contains((Object)neighbor)), (Object)BoxesRunTime.boxToBoolean((boolean)rightDirs$1.contains((Object)neighbor)));
        if (tuple3 != null && (bl6 = BoxesRunTime.unboxToBoolean((Object)tuple3._1()))) {
            sp3 = new Tuple2.mcII.sp(0, bs.right() - 1);
        } else if (tuple3 != null && (bl5 = BoxesRunTime.unboxToBoolean((Object)tuple3._2()))) {
            sp3 = new Tuple2.mcII.sp(0, cols$2 - 1);
        } else if (tuple3 != null && (bl4 = BoxesRunTime.unboxToBoolean((Object)tuple3._3()))) {
            sp3 = new Tuple2.mcII.sp(cols$2 - bs.left(), cols$2 - 1);
        } else {
            throw new IllegalStateException("Unreachable state");
        }
        Tuple2.mcII.sp sp6 = sp3;
        if (sp6 == null) {
            throw new MatchError((Object)sp6);
        }
        int l = sp6._1$mcI$sp();
        int r = sp6._2$mcI$sp();
        Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(l, r);
        Tuple2.mcII.sp sp8 = sp7;
        int l2 = sp8._1$mcI$sp();
        int r2 = sp8._2$mcI$sp();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)topDirs$1.contains((Object)neighbor)), (Object)BoxesRunTime.boxToBoolean((boolean)vmidDirs$1.contains((Object)neighbor)), (Object)BoxesRunTime.boxToBoolean((boolean)botDirs$1.contains((Object)neighbor)));
        if (tuple32 != null && (bl3 = BoxesRunTime.unboxToBoolean((Object)tuple32._1()))) {
            sp2 = new Tuple2.mcII.sp(0, bs.bottom() - 1);
        } else if (tuple32 != null && (bl2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2()))) {
            sp2 = new Tuple2.mcII.sp(0, rows$2 - 1);
        } else if (tuple32 != null && (bl = BoxesRunTime.unboxToBoolean((Object)tuple32._3()))) {
            sp2 = new Tuple2.mcII.sp(rows$2 - bs.top(), rows$2 - 1);
        } else {
            throw new IllegalStateException("Unreachable state");
        }
        Tuple2.mcII.sp sp9 = sp2;
        if (sp9 == null) {
            throw new MatchError((Object)sp9);
        }
        int t = sp9._1$mcI$sp();
        int b = sp9._2$mcI$sp();
        Tuple2.mcII.sp sp10 = new Tuple2.mcII.sp(t, b);
        Tuple2.mcII.sp sp11 = sp10;
        int t2 = sp11._1$mcI$sp();
        int b2 = sp11._2$mcI$sp();
        MODULE$.logger().debug((Object)new StringBuilder(47).append("Generating buffer for ").append(targetKey).append(" -> ").append(targetDir).append(" from ").append(key$2).append(" over span [").append(new Tuple2.mcII.sp(l2, t2)).append(", ").append(new Tuple2.mcII.sp(r2, b2)).append("]").toString());
        boolean x$106 = true;
        boolean x$107 = Crop.Options$.MODULE$.apply$default$1();
        CellGrid slice = (CellGrid)((CropMethods)evidence$56$1.apply((Object)tile$2)).crop(l2, t2, r2, b2, new Crop.Options(x$107, x$106));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(targetKey), (Object)new Tuple3(targetKey, (Object)targetDir, (Object)slice));
    }

    public static final /* synthetic */ Seq $anonfun$apply$22(Function1 includeKey$2, Function1 getBufferSizes$2, Component evidence$53$1, Function1 evidence$56$1, Seq leftDirs$1, Seq hmidDirs$1, Seq rightDirs$1, Seq topDirs$1, Seq vmidDirs$1, Seq botDirs$1, Tuple2 x0$10) {
        Tuple2.mcII.sp sp2;
        CellGrid tile;
        Object key;
        Tuple2 tuple2 = x0$10;
        if (tuple2 != null) {
            key = tuple2._1();
            tile = (CellGrid)tuple2._2();
            SpatialKey spatialKey = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$53$1);
            if (spatialKey == null) {
                throw new MatchError((Object)spatialKey);
            }
            int x = spatialKey.col();
            int y = spatialKey.row();
            sp2 = new Tuple2.mcII.sp(x, y);
        } else {
            throw new MatchError((Object)tuple2);
        }
        Tuple2.mcII.sp sp3 = sp2;
        int x = sp3._1$mcI$sp();
        int y = sp3._2$mcI$sp();
        int cols = tile.cols();
        int rows = tile.rows();
        Seq seq = BoxesRunTime.unboxToBoolean((Object)includeKey$2.apply(key)) ? (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$Center$.MODULE$, Direction$Left$.MODULE$, Direction$Right$.MODULE$, Direction$Bottom$.MODULE$, Direction$Top$.MODULE$, Direction$TopLeft$.MODULE$, Direction$TopRight$.MODULE$, Direction$BottomLeft$.MODULE$, Direction$BottomRight$.MODULE$}))).map((Function1 & Serializable & scala.Serializable)neighbor -> BufferTiles$.genSection$1(neighbor, getBufferSizes$2, evidence$53$1, evidence$56$1, leftDirs$1, hmidDirs$1, rightDirs$1, topDirs$1, vmidDirs$1, botDirs$1, key, tile, x, y, cols, rows), Seq$.MODULE$.canBuildFrom()) : (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction$Left$.MODULE$, Direction$Right$.MODULE$, Direction$Bottom$.MODULE$, Direction$Top$.MODULE$, Direction$TopLeft$.MODULE$, Direction$TopRight$.MODULE$, Direction$BottomLeft$.MODULE$, Direction$BottomRight$.MODULE$}))).map((Function1 & Serializable & scala.Serializable)neighbor -> BufferTiles$.genSection$1(neighbor, getBufferSizes$2, evidence$53$1, evidence$56$1, leftDirs$1, hmidDirs$1, rightDirs$1, topDirs$1, vmidDirs$1, botDirs$1, key, tile, x, y, cols, rows), Seq$.MODULE$.canBuildFrom());
        return seq;
    }

    public static final /* synthetic */ int $anonfun$apply$28(Map pieces$1, Product x) {
        return BoxesRunTime.unboxToInt((Object)pieces$1.get((Object)x).map((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToInteger((int)x$27.cols())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ int $anonfun$apply$27(Map pieces$1, Seq x$26) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$26.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)BufferTiles$.$anonfun$apply$28(pieces$1, x)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
    }

    public static final /* synthetic */ Seq $anonfun$apply$31(Seq acc, int x) {
        return (Seq)acc.$colon$plus((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)acc.last()) + x)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ int $anonfun$apply$33(Map pieces$1, Product x) {
        return BoxesRunTime.unboxToInt((Object)pieces$1.get((Object)x).map((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToInteger((int)x$29.rows())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ int $anonfun$apply$32(Map pieces$1, Seq x$28) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$28.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)BufferTiles$.$anonfun$apply$33(pieces$1, x)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
    }

    public static final /* synthetic */ Seq $anonfun$apply$36(Seq acc, int x) {
        return (Seq)acc.$colon$plus((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)acc.last()) + x)), Seq$.MODULE$.canBuildFrom());
    }

    private static final Tuple2 loc$1(Direction dir, Seq lefts$1, Seq tops$1) {
        Tuple2.mcII.sp sp2;
        Direction direction = dir;
        if (Direction$TopLeft$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(0)), BoxesRunTime.unboxToInt((Object)tops$1.apply(0)));
        } else if (Direction$Top$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(1)), BoxesRunTime.unboxToInt((Object)tops$1.apply(0)));
        } else if (Direction$TopRight$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(2)), BoxesRunTime.unboxToInt((Object)tops$1.apply(0)));
        } else if (Direction$Left$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(0)), BoxesRunTime.unboxToInt((Object)tops$1.apply(1)));
        } else if (Direction$Center$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(1)), BoxesRunTime.unboxToInt((Object)tops$1.apply(1)));
        } else if (Direction$Right$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(2)), BoxesRunTime.unboxToInt((Object)tops$1.apply(1)));
        } else if (Direction$BottomLeft$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(0)), BoxesRunTime.unboxToInt((Object)tops$1.apply(2)));
        } else if (Direction$Bottom$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(1)), BoxesRunTime.unboxToInt((Object)tops$1.apply(2)));
        } else if (Direction$BottomRight$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(2)), BoxesRunTime.unboxToInt((Object)tops$1.apply(2)));
        } else {
            throw new MatchError((Object)direction);
        }
        return sp2;
    }

    public static final /* synthetic */ TraversableOnce $anonfun$apply$25(Stitcher evidence$55$1, Seq leftDirs$1, Seq hmidDirs$1, Seq rightDirs$1, Seq topDirs$1, Seq vmidDirs$1, Seq botDirs$1, Iterable iter) {
        Iterable iterable;
        Map pieces = ((TraversableOnce)iter.map((Function1 & Serializable & scala.Serializable)x0$11 -> {
            Tuple3 tuple3 = x0$11;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Direction dir = (Direction)tuple3._2();
            CellGrid tile = (CellGrid)tuple3._3();
            Tuple2 tuple2 = new Tuple2((Object)dir, (Object)tile);
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (pieces.contains((Object)Direction$Center$.MODULE$)) {
            Seq lefts = (Seq)((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{leftDirs$1, hmidDirs$1, rightDirs$1}))).map((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToInteger((int)BufferTiles$.$anonfun$apply$27(pieces, x$26)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(acc, x) -> BufferTiles$.$anonfun$apply$31(acc, BoxesRunTime.unboxToInt((Object)x)));
            Seq tops = (Seq)((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{topDirs$1, vmidDirs$1, botDirs$1}))).map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToInteger((int)BufferTiles$.$anonfun$apply$32(pieces, x$28)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(acc, x) -> BufferTiles$.$anonfun$apply$36(acc, BoxesRunTime.unboxToInt((Object)x)));
            int totalWidth = BoxesRunTime.unboxToInt((Object)lefts.last());
            int totalHeight = BoxesRunTime.unboxToInt((Object)tops.last());
            Seq toStitch = (Seq)pieces.toSeq().map((Function1 & Serializable & scala.Serializable)x0$12 -> {
                Tuple2 tuple2 = x0$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Direction dir = (Direction)tuple2._1();
                CellGrid tile = (CellGrid)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)tile, (Object)BufferTiles$.loc$1(dir, lefts, tops));
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom());
            Stitcher stitcher = (Stitcher)Predef$.MODULE$.implicitly((Object)evidence$55$1);
            CellGrid stitched = stitcher.stitch((Iterable)toStitch, totalWidth, totalHeight);
            iterable = Option$.MODULE$.option2Iterable((Option)new Some(new BufferedTile<CellGrid>(stitched, new GridBounds(BoxesRunTime.unboxToInt((Object)lefts.apply(1)), BoxesRunTime.unboxToInt((Object)tops.apply(1)), BoxesRunTime.unboxToInt((Object)lefts.apply(2)) - 1, BoxesRunTime.unboxToInt((Object)tops.apply(2)) - 1))));
        } else {
            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }
        return iterable;
    }

    private BufferTiles$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

