/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.crop;

import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.TileCropMethods;
import geotrellis.spark.Bounds;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.EmptyBounds$;
import geotrellis.spark.KeyBounds;
import geotrellis.spark.Metadata;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.spark.tiling.MapKeyTransform;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.package$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Crop$ {
    public static Crop$ MODULE$;

    static {
        new Crop$();
    }

    public <K, V extends CellGrid, M> RDD<Tuple2<K, V>> apply(RDD<Tuple2<K, V>> rdd, Extent extent, Crop.Options options, Component<K, SpatialKey> evidence$1, Function1<V, TileCropMethods<V>> evidence$2, Component<M, Bounds<K>> evidence$3, GetComponent<M, Extent> evidence$4, GetComponent<M, LayoutDefinition> evidence$5) {
        RDD<Tuple2<K, V>> rDD;
        Option option = ((Extent)package$.MODULE$.withGetComponentMethods(((Metadata)rdd).metadata()).getComponent(evidence$4)).intersection(extent);
        if (option instanceof Some) {
            RDD<Tuple2<K, V>> rDD2;
            Some some = (Some)option;
            Extent intersectionExtent = (Extent)some.value();
            Bounds bounds = (Bounds)package$.MODULE$.withGetComponentMethods(((Metadata)rdd).metadata()).getComponent(evidence$3);
            if (bounds instanceof KeyBounds) {
                KeyBounds keyBounds = (KeyBounds)bounds;
                Object minKey = keyBounds.minKey();
                Object maxKey = keyBounds.maxKey();
                MapKeyTransform mapTransform = ((LayoutDefinition)((Object)package$.MODULE$.withGetComponentMethods(((Metadata)rdd).metadata()).getComponent(evidence$5))).mapTransform();
                RDD croppedRdd = rdd.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Iterable iterable;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        CellGrid tile = (CellGrid)tuple2._2();
                        Extent srcExtent = mapTransform.keyToExtent((SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$1));
                        if (extent.contains(srcExtent)) {
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2(key, (Object)tile)));
                        } else if (extent.interiorIntersects(srcExtent)) {
                            CellGrid newTile = ((TileCropMethods)evidence$2.apply((Object)tile)).crop(srcExtent, (Extent)extent.intersection(srcExtent).get(), options);
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2(key, (Object)newTile)));
                        } else {
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Iterable iterable2 = iterable;
                    return iterable2;
                }), true, ClassTag$.MODULE$.apply(Tuple2.class));
                GridBounds gridBounds = mapTransform.apply(intersectionExtent);
                if (gridBounds == null) {
                    throw new MatchError((Object)gridBounds);
                }
                int minCol = gridBounds.colMin();
                int minRow = gridBounds.rowMin();
                int maxCol = gridBounds.colMax();
                int maxRow = gridBounds.rowMax();
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)minCol), (Object)BoxesRunTime.boxToInteger((int)minRow), (Object)BoxesRunTime.boxToInteger((int)maxCol), (Object)BoxesRunTime.boxToInteger((int)maxRow));
                Tuple4 tuple42 = tuple4;
                int minCol2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
                int minRow2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
                int maxCol2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
                int maxRow2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
                KeyBounds<Object> newKeyBounds = new KeyBounds<Object>(package$.MODULE$.withSetComponentMethods(minKey).setComponent((Object)new SpatialKey(minCol2, minRow2), evidence$1), package$.MODULE$.withSetComponentMethods(maxKey).setComponent((Object)new SpatialKey(maxCol2, maxRow2), evidence$1));
                Object md = package$.MODULE$.withSetComponentMethods(((Metadata)rdd).metadata()).setComponent(newKeyBounds, evidence$3);
                rDD2 = ContextRDD$.MODULE$.apply(croppedRdd, md);
            } else if (EmptyBounds$.MODULE$.equals(bounds)) {
                rDD2 = rdd;
            } else {
                throw new MatchError((Object)bounds);
            }
            rDD = rDD2;
        } else if (None$.MODULE$.equals(option)) {
            SparkContext qual$1 = rdd.sparkContext();
            Seq x$2 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            int x$3 = qual$1.parallelize$default$2();
            rDD = ContextRDD$.MODULE$.apply(qual$1.parallelize(x$2, x$3, ClassTag$.MODULE$.apply(Tuple2.class)), package$.MODULE$.withSetComponentMethods(((Metadata)rdd).metadata()).setComponent((Object)EmptyBounds$.MODULE$, evidence$3));
        } else {
            throw new MatchError((Object)option);
        }
        return rDD;
    }

    private Crop$() {
        MODULE$ = this;
    }
}

