/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.distance;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.distance.EuclideanDistanceTile$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.SpatialKey$;
import geotrellis.spark.buffer.Direction;
import geotrellis.spark.buffer.Direction$;
import geotrellis.spark.package$;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.vector.Extent;
import geotrellis.vector.Extent$;
import geotrellis.vector.Geometry;
import geotrellis.vector.Point$;
import geotrellis.vector.Polygon;
import geotrellis.vector.mesh.IndexedPointSet$;
import geotrellis.vector.triangulation.BoundaryDelaunay;
import geotrellis.vector.triangulation.BoundaryDelaunay$;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.triangulation.DelaunayTriangulation$;
import geotrellis.vector.triangulation.StitchedDelaunay;
import geotrellis.vector.triangulation.StitchedDelaunay$;
import geotrellis.vector.voronoi.VoronoiDiagram$;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.locationtech.jts.geom.Coordinate;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class EuclideanDistance$ {
    public static EuclideanDistance$ MODULE$;

    static {
        new EuclideanDistance$();
    }

    public Seq<Tuple2<Polygon, Coordinate>> voronoiCells(StitchedDelaunay centerStitched, int initialEdge, Extent extent) {
        ListBuffer queue = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(initialEdge, centerStitched.halfEdgeTable().getDest(initialEdge))}));
        Set visited = Set$.MODULE$.empty();
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        block0: while (queue.nonEmpty()) {
            Tuple2 tuple2 = (Tuple2)queue.remove(0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int incoming = tuple2._1$mcI$sp();
            int here = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(incoming, here);
            Tuple2.mcII.sp sp3 = sp2;
            int incoming2 = sp3._1$mcI$sp();
            int here2 = sp3._2$mcI$sp();
            if (visited.contains((Object)BoxesRunTime.boxToInteger((int)here2))) continue;
            visited.$plus$eq((Object)BoxesRunTime.boxToInteger((int)here2));
            Option poly = VoronoiDiagram$.MODULE$.polygonalCell(centerStitched.halfEdgeTable(), centerStitched.indexToCoord(), extent, incoming2);
            if (!poly.isDefined()) continue;
            result.$plus$eq((Object)new Tuple2(poly.get(), centerStitched.indexToCoord().apply((Object)BoxesRunTime.boxToInteger((int)here2))));
            int e = centerStitched.halfEdgeTable().getFlip(incoming2);
            while (true) {
                queue.$plus$eq((Object)new Tuple2.mcII.sp(e, centerStitched.halfEdgeTable().getDest(e)));
                e = centerStitched.halfEdgeTable().rotCWSrc(e);
                if (e == centerStitched.halfEdgeTable().getFlip(incoming2)) continue block0;
            }
        }
        return result;
    }

    public Option<Tile> neighborEuclideanDistance(DelaunayTriangulation center, Map<Direction, Tuple2<BoundaryDelaunay, Extent>> neighbors, RasterExtent re) {
        None$ none$;
        Map _neighbors = (Map)neighbors.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Direction dir = (Direction)tuple2._1();
            Tuple2 value = (Tuple2)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)Direction$.MODULE$.convertDirection(dir), (Object)value);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        StitchedDelaunay stitched = StitchedDelaunay$.MODULE$.apply(center, _neighbors, false);
        if (stitched.pointSet().length() == 0) {
            none$ = None$.MODULE$;
        } else {
            int baseEdge = center.boundary() != -1 ? stitched.halfEdgeTable().edgeIncidentTo(center.halfEdgeTable().getDest(center.boundary())) : EuclideanDistance$.findBaseEdge$1(re, stitched);
            Extent extent = re.extent();
            Seq<Tuple2<Polygon, Coordinate>> cells = this.voronoiCells(stitched, baseEdge, extent);
            DoubleArrayTile tile = DoubleArrayTile$.MODULE$.empty(re.cols(), re.rows());
            cells.foreach((Function1 & Serializable & scala.Serializable)arg -> {
                EuclideanDistanceTile$.MODULE$.rasterizeDistanceCell(re, (MutableArrayTile)tile, arg);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)tile);
        }
        return none$;
    }

    public RDD<Tuple2<SpatialKey, Tile>> apply(RDD<Tuple2<SpatialKey, Coordinate[]>> rdd, LayoutDefinition layoutDefinition) {
        RDD triangulations = rdd.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey key = (SpatialKey)tuple2._1();
            Coordinate[] points = (Coordinate[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)DelaunayTriangulation$.MODULE$.apply(IndexedPointSet$.MODULE$.coordinateArrayToIndexedPointSet(points), DelaunayTriangulation$.MODULE$.apply$default$2(), DelaunayTriangulation$.MODULE$.apply$default$3()));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD borders = triangulations.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey sk = (SpatialKey)tuple2._1();
            DelaunayTriangulation dt = (DelaunayTriangulation)tuple2._2();
            Extent ex = layoutDefinition.mapTransform().apply(sk);
            Tuple2 tuple22 = new Tuple2((Object)sk, (Object)BoundaryDelaunay$.MODULE$.apply(dt, ex));
            return tuple22;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(package$.MODULE$.withCollectNeighborsMethodsWrapper(borders, geotrellis.util.package$.MODULE$.identityComponent(), ClassTag$.MODULE$.apply(SpatialKey.class)).collectNeighbors().mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey key = (SpatialKey)tuple2._1();
            Iterable neighbors = (Iterable)tuple2._2();
            Iterable newNeighbors = (Iterable)neighbors.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2;
                Direction direction;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$5;
                        if (tuple22 == null) break block2;
                        direction = (Direction)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                SpatialKey key2 = (SpatialKey)tuple2._1();
                BoundaryDelaunay border = (BoundaryDelaunay)tuple2._2();
                Extent ex = layoutDefinition.mapTransform().apply(key2);
                Tuple2 tuple23 = new Tuple2((Object)direction, (Object)new Tuple2((Object)border, (Object)ex));
                return tuple23;
            }, Iterable$.MODULE$.canBuildFrom());
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)newNeighbors.toMap(Predef$.MODULE$.$conforms()));
            return tuple22;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Map.class), SpatialKey$.MODULE$.ordering()).join(triangulations).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.flatMap((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Iterable iterable;
            Extent extent;
            RasterExtent re;
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            SpatialKey key = (SpatialKey)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            Map borders = (Map)tuple22._1();
            DelaunayTriangulation triangulation = (DelaunayTriangulation)tuple22._2();
            Option<Tile> option = MODULE$.neighborEuclideanDistance(triangulation, (Map<Direction, Tuple2<BoundaryDelaunay, Extent>>)borders, re = RasterExtent$.MODULE$.apply(extent = layoutDefinition.mapTransform().apply(key), layoutDefinition.tileCols(), layoutDefinition.tileRows()));
            if (None$.MODULE$.equals(option)) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                return iterable;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Tile tile = (Tile)some.value();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)key, (Object)tile)));
            }
            return iterable;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private static final int findBaseEdge$1(RasterExtent re$1, StitchedDelaunay stitched$1) {
        int e = 0;
        double bestdist = Double.POSITIVE_INFINITY;
        int best = -1;
        while (true) {
            if (stitched$1.halfEdgeTable().getDest(e) == -1 && e < stitched$1.halfEdgeTable().maxEdgeIndex()) {
                ++e;
                continue;
            }
            double dist = Extent$.MODULE$.toPolygon(re$1.extent()).distance((Geometry)Point$.MODULE$.jtsCoord2Point((Coordinate)stitched$1.indexToCoord().apply((Object)BoxesRunTime.boxToInteger((int)stitched$1.halfEdgeTable().getDest(e)))));
            if (dist < bestdist) {
                best = e;
                bestdist = dist;
            }
            if (!(bestdist > 0.0) || ++e >= stitched$1.halfEdgeTable().maxEdgeIndex()) break;
        }
        return best;
    }

    private EuclideanDistance$() {
        MODULE$ = this;
    }
}

