/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.distance;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.distance.EuclideanDistanceTile$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.tiling.LayoutDefinition;
import geotrellis.vector.Extent;
import geotrellis.vector.mesh.IndexedPointSet$;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.triangulation.DelaunayTriangulation$;
import geotrellis.vector.voronoi.VoronoiDiagram;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.locationtech.jts.geom.Coordinate;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class SparseEuclideanDistance$ {
    public static SparseEuclideanDistance$ MODULE$;

    static {
        new SparseEuclideanDistance$();
    }

    public RDD<Tuple2<SpatialKey, Tile>> apply(Coordinate[] pts, Extent geomExtent, LayoutDefinition ld, int tileCols, int tileRows, DataType cellType, SparkContext sc) {
        Broadcast dt = sc.broadcast((Object)DelaunayTriangulation$.MODULE$.apply(IndexedPointSet$.MODULE$.coordinateArrayToIndexedPointSet(pts), DelaunayTriangulation$.MODULE$.apply$default$2(), DelaunayTriangulation$.MODULE$.apply$default$3()), ClassTag$.MODULE$.apply(DelaunayTriangulation.class));
        GridBounds gridBounds = ld.mapTransform().apply(geomExtent);
        if (gridBounds == null) {
            throw new MatchError((Object)gridBounds);
        }
        int cmin = gridBounds.colMin();
        int rmin = gridBounds.rowMin();
        int cmax = gridBounds.colMax();
        int rmax = gridBounds.rowMax();
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)cmin), (Object)BoxesRunTime.boxToInteger((int)rmin), (Object)BoxesRunTime.boxToInteger((int)cmax), (Object)BoxesRunTime.boxToInteger((int)rmax));
        Tuple4 tuple42 = tuple4;
        int cmin2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
        int rmin2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
        int cmax2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int rmax2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
        RDD keys = sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(rmin2), rmax2).flatMap((Function1 & Serializable & scala.Serializable)r -> SparseEuclideanDistance$.$anonfun$apply$9(cmin2, cmax2, BoxesRunTime.unboxToInt((Object)r)), IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(SpatialKey.class));
        return keys.mapPartitions((Function1 & Serializable & scala.Serializable)x$3 -> x$3.map((Function1 & Serializable & scala.Serializable)key -> {
            Extent ex = ld.mapTransform().apply((SpatialKey)key);
            VoronoiDiagram vor = new VoronoiDiagram((DelaunayTriangulation)dt.value(), ex);
            RasterExtent re = RasterExtent$.MODULE$.apply(ex, tileCols, tileRows);
            MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, re.cols(), re.rows());
            vor.voronoiCellsWithPoints().foreach((Function1 & Serializable & scala.Serializable)arg -> {
                EuclideanDistanceTile$.MODULE$.rasterizeDistanceCell(re, tile, arg);
                return BoxedUnit.UNIT;
            });
            return new Tuple2(key, (Object)tile);
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public DataType apply$default$6() {
        return DoubleConstantNoDataCellType$.MODULE$;
    }

    public static final /* synthetic */ SpatialKey $anonfun$apply$10(int r$1, int c) {
        return new SpatialKey(c, r$1);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$apply$9(int cmin$1, int cmax$1, int r) {
        return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(cmin$1), cmax$1).map((Function1 & Serializable & scala.Serializable)c -> SparseEuclideanDistance$.$anonfun$apply$10(r, BoxesRunTime.unboxToInt((Object)c)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private SparseEuclideanDistance$() {
        MODULE$ = this;
    }
}

