/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.io;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayoutTransform;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayoutTransform$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.spark.io.RasterReader;
import geotrellis.vector.Geometry;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001C\u0001\u0003!\u0003\r\tA\u0002\u0005\u0003#\u001d+w\u000eV5gM&sgm\u001c*fC\u0012,'O\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tQa\u001d9be.T\u0011aB\u0001\u000bO\u0016|GO]3mY&\u001c8C\u0001\u0001\n!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fM\")\u0001\u0003\u0001C\u0001%\u00051A%\u001b8ji\u0012\u001a\u0001\u0001F\u0001\u0014!\tQA#\u0003\u0002\u0016\u0017\t!QK\\5u\u0011\u00159\u0002A\"\u0001\u0019\u000399Wm\u001c+jM\u001aLeNZ8S\t\u0012#\"!G\u0018\u0011\u0007i\u0011C%D\u0001\u001c\u0015\taR$A\u0002sI\u0012T!!\u0002\u0010\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\u0005\u0003Gm\u00111A\u0015#E!\t)CF\u0004\u0002'UA\u0011qeC\u0007\u0002Q)\u0011\u0011&E\u0001\u0007yI|w\u000e\u001e \n\u0005-Z\u0011A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!aK\u0006\t\u000bA2\u00029A\u0019\u0002\u0005M\u001c\u0007C\u0001\u001a4\u001b\u0005i\u0012B\u0001\u001b\u001e\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u00151\u0004A\"\u00018\u000399W\r^$f_RKgMZ%oM>$\"\u0001\u000f)\u0011\u0005ejeB\u0001\u001eK\u001d\tYtI\u0004\u0002=\t:\u0011QH\u0011\b\u0003}\u0001s!aJ \n\u0003\u001dI!!\u0011\u0004\u0002\rI\f7\u000f^3s\u0013\t\u00191I\u0003\u0002B\r%\u0011QIR\u0001\bO\u0016|G/\u001b4g\u0015\t\u00191)\u0003\u0002I\u0013\u00061!/Z1eKJT!!\u0012$\n\u0005-c\u0015!D$f_RKgM\u001a*fC\u0012,'O\u0003\u0002I\u0013&\u0011aj\u0014\u0002\f\u000f\u0016|G+\u001b4g\u0013:4wN\u0003\u0002L\u0019\")\u0011+\u000ea\u0001I\u0005\u0019QO]5\t\u000bM\u0003A\u0011\u0001+\u00023\u001d,GoU3h[\u0016tG\u000fT1z_V$HK]1og\u001a|'/\u001c\u000b\u0003+f\u0003\"AV,\u000e\u0003%K!\u0001W%\u0003;\u001d+w\u000eV5gMN+w-\\3oi2\u000b\u0017p\\;u)J\fgn\u001d4pe6DQA\u0017*A\u0002a\n1bZ3p)&4g-\u00138g_\")A\f\u0001C\u0005;\u0006\u0011r/\u001b8e_^\u001c()\u001f)beRLG/[8o)\u0015qf\r[7s!\rQq,Y\u0005\u0003A.\u0011Q!\u0011:sCf\u00042AC0c!\t\u0019G-D\u0001D\u0013\t)7I\u0001\u0006He&$'i\\;oINDQaZ.A\u0002a\nA!\u001b8g_\")\u0011n\u0017a\u0001U\u00069Q.\u0019=TSj,\u0007C\u0001\u0006l\u0013\ta7BA\u0002J]RDQA\\.A\u0002=\fa\u0002]1si&$\u0018n\u001c8CsR,7\u000f\u0005\u0002\u000ba&\u0011\u0011o\u0003\u0002\u0005\u0019>tw\rC\u0003t7\u0002\u0007A/\u0001\u0005hK>lW\r\u001e:z!\rQQo^\u0005\u0003m.\u0011aa\u00149uS>t\u0007C\u0001=|\u001b\u0005I(B\u0001>\u0007\u0003\u00191Xm\u0019;pe&\u0011A0\u001f\u0002\t\u000f\u0016|W.\u001a;ss\")a\u0010\u0001C\u0001\u007f\u0006Y!/Z1e/&tGm\\<t+)\t\t!!\u000f\u0002B\u0005E\u0011Q\u0005\u000b\u000f\u0003\u0007\t)%a\u0017\u0002f\u0005\u001d\u0014\u0011NA7)\u0019\t)!!\u000b\u0002,A!!DIA\u0004!\u001dQ\u0011\u0011BA\u0007\u0003GI1!a\u0003\f\u0005\u0019!V\u000f\u001d7feA!\u0011qBA\t\u0019\u0001!q!a\u0005~\u0005\u0004\t)BA\u0001L#\u0011\t9\"!\b\u0011\u0007)\tI\"C\u0002\u0002\u001c-\u0011qAT8uQ&tw\rE\u0002\u000b\u0003?I1!!\t\f\u0005\r\te.\u001f\t\u0005\u0003\u001f\t)\u0003B\u0004\u0002(u\u0014\r!!\u0006\u0003\u0003YCQ\u0001M?A\u0004EBq!!\f~\u0001\b\ty#\u0001\u0002seBA\u0011\u0011GA\u001a\u0003o\ti$D\u0001\u0003\u0013\r\t)D\u0001\u0002\r%\u0006\u001cH/\u001a:SK\u0006$WM\u001d\t\u0005\u0003\u001f\tI\u0004B\u0004\u0002<u\u0014\r!!\u0006\u0003\u0003=\u0003rACA\u0005\u0003\u007f\t\u0019\u0003\u0005\u0003\u0002\u0010\u0005\u0005CaBA\"{\n\u0007\u0011Q\u0003\u0002\u0002\u0013\"9\u0011qI?A\u0002\u0005%\u0013!\u00024jY\u0016\u001c\b\u0003\u0002\u000e#\u0003\u0017\u0002B!!\u0014\u0002X5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0002oKRT!!!\u0016\u0002\t)\fg/Y\u0005\u0005\u00033\nyEA\u0002V%&Cq!!\u0018~\u0001\u0004\ty&\u0001\u0005ve&$vnS3z!%Q\u0011\u0011MA&\u0003\u007f\ti!C\u0002\u0002d-\u0011\u0011BR;oGRLwN\u001c\u001a\t\u000b%l\b\u0019\u00016\t\u000b9l\b\u0019A8\t\u000f\u0005-T\u00101\u0001\u00028\u0005\u0019\"/Y:uKJ\u0014V-\u00193fe>\u0003H/[8og\")1/ a\u0001i\"Q\u0011\u0011\u000f\u0001\t\u0006\u0004%\t\"a\u001d\u0002\r1|wmZ3s+\t\t)\b\u0005\u0003\u0002x\u0005\u0015UBAA=\u0015\u0011\tY(! \u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005}\u0014\u0011Q\u0001\tif\u0004Xm]1gK*\u0011\u00111Q\u0001\u0004G>l\u0017\u0002BAD\u0003s\u0012a\u0001T8hO\u0016\u0014\b\u0006BA8\u0003\u0017\u00032ACAG\u0013\r\tyi\u0003\u0002\niJ\fgn]5f]R\u0004")
public interface GeoTiffInfoReader {
    public static /* synthetic */ Logger logger$(GeoTiffInfoReader $this) {
        return $this.logger();
    }

    default public Logger logger() {
        return Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }

    public RDD<String> geoTiffInfoRDD(SparkContext var1);

    public GeoTiffReader.GeoTiffInfo getGeoTiffInfo(String var1);

    public static /* synthetic */ GeoTiffSegmentLayoutTransform getSegmentLayoutTransform$(GeoTiffInfoReader $this, GeoTiffReader.GeoTiffInfo geoTiffInfo) {
        return $this.getSegmentLayoutTransform(geoTiffInfo);
    }

    default public GeoTiffSegmentLayoutTransform getSegmentLayoutTransform(GeoTiffReader.GeoTiffInfo geoTiffInfo) {
        return GeoTiffSegmentLayoutTransform$.MODULE$.apply(geoTiffInfo.segmentLayout(), geoTiffInfo.bandCount());
    }

    private GridBounds[][] windowsByPartition(GeoTiffReader.GeoTiffInfo info, int maxSize, long partitionBytes, Option<Geometry> geometry) {
        GridBounds[] gridBoundsArray;
        Option<Geometry> option = geometry;
        if (option instanceof Some) {
            Some some = (Some)option;
            Geometry geometry2 = (Geometry)some.value();
            gridBoundsArray = info.segmentLayout().listWindows(maxSize, info.extent(), geometry2);
        } else if (None$.MODULE$.equals(option)) {
            gridBoundsArray = info.segmentLayout().listWindows(maxSize);
        } else {
            throw new MatchError(option);
        }
        GridBounds[] windows = gridBoundsArray;
        return info.segmentLayout().partitionWindowsBySegments((Seq)Predef$.MODULE$.wrapRefArray((Object[])windows), partitionBytes / (long)package$.MODULE$.max(info.cellType().bytes(), 1));
    }

    public static /* synthetic */ RDD readWindows$(GeoTiffInfoReader $this, RDD files, Function2 uriToKey, int maxSize, long partitionBytes, Object rasterReaderOptions, Option geometry, SparkContext sc, RasterReader rr) {
        return $this.readWindows((RDD<URI>)files, uriToKey, maxSize, partitionBytes, rasterReaderOptions, (Option<Geometry>)geometry, sc, rr);
    }

    default public <O, I, K, V> RDD<Tuple2<K, V>> readWindows(RDD<URI> files, Function2<URI, I, K> uriToKey, int maxSize, long partitionBytes, O rasterReaderOptions, Option<Geometry> geometry, SparkContext sc, RasterReader<O, Tuple2<I, V>> rr) {
        RDD rDD;
        RDD windows = files.flatMap((Function1 & Serializable & scala.Serializable)uri -> (TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.windowsByPartition(this.getGeoTiffInfo(uri.toString()), maxSize, partitionBytes, geometry))).map((Function1 & Serializable & scala.Serializable)windows -> new Tuple2(uri, windows), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), ClassTag$.MODULE$.apply(Tuple2.class));
        windows.persist();
        int windowCount = (int)windows.count();
        if (windowCount > windows.partitions().length) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Repartition into {} partitions.", new Object[]{BoxesRunTime.boxToInteger((int)windowCount)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            int x$1 = windowCount;
            Ordering x$2 = windows.repartition$default$2(x$1);
            rDD = windows.repartition(x$1, x$2);
        } else {
            rDD = windows;
        }
        RDD repartition = rDD;
        RDD result = repartition.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            URI uri = (URI)tuple2._1();
            GridBounds[] windows = (GridBounds[])tuple2._2();
            GeoTiffReader.GeoTiffInfo info = this.getGeoTiffInfo(uri.toString());
            Iterator iterator = rr.readWindows(windows, info, rasterReaderOptions).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(uriToKey.apply((Object)uri, k)), v);
                return tuple22;
            });
            return iterator;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        windows.unpersist(windows.unpersist$default$1());
        return result;
    }

    public static void $init$(GeoTiffInfoReader $this) {
    }
}

